/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.io.json.JsonValue;
import biweekly.util.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JCalValue {
    private final List<JsonValue> values;

    public JCalValue(List<JsonValue> values) {
        this.values = Collections.unmodifiableList(values);
    }

    public JCalValue(JsonValue ... values) {
        this.values = Arrays.asList(values);
    }

    public static JCalValue single(Object value) {
        return new JCalValue(new JsonValue(value));
    }

    public static JCalValue multi(Object ... values) {
        return JCalValue.multi(Arrays.asList(values));
    }

    public static JCalValue multi(List<?> values) {
        ArrayList<JsonValue> multiValues = new ArrayList<JsonValue>(values.size());
        for (Object value : values) {
            multiValues.add(new JsonValue(value));
        }
        return new JCalValue(multiValues);
    }

    public static JCalValue structured(Object ... values) {
        ArrayList valuesList = new ArrayList(values.length);
        for (Object value : values) {
            List<Object> list = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
            valuesList.add(list);
        }
        return JCalValue.structured(valuesList);
    }

    public static JCalValue structured(List<List<?>> values) {
        ArrayList<JsonValue> array = new ArrayList<JsonValue>(values.size());
        for (List<?> list : values) {
            if (list.isEmpty()) {
                array.add(new JsonValue(""));
                continue;
            }
            if (list.size() == 1) {
                Object value = list.get(0);
                if (value == null) {
                    value = "";
                }
                array.add(new JsonValue(value));
                continue;
            }
            ArrayList<JsonValue> subArray = new ArrayList<JsonValue>(list.size());
            for (Object value : list) {
                if (value == null) {
                    value = "";
                }
                subArray.add(new JsonValue(value));
            }
            array.add(new JsonValue(subArray));
        }
        return new JCalValue(new JsonValue(array));
    }

    public static JCalValue object(ListMultimap<String, Object> value) {
        LinkedHashMap<String, JsonValue> object = new LinkedHashMap<String, JsonValue>();
        for (Map.Entry<String, List<Object>> entry : value) {
            JsonValue v;
            String key = entry.getKey();
            List<Object> list = entry.getValue();
            if (list.size() == 1) {
                v = new JsonValue(list.get(0));
            } else {
                ArrayList<JsonValue> array = new ArrayList<JsonValue>(list.size());
                for (Object element : list) {
                    array.add(new JsonValue(element));
                }
                v = new JsonValue(array);
            }
            object.put(key, v);
        }
        return new JCalValue(new JsonValue(object));
    }

    public List<JsonValue> getValues() {
        return this.values;
    }

    public String asSingle() {
        if (this.values.isEmpty()) {
            return "";
        }
        JsonValue first = this.values.get(0);
        if (first.isNull()) {
            return "";
        }
        Object obj = first.getValue();
        if (obj != null) {
            return obj.toString();
        }
        List<JsonValue> array = first.getArray();
        if (array != null && !array.isEmpty() && (obj = array.get(0).getValue()) != null) {
            return obj.toString();
        }
        return "";
    }

    public List<List<String>> asStructured() {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        JsonValue first = this.values.get(0);
        List<JsonValue> array = first.getArray();
        if (array != null) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(array.size());
            for (JsonValue value : array) {
                if (value.isNull()) {
                    components.add(this.asStructuredNull());
                    continue;
                }
                Object obj = value.getValue();
                if (obj != null) {
                    components.add(this.asStructuredValue(obj));
                    continue;
                }
                List<JsonValue> subArray = value.getArray();
                if (subArray == null) continue;
                components.add(this.asStructuredSubArray(subArray));
            }
            return components;
        }
        Object obj = first.getValue();
        if (obj != null) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(1);
            components.add(this.asStructuredValue(obj));
            return components;
        }
        if (first.isNull()) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(1);
            components.add(this.asStructuredNull());
            return components;
        }
        return Collections.emptyList();
    }

    private List<String> asStructuredSubArray(List<JsonValue> subArray) {
        ArrayList<String> component = new ArrayList<String>(subArray.size());
        for (JsonValue subArrayValue : subArray) {
            if (subArrayValue.isNull()) {
                component.add("");
                continue;
            }
            Object obj = subArrayValue.getValue();
            if (obj == null) continue;
            component.add(obj.toString());
        }
        if (component.size() == 1 && ((String)component.get(0)).isEmpty()) {
            component.clear();
        }
        return component;
    }

    private List<String> asStructuredValue(Object obj) {
        String s = obj.toString();
        return s.isEmpty() ? Collections.emptyList() : Collections.singletonList(s);
    }

    private List<String> asStructuredNull() {
        return Collections.emptyList();
    }

    public List<String> asMulti() {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> multi = new ArrayList<String>(this.values.size());
        for (JsonValue value : this.values) {
            if (value.isNull()) {
                multi.add("");
                continue;
            }
            Object obj = value.getValue();
            if (obj == null) continue;
            multi.add(obj.toString());
        }
        return multi;
    }

    public ListMultimap<String, String> asObject() {
        if (this.values.isEmpty()) {
            return new ListMultimap<String, String>(0);
        }
        Map<String, JsonValue> map = this.values.get(0).getObject();
        if (map == null) {
            return new ListMultimap<String, String>(0);
        }
        ListMultimap<String, String> values = new ListMultimap<String, String>();
        for (Map.Entry<String, JsonValue> entry : map.entrySet()) {
            String key = entry.getKey();
            JsonValue value = entry.getValue();
            if (value.isNull()) {
                values.put(key, "");
                continue;
            }
            Object obj = value.getValue();
            if (obj != null) {
                values.put(key, obj.toString());
                continue;
            }
            List<JsonValue> array = value.getArray();
            if (array == null) continue;
            for (JsonValue element : array) {
                if (element.isNull()) {
                    values.put(key, "");
                    continue;
                }
                obj = element.getValue();
                if (obj == null) continue;
                values.put(key, obj.toString());
            }
        }
        return values;
    }
}

