/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class RandomizedBacktrackNeighbourSelection
extends BacktrackNeighbourSelection<Request, Enrollment> {
    private int iMaxValues = 100;
    private boolean iPreferPriorityStudents = true;

    public RandomizedBacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iMaxValues = properties.getPropertyInt("Neighbour.MaxValues", this.iMaxValues);
        this.iPreferPriorityStudents = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
    }

    @Override
    protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
        if (variable instanceof CourseRequest) {
            CourseRequest request = (CourseRequest)variable;
            final StudentSectioningModel model = (StudentSectioningModel)context.getModel();
            final Assignment<Request, Enrollment> assignment = context.getAssignment();
            final Enrollment current = (Enrollment)assignment.getValue(request);
            List<Enrollment> values = this.iMaxValues > 0 ? request.computeRandomEnrollments(assignment, this.iMaxValues) : request.computeEnrollments(assignment);
            Collections.sort(values, new Comparator<Enrollment>(){
                private HashMap<Enrollment, Double> iValues = new HashMap();

                private Double value(Enrollment e) {
                    Double value = this.iValues.get(e);
                    if (value == null) {
                        value = model.getStudentQuality() != null ? Double.valueOf(model.getStudentWeights().getWeight(assignment, e, model.getStudentQuality().conflicts(e))) : Double.valueOf(model.getStudentWeights().getWeight(assignment, e, model.getDistanceConflict() == null ? null : model.getDistanceConflict().conflicts(e), model.getTimeOverlaps() == null ? null : model.getTimeOverlaps().conflicts(e)));
                        this.iValues.put(e, value);
                    }
                    return value;
                }

                @Override
                public int compare(Enrollment e1, Enrollment e2) {
                    Double v2;
                    if (e1.equals(e2)) {
                        return 0;
                    }
                    if (e1.equals(current)) {
                        return -1;
                    }
                    if (e2.equals(current)) {
                        return 1;
                    }
                    Double v1 = this.value(e1);
                    return v1.equals(v2 = this.value(e2)) ? e1.compareTo(assignment, e2) : v2.compareTo(v1);
                }
            });
            return values.iterator();
        }
        return variable.computeEnrollments(context.getAssignment()).iterator();
    }

    public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
        float credit;
        if (conflict.getRequest().isMPP() && conflict.equals(conflict.getRequest().getInitialAssignment()) && !enrollment.equals(enrollment.getRequest().getInitialAssignment())) {
            return false;
        }
        if (conflict.getRequest() instanceof CourseRequest && ((CourseRequest)conflict.getRequest()).getFixedValue() != null) {
            return false;
        }
        if (conflict.getRequest().getStudent().hasMinCredit() && (credit = conflict.getRequest().getStudent().getAssignedCredit(assignment) - conflict.getCredit()) < conflict.getRequest().getStudent().getMinCredit()) {
            return false;
        }
        if (!conflict.getRequest().isAlternative() && conflict.getRequest().getRequestPriority().isHigher(enrollment.getRequest())) {
            return false;
        }
        return !this.iPreferPriorityStudents && !conflict.getRequest().getRequestPriority().isSame(enrollment.getRequest()) || !conflict.getStudent().getPriority().isHigher(enrollment.getStudent());
    }

    @Override
    protected boolean checkBound(List<Request> variables2resolve, int idx, int depth, Enrollment value, Set<Enrollment> conflicts) {
        for (Enrollment conflict : conflicts) {
            if (this.canUnassign(value, conflict, this.getContext().getAssignment())) continue;
            return false;
        }
        return super.checkBound(variables2resolve, idx, depth, value, conflicts);
    }
}

