/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.OptimisticInheritedAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.assignment.context.ModelWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ConstraintListener;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.constraint.CancelledSections;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.constraint.CourseLimit;
import org.cpsolver.studentsct.constraint.DependentCourses;
import org.cpsolver.studentsct.constraint.DisabledSections;
import org.cpsolver.studentsct.constraint.FixInitialAssignments;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.constraint.RequiredReservation;
import org.cpsolver.studentsct.constraint.RequiredRestrictions;
import org.cpsolver.studentsct.constraint.RequiredSections;
import org.cpsolver.studentsct.constraint.ReservationLimit;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.constraint.StudentConflict;
import org.cpsolver.studentsct.constraint.StudentNotAvailable;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.weights.PriorityStudentWeights;
import org.cpsolver.studentsct.weights.StudentWeights;

public class StudentSectioningModel
extends ModelWithContext<Request, Enrollment, StudentSectioningModelContext>
implements CanInheritContext<Request, Enrollment, StudentSectioningModelContext> {
    private static Logger sLog = LogManager.getLogger(StudentSectioningModel.class);
    protected static DecimalFormat sDecimalFormat = new DecimalFormat("0.00");
    private List<Student> iStudents = new ArrayList<Student>();
    private List<Offering> iOfferings = new ArrayList<Offering>();
    private List<LinkedSections> iLinkedSections = new ArrayList<LinkedSections>();
    private DataProperties iProperties;
    private DistanceConflict iDistanceConflict = null;
    private TimeOverlapsCounter iTimeOverlaps = null;
    private StudentQuality iStudentQuality = null;
    private int iNrDummyStudents = 0;
    private int iNrDummyRequests = 0;
    private int[] iNrPriorityStudents = null;
    private double iTotalDummyWeight = 0.0;
    private double iTotalCRWeight = 0.0;
    private double iTotalDummyCRWeight = 0.0;
    private double[] iTotalPriorityCRWeight = null;
    private double[] iTotalCriticalCRWeight = new double[Request.RequestPriority.values().length];
    private double[][] iTotalPriorityCriticalCRWeight = new double[Request.RequestPriority.values().length][Student.StudentPriority.values().length];
    private double iTotalMPPCRWeight = 0.0;
    private double iTotalSelCRWeight = 0.0;
    private double iBestAssignedCourseRequestWeight = 0.0;
    private StudentWeights iStudentWeights = null;
    private boolean iReservationCanAssignOverTheLimit;
    private boolean iMPP;
    private boolean iKeepInitials;
    protected double iProjectedStudentWeight = 0.01;
    private int iMaxDomainSize = -1;
    private int iDayOfWeekOffset = 0;
    private DependentCourses iDependentCourses = null;

    public StudentSectioningModel(DataProperties properties) {
        int i;
        for (i = 0; i < Request.RequestPriority.values().length; ++i) {
            this.iTotalCriticalCRWeight[i] = 0.0;
            for (int j = 0; j < Student.StudentPriority.values().length; ++j) {
                this.iTotalPriorityCriticalCRWeight[i][j] = 0.0;
            }
        }
        this.iNrPriorityStudents = new int[Student.StudentPriority.values().length];
        this.iTotalPriorityCRWeight = new double[Student.StudentPriority.values().length];
        for (i = 0; i < Student.StudentPriority.values().length; ++i) {
            this.iNrPriorityStudents[i] = 0;
            this.iTotalPriorityCRWeight[i] = 0.0;
        }
        this.iReservationCanAssignOverTheLimit = properties.getPropertyBoolean("Reservation.CanAssignOverTheLimit", false);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iKeepInitials = properties.getPropertyBoolean("Sectioning.KeepInitialAssignments", false);
        this.iStudentWeights = new PriorityStudentWeights(properties);
        this.iMaxDomainSize = properties.getPropertyInt("Sectioning.MaxDomainSize", this.iMaxDomainSize);
        this.iDayOfWeekOffset = properties.getPropertyInt("DatePattern.DayOfWeekOffset", 0);
        if (properties.getPropertyBoolean("Sectioning.SectionLimit", true)) {
            SectionLimit sectionLimit = new SectionLimit(properties);
            this.addGlobalConstraint(sectionLimit);
            if (properties.getPropertyBoolean("Sectioning.SectionLimit.Debug", false)) {
                sectionLimit.addConstraintListener(new ConstraintListener<Request, Enrollment>(){

                    @Override
                    public void constraintBeforeAssigned(Assignment<Request, Enrollment> assignment, long iteration, Constraint<Request, Enrollment> constraint, Enrollment enrollment, Set<Enrollment> unassigned) {
                        if (enrollment.getStudent().isDummy()) {
                            for (Enrollment conflict : unassigned) {
                                if (conflict.getStudent().isDummy()) continue;
                                sLog.warn("Enrolment of a real student " + conflict.getStudent() + " is unassigned \n  -- " + conflict + "\ndue to an enrollment of a dummy student " + enrollment.getStudent() + " \n  -- " + enrollment);
                            }
                        }
                    }

                    @Override
                    public void constraintAfterAssigned(Assignment<Request, Enrollment> assignment, long iteration, Constraint<Request, Enrollment> constraint, Enrollment assigned, Set<Enrollment> unassigned) {
                    }
                });
            }
        }
        if (properties.getPropertyBoolean("Sectioning.ConfigLimit", true)) {
            ConfigLimit configLimit = new ConfigLimit(properties);
            this.addGlobalConstraint(configLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.CourseLimit", true)) {
            CourseLimit courseLimit = new CourseLimit(properties);
            this.addGlobalConstraint(courseLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.ReservationLimit", true)) {
            ReservationLimit reservationLimit = new ReservationLimit(properties);
            this.addGlobalConstraint(reservationLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.RequiredReservations", true)) {
            RequiredReservation requiredReservation = new RequiredReservation();
            this.addGlobalConstraint(requiredReservation);
        }
        if (properties.getPropertyBoolean("Sectioning.CancelledSections", true)) {
            CancelledSections cancelledSections = new CancelledSections();
            this.addGlobalConstraint(cancelledSections);
        }
        if (properties.getPropertyBoolean("Sectioning.StudentNotAvailable", true)) {
            StudentNotAvailable studentNotAvailable = new StudentNotAvailable();
            this.addGlobalConstraint(studentNotAvailable);
        }
        if (properties.getPropertyBoolean("Sectioning.DisabledSections", true)) {
            DisabledSections disabledSections = new DisabledSections();
            this.addGlobalConstraint(disabledSections);
        }
        if (properties.getPropertyBoolean("Sectioning.RequiredSections", true)) {
            RequiredSections requiredSections = new RequiredSections();
            this.addGlobalConstraint(requiredSections);
        }
        if (properties.getPropertyBoolean("Sectioning.RequiredRestrictions", true)) {
            RequiredRestrictions requiredRestrictions = new RequiredRestrictions();
            this.addGlobalConstraint(requiredRestrictions);
        }
        if (properties.getPropertyBoolean("Sectioning.HardDistanceConflict", false)) {
            HardDistanceConflicts hardDistanceConflicts = new HardDistanceConflicts();
            this.addGlobalConstraint(hardDistanceConflicts);
        }
        if (this.iMPP && this.iKeepInitials) {
            this.addGlobalConstraint(new FixInitialAssignments());
        }
        try {
            Class<?> studentWeightsClass = Class.forName(properties.getProperty("StudentWeights.Class", PriorityStudentWeights.class.getName()));
            this.iStudentWeights = (StudentWeights)studentWeightsClass.getConstructor(DataProperties.class).newInstance(properties);
        }
        catch (Exception e) {
            sLog.error("Unable to create custom student weighting model (" + e.getMessage() + "), using default.", (Throwable)e);
            this.iStudentWeights = new PriorityStudentWeights(properties);
        }
        this.iProjectedStudentWeight = properties.getPropertyDouble("StudentWeights.ProjectedStudentWeight", this.iProjectedStudentWeight);
        this.iProperties = properties;
    }

    public boolean getReservationCanAssignOverTheLimit() {
        return this.iReservationCanAssignOverTheLimit;
    }

    public boolean isMPP() {
        return this.iMPP;
    }

    public boolean getKeepInitialAssignments() {
        return this.iKeepInitials;
    }

    public StudentWeights getStudentWeights() {
        return this.iStudentWeights;
    }

    public void setStudentWeights(StudentWeights weights) {
        this.iStudentWeights = weights;
    }

    public List<Student> getStudents() {
        return this.iStudents;
    }

    public void addStudent(Student student) {
        this.iStudents.add(student);
        if (student.isDummy()) {
            ++this.iNrDummyStudents;
        }
        int n = student.getPriority().ordinal();
        this.iNrPriorityStudents[n] = this.iNrPriorityStudents[n] + 1;
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
        if (this.getProperties().getPropertyBoolean("Sectioning.StudentConflict", true)) {
            this.addConstraint(new StudentConflict(student));
        }
    }

    public int getNbrStudents(Student.StudentPriority priority) {
        return this.iNrPriorityStudents[priority.ordinal()];
    }

    @Override
    public void addVariable(Request request) {
        super.addVariable(request);
        if (request instanceof CourseRequest && !request.isAlternative()) {
            this.iTotalCRWeight += request.getWeight();
        }
        if (request instanceof CourseRequest && request.getRequestPriority() != Request.RequestPriority.Normal && !request.getStudent().isDummy() && !request.isAlternative()) {
            int n = request.getRequestPriority().ordinal();
            this.iTotalCriticalCRWeight[n] = this.iTotalCriticalCRWeight[n] + request.getWeight();
        }
        if (request instanceof CourseRequest && request.getRequestPriority() != Request.RequestPriority.Normal && !request.isAlternative()) {
            double[] dArray = this.iTotalPriorityCriticalCRWeight[request.getRequestPriority().ordinal()];
            int n = request.getStudent().getPriority().ordinal();
            dArray[n] = dArray[n] + request.getWeight();
        }
        if (request.getStudent().isDummy()) {
            ++this.iNrDummyRequests;
            this.iTotalDummyWeight += request.getWeight();
            if (request instanceof CourseRequest && !request.isAlternative()) {
                this.iTotalDummyCRWeight += request.getWeight();
            }
        }
        if (request instanceof CourseRequest && !request.isAlternative()) {
            int n = request.getStudent().getPriority().ordinal();
            this.iTotalPriorityCRWeight[n] = this.iTotalPriorityCRWeight[n] + request.getWeight();
        }
        if (request.isMPP()) {
            this.iTotalMPPCRWeight += request.getWeight();
        }
        if (request.hasSelection()) {
            this.iTotalSelCRWeight += request.getWeight();
        }
    }

    public void setCourseRequestPriority(CourseRequest request, Request.RequestPriority priority) {
        if (request.getRequestPriority() != Request.RequestPriority.Normal && !request.getStudent().isDummy() && !request.isAlternative()) {
            int n = request.getRequestPriority().ordinal();
            this.iTotalCriticalCRWeight[n] = this.iTotalCriticalCRWeight[n] - request.getWeight();
        }
        if (request.getRequestPriority() != Request.RequestPriority.Normal && !request.isAlternative()) {
            double[] dArray = this.iTotalPriorityCriticalCRWeight[request.getRequestPriority().ordinal()];
            int n = request.getStudent().getPriority().ordinal();
            dArray[n] = dArray[n] - request.getWeight();
        }
        request.setRequestPriority(priority);
        if (request.getRequestPriority() != Request.RequestPriority.Normal && !request.getStudent().isDummy() && !request.isAlternative()) {
            int n = request.getRequestPriority().ordinal();
            this.iTotalCriticalCRWeight[n] = this.iTotalCriticalCRWeight[n] + request.getWeight();
        }
        if (request.getRequestPriority() != Request.RequestPriority.Normal && !request.isAlternative()) {
            double[] dArray = this.iTotalPriorityCriticalCRWeight[request.getRequestPriority().ordinal()];
            int n = request.getStudent().getPriority().ordinal();
            dArray[n] = dArray[n] + request.getWeight();
        }
    }

    public void requestWeightsChanged(Assignment<Request, Enrollment> assignment) {
        ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).requestWeightsChanged(assignment);
    }

    public void removeStudent(Student student) {
        this.iStudents.remove(student);
        if (student.isDummy()) {
            --this.iNrDummyStudents;
        }
        int n = student.getPriority().ordinal();
        this.iNrPriorityStudents[n] = this.iNrPriorityStudents[n] - 1;
        Constraint conflict = null;
        for (Request request : student.getRequests()) {
            for (Constraint c : request.constraints()) {
                if (!(c instanceof StudentConflict)) continue;
                conflict = (StudentConflict)c;
                break;
            }
            if (conflict != null) {
                conflict.removeVariable(request);
            }
            this.removeVariable(request);
        }
        if (conflict != null) {
            this.removeConstraint(conflict);
        }
    }

    @Override
    public void removeVariable(Request request) {
        super.removeVariable(request);
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            for (Course course : cr.getCourses()) {
                course.getRequests().remove(request);
            }
        }
        if (request.getStudent().isDummy()) {
            --this.iNrDummyRequests;
            this.iTotalDummyWeight -= request.getWeight();
            if (request instanceof CourseRequest && !request.isAlternative()) {
                this.iTotalDummyCRWeight -= request.getWeight();
            }
        }
        if (request instanceof CourseRequest && !request.isAlternative()) {
            int n = request.getStudent().getPriority().ordinal();
            this.iTotalPriorityCRWeight[n] = this.iTotalPriorityCRWeight[n] - request.getWeight();
        }
        if (request.isMPP()) {
            this.iTotalMPPCRWeight -= request.getWeight();
        }
        if (request.hasSelection()) {
            this.iTotalSelCRWeight -= request.getWeight();
        }
        if (request instanceof CourseRequest && !request.isAlternative()) {
            this.iTotalCRWeight -= request.getWeight();
        }
        if (request instanceof CourseRequest && request.getRequestPriority() != Request.RequestPriority.Normal && !request.getStudent().isDummy() && !request.isAlternative()) {
            int n = request.getRequestPriority().ordinal();
            this.iTotalCriticalCRWeight[n] = this.iTotalCriticalCRWeight[n] - request.getWeight();
        }
        if (request instanceof CourseRequest && request.getRequestPriority() != Request.RequestPriority.Normal && !request.isAlternative()) {
            double[] dArray = this.iTotalPriorityCriticalCRWeight[request.getRequestPriority().ordinal()];
            int n = request.getStudent().getPriority().ordinal();
            dArray[n] = dArray[n] - request.getWeight();
        }
    }

    public List<Offering> getOfferings() {
        return this.iOfferings;
    }

    public void addOffering(Offering offering) {
        this.iOfferings.add(offering);
        offering.setModel(this);
    }

    public void addLinkedSections(boolean mustBeUsed, Section ... sections) {
        LinkedSections constraint = new LinkedSections(sections);
        constraint.setMustBeUsed(mustBeUsed);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    @Deprecated
    public void addLinkedSections(Section ... sections) {
        this.addLinkedSections(false, sections);
    }

    public void addLinkedSections(boolean mustBeUsed, Collection<Section> sections) {
        LinkedSections constraint = new LinkedSections(sections);
        constraint.setMustBeUsed(mustBeUsed);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    @Deprecated
    public void addLinkedSections(Collection<Section> sections) {
        this.addLinkedSections(false, sections);
    }

    public List<LinkedSections> getLinkedSections() {
        return this.iLinkedSections;
    }

    @Override
    public Map<String, String> getInfo(Assignment<Request, Enrollment> assignment) {
        int nrLastLikeStudents;
        int confs;
        int shortConfs;
        Map<String, String> info = super.getInfo(assignment);
        StudentSectioningModelContext context = (StudentSectioningModelContext)this.getContext((Assignment)assignment);
        if (!this.getStudents().isEmpty()) {
            info.put("Students with complete schedule", sDoubleFormat.format(100.0 * (double)context.nrComplete() / (double)this.getStudents().size()) + "% (" + context.nrComplete() + "/" + this.getStudents().size() + ")");
        }
        String priorityComplete = "";
        for (Student.StudentPriority sp : Student.StudentPriority.values()) {
            if (sp == Student.StudentPriority.Dummy || this.iNrPriorityStudents[sp.ordinal()] <= 0) continue;
            priorityComplete = priorityComplete + (priorityComplete.isEmpty() ? "" : "\n") + sp.name() + ": " + sDoubleFormat.format(100.0 * (double)context.iNrCompletePriorityStudents[sp.ordinal()] / (double)this.iNrPriorityStudents[sp.ordinal()]) + "% (" + context.iNrCompletePriorityStudents[sp.ordinal()] + "/" + this.iNrPriorityStudents[sp.ordinal()] + ")";
        }
        if (!priorityComplete.isEmpty()) {
            info.put("Students with complete schedule (priority students)", priorityComplete);
        }
        if (this.getStudentQuality() != null) {
            int confs2 = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.Distance, assignment);
            shortConfs = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.ShortDistance, assignment);
            int unavConfs = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.UnavailabilityDistance, assignment);
            if (confs2 > 0 || shortConfs > 0) {
                info.put("Student distance conflicts", confs2 + (shortConfs == 0 ? "" : " (" + this.getDistanceMetric().getShortDistanceAccommodationReference() + ": " + shortConfs + ")"));
            }
            if (unavConfs > 0) {
                info.put("Unavailabilities: Distance conflicts", String.valueOf(unavConfs));
            }
        } else if (this.getDistanceConflict() != null && (confs = this.getDistanceConflict().getTotalNrConflicts(assignment)) > 0) {
            shortConfs = this.getDistanceConflict().getTotalNrShortConflicts(assignment);
            info.put("Student distance conflicts", confs + (shortConfs == 0 ? "" : " (" + this.getDistanceConflict().getDistanceMetric().getShortDistanceAccommodationReference() + ": " + shortConfs + ")"));
        }
        if (this.getStudentQuality() != null) {
            int shareUN;
            int shareFT;
            int shareCR = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.CourseTimeOverlap, assignment);
            if (shareCR + (shareFT = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.FreeTimeOverlap, assignment)) + (shareUN = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.Unavailability, assignment)) > 0) {
                info.put("Time overlapping conflicts", sDoubleFormat.format(5.0 * (double)(shareCR + shareFT + shareUN) / (double)this.iStudents.size()) + " mins per student\n(" + sDoubleFormat.format(5.0 * (double)shareCR / (double)this.iStudents.size()) + " between courses, " + sDoubleFormat.format(5.0 * (double)shareFT / (double)this.iStudents.size()) + " free time" + (shareUN == 0 ? "" : ", " + sDoubleFormat.format(5.0 * (double)shareUN / (double)this.iStudents.size()) + " teaching assignments & unavailabilities") + "; " + sDoubleFormat.format((double)(shareCR + shareFT + shareUN) / 12.0) + " hours total)");
            }
        } else if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts(assignment) != 0) {
            info.put("Time overlapping conflicts", sDoubleFormat.format(5.0 * (double)this.getTimeOverlaps().getTotalNrConflicts(assignment) / (double)this.iStudents.size()) + " mins per student (" + sDoubleFormat.format((double)this.getTimeOverlaps().getTotalNrConflicts(assignment) / 12.0) + " hours total)");
        }
        if (this.getStudentQuality() != null) {
            int shortConfs2;
            int accBbc;
            int accBtB;
            int accFT;
            int late;
            int early;
            int confWorkDay;
            int confMod;
            int confBtB;
            int confTravel;
            int confLunch = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.LunchBreak, assignment);
            if (confLunch > 0) {
                info.put("Schedule Quality: Lunch conflicts", sDoubleFormat.format(20.0 * (double)confLunch / (double)this.getNrRealStudents(false)) + "% (" + confLunch + ")");
            }
            if ((confTravel = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.TravelTime, assignment)) > 0) {
                info.put("Schedule Quality: Travel time", sDoubleFormat.format((double)confTravel / (double)this.getNrRealStudents(false)) + " mins per student (" + sDecimalFormat.format((double)confTravel / 60.0) + " hours total)");
            }
            if ((confBtB = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.BackToBack, assignment)) != 0) {
                info.put("Schedule Quality: Back-to-back classes", sDoubleFormat.format((double)confBtB / (double)this.getNrRealStudents(false)) + " per student (" + confBtB + ")");
            }
            if ((confMod = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.Modality, assignment)) > 0) {
                info.put("Schedule Quality: Online class preference", sDoubleFormat.format((double)confMod / (double)this.getNrRealStudents(false)) + " per student (" + confMod + ")");
            }
            if ((confWorkDay = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.WorkDay, assignment)) > 0) {
                info.put("Schedule Quality: Work day", sDoubleFormat.format(5.0 * (double)confWorkDay / (double)this.getNrRealStudents(false)) + " mins over " + new DecimalFormat("0.#").format((double)this.getProperties().getPropertyInt("WorkDay.WorkDayLimit", 72) / 12.0) + " hours a day per student\n(from start to end, " + sDoubleFormat.format((double)confWorkDay / 12.0) + " hours total)");
            }
            if ((early = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.TooEarly, assignment)) > 0) {
                int min = this.getProperties().getPropertyInt("WorkDay.EarlySlot", 102) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                int h = min / 60;
                int m = min % 60;
                String time = this.getProperties().getPropertyBoolean("General.UseAmPm", true) ? (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a") : h + ":" + (m < 10 ? "0" : "") + m;
                info.put("Schedule Quality: Early classes", sDoubleFormat.format(5.0 * (double)early / (double)this.iStudents.size()) + " mins before " + time + " per student (" + sDoubleFormat.format((double)early / 12.0) + " hours total)");
            }
            if ((late = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.TooLate, assignment)) > 0) {
                int min = this.getProperties().getPropertyInt("WorkDay.LateSlot", 210) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                int h = min / 60;
                int m = min % 60;
                String time = this.getProperties().getPropertyBoolean("General.UseAmPm", true) ? (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a") : h + ":" + (m < 10 ? "0" : "") + m;
                info.put("Schedule Quality: Late classes", sDoubleFormat.format(5.0 * (double)late / (double)this.iStudents.size()) + " mins after " + time + " per student (" + sDoubleFormat.format((double)late / 12.0) + " hours total)");
            }
            if ((accFT = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.AccFreeTimeOverlap, assignment)) > 0) {
                info.put("Accommodations: Free time conflicts", sDoubleFormat.format(5.0 * (double)accFT / (double)this.getStudentsWithAccommodation(this.getStudentQuality().getStudentQualityContext().getFreeTimeAccommodation())) + " mins per student, " + sDoubleFormat.format((double)accFT / 12.0) + " hours total");
            }
            if ((accBtB = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.AccBackToBack, assignment)) > 0) {
                info.put("Accommodations: Back-to-back classes", sDoubleFormat.format((double)accBtB / (double)this.getStudentsWithAccommodation(this.getStudentQuality().getStudentQualityContext().getBackToBackAccommodation())) + " non-BTB classes per student, " + accBtB + " total");
            }
            if ((accBbc = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.AccBreaksBetweenClasses, assignment)) > 0) {
                info.put("Accommodations: Break between classes", sDoubleFormat.format((double)accBbc / (double)this.getStudentsWithAccommodation(this.getStudentQuality().getStudentQualityContext().getBreakBetweenClassesAccommodation())) + " BTB classes per student, " + accBbc + " total");
            }
            if ((shortConfs2 = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.ShortDistance, assignment)) > 0) {
                info.put("Accommodations: Distance conflicts", sDoubleFormat.format((double)shortConfs2 / (double)this.getStudentsWithAccommodation(this.getStudentQuality().getDistanceMetric().getShortDistanceAccommodationReference())) + " short distance conflicts per student, " + shortConfs2 + " total");
            }
        }
        if ((nrLastLikeStudents = this.getNrLastLikeStudents(false)) != 0 && nrLastLikeStudents != this.getStudents().size()) {
            int nrRealStudents = this.getStudents().size() - nrLastLikeStudents;
            int nrLastLikeCompleteStudents = this.getNrCompleteLastLikeStudents(assignment, false);
            int nrRealCompleteStudents = context.nrComplete() - nrLastLikeCompleteStudents;
            if (nrLastLikeStudents > 0) {
                info.put("Projected students with complete schedule", sDecimalFormat.format(100.0 * (double)nrLastLikeCompleteStudents / (double)nrLastLikeStudents) + "% (" + nrLastLikeCompleteStudents + "/" + nrLastLikeStudents + ")");
            }
            if (nrRealStudents > 0) {
                info.put("Real students with complete schedule", sDecimalFormat.format(100.0 * (double)nrRealCompleteStudents / (double)nrRealStudents) + "% (" + nrRealCompleteStudents + "/" + nrRealStudents + ")");
            }
            int nrLastLikeRequests = this.getNrLastLikeRequests(false);
            int nrRealRequests = this.variables().size() - nrLastLikeRequests;
            int nrLastLikeAssignedRequests = context.getNrAssignedLastLikeRequests();
            int nrRealAssignedRequests = assignment.nrAssignedVariables() - nrLastLikeAssignedRequests;
            if (nrLastLikeRequests > 0) {
                info.put("Projected assigned requests", sDecimalFormat.format(100.0 * (double)nrLastLikeAssignedRequests / (double)nrLastLikeRequests) + "% (" + nrLastLikeAssignedRequests + "/" + nrLastLikeRequests + ")");
            }
            if (nrRealRequests > 0) {
                info.put("Real assigned requests", sDecimalFormat.format(100.0 * (double)nrRealAssignedRequests / (double)nrRealRequests) + "% (" + nrRealAssignedRequests + "/" + nrRealRequests + ")");
            }
        }
        context.getInfo(assignment, info);
        double groupSpread = 0.0;
        double groupCount = 0.0;
        for (Offering offering : this.iOfferings) {
            for (Course course : offering.getCourses()) {
                for (RequestGroup group : course.getRequestGroups()) {
                    groupSpread += group.getAverageSpread(assignment) * group.getEnrollmentWeight(assignment, null);
                    groupCount += group.getEnrollmentWeight(assignment, null);
                }
            }
        }
        if (groupCount > 0.0) {
            info.put("Same group", sDecimalFormat.format(100.0 * groupSpread / groupCount) + "%");
        }
        return info;
    }

    public double getTotalValue(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (precise) {
            double total = 0.0;
            for (Request request : assignment.assignedVariables()) {
                total += request.getWeight() * this.iStudentWeights.getWeight(assignment, assignment.getValue(request));
            }
            if (this.iDistanceConflict != null) {
                for (DistanceConflict.Conflict conflict : this.iDistanceConflict.computeAllConflicts(assignment)) {
                    total -= this.avg(conflict.getR1().getWeight(), conflict.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(assignment, conflict);
                }
            }
            if (this.iTimeOverlaps != null) {
                for (TimeOverlapsCounter.Conflict conflict : ((TimeOverlapsCounter.TimeOverlapsCounterContext)this.iTimeOverlaps.getContext(assignment)).computeAllConflicts(assignment)) {
                    if (conflict.getR1() != null) {
                        total -= conflict.getR1Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, conflict.getE1(), conflict);
                    }
                    if (conflict.getR2() == null) continue;
                    total -= conflict.getR2Weight() * this.iStudentWeights.getTimeOverlapConflictWeight(assignment, conflict.getE2(), conflict);
                }
            }
            if (this.iStudentQuality != null) {
                for (Iterator<Object> iterator : StudentQuality.Type.values()) {
                    for (StudentQuality.Conflict c : ((StudentQuality.StudentQualityContext)this.iStudentQuality.getContext(assignment)).computeAllConflicts((StudentQuality.Type)((Object)iterator), assignment)) {
                        switch (c.getType().getType()) {
                            case REQUEST: {
                                if (c.getR1() instanceof CourseRequest) {
                                    total -= c.getR1Weight() * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                                    break;
                                }
                                total -= c.getR2Weight() * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                                break;
                            }
                            case BOTH: {
                                total -= c.getR1Weight() * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                                total -= c.getR2Weight() * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                                break;
                            }
                            case LOWER: {
                                total -= this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                                break;
                            }
                            case HIGHER: {
                                total -= this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                            }
                        }
                    }
                }
            }
            return -total;
        }
        return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getTotalValue();
    }

    @Override
    public double getTotalValue(Assignment<Request, Enrollment> assignment) {
        return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getTotalValue();
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void clearOnlineSectioningInfos() {
        for (Offering offering : this.iOfferings) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        section.setSpaceExpected(0.0);
                        section.setSpaceHeld(0.0);
                    }
                }
            }
        }
    }

    public void computeOnlineSectioningInfos(Assignment<Request, Enrollment> assignment) {
        this.clearOnlineSectioningInfos();
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                Enrollment enrollment = assignment.getValue(courseRequest);
                if (enrollment != null) {
                    for (Section section : enrollment.getSections()) {
                        section.setSpaceHeld(courseRequest.getWeight() + section.getSpaceHeld());
                    }
                }
                ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
                int totalLimit = 0;
                for (Enrollment enrl : courseRequest.values(assignment)) {
                    boolean overlaps = false;
                    for (Request otherRequest : student.getRequests()) {
                        Enrollment otherErollment;
                        if (otherRequest.equals(courseRequest) || !(otherRequest instanceof CourseRequest) || (otherErollment = assignment.getValue(otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                        overlaps = true;
                        break;
                    }
                    if (overlaps) continue;
                    feasibleEnrollments.add(enrl);
                    if (totalLimit < 0) continue;
                    int limit = enrl.getLimit();
                    if (limit < 0) {
                        totalLimit = -1;
                        continue;
                    }
                    totalLimit += limit;
                }
                double increment = courseRequest.getWeight() / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
                for (Enrollment feasibleEnrollment : feasibleEnrollments) {
                    for (Section section : feasibleEnrollment.getSections()) {
                        if (totalLimit > 0) {
                            section.setSpaceExpected(section.getSpaceExpected() + increment * (double)feasibleEnrollment.getLimit());
                            continue;
                        }
                        section.setSpaceExpected(section.getSpaceExpected() + increment);
                    }
                }
            }
        }
    }

    public double getUnassignedRequestWeight(Assignment<Request, Enrollment> assignment) {
        double weight = 0.0;
        for (Request request : assignment.unassignedVariables(this)) {
            weight += request.getWeight();
        }
        return weight;
    }

    public double getTotalRequestWeight() {
        double weight = 0.0;
        for (Request request : this.variables()) {
            weight += request.getWeight();
        }
        return weight;
    }

    public void setDistanceConflict(DistanceConflict dc) {
        this.iDistanceConflict = dc;
    }

    public DistanceConflict getDistanceConflict() {
        return this.iDistanceConflict;
    }

    public void setTimeOverlaps(TimeOverlapsCounter toc) {
        this.iTimeOverlaps = toc;
    }

    public TimeOverlapsCounter getTimeOverlaps() {
        return this.iTimeOverlaps;
    }

    public StudentQuality getStudentQuality() {
        return this.iStudentQuality;
    }

    public void setStudentQuality(StudentQuality q, boolean register) {
        if (this.iStudentQuality != null) {
            this.getInfoProviders().remove(this.iStudentQuality);
        }
        this.iStudentQuality = q;
        if (this.iStudentQuality != null) {
            this.getInfoProviders().add(this.iStudentQuality);
        }
        if (register) {
            this.iStudentQuality.setAssignmentContextReference(this.createReference(this.iStudentQuality));
            this.iStudentQuality.register(this);
        }
    }

    public void setStudentQuality(StudentQuality q) {
        this.setStudentQuality(q, true);
    }

    public double avgUnassignPriority(Assignment<Request, Enrollment> assignment) {
        double totalPriority = 0.0;
        for (Request request : assignment.unassignedVariables(this)) {
            if (request.isAlternative()) continue;
            totalPriority += (double)request.getPriority();
        }
        return 1.0 + totalPriority / (double)assignment.nrUnassignedVariables(this);
    }

    public double avgNrRequests() {
        double totalRequests = 0.0;
        int totalStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.nrRequests() == 0) continue;
            totalRequests += (double)student.nrRequests();
            ++totalStudents;
        }
        return totalRequests / (double)totalStudents;
    }

    public int getNrLastLikeStudents(boolean precise) {
        if (!precise) {
            return this.iNrDummyStudents;
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrRealStudents(boolean precise) {
        if (!precise) {
            return this.getStudents().size() - this.iNrDummyStudents;
        }
        int nrRealStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getStudentsWithAccommodation(String acc) {
        int nrAccStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.hasAccommodation(acc)) continue;
            ++nrAccStudents;
        }
        return nrAccStudents;
    }

    public int getNrCompleteLastLikeStudents(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrCompleteLastLikeStudents();
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isComplete(assignment) || !student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrCompleteRealStudents(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).nrComplete() - ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrCompleteLastLikeStudents();
        }
        int nrRealStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isComplete(assignment) || student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getNrLastLikeRequests(boolean precise) {
        if (!precise) {
            return this.iNrDummyRequests;
        }
        int nrLastLikeRequests = 0;
        for (Request request : this.variables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrRealRequests(boolean precise) {
        if (!precise) {
            return this.variables().size() - this.iNrDummyRequests;
        }
        int nrRealRequests = 0;
        for (Request request : this.variables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    public int getNrAssignedLastLikeRequests(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrAssignedLastLikeRequests();
        }
        int nrLastLikeRequests = 0;
        for (Request request : assignment.assignedVariables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrAssignedRealRequests(Assignment<Request, Enrollment> assignment, boolean precise) {
        if (!precise) {
            return assignment.nrAssignedVariables() - ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getNrAssignedLastLikeRequests();
        }
        int nrRealRequests = 0;
        for (Request request : assignment.assignedVariables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getExtendedInfo(Assignment<Request, Enrollment> assignment) {
        int i;
        void var14_57;
        Map<String, String> info = this.getInfo(assignment);
        if (this.getStudentQuality() == null && this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts(assignment) != 0) {
            Set<TimeOverlapsCounter.Conflict> conf = ((TimeOverlapsCounter.TimeOverlapsCounterContext)this.getTimeOverlaps().getContext(assignment)).computeAllConflicts(assignment);
            int share = 0;
            int crShare = 0;
            for (TimeOverlapsCounter.Conflict c : conf) {
                share += c.getShare();
                if (!(c.getR1() instanceof CourseRequest) || !(c.getR2() instanceof CourseRequest)) continue;
                crShare += c.getShare();
            }
            if (share > 0) {
                info.put("Time overlapping conflicts", sDoubleFormat.format(5.0 * (double)share / (double)this.iStudents.size()) + " mins per student\n(" + sDoubleFormat.format(5.0 * (double)crShare / (double)this.iStudents.size()) + " between courses; " + sDoubleFormat.format((double)this.getTimeOverlaps().getTotalNrConflicts(assignment) / 12.0) + " hours total)");
            }
        }
        if (this.getStudentQuality() != null) {
            int confMod;
            int confBtB = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.BackToBack, assignment);
            if (confBtB != 0) {
                int prefBtb = 0;
                int discBtb = 0;
                int prefStd = 0;
                int discStd = 0;
                int prefPairs = 0;
                int discPairs = 0;
                for (Student student : this.getStudents()) {
                    if (student.isDummy() || student.getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE) continue;
                    int[] classesPerDay = new int[]{0, 0, 0, 0, 0, 0, 0};
                    for (Request request : student.getRequests()) {
                        Enrollment e = request.getAssignment(assignment);
                        if (e == null || !e.isCourseRequest()) continue;
                        for (Section x : e.getSections()) {
                            if (x.getTime() == null) continue;
                            for (int i2 = 0; i2 < Constants.DAY_CODES.length; ++i2) {
                                if ((x.getTime().getDayCode() & Constants.DAY_CODES[i2]) == 0) continue;
                                int n = i2;
                                classesPerDay[n] = classesPerDay[n] + 1;
                            }
                        }
                    }
                    int max = 0;
                    for (int c : classesPerDay) {
                        if (c <= 1) continue;
                        max += c - 1;
                    }
                    int n = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).allPenalty(StudentQuality.Type.BackToBack, assignment, student);
                    if (student.getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED) {
                        ++prefStd;
                        prefBtb += n;
                        prefPairs += Math.max(n, max);
                        continue;
                    }
                    if (student.getBackToBackPreference() != Student.BackToBackPreference.BTB_DISCOURAGED) continue;
                    ++discStd;
                    discBtb -= n;
                    discPairs += Math.max(n, max);
                }
                if (prefStd > 0) {
                    info.put("Schedule Quality: Back-to-back preferred", sDoubleFormat.format(100.0 * (double)prefBtb / (double)prefPairs) + "% back-to-backs on average (" + prefBtb + "/" + prefPairs + " BTBs for " + prefStd + " students)");
                }
                if (discStd > 0) {
                    info.put("Schedule Quality: Back-to-back discouraged", sDoubleFormat.format(100.0 - 100.0 * (double)discBtb / (double)discPairs) + "% non back-to-backs on average (" + discBtb + "/" + discPairs + " BTBs for " + discStd + " students)");
                }
            }
            if ((confMod = this.getStudentQuality().getTotalPenalty(StudentQuality.Type.Modality, assignment)) > 0) {
                int prefOnl = 0;
                int discOnl = 0;
                int prefStd = 0;
                int discStd = 0;
                int prefCls = 0;
                int discCls = 0;
                for (Student s : this.getStudents()) {
                    if (s.isDummy() || s.isDummy() || s.getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE || s.getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED) continue;
                    int classes = 0;
                    for (Request r : s.getRequests()) {
                        Enrollment e = r.getAssignment(assignment);
                        if (e == null || !e.isCourseRequest()) continue;
                        classes += e.getSections().size();
                    }
                    if (s.getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED) {
                        ++prefStd;
                        prefOnl += ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).allPenalty(StudentQuality.Type.Modality, assignment, s);
                        prefCls += classes;
                        continue;
                    }
                    if (s.getModalityPreference() != Student.ModalityPreference.ONILNE_DISCOURAGED) continue;
                    ++discStd;
                    discOnl += ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).allPenalty(StudentQuality.Type.Modality, assignment, s);
                    discCls += classes;
                }
                if (prefStd > 0) {
                    info.put("Schedule Quality: Online preferred", sDoubleFormat.format(100.0 - 100.0 * (double)prefOnl / (double)prefCls) + "% online classes on average (" + prefOnl + "/" + prefCls + " classes for " + prefStd + " students)");
                }
                if (discStd > 0) {
                    info.put("Schedule Quality: Online discouraged", sDoubleFormat.format(100.0 - 100.0 * (double)discOnl / (double)discCls) + "% face-to-face classes on average (" + discOnl + "/" + discCls + " classes for " + discStd + " students)");
                }
            }
        }
        double disbWeight = 0.0;
        int disbSections = 0;
        int disb10Sections = 0;
        int disb10Limit = this.getProperties().getPropertyInt("Info.ListDisbalancedSections", 0);
        TreeSet<String> disb10SectionList = disb10Limit == 0 ? null : new TreeSet<String>();
        for (Offering offering : this.getOfferings()) {
            if (offering.isDummy()) continue;
            for (Config config : offering.getConfigs()) {
                double enrl = config.getEnrollmentTotalWeight(assignment, null);
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getSections().size() <= 1) continue;
                    if (subpart.getLimit() > 0) {
                        double ratio = enrl / (double)subpart.getLimit();
                        for (Section section : subpart.getSections()) {
                            double desired = ratio * (double)section.getLimit();
                            disbWeight += Math.abs(section.getEnrollmentTotalWeight(assignment, null) - desired);
                            ++disbSections;
                            if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                            ++disb10Sections;
                            if (disb10SectionList == null) continue;
                            disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                        }
                        continue;
                    }
                    for (Section section : subpart.getSections()) {
                        double desired = enrl / (double)subpart.getSections().size();
                        disbWeight += Math.abs(section.getEnrollmentTotalWeight(assignment, null) - desired);
                        ++disbSections;
                        if (!(Math.abs(desired - section.getEnrollmentTotalWeight(assignment, null)) >= Math.max(1.0, 0.1 * desired))) continue;
                        ++disb10Sections;
                        if (disb10SectionList == null) continue;
                        disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                    }
                }
            }
        }
        if (disbSections != 0) {
            void var11_34;
            double assignedCRWeight = ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCourseRequestWeight();
            info.put("Average disbalance", sDecimalFormat.format(assignedCRWeight == 0.0 ? 0.0 : 100.0 * disbWeight / assignedCRWeight) + "% (" + sDecimalFormat.format(disbWeight / (double)disbSections) + ")");
            String string = "";
            if (disb10SectionList != null) {
                int i3 = 0;
                for (String string2 : disb10SectionList) {
                    void var11_31;
                    if (i3 == disb10Limit) {
                        String string3 = (String)var11_31 + "\n...";
                        break;
                    }
                    String string4 = (String)var11_31 + "\n" + string2;
                    ++i3;
                }
            }
            info.put("Sections disbalanced by 10% or more", sDecimalFormat.format(disbSections == 0 ? 0.0 : 100.0 * (double)disb10Sections / (double)disbSections) + "% (" + disb10Sections + ")" + (var11_34.isEmpty() ? "" : "\n" + (String)var11_34));
        }
        int assCR = 0;
        int priCR = 0;
        for (Request r : this.variables()) {
            CourseRequest cr;
            Enrollment enrollment;
            if (!(r instanceof CourseRequest) || r.getStudent().isDummy() || (enrollment = assignment.getValue(cr = (CourseRequest)r)) == null) continue;
            ++assCR;
            if (cr.isAlternative() || !cr.getCourses().get(0).equals(enrollment.getCourse())) continue;
            ++priCR;
        }
        if (assCR > 0) {
            info.put("Assigned priority course requests", sDoubleFormat.format(100.0 * (double)priCR / (double)assCR) + "% (" + priCR + "/" + assCR + ")");
        }
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        int incomplete = 0;
        for (Student student : this.getStudents()) {
            if (student.isDummy()) continue;
            int nrRequests = 0;
            int nrAssignedRequests = 0;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                if (!r.isAlternative()) {
                    ++nrRequests;
                }
                if (!r.isAssigned(assignment)) continue;
                ++nrAssignedRequests;
            }
            if (nrAssignedRequests >= nrRequests) continue;
            int n = Math.min(nrRequests - nrAssignedRequests, nArray.length) - 1;
            nArray[n] = nArray[n] + 1;
            ++incomplete;
        }
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            if (nArray[i4] <= 0) continue;
            info.put("Students missing " + (i4 == 0 ? "1 course" : (i4 + 1 == nArray.length ? i4 + 1 + " or more courses" : i4 + 1 + " courses")), sDecimalFormat.format(100.0 * (double)nArray[i4] / (double)incomplete) + "% (" + nArray[i4] + ")");
        }
        info.put("Overall solution value", sDoubleFormat.format(this.getTotalValue(assignment)));
        int nrStudentsBelowMinCredit = 0;
        boolean bl = false;
        for (Student student : this.getStudents()) {
            if (student.isDummy() || !student.hasMinCredit()) continue;
            ++var14_57;
            float credit = student.getAssignedCredit(assignment);
            if (!(credit < student.getMinCredit()) || student.isComplete(assignment)) continue;
            ++nrStudentsBelowMinCredit;
        }
        if (nrStudentsBelowMinCredit > 0) {
            info.put("Students below min credit", sDoubleFormat.format(100.0 * (double)nrStudentsBelowMinCredit / (double)var14_57) + "% (" + nrStudentsBelowMinCredit + "/" + (int)var14_57 + ")");
        }
        int[] notAssignedPriority = new int[]{0, 0, 0, 0, 0, 0, 0};
        int[] assignedChoice = new int[]{0, 0, 0, 0, 0};
        int notAssignedTotal = 0;
        int assignedChoiceTotal = 0;
        int avgPriority = 0;
        int avgChoice = 0;
        for (Student student : this.getStudents()) {
            if (student.isDummy()) continue;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                Enrollment e = r.getAssignment(assignment);
                if (e == null) {
                    if (r.isAlternative()) continue;
                    int n = Math.min(r.getPriority(), notAssignedPriority.length - 1);
                    notAssignedPriority[n] = notAssignedPriority[n] + 1;
                    ++notAssignedTotal;
                    avgPriority += r.getPriority();
                    continue;
                }
                int n = Math.min(e.getTruePriority(), assignedChoice.length - 1);
                assignedChoice[n] = assignedChoice[n] + 1;
                ++assignedChoiceTotal;
                avgChoice += e.getTruePriority();
            }
        }
        for (i = 0; i < notAssignedPriority.length; ++i) {
            if (notAssignedPriority[i] <= 0) continue;
            info.put("Priority: Not-assigned priority " + (i + 1 == notAssignedPriority.length ? i + 1 + "+" : Integer.valueOf(i + 1)) + " course requests", sDecimalFormat.format(100.0 * (double)notAssignedPriority[i] / (double)notAssignedTotal) + "% (" + notAssignedPriority[i] + ")");
        }
        if (notAssignedTotal > 0) {
            info.put("Priority: Average not-assigned priority", sDecimalFormat.format(1.0 + (double)avgPriority / (double)notAssignedTotal));
        }
        for (i = 0; i < assignedChoice.length; ++i) {
            if (assignedChoice[i] <= 0) continue;
            info.put("Choice: assigned " + (i == 0 ? "1st" : (i == 1 ? "2nd" : (i == 2 ? "3rd" : (i + 1 == assignedChoice.length ? i + 1 + "th+" : i + 1 + "th")))) + " course choice", sDecimalFormat.format(100.0 * (double)assignedChoice[i] / (double)assignedChoiceTotal) + "% (" + assignedChoice[i] + ")");
        }
        if (assignedChoiceTotal > 0) {
            info.put("Choice: Average assigned choice", sDecimalFormat.format(1.0 + (double)avgChoice / (double)assignedChoiceTotal));
        }
        int nbrSections = 0;
        int nbrFullSections = 0;
        int nbrSections98 = 0;
        int nbrSections95 = 0;
        int nbrSections90 = 0;
        int nbrSectionsDis = 0;
        int enrlSections = 0;
        int enrlFullSections = 0;
        int enrlSections98 = 0;
        int enrlSections95 = 0;
        int enrlSections90 = 0;
        int enrlSectionsDis = 0;
        int nbrOfferings = 0;
        int nbrFullOfferings = 0;
        int nbrOfferings98 = 0;
        int nbrOfferings95 = 0;
        int nbrOfferings90 = 0;
        int enrlOfferings = 0;
        int enrlOfferingsFull = 0;
        int enrlOfferings98 = 0;
        int enrlOfferings95 = 0;
        int enrlOfferings90 = 0;
        for (Offering offering : this.getOfferings()) {
            if (offering.isDummy()) continue;
            int offeringLimit = 0;
            int offeringEnrollment = 0;
            for (Config config : offering.getConfigs()) {
                int configLimit = config.getLimit();
                for (Subpart subpart : config.getSubparts()) {
                    int subpartLimit = 0;
                    for (Section section : subpart.getSections()) {
                        if (section.isCancelled()) continue;
                        int enrl = section.getEnrollments(assignment).size();
                        subpartLimit = section.getLimit() < 0 || subpartLimit < 0 ? -1 : (subpartLimit += section.isEnabled() ? section.getLimit() : enrl);
                        ++nbrSections;
                        enrlSections += enrl;
                        if (section.getLimit() >= 0 && section.getLimit() <= enrl) {
                            ++nbrFullSections;
                            enrlFullSections += enrl;
                        }
                        if (!(section.isEnabled() || enrl <= 0 && section.getLimit() < 0)) {
                            ++nbrSectionsDis;
                            enrlSectionsDis += enrl;
                        }
                        if (section.getLimit() >= 0 && (long)(section.getLimit() - enrl) <= Math.round(0.02 * (double)section.getLimit())) {
                            ++nbrSections98;
                            enrlSections98 += enrl;
                        }
                        if (section.getLimit() >= 0 && (long)(section.getLimit() - enrl) <= Math.round(0.05 * (double)section.getLimit())) {
                            ++nbrSections95;
                            enrlSections95 += enrl;
                        }
                        if (section.getLimit() < 0 || (long)(section.getLimit() - enrl) > Math.round(0.1 * (double)section.getLimit())) continue;
                        ++nbrSections90;
                        enrlSections90 += enrl;
                    }
                    if (configLimit < 0 || subpartLimit < 0) {
                        configLimit = -1;
                        continue;
                    }
                    configLimit = Math.min(configLimit, subpartLimit);
                }
                offeringLimit = offeringLimit < 0 || configLimit < 0 ? -1 : (offeringLimit += configLimit);
                offeringEnrollment += config.getEnrollments(assignment).size();
            }
            ++nbrOfferings;
            enrlOfferings += offeringEnrollment;
            if (offeringLimit >= 0 && offeringEnrollment >= offeringLimit) {
                ++nbrFullOfferings;
                enrlOfferingsFull += offeringEnrollment;
            }
            if (offeringLimit >= 0 && (long)(offeringLimit - offeringEnrollment) <= Math.round(0.02 * (double)offeringLimit)) {
                ++nbrOfferings98;
                enrlOfferings98 += offeringEnrollment;
            }
            if (offeringLimit >= 0 && (long)(offeringLimit - offeringEnrollment) <= Math.round(0.05 * (double)offeringLimit)) {
                ++nbrOfferings95;
                enrlOfferings95 += offeringEnrollment;
            }
            if (offeringLimit < 0 || (long)(offeringLimit - offeringEnrollment) > Math.round(0.1 * (double)offeringLimit)) continue;
            ++nbrOfferings90;
            enrlOfferings90 += offeringEnrollment;
        }
        if (enrlOfferings90 > 0 && enrlOfferings > 0) {
            info.put("Full Offerings", (nbrFullOfferings > 0 ? nbrFullOfferings + " with no space (" + sDecimalFormat.format(100.0 * (double)nbrFullOfferings / (double)nbrOfferings) + "% of all offerings, " + sDecimalFormat.format(100.0 * (double)enrlOfferingsFull / (double)enrlOfferings) + "% assignments)\n" : "") + (nbrOfferings98 > nbrFullOfferings ? nbrOfferings98 + " with &leq; 2% available (" + sDecimalFormat.format(100.0 * (double)nbrOfferings98 / (double)nbrOfferings) + "% of all offerings, " + sDecimalFormat.format(100.0 * (double)enrlOfferings98 / (double)enrlOfferings) + "% assignments)\n" : "") + (nbrOfferings95 > nbrOfferings98 ? nbrOfferings95 + " with &leq; 5% available (" + sDecimalFormat.format(100.0 * (double)nbrOfferings95 / (double)nbrOfferings) + "% of all offerings, " + sDecimalFormat.format(100.0 * (double)enrlOfferings95 / (double)enrlOfferings) + "% assignments)\n" : "") + (nbrOfferings90 > nbrOfferings95 ? nbrOfferings90 + " with &leq; 10% available (" + sDecimalFormat.format(100.0 * (double)nbrOfferings90 / (double)nbrOfferings) + "% of all offerings, " + sDecimalFormat.format(100.0 * (double)enrlOfferings90 / (double)enrlOfferings) + "% assignments)" : ""));
        }
        if ((enrlSections90 > 0 || nbrSectionsDis > 0) && enrlSections > 0) {
            info.put("Full Sections", (nbrFullSections > 0 ? nbrFullSections + " with no space (" + sDecimalFormat.format(100.0 * (double)nbrFullSections / (double)nbrSections) + "% of all sections, " + sDecimalFormat.format(100.0 * (double)enrlFullSections / (double)enrlSections) + "% assignments)\n" : "") + (nbrSectionsDis > 0 ? nbrSectionsDis + " disabled (" + sDecimalFormat.format(100.0 * (double)nbrSectionsDis / (double)nbrSections) + "% of all sections, " + sDecimalFormat.format(100.0 * (double)enrlSectionsDis / (double)enrlSections) + "% assignments)\n" : "") + (enrlSections98 > nbrFullSections ? nbrSections98 + " with &leq; 2% available (" + sDecimalFormat.format(100.0 * (double)nbrSections98 / (double)nbrSections) + "% of all sections, " + sDecimalFormat.format(100.0 * (double)enrlSections98 / (double)enrlSections) + "% assignments)\n" : "") + (nbrSections95 > enrlSections98 ? nbrSections95 + " with &leq; 5% available (" + sDecimalFormat.format(100.0 * (double)nbrSections95 / (double)nbrSections) + "% of all sections, " + sDecimalFormat.format(100.0 * (double)enrlSections95 / (double)enrlSections) + "% assignments)\n" : "") + (nbrSections90 > nbrSections95 ? nbrSections90 + " with &leq; 10% available (" + sDecimalFormat.format(100.0 * (double)nbrSections90 / (double)nbrSections) + "% of all sections, " + sDecimalFormat.format(100.0 * (double)enrlSections90 / (double)enrlSections) + "% assignments)" : ""));
        }
        if (this.getStudentQuality() != null) {
            HashSet<Student> students;
            int shareCR = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.CourseTimeOverlap, assignment);
            int shareFT = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.FreeTimeOverlap, assignment);
            int shareUN = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.Unavailability, assignment);
            int shareUND = ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).countTotalPenalty(StudentQuality.Type.UnavailabilityDistance, assignment);
            if (shareCR > 0) {
                students = new HashSet<Student>();
                for (StudentQuality.Conflict c : ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).computeAllConflicts(StudentQuality.Type.CourseTimeOverlap, assignment)) {
                    students.add(c.getStudent());
                }
                info.put("Time overlaps: courses", students.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareCR / (double)students.size()) + " mins)");
            }
            if (shareFT > 0) {
                students = new HashSet();
                for (StudentQuality.Conflict c : ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).computeAllConflicts(StudentQuality.Type.FreeTimeOverlap, assignment)) {
                    students.add(c.getStudent());
                }
                info.put("Time overlaps: free times", students.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareFT / (double)students.size()) + " mins)");
            }
            if (shareUN > 0) {
                students = new HashSet();
                for (StudentQuality.Conflict c : ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).computeAllConflicts(StudentQuality.Type.Unavailability, assignment)) {
                    students.add(c.getStudent());
                }
                info.put("Unavailabilities: Time conflicts", students.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareUN / (double)students.size()) + " mins)");
            }
            if (shareUND > 0) {
                students = new HashSet();
                for (StudentQuality.Conflict c : ((StudentQuality.StudentQualityContext)this.getStudentQuality().getContext(assignment)).computeAllConflicts(StudentQuality.Type.UnavailabilityDistance, assignment)) {
                    students.add(c.getStudent());
                }
                info.put("Unavailabilities: Distance conflicts", students.size() + " students (avg " + sDoubleFormat.format(shareUND / students.size()) + " travels)");
            }
        } else if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts(assignment) != 0) {
            Set<TimeOverlapsCounter.Conflict> conf = ((TimeOverlapsCounter.TimeOverlapsCounterContext)this.getTimeOverlaps().getContext(assignment)).computeAllConflicts(assignment);
            int shareCR = 0;
            int shareFT = 0;
            int shareUN = 0;
            HashSet<Student> studentsCR = new HashSet<Student>();
            HashSet<Student> hashSet = new HashSet<Student>();
            HashSet<Student> studentsUN = new HashSet<Student>();
            for (TimeOverlapsCounter.Conflict c : conf) {
                if (c.getR1() instanceof CourseRequest && c.getR2() instanceof CourseRequest) {
                    shareCR += c.getShare();
                    studentsCR.add(c.getStudent());
                    continue;
                }
                if (c.getS2() instanceof Unavailability) {
                    shareUN += c.getShare();
                    studentsUN.add(c.getStudent());
                    continue;
                }
                shareFT += c.getShare();
                hashSet.add(c.getStudent());
            }
            if (shareCR > 0) {
                info.put("Time overlaps: courses", studentsCR.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareCR / (double)studentsCR.size()) + " mins)");
            }
            if (shareFT > 0) {
                info.put("Time overlaps: free times", hashSet.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareFT / (double)hashSet.size()) + " mins)");
            }
            if (shareUN > 0) {
                info.put("Time overlaps: teaching assignments", studentsUN.size() + " students (avg " + sDoubleFormat.format(5.0 * (double)shareUN / (double)studentsUN.size()) + " mins)");
            }
        }
        return info;
    }

    @Override
    public void restoreBest(Assignment<Request, Enrollment> assignment) {
        this.restoreBest(assignment, new Comparator<Request>(){

            @Override
            public int compare(Request r1, Request r2) {
                Enrollment e1 = (Enrollment)r1.getBestAssignment();
                Enrollment e2 = (Enrollment)r2.getBestAssignment();
                if (e1.getReservation() != null && e2.getReservation() == null) {
                    return -1;
                }
                if (e1.getReservation() == null && e2.getReservation() != null) {
                    return 1;
                }
                if (r1.getBestAssignmentIteration() != r2.getBestAssignmentIteration()) {
                    return r1.getBestAssignmentIteration() < r2.getBestAssignmentIteration() ? -1 : 1;
                }
                return r1.compareTo(r2);
            }
        });
        this.recomputeTotalValue(assignment);
    }

    public void recomputeTotalValue(Assignment<Request, Enrollment> assignment) {
        ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iTotalValue = this.getTotalValue(assignment, true);
    }

    @Override
    public void saveBest(Assignment<Request, Enrollment> assignment) {
        this.recomputeTotalValue(assignment);
        this.iBestAssignedCourseRequestWeight = ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCourseRequestWeight();
        super.saveBest(assignment);
    }

    public double getBestAssignedCourseRequestWeight() {
        return this.iBestAssignedCourseRequestWeight;
    }

    @Override
    public String toString(Assignment<Request, Enrollment> assignment) {
        double groupSpread = 0.0;
        double groupCount = 0.0;
        for (Offering offering : this.iOfferings) {
            for (Course course : offering.getCourses()) {
                for (RequestGroup group : course.getRequestGroups()) {
                    groupSpread += group.getAverageSpread(assignment) * group.getEnrollmentWeight(assignment, null);
                    groupCount += group.getEnrollmentWeight(assignment, null);
                }
            }
        }
        String priority = "";
        for (Student.StudentPriority sp : Student.StudentPriority.values()) {
            if (sp.ordinal() >= Student.StudentPriority.Normal.ordinal()) continue;
            if (this.iTotalPriorityCRWeight[sp.ordinal()] > 0.0) {
                priority = priority + sp.code() + "PCR:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCRWeight[sp.ordinal()] / this.iTotalPriorityCRWeight[sp.ordinal()]) + "%, ";
            }
            if (this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.LC.ordinal()][sp.ordinal()] > 0.0) {
                priority = priority + sp.code() + "PCL:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCriticalCRWeight[Request.RequestPriority.LC.ordinal()][sp.ordinal()] / this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.LC.ordinal()][sp.ordinal()]) + "%, ";
            }
            if (this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Critical.ordinal()][sp.ordinal()] > 0.0) {
                priority = priority + sp.code() + "PCC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCriticalCRWeight[Request.RequestPriority.Critical.ordinal()][sp.ordinal()] / this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Critical.ordinal()][sp.ordinal()]) + "%, ";
            }
            if (this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Important.ordinal()][sp.ordinal()] > 0.0) {
                priority = priority + sp.code() + "PCI:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCriticalCRWeight[Request.RequestPriority.Important.ordinal()][sp.ordinal()] / this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Important.ordinal()][sp.ordinal()]) + "%, ";
            }
            if (this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Vital.ordinal()][sp.ordinal()] > 0.0) {
                priority = priority + sp.code() + "PCV:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCriticalCRWeight[Request.RequestPriority.Vital.ordinal()][sp.ordinal()] / this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.Vital.ordinal()][sp.ordinal()]) + "%, ";
            }
            if (!(this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.VisitingF2F.ordinal()][sp.ordinal()] > 0.0)) continue;
            priority = priority + sp.code() + "PCVF:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedPriorityCriticalCRWeight[Request.RequestPriority.VisitingF2F.ordinal()][sp.ordinal()] / this.iTotalPriorityCriticalCRWeight[Request.RequestPriority.VisitingF2F.ordinal()][sp.ordinal()]) + "%, ";
        }
        return (this.getNrRealStudents(false) > 0 ? "RRq:" + this.getNrAssignedRealRequests(assignment, false) + "/" + this.getNrRealRequests(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DRq:" + this.getNrAssignedLastLikeRequests(assignment, false) + "/" + this.getNrLastLikeRequests(false) + ", " : "") + (this.getNrRealStudents(false) > 0 ? "RS:" + this.getNrCompleteRealStudents(assignment, false) + "/" + this.getNrRealStudents(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DS:" + this.getNrCompleteLastLikeStudents(assignment, false) + "/" + this.getNrLastLikeStudents(false) + ", " : "") + (this.iTotalCRWeight > 0.0 ? "CR:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCourseRequestWeight() / this.iTotalCRWeight) + "%, " : "") + (this.iTotalSelCRWeight > 0.0 ? "S:" + sDoubleFormat.format(100.0 * (0.3 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSelectedConfigWeight + 0.7 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSelectedSectionWeight) / this.iTotalSelCRWeight) + "%, " : "") + (this.iTotalCriticalCRWeight[Request.RequestPriority.LC.ordinal()] > 0.0 ? "LC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCriticalCourseRequestWeight(Request.RequestPriority.LC) / this.iTotalCriticalCRWeight[Request.RequestPriority.LC.ordinal()]) + "%, " : "") + (this.iTotalCriticalCRWeight[Request.RequestPriority.Critical.ordinal()] > 0.0 ? "CC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCriticalCourseRequestWeight(Request.RequestPriority.Critical) / this.iTotalCriticalCRWeight[Request.RequestPriority.Critical.ordinal()]) + "%, " : "") + (this.iTotalCriticalCRWeight[Request.RequestPriority.Important.ordinal()] > 0.0 ? "IC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCriticalCourseRequestWeight(Request.RequestPriority.Important) / this.iTotalCriticalCRWeight[Request.RequestPriority.Important.ordinal()]) + "%, " : "") + (this.iTotalCriticalCRWeight[Request.RequestPriority.Vital.ordinal()] > 0.0 ? "VC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCriticalCourseRequestWeight(Request.RequestPriority.Vital) / this.iTotalCriticalCRWeight[Request.RequestPriority.Vital.ordinal()]) + "%, " : "") + (this.iTotalCriticalCRWeight[Request.RequestPriority.VisitingF2F.ordinal()] > 0.0 ? "VFC:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).getAssignedCriticalCourseRequestWeight(Request.RequestPriority.VisitingF2F) / this.iTotalCriticalCRWeight[Request.RequestPriority.VisitingF2F.ordinal()]) + "%, " : "") + priority + "V:" + sDecimalFormat.format(-this.getTotalValue(assignment)) + (this.getDistanceConflict() == null ? "" : ", DC:" + this.getDistanceConflict().getTotalNrConflicts(assignment)) + (this.getTimeOverlaps() == null ? "" : ", TOC:" + this.getTimeOverlaps().getTotalNrConflicts(assignment)) + (this.iMPP ? ", IS:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSameSectionWeight / this.iTotalMPPCRWeight) + "%" : "") + (this.iMPP ? ", IT:" + sDecimalFormat.format(100.0 * ((StudentSectioningModelContext)this.getContext((Assignment)assignment)).iAssignedSameTimeWeight / this.iTotalMPPCRWeight) + "%" : "") + ", %:" + sDecimalFormat.format(-100.0 * this.getTotalValue(assignment) / ((double)(this.getStudents().size() - this.iNrDummyStudents) + (this.iProjectedStudentWeight < 0.0 ? (double)this.iNrDummyStudents * (this.iTotalDummyWeight / (double)this.iNrDummyRequests) : this.iProjectedStudentWeight * this.iTotalDummyWeight))) + (groupCount > 0.0 ? ", SG:" + sDecimalFormat.format(100.0 * groupSpread / groupCount) + "%" : "") + (this.getStudentQuality() == null ? "" : ", SQ:{" + this.getStudentQuality().toString(assignment) + "}");
    }

    public double avg(double w1, double w2) {
        return Math.sqrt(w1 * w2);
    }

    public int getMaxDomainSize() {
        return this.iMaxDomainSize;
    }

    public void setMaxDomainSize(int maxDomainSize) {
        this.iMaxDomainSize = maxDomainSize;
    }

    public int getDayOfWeekOffset() {
        return this.iDayOfWeekOffset;
    }

    public void setDayOfWeekOffset(int dayOfWeekOffset) {
        this.iDayOfWeekOffset = dayOfWeekOffset;
        if (this.iProperties != null) {
            this.iProperties.setProperty("DatePattern.DayOfWeekOffset", Integer.toString(dayOfWeekOffset));
        }
    }

    @Override
    public StudentSectioningModelContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new StudentSectioningModelContext(assignment);
    }

    @Override
    public InheritedAssignment<Request, Enrollment> createInheritedAssignment(Solution<Request, Enrollment> solution, int index) {
        return new OptimisticInheritedAssignment<Request, Enrollment>(solution, index);
    }

    public DistanceMetric getDistanceMetric() {
        return this.iStudentQuality != null ? this.iStudentQuality.getDistanceMetric() : (this.iDistanceConflict != null ? this.iDistanceConflict.getDistanceMetric() : null);
    }

    @Override
    public StudentSectioningModelContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, StudentSectioningModelContext parentContext) {
        return new StudentSectioningModelContext(parentContext);
    }

    @Override
    public void addGlobalConstraint(GlobalConstraint<Request, Enrollment> constraint) {
        super.addGlobalConstraint(constraint);
        if (constraint instanceof DependentCourses) {
            this.iDependentCourses = (DependentCourses)constraint;
        }
    }

    @Override
    public void removeGlobalConstraint(GlobalConstraint<Request, Enrollment> constraint) {
        super.removeGlobalConstraint(constraint);
        if (constraint instanceof DependentCourses) {
            this.iDependentCourses = null;
        }
    }

    public DependentCourses getDependentCoursesConstraint() {
        return this.iDependentCourses;
    }

    static /* synthetic */ double[] access$1302(StudentSectioningModel x0, double[] x1) {
        x0.iTotalPriorityCRWeight = x1;
        return x1;
    }

    public class StudentSectioningModelContext
    implements AssignmentConstraintContext<Request, Enrollment>,
    InfoProvider<Request, Enrollment> {
        private Set<Student> iCompleteStudents = new HashSet<Student>();
        private double iTotalValue = 0.0;
        private int iNrAssignedDummyRequests = 0;
        private int iNrCompleteDummyStudents = 0;
        private double iAssignedCRWeight = 0.0;
        private double iAssignedDummyCRWeight = 0.0;
        private double[] iAssignedCriticalCRWeight;
        private double[][] iAssignedPriorityCriticalCRWeight;
        private double iReservedSpace = 0.0;
        private double iTotalReservedSpace = 0.0;
        private double iAssignedSameSectionWeight = 0.0;
        private double iAssignedSameChoiceWeight = 0.0;
        private double iAssignedSameTimeWeight = 0.0;
        private double iAssignedSelectedSectionWeight = 0.0;
        private double iAssignedSelectedConfigWeight = 0.0;
        private double iAssignedNoTimeSectionWeight = 0.0;
        private double iAssignedOnlineSectionWeight = 0.0;
        private double iAssignedPastSectionWeight = 0.0;
        private int[] iNrCompletePriorityStudents = null;
        private double[] iAssignedPriorityCRWeight = null;

        public StudentSectioningModelContext(StudentSectioningModelContext parent) {
            int i;
            this.iCompleteStudents = new HashSet<Student>(parent.iCompleteStudents);
            this.iTotalValue = parent.iTotalValue;
            this.iNrAssignedDummyRequests = parent.iNrAssignedDummyRequests;
            this.iNrCompleteDummyStudents = parent.iNrCompleteDummyStudents;
            this.iAssignedCRWeight = parent.iAssignedCRWeight;
            this.iAssignedDummyCRWeight = parent.iAssignedDummyCRWeight;
            this.iReservedSpace = parent.iReservedSpace;
            this.iTotalReservedSpace = parent.iTotalReservedSpace;
            this.iAssignedSameSectionWeight = parent.iAssignedSameSectionWeight;
            this.iAssignedSameChoiceWeight = parent.iAssignedSameChoiceWeight;
            this.iAssignedSameTimeWeight = parent.iAssignedSameTimeWeight;
            this.iAssignedSelectedSectionWeight = parent.iAssignedSelectedSectionWeight;
            this.iAssignedSelectedConfigWeight = parent.iAssignedSelectedConfigWeight;
            this.iAssignedNoTimeSectionWeight = parent.iAssignedNoTimeSectionWeight;
            this.iAssignedOnlineSectionWeight = parent.iAssignedOnlineSectionWeight;
            this.iAssignedPastSectionWeight = parent.iAssignedPastSectionWeight;
            this.iAssignedCriticalCRWeight = new double[Request.RequestPriority.values().length];
            this.iAssignedPriorityCriticalCRWeight = new double[Request.RequestPriority.values().length][Student.StudentPriority.values().length];
            for (i = 0; i < Request.RequestPriority.values().length; ++i) {
                this.iAssignedCriticalCRWeight[i] = parent.iAssignedCriticalCRWeight[i];
                for (int j = 0; j < Student.StudentPriority.values().length; ++j) {
                    this.iAssignedPriorityCriticalCRWeight[i][j] = parent.iAssignedPriorityCriticalCRWeight[i][j];
                }
            }
            this.iNrCompletePriorityStudents = new int[Student.StudentPriority.values().length];
            this.iAssignedPriorityCRWeight = new double[Student.StudentPriority.values().length];
            for (i = 0; i < Student.StudentPriority.values().length; ++i) {
                this.iNrCompletePriorityStudents[i] = parent.iNrCompletePriorityStudents[i];
                this.iAssignedPriorityCRWeight[i] = parent.iAssignedPriorityCRWeight[i];
            }
        }

        public StudentSectioningModelContext(Assignment<Request, Enrollment> assignment) {
            int i;
            this.iAssignedCriticalCRWeight = new double[Request.RequestPriority.values().length];
            this.iAssignedPriorityCriticalCRWeight = new double[Request.RequestPriority.values().length][Student.StudentPriority.values().length];
            for (i = 0; i < Request.RequestPriority.values().length; ++i) {
                this.iAssignedCriticalCRWeight[i] = 0.0;
                for (int j = 0; j < Student.StudentPriority.values().length; ++j) {
                    this.iAssignedPriorityCriticalCRWeight[i][j] = 0.0;
                }
            }
            this.iNrCompletePriorityStudents = new int[Student.StudentPriority.values().length];
            this.iAssignedPriorityCRWeight = new double[Student.StudentPriority.values().length];
            for (i = 0; i < Student.StudentPriority.values().length; ++i) {
                this.iNrCompletePriorityStudents[i] = 0;
                this.iAssignedPriorityCRWeight[i] = 0.0;
            }
            for (Request request : StudentSectioningModel.this.variables()) {
                Enrollment enrollment = assignment.getValue(request);
                if (enrollment == null) continue;
                this.assigned(assignment, enrollment);
            }
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            Student student = enrollment.getStudent();
            if (student.isComplete(assignment) && this.iCompleteStudents.add(student)) {
                if (student.isDummy()) {
                    ++this.iNrCompleteDummyStudents;
                }
                int n = student.getPriority().ordinal();
                this.iNrCompletePriorityStudents[n] = this.iNrCompletePriorityStudents[n] + 1;
            }
            double value = enrollment.getRequest().getWeight() * StudentSectioningModel.this.iStudentWeights.getWeight(assignment, enrollment);
            this.iTotalValue -= value;
            ((Request.RequestContext)((Request)enrollment.variable()).getContext(assignment)).setLastWeight(value);
            if (enrollment.isCourseRequest()) {
                this.iAssignedCRWeight += enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && enrollment.getRequest().getRequestPriority() != Request.RequestPriority.Normal && !enrollment.getStudent().isDummy() && !enrollment.getRequest().isAlternative()) {
                int n = enrollment.getRequest().getRequestPriority().ordinal();
                this.iAssignedCriticalCRWeight[n] = this.iAssignedCriticalCRWeight[n] + enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && enrollment.getRequest().getRequestPriority() != Request.RequestPriority.Normal && !enrollment.getRequest().isAlternative()) {
                double[] dArray = this.iAssignedPriorityCriticalCRWeight[enrollment.getRequest().getRequestPriority().ordinal()];
                int n = enrollment.getStudent().getPriority().ordinal();
                dArray[n] = dArray[n] + enrollment.getRequest().getWeight();
            }
            if (enrollment.getRequest().isMPP()) {
                this.iAssignedSameSectionWeight += enrollment.getRequest().getWeight() * enrollment.percentInitial();
                this.iAssignedSameChoiceWeight += enrollment.getRequest().getWeight() * enrollment.percentSelected();
                this.iAssignedSameTimeWeight += enrollment.getRequest().getWeight() * enrollment.percentSameTime();
            }
            if (enrollment.getRequest().hasSelection()) {
                this.iAssignedSelectedSectionWeight += enrollment.getRequest().getWeight() * enrollment.percentSelectedSameSection();
                this.iAssignedSelectedConfigWeight += enrollment.getRequest().getWeight() * enrollment.percentSelectedSameConfig();
            }
            if (enrollment.getReservation() != null) {
                this.iReservedSpace += enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
                this.iTotalReservedSpace += enrollment.getRequest().getWeight();
            }
            if (student.isDummy()) {
                ++this.iNrAssignedDummyRequests;
                if (enrollment.isCourseRequest()) {
                    this.iAssignedDummyCRWeight += enrollment.getRequest().getWeight();
                }
            }
            if (enrollment.isCourseRequest()) {
                int n = enrollment.getStudent().getPriority().ordinal();
                this.iAssignedPriorityCRWeight[n] = this.iAssignedPriorityCRWeight[n] + enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest()) {
                int noTime = 0;
                int online = 0;
                int past = 0;
                for (Section section : enrollment.getSections()) {
                    if (!section.hasTime()) {
                        ++noTime;
                    }
                    if (section.isOnline()) {
                        ++online;
                    }
                    if (!section.isPast()) continue;
                    ++past;
                }
                if (noTime > 0) {
                    this.iAssignedNoTimeSectionWeight += enrollment.getRequest().getWeight() * (double)noTime / (double)enrollment.getSections().size();
                }
                if (online > 0) {
                    this.iAssignedOnlineSectionWeight += enrollment.getRequest().getWeight() * (double)online / (double)enrollment.getSections().size();
                }
                if (past > 0) {
                    this.iAssignedPastSectionWeight += enrollment.getRequest().getWeight() * (double)past / (double)enrollment.getSections().size();
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            Request.RequestContext cx;
            Double value;
            Student student = enrollment.getStudent();
            if (enrollment.isCourseRequest() && this.iCompleteStudents.contains(student)) {
                this.iCompleteStudents.remove(student);
                if (student.isDummy()) {
                    --this.iNrCompleteDummyStudents;
                }
                int n = student.getPriority().ordinal();
                this.iNrCompletePriorityStudents[n] = this.iNrCompletePriorityStudents[n] - 1;
            }
            if ((value = (cx = (Request.RequestContext)((Request)enrollment.variable()).getContext(assignment)).getLastWeight()) == null) {
                value = enrollment.getRequest().getWeight() * StudentSectioningModel.this.iStudentWeights.getWeight(assignment, enrollment);
            }
            this.iTotalValue += value.doubleValue();
            cx.setLastWeight(null);
            if (enrollment.isCourseRequest()) {
                this.iAssignedCRWeight -= enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && enrollment.getRequest().getRequestPriority() != Request.RequestPriority.Normal && !enrollment.getStudent().isDummy() && !enrollment.getRequest().isAlternative()) {
                int n = enrollment.getRequest().getRequestPriority().ordinal();
                this.iAssignedCriticalCRWeight[n] = this.iAssignedCriticalCRWeight[n] - enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && enrollment.getRequest().getRequestPriority() != Request.RequestPriority.Normal && !enrollment.getRequest().isAlternative()) {
                double[] dArray = this.iAssignedPriorityCriticalCRWeight[enrollment.getRequest().getRequestPriority().ordinal()];
                int n = enrollment.getStudent().getPriority().ordinal();
                dArray[n] = dArray[n] - enrollment.getRequest().getWeight();
            }
            if (enrollment.getRequest().isMPP()) {
                this.iAssignedSameSectionWeight -= enrollment.getRequest().getWeight() * enrollment.percentInitial();
                this.iAssignedSameChoiceWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelected();
                this.iAssignedSameTimeWeight -= enrollment.getRequest().getWeight() * enrollment.percentSameTime();
            }
            if (enrollment.getRequest().hasSelection()) {
                this.iAssignedSelectedSectionWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelectedSameSection();
                this.iAssignedSelectedConfigWeight -= enrollment.getRequest().getWeight() * enrollment.percentSelectedSameConfig();
            }
            if (enrollment.getReservation() != null) {
                this.iReservedSpace -= enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
                this.iTotalReservedSpace -= enrollment.getRequest().getWeight();
            }
            if (student.isDummy()) {
                --this.iNrAssignedDummyRequests;
                if (enrollment.isCourseRequest()) {
                    this.iAssignedDummyCRWeight -= enrollment.getRequest().getWeight();
                }
            }
            if (enrollment.isCourseRequest()) {
                int n = enrollment.getStudent().getPriority().ordinal();
                this.iAssignedPriorityCRWeight[n] = this.iAssignedPriorityCRWeight[n] - enrollment.getRequest().getWeight();
            }
            if (enrollment.isCourseRequest()) {
                int noTime = 0;
                int online = 0;
                int past = 0;
                for (Section section : enrollment.getSections()) {
                    if (!section.hasTime()) {
                        ++noTime;
                    }
                    if (section.isOnline()) {
                        ++online;
                    }
                    if (!section.isPast()) continue;
                    ++past;
                }
                if (noTime > 0) {
                    this.iAssignedNoTimeSectionWeight -= enrollment.getRequest().getWeight() * (double)noTime / (double)enrollment.getSections().size();
                }
                if (online > 0) {
                    this.iAssignedOnlineSectionWeight -= enrollment.getRequest().getWeight() * (double)online / (double)enrollment.getSections().size();
                }
                if (past > 0) {
                    this.iAssignedPastSectionWeight -= enrollment.getRequest().getWeight() * (double)past / (double)enrollment.getSections().size();
                }
            }
        }

        public void add(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
            this.iTotalValue += StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getDistanceConflictWeight(assignment, c);
        }

        public void remove(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
            this.iTotalValue -= StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getDistanceConflictWeight(assignment, c);
        }

        public void add(Assignment<Request, Enrollment> assignment, TimeOverlapsCounter.Conflict c) {
            if (c.getR1() != null) {
                this.iTotalValue += c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE1(), c);
            }
            if (c.getR2() != null) {
                this.iTotalValue += c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE2(), c);
            }
        }

        public void remove(Assignment<Request, Enrollment> assignment, TimeOverlapsCounter.Conflict c) {
            if (c.getR1() != null) {
                this.iTotalValue -= c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE1(), c);
            }
            if (c.getR2() != null) {
                this.iTotalValue -= c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getTimeOverlapConflictWeight(assignment, c.getE2(), c);
            }
        }

        public void add(Assignment<Request, Enrollment> assignment, StudentQuality.Conflict c) {
            switch (c.getType().getType()) {
                case REQUEST: {
                    if (c.getR1() instanceof CourseRequest) {
                        this.iTotalValue += c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                        break;
                    }
                    this.iTotalValue += c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                    break;
                }
                case BOTH: {
                    this.iTotalValue += c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                    this.iTotalValue += c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                    break;
                }
                case LOWER: {
                    this.iTotalValue += StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                    break;
                }
                case HIGHER: {
                    this.iTotalValue += StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                }
            }
        }

        public void remove(Assignment<Request, Enrollment> assignment, StudentQuality.Conflict c) {
            switch (c.getType().getType()) {
                case REQUEST: {
                    if (c.getR1() instanceof CourseRequest) {
                        this.iTotalValue -= c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                        break;
                    }
                    this.iTotalValue -= c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                    break;
                }
                case BOTH: {
                    this.iTotalValue -= c.getR1Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                    this.iTotalValue -= c.getR2Weight() * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE2(), c);
                    break;
                }
                case LOWER: {
                    this.iTotalValue -= StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                    break;
                }
                case HIGHER: {
                    this.iTotalValue -= StudentSectioningModel.this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * StudentSectioningModel.this.iStudentWeights.getStudentQualityConflictWeight(assignment, c.getE1(), c);
                }
            }
        }

        public Set<Student> getCompleteStudents() {
            return this.iCompleteStudents;
        }

        public int nrComplete() {
            return this.getCompleteStudents().size();
        }

        public void requestWeightsChanged(Assignment<Request, Enrollment> assignment) {
            int i;
            StudentSectioningModel.this.iTotalCRWeight = 0.0;
            StudentSectioningModel.this.iTotalDummyWeight = 0.0;
            StudentSectioningModel.this.iTotalDummyCRWeight = 0.0;
            StudentSectioningModel.access$1302(StudentSectioningModel.this, new double[Student.StudentPriority.values().length]);
            this.iAssignedCRWeight = 0.0;
            this.iAssignedDummyCRWeight = 0.0;
            this.iAssignedCriticalCRWeight = new double[Request.RequestPriority.values().length];
            this.iAssignedPriorityCriticalCRWeight = new double[Request.RequestPriority.values().length][Student.StudentPriority.values().length];
            for (i = 0; i < Request.RequestPriority.values().length; ++i) {
                this.iAssignedCriticalCRWeight[i] = 0.0;
                for (int j = 0; j < Student.StudentPriority.values().length; ++j) {
                    this.iAssignedPriorityCriticalCRWeight[i][j] = 0.0;
                }
            }
            this.iAssignedPriorityCRWeight = new double[Student.StudentPriority.values().length];
            for (i = 0; i < Student.StudentPriority.values().length; ++i) {
                this.iAssignedPriorityCRWeight[i] = 0.0;
            }
            StudentSectioningModel.this.iNrDummyRequests = 0;
            this.iNrAssignedDummyRequests = 0;
            this.iTotalReservedSpace = 0.0;
            this.iReservedSpace = 0.0;
            StudentSectioningModel.this.iTotalMPPCRWeight = 0.0;
            StudentSectioningModel.this.iTotalSelCRWeight = 0.0;
            this.iAssignedNoTimeSectionWeight = 0.0;
            this.iAssignedOnlineSectionWeight = 0.0;
            this.iAssignedPastSectionWeight = 0.0;
            for (Request request : StudentSectioningModel.this.variables()) {
                Enrollment e;
                boolean cr = request instanceof CourseRequest;
                if (cr && !request.isAlternative()) {
                    StudentSectioningModel.this.iTotalCRWeight = StudentSectioningModel.this.iTotalCRWeight + request.getWeight();
                }
                if (request.getStudent().isDummy()) {
                    StudentSectioningModel.this.iTotalDummyWeight = StudentSectioningModel.this.iTotalDummyWeight + request.getWeight();
                    StudentSectioningModel.this.iNrDummyRequests++;
                    if (cr && !request.isAlternative()) {
                        StudentSectioningModel.this.iTotalDummyCRWeight = StudentSectioningModel.this.iTotalDummyCRWeight + request.getWeight();
                    }
                }
                if (cr && !request.isAlternative()) {
                    double[] dArray = StudentSectioningModel.this.iTotalPriorityCRWeight;
                    int n = request.getStudent().getPriority().ordinal();
                    dArray[n] = dArray[n] + request.getWeight();
                }
                if (request.isMPP()) {
                    StudentSectioningModel.this.iTotalMPPCRWeight = StudentSectioningModel.this.iTotalMPPCRWeight + request.getWeight();
                }
                if (request.hasSelection()) {
                    StudentSectioningModel.this.iTotalSelCRWeight = StudentSectioningModel.this.iTotalSelCRWeight + request.getWeight();
                }
                if ((e = assignment.getValue(request)) == null) continue;
                if (cr) {
                    this.iAssignedCRWeight += request.getWeight();
                }
                if (cr && request.getRequestPriority() != Request.RequestPriority.Normal && !request.getStudent().isDummy() && !request.isAlternative()) {
                    int n = request.getRequestPriority().ordinal();
                    this.iAssignedCriticalCRWeight[n] = this.iAssignedCriticalCRWeight[n] + request.getWeight();
                }
                if (cr && request.getRequestPriority() != Request.RequestPriority.Normal && !request.isAlternative()) {
                    double[] dArray = this.iAssignedPriorityCriticalCRWeight[request.getRequestPriority().ordinal()];
                    int n = request.getStudent().getPriority().ordinal();
                    dArray[n] = dArray[n] + request.getWeight();
                }
                if (request.isMPP()) {
                    this.iAssignedSameSectionWeight += request.getWeight() * e.percentInitial();
                    this.iAssignedSameChoiceWeight += request.getWeight() * e.percentSelected();
                    this.iAssignedSameTimeWeight += request.getWeight() * e.percentSameTime();
                }
                if (request.hasSelection()) {
                    this.iAssignedSelectedSectionWeight += request.getWeight() * e.percentSelectedSameSection();
                    this.iAssignedSelectedConfigWeight += request.getWeight() * e.percentSelectedSameConfig();
                }
                if (e.getReservation() != null) {
                    this.iReservedSpace += request.getWeight();
                }
                if (cr && ((CourseRequest)request).hasReservations()) {
                    this.iTotalReservedSpace += request.getWeight();
                }
                if (request.getStudent().isDummy()) {
                    ++this.iNrAssignedDummyRequests;
                    if (cr) {
                        this.iAssignedDummyCRWeight += request.getWeight();
                    }
                }
                if (cr) {
                    int n = request.getStudent().getPriority().ordinal();
                    this.iAssignedPriorityCRWeight[n] = this.iAssignedPriorityCRWeight[n] + request.getWeight();
                }
                if (!cr) continue;
                int noTime = 0;
                int online = 0;
                int past = 0;
                for (Section section : e.getSections()) {
                    if (!section.hasTime()) {
                        ++noTime;
                    }
                    if (section.isOnline()) {
                        ++online;
                    }
                    if (!section.isPast()) continue;
                    ++past;
                }
                if (noTime > 0) {
                    this.iAssignedNoTimeSectionWeight += request.getWeight() * (double)noTime / (double)e.getSections().size();
                }
                if (online > 0) {
                    this.iAssignedOnlineSectionWeight += request.getWeight() * (double)online / (double)e.getSections().size();
                }
                if (past <= 0) continue;
                this.iAssignedPastSectionWeight += request.getWeight() * (double)past / (double)e.getSections().size();
            }
        }

        public double getTotalValue() {
            return this.iTotalValue;
        }

        public int getNrCompleteLastLikeStudents() {
            return this.iNrCompleteDummyStudents;
        }

        public int getNrAssignedLastLikeRequests() {
            return this.iNrAssignedDummyRequests;
        }

        @Override
        public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
            if (StudentSectioningModel.this.iTotalCRWeight > 0.0) {
                info.put("Assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedCRWeight / StudentSectioningModel.this.iTotalCRWeight) + "% (" + (int)Math.round(this.iAssignedCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalCRWeight) + ")");
                if (StudentSectioningModel.this.iNrDummyStudents > 0 && StudentSectioningModel.this.iNrDummyStudents != StudentSectioningModel.this.getStudents().size() && StudentSectioningModel.this.iTotalCRWeight != StudentSectioningModel.this.iTotalDummyCRWeight) {
                    if (StudentSectioningModel.this.iTotalDummyCRWeight > 0.0) {
                        info.put("Projected assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedDummyCRWeight / StudentSectioningModel.this.iTotalDummyCRWeight) + "% (" + (int)Math.round(this.iAssignedDummyCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalDummyCRWeight) + ")");
                    }
                    info.put("Real assigned course requests", sDecimalFormat.format(100.0 * (this.iAssignedCRWeight - this.iAssignedDummyCRWeight) / (StudentSectioningModel.this.iTotalCRWeight - StudentSectioningModel.this.iTotalDummyCRWeight)) + "% (" + (int)Math.round(this.iAssignedCRWeight - this.iAssignedDummyCRWeight) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalCRWeight - StudentSectioningModel.this.iTotalDummyCRWeight) + ")");
                }
                if (this.iAssignedNoTimeSectionWeight > 0.0) {
                    info.put("Using classes w/o time", sDecimalFormat.format(100.0 * this.iAssignedNoTimeSectionWeight / this.iAssignedCRWeight) + "% (" + sDecimalFormat.format(this.iAssignedNoTimeSectionWeight) + ")");
                }
                if (this.iAssignedOnlineSectionWeight > 0.0) {
                    info.put("Using online classes", sDecimalFormat.format(100.0 * this.iAssignedOnlineSectionWeight / this.iAssignedCRWeight) + "% (" + sDecimalFormat.format(this.iAssignedOnlineSectionWeight) + ")");
                }
                if (this.iAssignedPastSectionWeight > 0.0) {
                    info.put("Using past classes", sDecimalFormat.format(100.0 * this.iAssignedPastSectionWeight / this.iAssignedCRWeight) + "% (" + sDecimalFormat.format(this.iAssignedPastSectionWeight) + ")");
                }
            }
            String priorityAssignedCR = "";
            for (Student.StudentPriority studentPriority : Student.StudentPriority.values()) {
                if (studentPriority == Student.StudentPriority.Dummy || !(StudentSectioningModel.this.iTotalPriorityCRWeight[studentPriority.ordinal()] > 0.0)) continue;
                priorityAssignedCR = priorityAssignedCR + (priorityAssignedCR.isEmpty() ? "" : "\n") + studentPriority.name() + ": " + sDecimalFormat.format(100.0 * this.iAssignedPriorityCRWeight[studentPriority.ordinal()] / StudentSectioningModel.this.iTotalPriorityCRWeight[studentPriority.ordinal()]) + "% (" + (int)Math.round(this.iAssignedPriorityCRWeight[studentPriority.ordinal()]) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalPriorityCRWeight[studentPriority.ordinal()]) + ")";
            }
            if (!priorityAssignedCR.isEmpty()) {
                info.put("Assigned course requests (priority students)", priorityAssignedCR);
            }
            for (Enum enum_ : Request.RequestPriority.values()) {
                if (enum_ == Request.RequestPriority.Normal) continue;
                if (StudentSectioningModel.this.iTotalCriticalCRWeight[enum_.ordinal()] > 0.0) {
                    info.put("Assigned " + enum_.name().toLowerCase() + " course requests", sDoubleFormat.format(100.0 * this.iAssignedCriticalCRWeight[enum_.ordinal()] / StudentSectioningModel.this.iTotalCriticalCRWeight[enum_.ordinal()]) + "% (" + (int)Math.round(this.iAssignedCriticalCRWeight[enum_.ordinal()]) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalCriticalCRWeight[enum_.ordinal()]) + ")");
                }
                priorityAssignedCR = "";
                for (Student.StudentPriority sp : Student.StudentPriority.values()) {
                    if (sp == Student.StudentPriority.Dummy || !(StudentSectioningModel.this.iTotalPriorityCriticalCRWeight[enum_.ordinal()][sp.ordinal()] > 0.0)) continue;
                    priorityAssignedCR = priorityAssignedCR + (priorityAssignedCR.isEmpty() ? "" : "\n") + sp.name() + ": " + sDoubleFormat.format(100.0 * this.iAssignedPriorityCriticalCRWeight[enum_.ordinal()][sp.ordinal()] / StudentSectioningModel.this.iTotalPriorityCriticalCRWeight[enum_.ordinal()][sp.ordinal()]) + "% (" + (int)Math.round(this.iAssignedPriorityCriticalCRWeight[enum_.ordinal()][sp.ordinal()]) + "/" + (int)Math.round(StudentSectioningModel.this.iTotalPriorityCriticalCRWeight[enum_.ordinal()][sp.ordinal()]) + ")";
                }
                if (priorityAssignedCR.isEmpty()) continue;
                info.put("Assigned " + enum_.name().toLowerCase() + " course requests (priority students)", priorityAssignedCR);
            }
            if (this.iTotalReservedSpace > 0.0) {
                info.put("Reservations", sDoubleFormat.format(100.0 * this.iReservedSpace / this.iTotalReservedSpace) + "% (" + Math.round(this.iReservedSpace) + "/" + Math.round(this.iTotalReservedSpace) + ")");
            }
            if (StudentSectioningModel.this.iMPP && StudentSectioningModel.this.iTotalMPPCRWeight > 0.0) {
                info.put("Perturbations: same section", sDoubleFormat.format(100.0 * this.iAssignedSameSectionWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameSectionWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                if (this.iAssignedSameChoiceWeight > this.iAssignedSameSectionWeight) {
                    info.put("Perturbations: same choice", sDoubleFormat.format(100.0 * this.iAssignedSameChoiceWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameChoiceWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                }
                if (this.iAssignedSameTimeWeight > this.iAssignedSameChoiceWeight) {
                    info.put("Perturbations: same time", sDoubleFormat.format(100.0 * this.iAssignedSameTimeWeight / StudentSectioningModel.this.iTotalMPPCRWeight) + "% (" + Math.round(this.iAssignedSameTimeWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalMPPCRWeight) + ")");
                }
            }
            if (StudentSectioningModel.this.iTotalSelCRWeight > 0.0) {
                info.put("Selection", sDoubleFormat.format(100.0 * (0.3 * this.iAssignedSelectedConfigWeight + 0.7 * this.iAssignedSelectedSectionWeight) / StudentSectioningModel.this.iTotalSelCRWeight) + "% (" + Math.round(0.3 * this.iAssignedSelectedConfigWeight + 0.7 * this.iAssignedSelectedSectionWeight) + "/" + Math.round(StudentSectioningModel.this.iTotalSelCRWeight) + ")");
            }
        }

        @Override
        public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
        }

        public double getAssignedCourseRequestWeight() {
            return this.iAssignedCRWeight;
        }

        public double getAssignedCriticalCourseRequestWeight(Request.RequestPriority rp) {
            return this.iAssignedCriticalCRWeight[rp.ordinal()];
        }
    }
}

