/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.unitime.timetable.solver.ui.JenrlInfo;

public class StudentConflictsReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet iGroups = new HashSet();

    public StudentConflictsReport(Solver solver) {
        TimetableModel model = (TimetableModel)solver.currentSolution().getModel();
        Assignment assignment = solver.currentSolution().getAssignment();
        for (JenrlConstraint jenrl : model.getJenrlConstraints()) {
            if (!jenrl.isInConflict(assignment) || jenrl.isToBeIgnored()) continue;
            this.iGroups.add(new JenrlInfo(solver, jenrl));
        }
        for (Lecture lecture : assignment.assignedVariables()) {
            this.iGroups.addAll(JenrlInfo.getCommitedJenrlInfos(solver, lecture).values());
        }
        if (model.constantVariables() != null) {
            for (Lecture lecture : model.constantVariables()) {
                if (assignment.getValue((Variable)lecture) == null) continue;
                this.iGroups.addAll(JenrlInfo.getCommitedJenrlInfos(solver, lecture).values());
            }
        }
    }

    public Set getGroups() {
        return this.iGroups;
    }
}

