/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.CourseOfferingInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=CourseOfferingInterface.CourseOfferingCheckExists.class)
public class CourseOfferingCheckExistsBackend
implements GwtRpcImplementation<CourseOfferingInterface.CourseOfferingCheckExists, CourseOfferingInterface.CourseOfferingCheckExistsInterface> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public CourseOfferingInterface.CourseOfferingCheckExistsInterface execute(CourseOfferingInterface.CourseOfferingCheckExists request, SessionContext context) {
        CourseOfferingInterface.CourseOfferingCheckExistsInterface response = new CourseOfferingInterface.CourseOfferingCheckExistsInterface();
        Boolean isEdit = request.getIsEdit();
        SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(request.getSubjectAreaId());
        CourseOffering co = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(sa.getSessionId(), sa.getSubjectAreaAbbreviation(), request.getCourseNumber());
        if (!isEdit.booleanValue() && co != null) {
            response.setResponseText(MSG.errorCourseCannotBeCreated());
        } else if (isEdit.booleanValue() && co != null && !co.getUniqueId().equals(request.getCourseOfferingId())) {
            response.setResponseText(MSG.errorCourseCannotBeRenamed());
        } else {
            response.setResponseText("");
        }
        return response;
    }
}

