/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.util.Constants;

public class WSCHByDayOfWeekAndHourOfDay
extends BasePointInTimeDataReports {
    protected HashMap<String, PeriodEnrollment> periodEnrollmentMap = new HashMap();
    protected boolean startOnHalfHour = ApplicationProperty.ReportsStartOnTheHalfHour.isTrue();

    public static String dayOfWeekTimeLabelFor(Date date) {
        return Localization.getDateFormat("EEEE, HH:mm").format(date);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDayOfWeek());
        this.addTimeColumns(hdr);
        this.setHeader(hdr);
    }

    protected String getPeriodTag(String id, Date period) {
        int minute;
        Calendar d = Calendar.getInstance(Locale.US);
        d.setTime(period);
        int minuteOfHour = d.get(12);
        int hour = d.get(11);
        int n = minute = this.startOnHalfHour ? 30 : 0;
        if (this.startOnHalfHour && minuteOfHour < 30) {
            --hour;
        }
        return id + " " + d.get(7) + " " + hour + " " + minute;
    }

    protected String getPeriodTag(Date period) {
        int minute;
        Calendar d = Calendar.getInstance(Locale.US);
        d.setTime(period);
        int minuteOfHour = d.get(12);
        int hour = d.get(11);
        int n = minute = this.startOnHalfHour ? 30 : 0;
        if (this.startOnHalfHour && minuteOfHour < 30) {
            --hour;
        }
        return d.get(7) + " " + hour + " " + minute;
    }

    protected String getPeriodTag(String id, int dayOfWeek, int hourOfDay, int minute) {
        return id + " " + dayOfWeek + " " + (this.startOnHalfHour && minute < 30 ? hourOfDay - 1 : hourOfDay) + " " + (this.startOnHalfHour ? 30 : 0);
    }

    protected void addTimeColumns(ArrayList<String> header) {
        for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
            if (ApplicationProperty.ReportsStartOnTheHalfHour.isTrue()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getTimeLabel(this.periodTime(hourOfDay, 30))).append(" - ");
                if (hourOfDay == 23) {
                    sb.append(this.getTimeLabel(this.periodTime(0, 30)));
                } else {
                    sb.append(this.getTimeLabel(this.periodTime(hourOfDay + 1, 30)));
                }
                header.add(sb.toString());
                continue;
            }
            header.add(this.getTimeLabel(this.periodTime(hourOfDay, 0)) + " - " + this.getTimeLabel(this.periodTime(hourOfDay + 1, 0)));
        }
    }

    public String getTimeLabel(Date period) {
        return Localization.getDateFormat("HH:mm").format(period);
    }

    public String getDayOfWeekLabel(Date period) {
        return Localization.getDateFormat("EEEE").format(period);
    }

    @Override
    public String reportName() {
        return MSG.wseByDayOfWeekAndHourOfDayReport();
    }

    @Override
    public String reportDescription() {
        return MSG.wseByDayOfWeekAndHourOfDayReportNote();
    }

    private String getPeriodTag(int dayOfWeek, int hourOfDay, int minute) {
        return dayOfWeek + " " + (this.startOnHalfHour && minute < 30 ? hourOfDay - 1 : hourOfDay) + " " + (this.startOnHalfHour ? 30 : 0);
    }

    protected Date periodTime(int hourOfDay, int minute) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.clear();
        c.set(10, hourOfDay);
        c.set(12, minute);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    protected Date periodDayOfWeek(int dayOfWeek) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.clear();
        c.set(7, dayOfWeek);
        return c.getTime();
    }

    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        this.calculatePeriodsWithEnrollments(pointInTimeData, hibSession);
        int minute = this.startOnHalfHour ? 30 : 0;
        for (int dayOfWeek = 1; dayOfWeek < 8; ++dayOfWeek) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(this.getDayOfWeekLabel(this.periodDayOfWeek(dayOfWeek)));
            for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
                String key = this.getPeriodTag(dayOfWeek, hourOfDay, minute);
                row.add((String)(this.periodEnrollmentMap.get(key) == null ? "0" : "" + this.periodEnrollmentMap.get(key).getWeeklyStudentEnrollment()));
            }
            this.addDataRow(row);
        }
    }

    private void calculatePeriodsWithEnrollments(PointInTimeData pointInTimeData, Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct pc").append("\tfrom PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append("\tinner join pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pitCourseOfferings as pco").append("\twhere pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :sessId").append(" and pco.subjectArea.uniqueId = :saId").append("\tand pco.isControl = true").append(" and  pc.pitSchedulingSubpart.itype.organized = true");
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (SubjectArea subjectArea : pointInTimeData.getSession().getSubjectAreas()) {
            for (PitClass pc : hibSession.createQuery(sb.toString(), PitClass.class).setParameter("sessId", (Object)pointInTimeData.getUniqueId()).setParameter("saId", (Object)subjectArea.getUniqueId()).setCacheable(true).list()) {
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                for (Date meetingPeriod : pc.getUniquePeriods()) {
                    String label = this.getPeriodTag(meetingPeriod);
                    PeriodEnrollment pe = this.periodEnrollmentMap.get(label);
                    if (pe == null) {
                        pe = new PeriodEnrollment(label, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        this.periodEnrollmentMap.put(label, pe);
                    }
                    pe.addEnrollment(pc.getEnrollment());
                }
            }
        }
    }

    @Override
    protected void runReport(Session hibSession) {
        PointInTimeData pitd = (PointInTimeData)hibSession.createQuery("from PointInTimeData pitd where pitd.uniqueId = :uid", PointInTimeData.class).setParameter("uid", (Object)this.getPointInTimeDataUniqueId()).uniqueResult();
        this.createRoomUtilizationReportFor(pitd, hibSession);
    }

    protected class PeriodEnrollment {
        private float iWeeklyStudentEnrollment = 0.0f;
        private float iPeriodsPerStandardReportingHourPerTerm;
        private String iPeriodTag;
        private Float iStandardWeeksInReportingTerm;
        private Float iStandardMinutesInReportingHour;

        public String getPeriodTag() {
            return this.iPeriodTag;
        }

        public float getWeeklyStudentEnrollment() {
            return this.iWeeklyStudentEnrollment / this.iPeriodsPerStandardReportingHourPerTerm;
        }

        public PeriodEnrollment(String periodTag, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
            this.iStandardMinutesInReportingHour = standardMinutesInReportingHour;
            this.iStandardWeeksInReportingTerm = standardWeeksInReportingTerm;
            this.iPeriodTag = periodTag;
            this.iPeriodsPerStandardReportingHourPerTerm = this.iStandardMinutesInReportingHour.floatValue() / ((float)Constants.SLOT_LENGTH_MIN * 1.0f) * this.iStandardWeeksInReportingTerm.floatValue();
        }

        public void addEnrollment(Integer enrollment) {
            this.iWeeklyStudentEnrollment += enrollment.floatValue();
        }

        public void addEnrollment(float enrollment) {
            this.iWeeklyStudentEnrollment += enrollment;
        }
    }
}

