/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.NonUniversityLocationPicture;

@MappedSuperclass
public abstract class BaseNonUniversityLocation
extends Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iName;
    private Set<NonUniversityLocationPicture> iPictures;
    private Set<EventServiceProvider> iAllowedServices;

    public BaseNonUniversityLocation() {
    }

    public BaseNonUniversityLocation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="name", nullable=false, length=40)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="location", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<NonUniversityLocationPicture> getPictures() {
        return this.iPictures;
    }

    public void setPictures(Set<NonUniversityLocationPicture> pictures) {
        this.iPictures = pictures;
    }

    public void addToPictures(NonUniversityLocationPicture nonUniversityLocationPicture) {
        if (this.iPictures == null) {
            this.iPictures = new HashSet<NonUniversityLocationPicture>();
        }
        this.iPictures.add(nonUniversityLocationPicture);
    }

    @Deprecated
    public void addTopictures(NonUniversityLocationPicture nonUniversityLocationPicture) {
        this.addToPictures(nonUniversityLocationPicture);
    }

    @Override
    @ManyToMany
    @JoinTable(name="location_service_provider", joinColumns={@JoinColumn(name="location_id")}, inverseJoinColumns={@JoinColumn(name="provider_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventServiceProvider> getAllowedServices() {
        return this.iAllowedServices;
    }

    @Override
    public void setAllowedServices(Set<EventServiceProvider> allowedServices) {
        this.iAllowedServices = allowedServices;
    }

    public void addToAllowedServices(EventServiceProvider eventServiceProvider) {
        if (this.iAllowedServices == null) {
            this.iAllowedServices = new HashSet<EventServiceProvider>();
        }
        this.iAllowedServices.add(eventServiceProvider);
    }

    @Deprecated
    public void addToallowedServices(EventServiceProvider eventServiceProvider) {
        this.addToAllowedServices(eventServiceProvider);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof NonUniversityLocation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((NonUniversityLocation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((NonUniversityLocation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "NonUniversityLocation[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "NonUniversityLocation[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tCapacity: " + this.getCapacity() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + String.valueOf(this.getEventDepartment()) + "\n\tEventEmail: " + this.getEventEmail() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tName: " + this.getName() + "\n\tNote: " + this.getNote() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tRoomType: " + String.valueOf(this.getRoomType()) + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

