/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseUserData;
import org.unitime.timetable.model.base.UserDataId;
import org.unitime.timetable.model.dao.UserDataDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="user_data")
public class UserData
extends BaseUserData {
    private static final long serialVersionUID = 1L;

    public UserData() {
    }

    public UserData(String externalUniqueId, String name) {
        this.setExternalUniqueId(externalUniqueId);
        this.setName(name);
    }

    public static void setProperty(String externalUniqueId, String name, String value) {
        try {
            UserDataDAO dao = UserDataDAO.getInstance();
            UserData userData = (UserData)dao.get(new UserDataId(externalUniqueId, name));
            if (value != null && value.length() == 0) {
                value = null;
            }
            if (userData == null && value == null) {
                return;
            }
            if (userData != null && value != null && value.equals(userData.getValue())) {
                return;
            }
            if (value == null) {
                dao.getSession().remove((Object)userData);
                dao.getSession().flush();
                return;
            }
            if (userData == null) {
                userData = new UserData(externalUniqueId, name);
                userData.setValue(value);
                dao.getSession().persist((Object)userData);
            } else {
                userData.setValue(value);
                dao.getSession().merge((Object)userData);
            }
            dao.getSession().flush();
        }
        catch (Exception e) {
            Debug.warning("Failed to set user property " + name + ":=" + value + " (" + e.getMessage() + ")");
        }
    }

    public static String getProperty(String externalUniqueId, String name) {
        UserDataDAO dao = UserDataDAO.getInstance();
        UserData userData = (UserData)dao.get(new UserDataId(externalUniqueId, name));
        return userData == null ? null : userData.getValue();
    }

    public static String getProperty(String externalUniqueId, String name, String defaultValue) {
        String value = UserData.getProperty(externalUniqueId, name);
        return value != null ? value : defaultValue;
    }

    public static void removeProperty(String externalUniqueId, String name) {
        UserData.setProperty(externalUniqueId, name, null);
    }

    public static HashMap<String, String> getProperties(String externalUniqueId, Collection<String> names) {
        Object q = "select u from UserData u where u.externalUniqueId = :externalUniqueId and u.name in (";
        Iterator<String> i = names.iterator();
        while (i.hasNext()) {
            q = (String)q + "'" + i.next() + "'";
            if (!i.hasNext()) continue;
            q = (String)q + ",";
        }
        q = (String)q + ")";
        HashMap<String, String> ret = new HashMap<String, String>();
        for (UserData u : UserDataDAO.getInstance().getSession().createQuery((String)q, UserData.class).setParameter("externalUniqueId", (Object)externalUniqueId).setCacheable(true).list()) {
            ret.put(u.getName(), u.getValue());
        }
        return ret;
    }

    public static HashMap<String, String> getProperties(String externalUniqueId) {
        String q = "select u from UserData u where u.externalUniqueId = :externalUniqueId";
        HashMap<String, String> ret = new HashMap<String, String>();
        for (UserData u : UserDataDAO.getInstance().getSession().createQuery(q, UserData.class).setParameter("externalUniqueId", (Object)externalUniqueId).setCacheable(true).list()) {
            ret.put(u.getName(), u.getValue());
        }
        return ret;
    }

    public static boolean getPropertyBoolean(String externalUniqueId, String name, boolean defaultValue) {
        String value = UserData.getProperty(externalUniqueId, name);
        return value != null ? "1".equals(value) : defaultValue;
    }
}

