/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.FinalExamEvent;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.MidtermExamEvent;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseExam;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.model.base.BaseExamPeriodPref;
import org.unitime.timetable.model.base.BaseRoomPref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.Constants;

@Entity
@Table(name="exam")
public class Exam
extends BaseExam
implements Comparable<Exam> {
    private static final long serialVersionUID = 1L;
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    public static final int sSeatingTypeNormal = 0;
    public static final int sSeatingTypeExam = 1;
    private ExamEvent iEvent = null;

    public Exam() {
    }

    public Exam(Long uniqueId) {
        super(uniqueId);
    }

    public static String getSeatingTypeLabel(int seatingType) {
        if (seatingType == 0) {
            return MSG.seatingNormal();
        }
        return MSG.seatingExam();
    }

    public String generateName() {
        StringBuffer sb = new StringBuffer();
        ExamOwner prev = null;
        TreeSet<ExamOwner> owners = new TreeSet<ExamOwner>(this.getOwners());
        if (ApplicationProperty.ExaminationNameExpandCrossListedOfferingsToCourses.isTrue()) {
            HashSet<ExamOwner> dummies = new HashSet<ExamOwner>();
            Iterator<ExamOwner> i = owners.iterator();
            while (i.hasNext()) {
                InstructionalOffering offering;
                ExamOwner owner = i.next();
                if (owner.getOwnerType() == 1 || (offering = owner.getCourse().getInstructionalOffering()).getCourseOfferings().size() <= 1) continue;
                i.remove();
                for (CourseOffering course : offering.getCourseOfferings()) {
                    ExamOwner dummy = new ExamOwner();
                    dummy.setOwnerId(owner.getOwnerId());
                    dummy.setOwnerType(owner.getOwnerType());
                    dummy.setCourse(course);
                    dummies.add(dummy);
                }
            }
            owners.addAll(dummies);
        }
        for (ExamOwner owner : owners) {
            Object ownerObject = owner.getOwnerObject();
            if (prev != null && prev.getCourse().getSubjectArea().equals(owner.getCourse().getSubjectArea())) {
                if (prev.getCourse().equals(owner.getCourse()) && prev.getOwnerType().equals(owner.getOwnerType())) {
                    switch (owner.getOwnerType()) {
                        case 3: {
                            Class_ clazz = (Class_)ownerObject;
                            if (prev.getOwnerType() == 3 && ((Class_)prev.getOwnerObject()).getSchedulingSubpart().equals(clazz.getSchedulingSubpart())) {
                                sb.append(owner.genName(ApplicationProperties.getProperty("tmtbl.exam.name.sameSubpart." + ExamOwner.sOwnerTypes[owner.getOwnerType()])));
                                break;
                            }
                            sb.append(owner.genName(ApplicationProperties.getProperty("tmtbl.exam.name.sameCourse." + ExamOwner.sOwnerTypes[owner.getOwnerType()])));
                            break;
                        }
                        case 2: {
                            sb.append(owner.genName(ApplicationProperties.getProperty("tmtbl.exam.name.sameCourse." + ExamOwner.sOwnerTypes[owner.getOwnerType()])));
                        }
                    }
                } else {
                    sb.append(owner.genName(ApplicationProperties.getProperty("tmtbl.exam.name.sameSubject." + ExamOwner.sOwnerTypes[owner.getOwnerType()])));
                }
            } else {
                if (prev != null) {
                    sb.append(prev.genName(ApplicationProperty.ExamNameSeparator.value()));
                }
                sb.append(owner.genName(ApplicationProperties.getProperty("tmtbl.exam.name." + ExamOwner.sOwnerTypes[owner.getOwnerType()])));
            }
            prev = owner;
        }
        String suffix = prev == null ? "" : prev.genName(ApplicationProperty.ExamNameSuffix.value());
        int limit = ApplicationProperty.ExamNameMaxLength.intValue() - suffix.length();
        return (String)(sb.toString().length() <= limit ? sb.toString() : sb.toString().substring(0, limit - 3) + "...") + suffix;
    }

    @Transient
    public String getLabel() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return this.generateName();
    }

    @Override
    public String htmlLabel() {
        return this.getLabel();
    }

    @Transient
    public Vector getOwnerObjects() {
        Vector<Object> ret = new Vector<Object>();
        for (ExamOwner owner : new TreeSet<ExamOwner>(this.getOwners())) {
            ret.add(owner.getOwnerObject());
        }
        return ret;
    }

    public ExamOwner firstOwner() {
        ExamOwner ret = null;
        for (ExamOwner owner : this.getOwners()) {
            if (ret != null && ret.compareTo(owner) <= 0) continue;
            ret = owner;
        }
        return ret;
    }

    public static List findAll(Long sessionId, ExamType examType) {
        return Exam.findAll(sessionId, examType.getUniqueId());
    }

    public static List<Exam> findAll(Long sessionId, Long examTypeId) {
        return ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    public static List<Exam> findAllMidterm(Long sessionId) {
        return ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.type=:type", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("type", (Object)1).setCacheable(true).list();
    }

    public static List<Exam> findAllFinal(Long sessionId) {
        return ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.type=:type", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("type", (Object)0).setCacheable(true).list();
    }

    public static List<Exam> findExamsOfSubjectArea(Long subjectAreaId, Long examTypeId) {
        return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("subjectAreaId", (Object)subjectAreaId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    public static List<Exam> findExamsOfSubjectAreaIncludeCrossLists(Long subjectAreaId, Long examTypeId) {
        return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("subjectAreaId", (Object)subjectAreaId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    public static List<Exam> findExamsOfCourseOffering(Long courseOfferingId, Long examTypeId) {
        return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.uniqueId=:courseOfferingId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("courseOfferingId", (Object)courseOfferingId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    public static List<Exam> findExamsOfCourse(Long subjectAreaId, String courseNbr, Long examTypeId) {
        if (courseNbr == null || courseNbr.trim().length() == 0) {
            return Exam.findExamsOfSubjectArea(subjectAreaId, examTypeId);
        }
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.length() > 2) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId and (" + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr" : "o.course.courseNbr=:courseNbr") + " or lower(o.course.title) like lower('%' || :courseNbr || '%'))", Exam.class).setParameter("subjectAreaId", (Object)subjectAreaId).setParameter("courseNbr", (Object)courseNbr.trim().replaceAll("\\*", "%")).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
        }
        return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId and " + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr" : "o.course.courseNbr=:courseNbr"), Exam.class).setParameter("subjectAreaId", (Object)subjectAreaId).setParameter("courseNbr", (Object)courseNbr.trim().replaceAll("\\*", "%")).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    @Transient
    public Set<Student> getStudents() {
        HashSet<Student> students = new HashSet<Student>();
        Iterator<ExamOwner> i = this.getOwners().iterator();
        while (i.hasNext()) {
            students.addAll(i.next().getStudents());
        }
        return students;
    }

    @Transient
    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        HashSet<StudentClassEnrollment> enrollments = new HashSet<StudentClassEnrollment>();
        for (ExamOwner owner : this.getOwners()) {
            enrollments.addAll(owner.getStudentClassEnrollments());
        }
        return enrollments;
    }

    @Transient
    public Set<Long> getStudentIds() {
        HashSet<Long> studentIds = new HashSet<Long>();
        Iterator<ExamOwner> i = this.getOwners().iterator();
        while (i.hasNext()) {
            studentIds.addAll(i.next().getStudentIds());
        }
        return studentIds;
    }

    @Transient
    public Hashtable<Long, Set<Exam>> getStudentExams() {
        Hashtable<Long, Set<Exam>> studentExams = new Hashtable<Long, Set<Exam>>();
        for (ExamOwner owner : this.getOwners()) {
            owner.computeStudentExams(studentExams);
        }
        return studentExams;
    }

    @Transient
    public Hashtable<Assignment, Set<Long>> getStudentAssignments() {
        Hashtable<Assignment, Set<Long>> studentAssignments = new Hashtable<Assignment, Set<Long>>();
        for (ExamOwner owner : this.getOwners()) {
            owner.computeStudentAssignments(studentAssignments);
        }
        return studentAssignments;
    }

    public Hashtable<Meeting, Set<Long>> getOverlappingStudentMeetings(Long periodId) {
        Hashtable<Meeting, Set<Long>> studentMeetings = new Hashtable<Meeting, Set<Long>>();
        for (ExamOwner owner : this.getOwners()) {
            owner.computeOverlappingStudentMeetings(studentMeetings, periodId);
        }
        return studentMeetings;
    }

    public int countStudents() {
        int nrStudents = 0;
        Iterator<ExamOwner> i = this.getOwners().iterator();
        while (i.hasNext()) {
            nrStudents += i.next().countStudents();
        }
        return nrStudents;
    }

    @Transient
    public int getLimit() {
        int limit = 0;
        Iterator<ExamOwner> i = this.getOwners().iterator();
        while (i.hasNext()) {
            limit += i.next().getLimit();
        }
        return limit;
    }

    @Transient
    public int getSize() {
        if (this.getExamSize() != null) {
            return this.getExamSize();
        }
        int size = 0;
        Iterator<ExamOwner> i = this.getOwners().iterator();
        while (i.hasNext()) {
            size += i.next().getSize();
        }
        return size;
    }

    public Set effectivePreferences(Class type) {
        if (DistributionPref.class.equals((Object)type)) {
            TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
            try {
                if (this.getDistributionObjects() == null) {
                    return prefs;
                }
                Iterator<DistributionObject> j = this.getDistributionObjects().iterator();
                while (j.hasNext()) {
                    DistributionPref p = j.next().getDistributionPref();
                    prefs.add(p);
                }
            }
            catch (ObjectNotFoundException e) {
                new _RootDAO().getSession().refresh((Object)this);
                Iterator<DistributionObject> j = this.getDistributionObjects().iterator();
                while (j.hasNext()) {
                    DistributionPref p = j.next().getDistributionPref();
                    prefs.add(p);
                }
            }
            return prefs;
        }
        return super.effectivePreferences(type);
    }

    @Transient
    public Set getAvailableRooms() {
        return Location.findAllExamLocations(this.getSession().getUniqueId(), this.getExamType());
    }

    public SubjectArea firstSubjectArea() {
        Iterator<ExamOwner> i = new TreeSet<ExamOwner>(this.getOwners()).iterator();
        if (i.hasNext()) {
            ExamOwner owner = i.next();
            return owner.getCourse().getSubjectArea();
        }
        return null;
    }

    public CourseOffering firstCourseOffering() {
        Iterator<ExamOwner> i = new TreeSet<ExamOwner>(this.getOwners()).iterator();
        if (i.hasNext()) {
            ExamOwner owner = i.next();
            return owner.getCourse();
        }
        return null;
    }

    public Department firstDepartment() {
        Iterator<ExamOwner> i = new TreeSet<ExamOwner>(this.getOwners()).iterator();
        if (i.hasNext()) {
            ExamOwner owner = i.next();
            return owner.getCourse().getDepartment();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public int compareTo(Exam exam) {
        Iterator<ExamOwner> i1 = new TreeSet<ExamOwner>(this.getOwners()).iterator();
        Iterator<ExamOwner> i2 = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
        while (i1.hasNext() && i2.hasNext()) {
            ExamOwner o2;
            ExamOwner o1 = i1.next();
            int cmp = o1.compareTo(o2 = i2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return i1.hasNext() ? 1 : (i2.hasNext() ? -1 : this.getUniqueId().compareTo(exam.getUniqueId()));
    }

    public void deleteDependentObjects(Session hibSession, boolean updateExam) {
        boolean deleted = false;
        if (this.getDistributionObjects() == null) {
            return;
        }
        Iterator<DistributionObject> i = this.getDistributionObjects().iterator();
        while (i.hasNext()) {
            DistributionObject relatedObject = i.next();
            DistributionPref distributionPref = relatedObject.getDistributionPref();
            distributionPref.getDistributionObjects().remove(relatedObject);
            Integer seqNo = relatedObject.getSequenceNumber();
            hibSession.remove((Object)relatedObject);
            deleted = true;
            if (distributionPref.getDistributionObjects().isEmpty()) {
                PreferenceGroup owner = distributionPref.getOwner();
                owner.getPreferences().remove(distributionPref);
                this.getPreferences().remove(distributionPref);
                hibSession.merge((Object)owner);
                hibSession.remove((Object)distributionPref);
            } else {
                if (seqNo != null) {
                    for (DistributionObject dObj : distributionPref.getDistributionObjects()) {
                        if (seqNo.compareTo(dObj.getSequenceNumber()) >= 0) continue;
                        dObj.setSequenceNumber(dObj.getSequenceNumber() - 1);
                        hibSession.merge((Object)dObj);
                    }
                }
                if (updateExam) {
                    hibSession.merge((Object)distributionPref);
                }
            }
            i.remove();
        }
        ExamEvent event = this.getEvent();
        if (event != null) {
            hibSession.remove((Object)event);
            deleted = true;
        }
        if (deleted && updateExam) {
            hibSession.merge((Object)this);
        }
    }

    public static void deleteFromExams(Session hibSession, Integer ownerType, Long ownerId) {
        for (ExamOwner owner : hibSession.createQuery("select o from Exam x inner join x.owners o where o.ownerType=:ownerType and o.ownerId=:ownerId", ExamOwner.class).setParameter("ownerType", (Object)ownerType).setParameter("ownerId", (Object)ownerId).list()) {
            Exam exam = owner.getExam();
            exam.getOwners().remove(owner);
            hibSession.remove((Object)owner);
            if (exam.getOwners().isEmpty()) {
                exam.deleteDependentObjects(hibSession, false);
                hibSession.remove((Object)exam);
                continue;
            }
            hibSession.merge((Object)exam);
        }
    }

    public static void deleteFromExams(Session hibSession, Class_ clazz) {
        Exam.deleteFromExams(hibSession, 3, clazz.getUniqueId());
    }

    public static void deleteFromExams(Session hibSession, InstrOfferingConfig config) {
        Exam.deleteFromExams(hibSession, 2, config.getUniqueId());
    }

    public static void deleteFromExams(Session hibSession, InstructionalOffering offering) {
        Exam.deleteFromExams(hibSession, 0, offering.getUniqueId());
    }

    public static void deleteFromExams(Session hibSession, CourseOffering course) {
        Exam.deleteFromExams(hibSession, 1, course.getUniqueId());
    }

    public static List<Exam> findAll(int ownerType, Long ownerId) {
        return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.ownerType=:ownerType and o.ownerId=:ownerId", Exam.class).setParameter("ownerType", (Object)ownerType).setParameter("ownerId", (Object)ownerId).setCacheable(true).list();
    }

    public static List<Exam> findAllRelated(String type, Long id) {
        if ("Class_".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co inner join co.instructionalOffering io inner join io.instrOfferingConfigs ioc inner join ioc.schedulingSubparts ss inner join ss.classes c where c.uniqueId=:classId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )", Exam.class).setParameter("classId", (Object)id).setCacheable(true).list();
        }
        if ("SchedulingSubpart".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co inner join co.instructionalOffering io inner join io.instrOfferingConfigs ioc inner join ioc.schedulingSubparts ss left outer join ss.classes c where ss.uniqueId=:subpartId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )", Exam.class).setParameter("subpartId", (Object)id).setCacheable(true).list();
        }
        if ("CourseOffering".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co left outer join co.instructionalOffering io left outer join io.instrOfferingConfigs ioc left outer join ioc.schedulingSubparts ss left outer join ss.classes c where co.uniqueId=:courseOfferingId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )", Exam.class).setParameter("courseOfferingId", (Object)id).setCacheable(true).list();
        }
        if ("InstructionalOffering".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co inner join co.instructionalOffering io left outer join io.instrOfferingConfigs ioc left outer join ioc.schedulingSubparts ss left outer join ss.classes c where io.uniqueId=:instructionalOfferingId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )", Exam.class).setParameter("instructionalOfferingId", (Object)id).setCacheable(true).list();
        }
        if ("InstrOfferingConfig".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co inner join co.instructionalOffering io inner join io.instrOfferingConfigs ioc left outer join ioc.schedulingSubparts ss left outer join ss.classes c where ioc.uniqueId=:instrOfferingConfigId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) )", Exam.class).setParameter("instrOfferingConfigId", (Object)id).setCacheable(true).list();
        }
        if ("DepartmentalInstructor".equals(type)) {
            return ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors xi, DepartmentalInstructor i where i.uniqueId=:instructorId and (xi.uniqueId=i.uniqueId or (i.externalUniqueId is not null and i.externalUniqueId=xi.externalUniqueId and xi.department.session = i.department.session))", Exam.class).setParameter("instructorId", (Object)id).setCacheable(true).list();
        }
        if ("ExamEvent".equals(type)) {
            ArrayList<Exam> ret = new ArrayList<Exam>();
            ExamEvent event = (ExamEvent)ExamEventDAO.getInstance().get(id);
            if (event != null && event.getExam() != null) {
                ret.add(event.getExam());
            }
            return ret;
        }
        throw new RuntimeException("Unsupported type " + type);
    }

    public static boolean hasTimetable(Long sessionId, Integer examType) {
        if (sessionId == null) {
            return false;
        }
        if (examType == null) {
            return Exam.hasTimetable(sessionId);
        }
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(x) from Exam x where x.session.uniqueId=:sessionId and x.assignedPeriod is not null and x.examType.type=:examType", Number.class).setParameter("sessionId", (Object)sessionId).setParameter("examType", (Object)examType).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static boolean hasTimetable(Long sessionId) {
        if (sessionId == null) {
            return false;
        }
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(x) from Exam x where x.session.uniqueId=:sessionId and x.assignedPeriod is not null", Number.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static boolean hasMidtermExams(Long sessionId) {
        if (sessionId == null) {
            return false;
        }
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(p) from ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.type = 1", Number.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static boolean hasFinalExams(Long sessionId) {
        if (sessionId == null) {
            return false;
        }
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(p) from ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.type = 0", Number.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static boolean hasExamsOfType(Long sessionId, ExamType type) {
        if (sessionId == null) {
            return false;
        }
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(p) from ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.uniqueid = :typeId", Number.class).setParameter("sessionId", (Object)sessionId).setParameter("typeId", (Object)type.getUniqueId()).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static Collection<ExamAssignmentInfo> findAssignedExams(Long sessionId, Long examTypeId) {
        Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.assignedPeriod is not null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamAssignmentInfo(exam));
        }
        return ret;
    }

    public static Collection<ExamInfo> findUnassignedExams(Long sessionId, Long examTypeId) {
        Vector<ExamInfo> ret = new Vector<ExamInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.assignedPeriod is null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamInfo(exam));
        }
        return ret;
    }

    public static Collection<ExamAssignmentInfo> findAssignedExams(Long sessionId, Long subjectAreaId, Long examTypeId) {
        if (subjectAreaId == null || subjectAreaId < 0L) {
            return Exam.findAssignedExams(sessionId, examTypeId);
        }
        Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId and x.session.uniqueId=:sessionId and x.assignedPeriod is not null", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("subjectAreaId", (Object)subjectAreaId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamAssignmentInfo(exam));
        }
        return ret;
    }

    public static Collection<ExamInfo> findUnassignedExams(Long sessionId, Long subjectAreaId, Long examTypeId) {
        if (subjectAreaId == null || subjectAreaId < 0L) {
            return Exam.findUnassignedExams(sessionId, examTypeId);
        }
        Vector<ExamInfo> ret = new Vector<ExamInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId and x.session.uniqueId=:sessionId and x.assignedPeriod is null", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("subjectAreaId", (Object)subjectAreaId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamInfo(exam));
        }
        return ret;
    }

    public static Collection<ExamAssignmentInfo> findAssignedExamsOfLocation(Long locationId, Long examTypeId) throws Exception {
        Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.assignedRooms r where r.uniqueId=:locationId and x.assignedPeriod is not null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("locationId", (Object)locationId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamAssignmentInfo(exam));
        }
        return ret;
    }

    public static Collection<ExamAssignmentInfo> findAssignedExamsOfInstructor(Long instructorId, Long examTypeId) throws Exception {
        Vector<ExamAssignmentInfo> ret = new Vector<ExamAssignmentInfo>();
        List exams = ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.assignedPeriod is not null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("instructorId", (Object)instructorId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
        for (Exam exam : exams) {
            ret.add(new ExamAssignmentInfo(exam));
        }
        return ret;
    }

    public String assign(ExamAssignmentInfo assignment, String managerExternalId, Session hibSession) {
        Transaction tx = null;
        try {
            Exam otherExam;
            Iterator<ExamAssignment> j;
            Exam other;
            ExamConflict conf;
            tx = hibSession.beginTransaction();
            ExamAssignment oldAssignment = new ExamAssignment(this);
            this.setAssignedPeriod(assignment.getPeriod(hibSession));
            if (this.getAssignedRooms() == null) {
                this.setAssignedRooms(new HashSet<Location>());
            }
            this.getAssignedRooms().clear();
            for (ExamRoomInfo room : assignment.getRooms()) {
                this.getAssignedRooms().add(room.getLocation(hibSession));
            }
            this.setAssignedPreference(assignment.getAssignedPreferenceString());
            HashSet<Exam> otherExams = new HashSet<Exam>();
            Iterator<ExamConflict> j2 = this.getConflicts().iterator();
            while (j2.hasNext()) {
                ExamConflict conf2 = j2.next();
                for (Exam x : conf2.getExams()) {
                    if (x.equals(this)) continue;
                    x.getConflicts().remove(conf2);
                    otherExams.add(x);
                }
                hibSession.remove((Object)conf2);
                j2.remove();
            }
            for (ExamAssignmentInfo.DirectConflict dc : assignment.getDirectConflicts()) {
                if (dc.getOtherExam() == null) continue;
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setStudents(this.getStudents(hibSession, dc.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = dc.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : assignment.getBackToBackConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setStudents(this.getStudents(hibSession, btb.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = btb.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : assignment.getMoreThanTwoADaysConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setStudents(this.getStudents(hibSession, m2d.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                j = m2d.getOtherExams().iterator();
                while (j.hasNext()) {
                    otherExam = ((ExamInfo)j.next()).getExam(hibSession);
                    otherExam.getConflicts().add(conf);
                    otherExams.add(otherExam);
                }
            }
            for (ExamAssignmentInfo.DirectConflict dc : assignment.getInstructorDirectConflicts()) {
                if (dc.getOtherExam() == null) continue;
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setInstructors(this.getInstructors(hibSession, dc.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = dc.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : assignment.getInstructorBackToBackConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setInstructors(this.getInstructors(hibSession, btb.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = btb.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : assignment.getInstructorMoreThanTwoADaysConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setInstructors(this.getInstructors(hibSession, m2d.getStudents()));
                conf.setNrInstructors(conf.getInstructors().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                j = m2d.getOtherExams().iterator();
                while (j.hasNext()) {
                    otherExam = ((ExamInfo)j.next()).getExam(hibSession);
                    otherExam.getConflicts().add(conf);
                    otherExams.add(otherExam);
                }
            }
            ExamEvent event = this.generateEvent(this.getEvent(), true);
            if (event != null) {
                event.setEventName(assignment.getExamName());
                event.setMinCapacity(assignment.getNrStudents());
                event.setMaxCapacity(assignment.getNrStudents());
                EventContact contact = EventContact.findByExternalUniqueId(managerExternalId);
                if (contact == null) {
                    TimetableManager manager = TimetableManager.findByExternalId(managerExternalId);
                    contact = new EventContact();
                    contact.setFirstName(manager.getFirstName());
                    contact.setMiddleName(manager.getMiddleName());
                    contact.setLastName(manager.getLastName());
                    contact.setExternalUniqueId(manager.getExternalUniqueId());
                    contact.setEmailAddress(manager.getEmailAddress());
                    hibSession.persist((Object)contact);
                }
                event.setMainContact(contact);
                if (event.getUniqueId() == null) {
                    hibSession.persist((Object)event);
                } else {
                    hibSession.merge((Object)event);
                }
            }
            hibSession.merge((Object)this);
            Iterator i = otherExams.iterator();
            while (i.hasNext()) {
                hibSession.merge((Object)((Exam)i.next()));
            }
            SubjectArea subject = null;
            Department dept = null;
            Iterator<ExamOwner> i2 = new TreeSet<ExamOwner>(this.getOwners()).iterator();
            if (i2.hasNext()) {
                ExamOwner owner = i2.next();
                subject = owner.getCourse().getSubjectArea();
                dept = subject.getDepartment();
            }
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(managerExternalId), this.getSession(), this, assignment.getExamName() + " (" + (String)(oldAssignment.getPeriod() == null ? "N/A" : oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ")) + " &rarr; " + assignment.getPeriodAbbreviation() + " " + assignment.getRoomsName(", ") + ")", ChangeLog.Source.EXAM_INFO, ChangeLog.Operation.ASSIGN, subject, dept);
            tx.commit();
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Assignment of " + assignment.getExamName() + " to " + assignment.getPeriodAbbreviation() + " " + assignment.getRoomsName(", ") + " failed, reason: " + e.getMessage();
        }
    }

    public String unassign(String managerExternalId, Session hibSession) {
        Transaction tx = null;
        try {
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            ExamAssignment oldAssignment = new ExamAssignment(this);
            this.setAssignedPeriod(null);
            if (this.getAssignedRooms() == null) {
                this.setAssignedRooms(new HashSet<Location>());
            }
            this.getAssignedRooms().clear();
            this.setAssignedPreference(null);
            HashSet<Exam> otherExams = new HashSet<Exam>();
            Iterator<ExamConflict> j = this.getConflicts().iterator();
            while (j.hasNext()) {
                ExamConflict conf = j.next();
                for (Exam x : conf.getExams()) {
                    if (x.equals(this)) continue;
                    x.getConflicts().remove(conf);
                    otherExams.add(x);
                }
                hibSession.remove((Object)conf);
                j.remove();
            }
            ExamEvent event = this.getEvent();
            if (event != null) {
                hibSession.remove((Object)event);
            }
            hibSession.merge((Object)this);
            Iterator i = otherExams.iterator();
            while (i.hasNext()) {
                hibSession.merge((Object)((Exam)i.next()));
            }
            SubjectArea subject = null;
            Department dept = null;
            Iterator<ExamOwner> i2 = new TreeSet<ExamOwner>(this.getOwners()).iterator();
            if (i2.hasNext()) {
                ExamOwner owner = i2.next();
                subject = owner.getCourse().getSubjectArea();
                dept = subject.getDepartment();
            }
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(managerExternalId), this.getSession(), this, this.getName() + " (" + (String)(oldAssignment.getPeriod() == null ? "N/A" : oldAssignment.getPeriodAbbreviation() + " " + oldAssignment.getRoomsName(", ")) + " &rarr; N/A)", ChangeLog.Source.EXAM_INFO, ChangeLog.Operation.UNASSIGN, subject, dept);
            if (tx != null) {
                tx.commit();
            }
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Unassignment of " + this.getName() + " failed, reason: " + e.getMessage();
        }
    }

    protected HashSet getStudents(Session hibSession, Collection studentIds) {
        HashSet<Student> students = new HashSet<Student>();
        if (studentIds == null || studentIds.isEmpty()) {
            return students;
        }
        for (Long studentId : studentIds) {
            Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
            if (student == null) continue;
            students.add(student);
        }
        return students;
    }

    protected HashSet getInstructors(Session hibSession, Collection instructorIds) {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        if (instructorIds == null || instructorIds.isEmpty()) {
            return instructors;
        }
        for (Long instructorId : instructorIds) {
            DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId, hibSession);
            if (instructor == null) continue;
            instructors.add(instructor);
        }
        return instructors;
    }

    public int examOffset() {
        return this.getPrintOffset() == null ? 0 : this.getPrintOffset();
    }

    public ExamEvent generateEvent(ExamEvent event, boolean createNoRoomMeetings) {
        ExamPeriod period = this.getAssignedPeriod();
        if (period == null) {
            return null;
        }
        if (event == null) {
            if (this.getSession().getStatusType().isTestSession()) {
                return null;
            }
            event = this.getExamType().getType() == 0 ? new FinalExamEvent() : new MidtermExamEvent();
            event.setExam(this);
            this.setEvent(event);
        }
        if (event.getMeetings() != null) {
            event.getMeetings().clear();
        } else {
            event.setMeetings(new HashSet<Meeting>());
        }
        boolean created = false;
        for (Location location : this.getAssignedRooms()) {
            if (location.getPermanentId() == null) continue;
            Meeting m = new Meeting();
            m.setMeetingDate(period.getStartDate());
            m.setStartPeriod(period.getExamEventStartSlot());
            m.setStartOffset(period.getExamEventStartOffsetForExam(this));
            m.setStopPeriod(period.getExamEventStopSlot(this));
            m.setStopOffset(period.getExamEventStopOffsetForExam(this));
            m.setClassCanOverride(false);
            m.setLocationPermanentId(location.getPermanentId());
            m.setStatus(Meeting.Status.APPROVED);
            m.setApprovalDate(new Date());
            m.setEvent(event);
            event.getMeetings().add(m);
            created = true;
        }
        if (!created && createNoRoomMeetings) {
            Meeting m = new Meeting();
            m.setMeetingDate(period.getStartDate());
            m.setStartPeriod(period.getExamEventStartSlot());
            m.setStartOffset(period.getExamEventStartOffsetForExam(this));
            m.setStopPeriod(period.getExamEventStopSlot(this));
            m.setStopOffset(period.getExamEventStopOffsetForExam(this));
            m.setClassCanOverride(false);
            m.setLocationPermanentId(null);
            m.setStatus(Meeting.Status.APPROVED);
            m.setApprovalDate(new Date());
            m.setEvent(event);
            event.getMeetings().add(m);
        }
        return event;
    }

    @Transient
    public ExamPeriod getAveragePeriod() {
        return ExamPeriod.findByIndex(this.getSession().getUniqueId(), this.getExamType(), this.getAvgPeriod());
    }

    public static Exam findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (Exam)ExamDAO.getInstance().getSession().createQuery("select e from Exam e where e.session.uniqueId=:sessionId and e.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("uniqueIdRolledForwardFrom", (Object)uniqueIdRolledForwardFrom).setCacheable(true).uniqueResult();
    }

    public void generateDefaultPreferences(boolean override) {
        PreferenceLevel originalPref;
        Preference pref;
        ClassEvent event;
        PreferenceLevel eveningPref;
        TreeSet<ExamPeriod> allPeriods = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType());
        if (this.getPreferences() == null) {
            this.setPreferences(new HashSet<Preference>());
        }
        if (!PreferenceLevel.sNeutral.equals((eveningPref = PreferenceLevel.getPreferenceLevel(ApplicationProperty.ExamDefaultsEveningClassPreference.value(this.getExamType().getReference()))).getPrefProlog()) && (override || this.getPreferences(ExamPeriodPref.class).isEmpty())) {
            int firstEveningPeriod = ApplicationProperty.ExamDefaultsEveningClassStart.intValue(this.getExamType().getReference());
            HashSet<BaseExamPeriod> periods = new HashSet<BaseExamPeriod>();
            for (ExamOwner examOwner : this.getOwners()) {
                if (3 != examOwner.getOwnerType() || (event = ((Class_)examOwner.getOwnerObject()).getEvent()) == null) continue;
                for (Meeting meeting : event.getMeetings()) {
                    if (meeting.getStopPeriod() <= firstEveningPeriod) continue;
                    BaseExamPeriod lastPeriod = null;
                    for (ExamPeriod period : allPeriods) {
                        if (period.getDayOfWeek() != meeting.getDayOfWeek() || lastPeriod != null && lastPeriod.getStartSlot() >= period.getStartSlot()) continue;
                        lastPeriod = period;
                    }
                    if (lastPeriod == null) continue;
                    periods.add(lastPeriod);
                }
            }
            if (!periods.isEmpty()) {
                for (ExamPeriodPref examPeriodPref : this.getPreferences(ExamPeriodPref.class)) {
                    if (periods.contains(examPeriodPref.getExamPeriod())) {
                        periods.remove(examPeriodPref.getExamPeriod());
                        if (examPeriodPref.getPrefLevel().equals(eveningPref)) continue;
                        examPeriodPref.setPrefLevel(eveningPref);
                        continue;
                    }
                    this.getPreferences().remove(examPeriodPref);
                }
                for (ExamPeriod examPeriod : periods) {
                    pref = new ExamPeriodPref();
                    pref.setPrefLevel(eveningPref);
                    pref.setOwner(this);
                    ((BaseExamPeriodPref)pref).setExamPeriod(examPeriod);
                    this.getPreferences().add(pref);
                }
            }
        }
        if (!PreferenceLevel.sNeutral.equals((originalPref = PreferenceLevel.getPreferenceLevel(ApplicationProperty.ExamDefaultsOriginalRoomPreference.value(this.getExamType().getReference()))).getPrefProlog()) && (override || this.getPreferences(RoomPref.class).isEmpty())) {
            HashSet<Location> locations = new HashSet<Location>();
            for (ExamOwner examOwner : this.getOwners()) {
                if (3 != examOwner.getOwnerType() || (event = ((Class_)examOwner.getOwnerObject()).getEvent()) == null) continue;
                for (Meeting meeting : event.getMeetings()) {
                    if (meeting.getLocation() == null || !meeting.getLocation().isExamEnabled(this.getExamType())) continue;
                    locations.add(meeting.getLocation());
                }
            }
            if (!locations.isEmpty()) {
                for (RoomPref roomPref : this.getPreferences(RoomPref.class)) {
                    if (locations.contains(roomPref.getRoom())) {
                        locations.remove(roomPref.getRoom());
                        if (roomPref.getPrefLevel().equals(originalPref)) continue;
                        roomPref.setPrefLevel(originalPref);
                        continue;
                    }
                    this.getPreferences().remove(roomPref);
                }
                for (Location location : locations) {
                    pref = new RoomPref();
                    pref.setPrefLevel(originalPref);
                    pref.setOwner(this);
                    ((BaseRoomPref)pref).setRoom(location);
                    this.getPreferences().add(pref);
                }
            }
        }
        PreferenceLevel originalBuildingPref = PreferenceLevel.getPreferenceLevel(ApplicationProperty.ExamDefaultsOriginalBuildingPreference.value(this.getExamType().getReference()));
        boolean examRoomsOnly = ApplicationProperty.ExamDefaultsOriginalBuildingOnlyForExamRooms.isTrue(this.getExamType().getReference());
        if (!PreferenceLevel.sNeutral.equals(originalBuildingPref.getPrefProlog()) && (override || this.getPreferences(BuildingPref.class).isEmpty())) {
            HashSet<Building> hashSet = new HashSet<Building>();
            for (ExamOwner owner : this.getOwners()) {
                ClassEvent event2;
                if (3 != owner.getOwnerType() || (event2 = ((Class_)owner.getOwnerObject()).getEvent()) == null) continue;
                for (Meeting meeting : event2.getMeetings()) {
                    Location location = meeting.getLocation();
                    if (location == null || !(location instanceof Room) || examRoomsOnly && !location.isExamEnabled(this.getExamType())) continue;
                    hashSet.add(((Room)location).getBuilding());
                }
            }
            if (!hashSet.isEmpty()) {
                for (BuildingPref pref3 : this.getPreferences(BuildingPref.class)) {
                    if (hashSet.contains(pref3.getBuilding())) {
                        hashSet.remove(pref3.getBuilding());
                        if (pref3.getPrefLevel().equals(originalBuildingPref)) continue;
                        pref3.setPrefLevel(originalBuildingPref);
                        continue;
                    }
                    this.getPreferences().remove(pref3);
                }
                for (Building building : hashSet) {
                    BuildingPref pref4 = new BuildingPref();
                    pref4.setPrefLevel(originalBuildingPref);
                    pref4.setOwner(this);
                    pref4.setBuilding(building);
                    this.getPreferences().add(pref4);
                }
            }
        }
    }

    @Transient
    public ExamEvent getEvent() {
        if (this.getUniqueId() == null) {
            return null;
        }
        if (this.iEvent == null) {
            this.iEvent = (ExamEvent)ExamDAO.getInstance().getSession().createQuery("select e from ExamEvent e left join fetch e.meetings m where e.exam.uniqueId=:examId", ExamEvent.class).setParameter("examId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult();
        }
        return this.iEvent;
    }

    public void setEvent(ExamEvent event) {
        this.iEvent = event;
    }

    public void updateConflicts(Session hibSession) throws Exception {
        Transaction tx = null;
        try {
            Exam otherExam;
            Iterator<ExamAssignment> j;
            Exam other;
            ExamConflict conf;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            HashSet<Exam> otherExams = new HashSet<Exam>();
            Iterator<ExamConflict> j2 = this.getConflicts().iterator();
            while (j2.hasNext()) {
                ExamConflict conf2 = j2.next();
                for (Exam x : conf2.getExams()) {
                    if (x.equals(this)) continue;
                    x.getConflicts().remove(conf2);
                    otherExams.add(x);
                }
                hibSession.remove((Object)conf2);
                j2.remove();
            }
            ExamAssignmentInfo assignment = new ExamAssignmentInfo(this, false);
            for (ExamAssignmentInfo.DirectConflict dc : assignment.getDirectConflicts()) {
                if (dc.getOtherExam() == null) continue;
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setStudents(this.getStudents(hibSession, dc.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = dc.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : assignment.getBackToBackConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setStudents(this.getStudents(hibSession, btb.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = btb.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : assignment.getMoreThanTwoADaysConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setStudents(this.getStudents(hibSession, m2d.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                j = m2d.getOtherExams().iterator();
                while (j.hasNext()) {
                    otherExam = ((ExamInfo)j.next()).getExam(hibSession);
                    otherExam.getConflicts().add(conf);
                    otherExams.add(otherExam);
                }
            }
            for (ExamAssignmentInfo.DirectConflict dc : assignment.getInstructorDirectConflicts()) {
                if (dc.getOtherExam() == null) continue;
                conf = new ExamConflict();
                conf.setConflictType(0);
                conf.setStudents(this.getInstructors(hibSession, dc.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = dc.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : assignment.getInstructorBackToBackConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(btb.isDistance() ? 2 : 3);
                conf.setDistance(btb.getDistance());
                conf.setStudents(this.getInstructors(hibSession, btb.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                other = btb.getOtherExam().getExam(hibSession);
                other.getConflicts().add(conf);
                otherExams.add(other);
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : assignment.getInstructorMoreThanTwoADaysConflicts()) {
                conf = new ExamConflict();
                conf.setConflictType(1);
                conf.setStudents(this.getInstructors(hibSession, m2d.getStudents()));
                conf.setNrStudents(conf.getStudents().size());
                hibSession.persist((Object)conf);
                this.getConflicts().add(conf);
                j = m2d.getOtherExams().iterator();
                while (j.hasNext()) {
                    otherExam = ((ExamInfo)j.next()).getExam(hibSession);
                    otherExam.getConflicts().add(conf);
                    otherExams.add(otherExam);
                }
            }
            hibSession.merge((Object)this);
            Iterator<Comparable<ExamAssignmentInfo.DirectConflict>> i = otherExams.iterator();
            while (i.hasNext()) {
                hibSession.merge((Object)((Exam)i.next()));
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public Date getEndTime(ExamPeriod period) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, period.getDateOffset());
        int min = period.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.examOffset() + this.getLength();
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    public Date getStartTime(ExamPeriod period) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, period.getDateOffset());
        int min = period.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + this.examOffset();
        c.set(10, min / 60);
        c.set(12, min % 60);
        return c.getTime();
    }

    @Override
    @Transient
    public Department getDepartment() {
        return null;
    }

    public DepartmentStatusType effectiveStatusType() {
        return this.getStatusType() == null ? this.getSession().getStatusType() : this.getStatusType();
    }

    public boolean canView() {
        DepartmentStatusType type = this.effectiveStatusType();
        return type != null && (this.getExamType().getType() == 0 ? type.canNoRoleReportExamFinal() : type.canNoRoleReportExamMidterm());
    }
}

