/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.Transaction;
import org.unitime.timetable.dataexchange.AcademicAreaImport;
import org.unitime.timetable.dataexchange.AcademicClassificationImport;
import org.unitime.timetable.dataexchange.AcademicSessionSetupExport;
import org.unitime.timetable.dataexchange.AcademicSessionSetupImport;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.BuildingRoomImport;
import org.unitime.timetable.dataexchange.CourseCatalogImport;
import org.unitime.timetable.dataexchange.CourseOfferingExport;
import org.unitime.timetable.dataexchange.CourseOfferingImport;
import org.unitime.timetable.dataexchange.CourseOfferingReservationImport;
import org.unitime.timetable.dataexchange.CourseTimetableExport;
import org.unitime.timetable.dataexchange.CourseTimetableImport;
import org.unitime.timetable.dataexchange.CurriculaExport;
import org.unitime.timetable.dataexchange.CurriculaImport;
import org.unitime.timetable.dataexchange.DepartmentImport;
import org.unitime.timetable.dataexchange.EventImport;
import org.unitime.timetable.dataexchange.ExamImport;
import org.unitime.timetable.dataexchange.HQLExport;
import org.unitime.timetable.dataexchange.HQLImport;
import org.unitime.timetable.dataexchange.InstructorSurveyExport;
import org.unitime.timetable.dataexchange.InstructorSurveyImport;
import org.unitime.timetable.dataexchange.LastLikeCourseDemandExport;
import org.unitime.timetable.dataexchange.LastLikeCourseDemandImport;
import org.unitime.timetable.dataexchange.PermissionsExport;
import org.unitime.timetable.dataexchange.PermissionsImport;
import org.unitime.timetable.dataexchange.PointInTimeDataExport;
import org.unitime.timetable.dataexchange.PointInTimeDataImport;
import org.unitime.timetable.dataexchange.PosMajorImport;
import org.unitime.timetable.dataexchange.PosMinorImport;
import org.unitime.timetable.dataexchange.PreferencesExport;
import org.unitime.timetable.dataexchange.PreferencesImport;
import org.unitime.timetable.dataexchange.ReservationExport;
import org.unitime.timetable.dataexchange.ReservationImport;
import org.unitime.timetable.dataexchange.RoomSharingExport;
import org.unitime.timetable.dataexchange.RoomSharingImport;
import org.unitime.timetable.dataexchange.ScriptExport;
import org.unitime.timetable.dataexchange.ScriptImport;
import org.unitime.timetable.dataexchange.SessionImport;
import org.unitime.timetable.dataexchange.SolverImport;
import org.unitime.timetable.dataexchange.StaffImport;
import org.unitime.timetable.dataexchange.StudentAccomodationImport;
import org.unitime.timetable.dataexchange.StudentAdvisorsExport;
import org.unitime.timetable.dataexchange.StudentAdvisorsImport;
import org.unitime.timetable.dataexchange.StudentEnrollmentExport;
import org.unitime.timetable.dataexchange.StudentEnrollmentImport;
import org.unitime.timetable.dataexchange.StudentExport;
import org.unitime.timetable.dataexchange.StudentGroupImport;
import org.unitime.timetable.dataexchange.StudentImport;
import org.unitime.timetable.dataexchange.StudentSchedulingStatusExport;
import org.unitime.timetable.dataexchange.StudentSchedulingStatusImport;
import org.unitime.timetable.dataexchange.StudentSectioningExport;
import org.unitime.timetable.dataexchange.StudentSectioningImport;
import org.unitime.timetable.dataexchange.SubjectAreaImport;
import org.unitime.timetable.dataexchange.TravelTimesExport;
import org.unitime.timetable.dataexchange.TravelTimesImport;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao._RootDAO;

public class DataExchangeHelper {
    protected static Log sLog = LogFactory.getLog(DataExchangeHelper.class);
    protected Log iTextLog;
    protected org.hibernate.Session iHibSession = null;
    protected Transaction iTx = null;
    protected int iFlushIfNeededCounter = 0;
    protected static int sBatchSize = 100;
    public static Hashtable<String, Class> sExportRegister = new Hashtable();
    public static Hashtable<String, Class> sImportRegister;

    public void setLog(Log out) {
        this.iTextLog = out;
    }

    public Log getLog() {
        return this.iTextLog;
    }

    public void debug(String msg) {
        if (this.iTextLog != null) {
            this.iTextLog.debug((Object)msg);
        }
        sLog.debug((Object)msg);
    }

    public void info(String msg) {
        if (this.iTextLog != null) {
            this.iTextLog.info((Object)msg);
        }
        sLog.info((Object)msg);
    }

    public void warn(String msg) {
        if (this.iTextLog != null) {
            this.iTextLog.warn((Object)msg);
        }
        sLog.warn((Object)msg);
    }

    public void error(String msg) {
        if (this.iTextLog != null) {
            this.iTextLog.error((Object)msg);
        }
        sLog.error((Object)msg);
    }

    public void fatal(String msg) {
        if (this.iTextLog != null) {
            this.iTextLog.fatal((Object)msg);
        }
        sLog.fatal((Object)msg);
    }

    public void debug(String msg, Throwable t) {
        if (this.iTextLog != null) {
            this.iTextLog.debug((Object)msg, t);
        }
        sLog.debug((Object)msg, t);
    }

    public void info(String msg, Throwable t) {
        if (this.iTextLog != null) {
            this.iTextLog.info((Object)msg, t);
        }
        sLog.info((Object)msg, t);
    }

    public void warn(String msg, Throwable t) {
        if (this.iTextLog != null) {
            this.iTextLog.warn((Object)msg, t);
        }
        sLog.warn((Object)msg, t);
    }

    public void error(String msg, Throwable t) {
        if (this.iTextLog != null) {
            this.iTextLog.error((Object)msg, t);
        }
        sLog.error((Object)msg, t);
    }

    public void fatal(String msg, Throwable t) {
        if (this.iTextLog != null) {
            this.iTextLog.fatal((Object)msg, t);
        }
        sLog.fatal((Object)msg, t);
    }

    public org.hibernate.Session getHibSession() {
        return this.iHibSession;
    }

    public boolean beginTransaction() {
        try {
            this.iHibSession = new _RootDAO().getSession();
            if (this.iHibSession.getTransaction() != null && this.iHibSession.getTransaction().isActive()) {
                return false;
            }
            this.iTx = this.iHibSession.beginTransaction();
            this.debug("Transaction started.");
            return true;
        }
        catch (Exception e) {
            this.fatal("Unable to begin transaction, reason: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean commitTransaction() {
        try {
            if (this.iTx == null) {
                this.iHibSession = null;
                boolean bl = false;
                return bl;
            }
            this.iTx.commit();
            this.debug("Transaction committed.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.fatal("Unable to commit transaction, reason: " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.iHibSession != null && this.iHibSession.isOpen()) {
                this.iHibSession.close();
            }
        }
    }

    public boolean rollbackTransaction() {
        try {
            if (this.iTx == null) {
                this.iHibSession = null;
                boolean bl = false;
                return bl;
            }
            this.iTx.rollback();
            this.info("Transaction rollbacked.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.fatal("Unable to rollback transaction, reason: " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.iHibSession != null && this.iHibSession.isOpen()) {
                this.iHibSession.close();
            }
        }
    }

    public boolean flush(boolean commit) {
        try {
            this.getHibSession().flush();
            this.getHibSession().clear();
            if (commit && this.iTx != null) {
                this.iTx.commit();
                this.iTx = this.getHibSession().beginTransaction();
            }
            return true;
        }
        catch (Exception e) {
            this.fatal("Unable to flush current session, reason: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean flushIfNeeded(boolean commit) {
        ++this.iFlushIfNeededCounter;
        if (this.iFlushIfNeededCounter >= sBatchSize) {
            this.iFlushIfNeededCounter = 0;
            return this.flush(commit);
        }
        return true;
    }

    public boolean flushDoNotClearSession(boolean commit) {
        try {
            this.getHibSession().flush();
            if (commit && this.iTx != null) {
                this.iTx.commit();
                this.iTx = this.getHibSession().beginTransaction();
            }
            return true;
        }
        catch (Exception e) {
            this.fatal("Unable to flush current session, reason: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean flushIfNeededDoNotClearSession(boolean commit) {
        ++this.iFlushIfNeededCounter;
        if (this.iFlushIfNeededCounter >= sBatchSize) {
            this.iFlushIfNeededCounter = 0;
            return this.flushDoNotClearSession(commit);
        }
        return true;
    }

    public static BaseImport createImportBase(String type) throws Exception {
        if (type == null) {
            throw new Exception("Import type not provided.");
        }
        if (!sImportRegister.containsKey(type)) {
            throw new Exception("Unknown import type " + type + ".");
        }
        return (BaseImport)sImportRegister.get(type).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static BaseExport createExportBase(String type) throws Exception {
        if (type == null) {
            throw new Exception("Export type not provided.");
        }
        if (!sExportRegister.containsKey(type)) {
            throw new Exception("Unknown export type " + type + ".");
        }
        return (BaseExport)sExportRegister.get(type).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void importDocument(Document document, String userId, Log log) throws Exception {
        BaseImport imp = DataExchangeHelper.createImportBase(document.getRootElement().getName());
        imp.setLog(log);
        if (userId != null) {
            imp.setManager(TimetableManager.findByExternalId(userId));
        }
        imp.loadXml(document.getRootElement());
    }

    public static Document exportDocument(String rootName, Session session, Properties parameters, Log log) throws Exception {
        BaseExport exp = DataExchangeHelper.createExportBase(rootName);
        exp.setLog(log);
        return exp.saveXml(session, parameters);
    }

    protected String getExternalUniqueId(Class_ clazz) {
        String externalId = clazz.getExternalUniqueId();
        if (externalId != null && !externalId.isEmpty()) {
            return externalId;
        }
        return this.getClassLabel(clazz);
    }

    protected String getClassLabel(Class_ clazz) {
        String label = clazz.getCourseName() + " " + clazz.getItypeDesc().trim() + " " + this.getClassSuffix(clazz);
        return label.length() <= 40 ? label : clazz.getItypeDesc().trim() + " " + this.getClassSuffix(clazz);
    }

    protected String getClassSuffix(Class_ clazz) {
        String suffix = clazz.getClassSuffix();
        if (suffix != null && !suffix.isEmpty()) {
            return suffix;
        }
        return clazz.getSectionNumberString(this.getHibSession());
    }

    static {
        sExportRegister.put("exams", CourseOfferingExport.class);
        sExportRegister.put("offerings", CourseOfferingExport.class);
        sExportRegister.put("timetable", CourseTimetableExport.class);
        sExportRegister.put("curricula", CurriculaExport.class);
        sExportRegister.put("studentEnrollments", StudentEnrollmentExport.class);
        sExportRegister.put("students", StudentExport.class);
        sExportRegister.put("reservations", ReservationExport.class);
        sExportRegister.put("permissions", PermissionsExport.class);
        sExportRegister.put("traveltimes", TravelTimesExport.class);
        sExportRegister.put("lastLikeCourseDemand", LastLikeCourseDemandExport.class);
        sExportRegister.put("request", StudentSectioningExport.class);
        sExportRegister.put("roomSharing", RoomSharingExport.class);
        sExportRegister.put("pointInTimeData", PointInTimeDataExport.class);
        sExportRegister.put("preferences", PreferencesExport.class);
        sExportRegister.put("sessionSetup", AcademicSessionSetupExport.class);
        sExportRegister.put("studentAdvisors", StudentAdvisorsExport.class);
        sExportRegister.put("studentStatuses", StudentSchedulingStatusExport.class);
        sExportRegister.put("instructorSurveys", InstructorSurveyExport.class);
        sExportRegister.put("scripts", ScriptExport.class);
        sExportRegister.put("reports", HQLExport.class);
        sImportRegister = new Hashtable();
        sImportRegister.put("academicAreas", AcademicAreaImport.class);
        sImportRegister.put("academicClassifications", AcademicClassificationImport.class);
        sImportRegister.put("buildingsRooms", BuildingRoomImport.class);
        sImportRegister.put("courseCatalog", CourseCatalogImport.class);
        sImportRegister.put("offerings", CourseOfferingImport.class);
        sImportRegister.put("courseOfferingReservations", CourseOfferingReservationImport.class);
        sImportRegister.put("departments", DepartmentImport.class);
        sImportRegister.put("posMajors", PosMajorImport.class);
        sImportRegister.put("posMinors", PosMinorImport.class);
        sImportRegister.put("session", SessionImport.class);
        sImportRegister.put("staff", StaffImport.class);
        sImportRegister.put("studentEnrollments", StudentEnrollmentImport.class);
        sImportRegister.put("students", StudentImport.class);
        sImportRegister.put("lastLikeCourseDemand", LastLikeCourseDemandImport.class);
        sImportRegister.put("subjectAreas", SubjectAreaImport.class);
        sImportRegister.put("request", StudentSectioningImport.class);
        sImportRegister.put("events", EventImport.class);
        sImportRegister.put("curricula", CurriculaImport.class);
        sImportRegister.put("studentGroups", StudentGroupImport.class);
        sImportRegister.put("studentAccomodations", StudentAccomodationImport.class);
        sImportRegister.put("reservations", ReservationImport.class);
        sImportRegister.put("permissions", PermissionsImport.class);
        sImportRegister.put("traveltimes", TravelTimesImport.class);
        sImportRegister.put("timetable", CourseTimetableImport.class);
        sImportRegister.put("roomSharing", RoomSharingImport.class);
        sImportRegister.put("scripts", ScriptImport.class);
        sImportRegister.put("script", ScriptImport.class);
        sImportRegister.put("reports", HQLImport.class);
        sImportRegister.put("report", HQLImport.class);
        sImportRegister.put("pointInTimeData", PointInTimeDataImport.class);
        sImportRegister.put("preferences", PreferencesImport.class);
        sImportRegister.put("sessionSetup", AcademicSessionSetupImport.class);
        sImportRegister.put("studentAdvisors", StudentAdvisorsImport.class);
        sImportRegister.put("studentStatuses", StudentSchedulingStatusImport.class);
        sImportRegister.put("examtt", SolverImport.class);
        sImportRegister.put("coursett", SolverImport.class);
        sImportRegister.put("sectioning", SolverImport.class);
        sImportRegister.put("instructor-schedule", SolverImport.class);
        sImportRegister.put("instructorSurveys", InstructorSurveyImport.class);
        sImportRegister.put("exams", ExamImport.class);
    }

    public static interface LogWriter {
        public void println(String var1);
    }
}

