/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpSession;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CommonSolverInterface;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;

@Action(value="manageSolvers", results={@Result(name={"showSolvers"}, type="tiles", location="manageSolvers.tiles")})
@TilesDefinition(name="manageSolvers.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Manage Solvers"), @TilesPutAttribute(name="body", value="/tt/manageSolvers.jsp")})
public class ManageSolversAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = 5315110666093536200L;
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private static Logger sLog = LogManager.getLogger(ManageSolversAction.class);
    private String owner;
    private String type;
    private String onlineId;
    private String host;
    private String solver;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOnlineId() {
        return this.onlineId;
    }

    public void setOnlineId(String onlineId) {
        this.onlineId = onlineId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSolver() {
        return this.solver;
    }

    public void setSolver(String solver) {
        this.solver = solver;
    }

    protected SolverService<? extends CommonSolverInterface> getSolverService(SolverParameterGroup.SolverType type) {
        switch (type) {
            case COURSE: {
                return this.getCourseTimetablingSolverService();
            }
            case EXAM: {
                return this.getExaminationSolverService();
            }
            case STUDENT: {
                return this.getStudentSectioningSolverService();
            }
            case INSTRUCTOR: {
                return this.getInstructorSchedulingSolverService();
            }
        }
        throw new IllegalArgumentException(MESSAGES.errorSolverInvalidType(type.name()));
    }

    public String execute() throws Exception {
        OnlineSectioningServer solver;
        SolverServer server;
        this.sessionContext.checkPermission(Right.ManageSolvers);
        if ("Select".equals(this.op) && this.owner != null && this.type != null) {
            switch (SolverParameterGroup.SolverType.valueOf(this.type)) {
                case COURSE: {
                    this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
                    this.response.sendRedirect("solver?type=course");
                    return null;
                }
                case EXAM: {
                    this.sessionContext.setAttribute(SessionAttribute.ExaminationUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
                    LookupTables.setupExamTypes(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
                    this.response.sendRedirect("solver?type=exam");
                    return null;
                }
                case STUDENT: {
                    this.sessionContext.setAttribute(SessionAttribute.StudentSectioningUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
                    this.response.sendRedirect("solver?type=student");
                    return null;
                }
                case INSTRUCTOR: {
                    this.sessionContext.setAttribute(SessionAttribute.InstructorSchedulingUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.InstructorSchedulingSolver);
                    this.response.sendRedirect("solver?type=instructor");
                    return null;
                }
            }
        }
        if ("Unload".equals(this.op) && this.owner != null && this.type != null) {
            switch (SolverParameterGroup.SolverType.valueOf(this.type)) {
                case COURSE: {
                    this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
                    this.getCourseTimetablingSolverService().removeSolver();
                    break;
                }
                case EXAM: {
                    this.sessionContext.setAttribute(SessionAttribute.ExaminationUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
                    this.getExaminationSolverService().removeSolver();
                    break;
                }
                case STUDENT: {
                    this.sessionContext.setAttribute(SessionAttribute.StudentSectioningUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
                    this.getStudentSectioningSolverService().removeSolver();
                    break;
                }
                case INSTRUCTOR: {
                    this.sessionContext.setAttribute(SessionAttribute.InstructorSchedulingUser, (Object)this.owner);
                    this.sessionContext.removeAttribute(SessionAttribute.InstructorSchedulingSolver);
                    this.getInstructorSchedulingSolverService().removeSolver();
                }
            }
        }
        if ("Unload".equals(this.op) && this.onlineId != null) {
            if (this.host != null) {
                server = this.getSolverServerService().getServer(this.host);
                if (server != null) {
                    server.getOnlineStudentSchedulingContainer().unloadSolver(this.onlineId);
                } else {
                    this.getSolverServerService().getOnlineStudentSchedulingContainer().unloadSolver(this.onlineId);
                }
            } else {
                this.getSolverServerService().getOnlineStudentSchedulingContainer().unloadSolver(this.onlineId);
            }
        }
        if ("Reload".equals(this.op) && this.onlineId != null && (solver = this.getSolverServerService().getOnlineStudentSchedulingContainer().getSolver(this.onlineId)) != null) {
            solver.reload();
        }
        if ("Deselect".equals(this.op)) {
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingUser);
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationUser);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningUser);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            this.sessionContext.removeAttribute(SessionAttribute.InstructorSchedulingUser);
            this.sessionContext.removeAttribute(SessionAttribute.InstructorSchedulingSolver);
        }
        if ("Shutdown".equals(this.op) && (server = this.getSolverServerService().getServer(this.solver)) != null) {
            server.shutdown();
        }
        if ("Reset".equals(this.op) && (server = this.getSolverServerService().getServer(this.solver)) != null) {
            server.reset(false);
        }
        if ("Reconnect".equals(this.op) && (server = this.getSolverServerService().getServer(this.solver)) != null) {
            server.reconnect();
        }
        if ("Hibernate".equals(this.op)) {
            server = this.getSolverServerService().getServer(this.solver);
            if (server != null) {
                server.reconnectHibernate();
            } else {
                HibernateUtil.reconnect(null);
            }
        }
        if ("Enable".equals(this.op) && (server = this.getSolverServerService().getServer(this.solver)) != null) {
            server.setUsageBase(0);
        }
        if ("Disable".equals(this.op) && (server = this.getSolverServerService().getServer(this.solver)) != null) {
            server.setUsageBase(1000);
        }
        return "showSolvers";
    }

    public static String getSolverOwner(DataProperties solverProperties) {
        String owner = solverProperties.getProperty("General.OwnerPuid", null);
        if (owner != null) {
            if (owner.startsWith("PUBLISHED_")) {
                return "Published";
            }
            TimetableManager mgr = TimetableManager.findByExternalId(owner);
            if (mgr != null) {
                owner = mgr.getShortName();
            }
        } else {
            owner = MESSAGES.itemNotApplicable();
        }
        Long[] solverGroupId = solverProperties.getPropertyLongArry("General.SolverGroupId", null);
        Object problem = null;
        if (solverGroupId != null) {
            problem = "";
            for (int i = 0; i < solverGroupId.length; ++i) {
                SolverGroup g = (SolverGroup)SolverGroupDAO.getInstance().get(solverGroupId[i]);
                if (g == null) continue;
                problem = (String)problem + (i == 0 ? "" : " & ") + g.getAbbv();
            }
        } else {
            ExamType type;
            Long examTypeId = solverProperties.getPropertyLong("Exam.Type", null);
            if (examTypeId != null && (type = (ExamType)ExamTypeDAO.getInstance().get(examTypeId)) != null) {
                problem = type.getLabel();
            }
        }
        if (problem == null || ((String)problem).isEmpty()) {
            problem = MESSAGES.itemNotApplicable();
        }
        if (MESSAGES.itemNotApplicable().equals(problem)) {
            return owner;
        }
        if (MESSAGES.itemNotApplicable().equals(owner)) {
            return problem;
        }
        if (!owner.equals(problem)) {
            return MESSAGES.solverOwner(owner, (String)problem);
        }
        return owner;
    }

    public static String getSolverSession(DataProperties solverProperties) {
        Session session;
        Long sessionId = solverProperties.getPropertyLong("General.SessionId", null);
        if (sessionId != null && (session = (Session)SessionDAO.getInstance().get(sessionId)) != null) {
            return session.getLabel();
        }
        return MESSAGES.itemNotApplicable();
    }

    public static String getSolverConfiguration(DataProperties solverProperties) {
        SolverPredefinedSetting setting;
        Long settingsId = solverProperties.getPropertyLong("General.SettingsId", null);
        if (settingsId != null && (setting = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(settingsId)) != null) {
            return setting.getDescription();
        }
        return solverProperties.getProperty("Basic.Mode", MESSAGES.itemNotApplicable());
    }

    public String getOnClick(DataProperties solverProperties, SolverParameterGroup.SolverType type) {
        Long sessionId = solverProperties.getPropertyLong("General.SessionId", null);
        String ownerId = solverProperties.getProperty("General.OwnerPuid");
        if (sessionId != null && sessionId.equals(this.sessionContext.getUser().getCurrentAcademicSessionId()) && ownerId != null) {
            return "onClick=\"document.location='manageSolvers.action?op=Select&type=" + type.name() + "&owner=" + ownerId + "';\"";
        }
        return null;
    }

    public static String getSolverStatus(CommonSolverInterface solver) {
        String status = MESSAGES.itemNotApplicable();
        try {
            status = (String)solver.getProgress().get("STATUS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public static String getSolverOperations(DataProperties solverProperties, SolverParameterGroup.SolverType type) {
        Object operations = "";
        String ownerId = solverProperties.getProperty("General.OwnerPuid");
        if (ownerId != null) {
            operations = (String)operations + "<input type=\"button\" value=\"" + MESSAGES.actionSolverUnload() + "\" onClick=\"if (confirm('" + MESSAGES.confirmUnloadSolver() + "')) document.location='manageSolvers.action?op=Unload&type=" + type.name() + "&owner=" + ownerId + "'; event.cancelBubble=true;\">";
        }
        return operations;
    }

    public static String getSolverMemory(DataProperties solverProperties, SolverParameterGroup.SolverType type) {
        String ownerId = solverProperties.getProperty("General.OwnerPuid");
        if (ownerId != null) {
            switch (type) {
                case COURSE: {
                    return "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>C" + ownerId + "</span>";
                }
                case STUDENT: {
                    return "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>S" + ownerId + "</span>";
                }
                case EXAM: {
                    return "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>X" + ownerId + "</span>";
                }
                case INSTRUCTOR: {
                    return "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>I" + ownerId + "</span>";
                }
            }
        }
        return MESSAGES.itemNotApplicable();
    }

    protected static String getTableName(SolverParameterGroup.SolverType type) {
        switch (type) {
            case COURSE: {
                return MESSAGES.sectManageSolversCourse();
            }
            case EXAM: {
                return MESSAGES.sectManageSolversExam();
            }
            case STUDENT: {
                return MESSAGES.sectManageSolversStudent();
            }
            case INSTRUCTOR: {
                return MESSAGES.sectManageSolversInstructor();
            }
        }
        return "Manage " + Constants.toInitialCase(type.name()) + " Solvers";
    }

    public SolverParameterGroup.SolverType[] getSolverTypes() {
        return SolverParameterGroup.SolverType.values();
    }

    public String getSolverTable(SolverParameterGroup.SolverType type) {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord[" + String.valueOf((Object)type) + "]", this.request.getParameter("ord" + type.ordinal()), 1);
            List<SolverProperties> props = SolverProperties.applicable(type);
            String[] names = new String[props.size()];
            String[] align = new String[props.size()];
            boolean[] ord = new boolean[props.size()];
            for (int i = 0; i < props.size(); ++i) {
                SolverProperties p = props.get(i);
                names[i] = p.getName();
                align[i] = p.getAlignment();
                ord[i] = p.getDefaultOrder();
            }
            WebTable webTable = new WebTable(props.size(), ManageSolversAction.getTableName(type), "manageSolvers.action?ord" + type.ordinal() + "=%%", names, align, ord);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            SolverService<? extends CommonSolverInterface> service = this.getSolverService(type);
            CommonSolverInterface selected = service.getSolverNoSessionCheck();
            String selectedId = selected == null ? null : selected.getUser();
            ArrayList<? extends CommonSolverInterface> solvers = new ArrayList<CommonSolverInterface>(service.getSolvers().values());
            for (CommonSolverInterface commonSolverInterface : solvers) {
                DataProperties properties;
                if (commonSolverInterface == null || (properties = commonSolverInterface.getProperties()) == null) continue;
                Map<String, String> info = commonSolverInterface.bestSolutionInfo();
                if (info == null) {
                    info = commonSolverInterface.currentSolutionInfo();
                }
                String bgColor = null;
                if (selectedId != null && selectedId.equals(commonSolverInterface.getUser())) {
                    bgColor = "rgb(168,187,225)";
                }
                String[] line = new String[props.size()];
                Comparable[] cmp = new Comparable[props.size()];
                for (int i = 0; i < props.size(); ++i) {
                    SolverProperty<?> p = props.get(i).getProperty();
                    Object o = p.getValue(commonSolverInterface, type, properties, info);
                    line[i] = p.getText(o);
                    cmp[i] = p.getComparable(o);
                }
                webTable.addLine(this.getOnClick(properties, type), line, cmp).setBgColor(bgColor);
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>" + MESSAGES.infoNoSolver() + "</i>"}, null, null);
            }
            return webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord[" + String.valueOf((Object)type) + "]"));
        }
        catch (Exception e) {
            sLog.error((Object)e);
            return e.getMessage();
        }
    }

    public boolean hasServers() {
        return true;
    }

    public String getServers() {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord[SERVERS]", this.request.getParameter("ords"), 1);
            boolean ops = this.sessionContext.hasPermission(Right.SessionIndependent);
            WebTable webTable = new WebTable(12, MESSAGES.sectAvailableServers(), "manageSolvers.action?ords=%%", new String[]{MESSAGES.colServerHost(), MESSAGES.colServerVersion(), MESSAGES.colServerStarted(), MESSAGES.colServerAvailableMemory(), MESSAGES.colServerNrCores(), MESSAGES.colServerPing(), MESSAGES.colServerUsage(), MESSAGES.colServerNrInstances(), MESSAGES.colServerActive(), MESSAGES.colServerWorking(), MESSAGES.colServerPassivated(), MESSAGES.colServerOperations()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            DecimalFormat df = new DecimalFormat("0.00");
            int nrLines = 0;
            for (SolverServer server : this.getSolverServerService().getServers(false)) {
                CommonSolverInterface solver;
                if (!server.isActive()) {
                    webTable.addLine(null, new String[]{server.getHost(), "<i>" + MESSAGES.serverInactive() + "</i>", "", "", "", "", "", "", "", "", "", ""}, new Comparable[]{server.getHost(), "", null, Long.valueOf(-1L), Integer.valueOf(-1), Long.valueOf(-1L), Long.valueOf(-1L), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1), null});
                    continue;
                }
                int nrActive = 0;
                int nrPassivated = 0;
                int nrWorking = 0;
                long mem = server.getAvailableMemory();
                long t0 = System.currentTimeMillis();
                long usage = server.getUsage();
                long t1 = System.currentTimeMillis();
                for (String user : server.getCourseSolverContainer().getSolvers()) {
                    solver = server.getCourseSolverContainer().getSolver(user);
                    if (solver == null) continue;
                    if (solver.isPassivated()) {
                        ++nrPassivated;
                        continue;
                    }
                    ++nrActive;
                    if (!solver.isWorking()) continue;
                    ++nrWorking;
                }
                for (String user : server.getExamSolverContainer().getSolvers()) {
                    solver = server.getExamSolverContainer().getSolver(user);
                    if (solver == null) continue;
                    if (solver.isPassivated()) {
                        ++nrPassivated;
                        continue;
                    }
                    ++nrActive;
                    if (!solver.isWorking()) continue;
                    ++nrWorking;
                }
                String version = server.getVersion();
                Date startTime = server.getStartTime();
                boolean local = server.isLocal();
                int cores = server.getAvailableProcessors();
                Object op = "";
                if (ops) {
                    op = usage >= 1000L ? (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerEnable() + "\" onClick=\"if (confirm('" + MESSAGES.configServerEnable(server.getHost()) + "')) document.location='manageSolvers.action?op=Enable&solver=" + server.getHost() + "';\">&nbsp;&nbsp;" : (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerDisable() + "\" onClick=\"if (confirm('" + MESSAGES.confirmServerDisable(server.getHost()) + "')) document.location='manageSolvers.action?op=Disable&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                    if (server.isCoordinator()) {
                        op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerReset() + "\" onClick=\"if (confirm('" + MESSAGES.confirmServerReset(server.getHost()) + "')) document.location='manageSolvers.action?op=Reset&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                    }
                    if (ApplicationProperty.SolverClusterEnabled.isTrue()) {
                        op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerReconnect() + "\" onClick=\"if (confirm('" + MESSAGES.confirmServerReconnect(server.getHost()) + "')) document.location='manageSolvers.action?op=Reconnect&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                    }
                    op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerReconnectHibernate() + "\" onClick=\"if (confirm('" + MESSAGES.confirmServerReconnectHibernate() + "')) document.location='manageSolvers.action?op=Hibernate&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                    if (!local) {
                        op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionServerShutdown() + "\" onClick=\"if (confirm('" + MESSAGES.confirmServerShutdown(server.getHost()) + "')) document.location='manageSolvers.action?op=Shutdown&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                    }
                }
                TreeSet<String> flags = new TreeSet<String>();
                if (local) {
                    flags.add(MESSAGES.serverFlagTomcat());
                }
                if (server.isCoordinator()) {
                    flags.add(MESSAGES.serverFlagCoordinator());
                }
                if (!server.isAvailable()) {
                    flags.add(MESSAGES.serverFlagUnavailable());
                }
                webTable.addLine(null, new String[]{server.getHost() + (String)(flags.isEmpty() ? "" : " " + ((Object)flags).toString()), version == null || "-1".equals(version) ? "<i>" + MESSAGES.itemNotApplicable() + "</i>" : version, startTime == null ? "<i>" + MESSAGES.itemNotApplicable() + "</i>" : sDF.format(startTime), df.format((double)mem / 1024.0 / 1024.0) + " MB", String.valueOf(cores), t1 - t0 + " ms", String.valueOf(usage), String.valueOf(nrActive + nrPassivated), String.valueOf(nrActive), String.valueOf(nrWorking), String.valueOf(nrPassivated), op}, new Comparable[]{server.getHost(), version, startTime, Long.valueOf(t1 - t0), Integer.valueOf(cores), Long.valueOf(mem), Long.valueOf(usage), Integer.valueOf(nrActive + nrPassivated), Integer.valueOf(nrActive), Integer.valueOf(nrWorking), Integer.valueOf(nrPassivated), null});
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>" + MESSAGES.infoNoServerRunning() + "</i>"}, null, null);
            }
            return webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord[SERVERS]"));
        }
        catch (Exception e) {
            sLog.error((Object)e);
            return e.getMessage();
        }
    }

    public String getOnlineSolvers() {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord[ONLINE]", this.request.getParameter("ordo"), 1);
            boolean mem = ApplicationProperty.ManageSolversComputeMemoryUses.isTrue();
            WebTable webTable = mem ? new WebTable(14, MESSAGES.sectManageSolversOnline(), "manageSolvers.action?ordo=%%", new String[]{MESSAGES.colCreated(), MESSAGES.colSession(), MESSAGES.colSolverHost(), MESSAGES.colSolverMode(), MESSAGES.colSolverMem(), MESSAGES.colSolverOverallValue(), MESSAGES.colSolverStudCourseReqs(), MESSAGES.colSolverStud1stChoice(), MESSAGES.colSolverStudCompleteStuds(), MESSAGES.colSolverStudDistanceConfs(), MESSAGES.colSolverStudTimeOverlaps(), MESSAGES.colSolverStudAvgDisbalance(), MESSAGES.colSolverStudDisbOver10(), MESSAGES.colSolverOperations()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null) : new WebTable(13, MESSAGES.sectManageSolversOnline(), "manageSolvers.action?ordo=%%", new String[]{MESSAGES.colCreated(), MESSAGES.colSession(), MESSAGES.colSolverHost(), MESSAGES.colSolverMode(), MESSAGES.colSolverOverallValue(), MESSAGES.colSolverStudCourseReqs(), MESSAGES.colSolverStud1stChoice(), MESSAGES.colSolverStudCompleteStuds(), MESSAGES.colSolverStudDistanceConfs(), MESSAGES.colSolverStudTimeOverlaps(), MESSAGES.colSolverStudAvgDisbalance(), MESSAGES.colSolverStudDisbOver10(), MESSAGES.colSolverOperations()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            List<SolverServer> servers = this.getSolverServerService().getServers(true);
            for (SolverServer server : servers) {
                for (String sessionId : server.getOnlineStudentSchedulingContainer().getSolvers()) {
                    DataProperties properties;
                    OnlineSectioningServer solver = server.getOnlineStudentSchedulingContainer().getSolver(sessionId);
                    if (solver == null || (properties = solver.getConfig()) == null) continue;
                    String sessionLabel = solver.getAcademicSession().toString();
                    String mode = solver.getAcademicSession().isSectioningEnabled() ? "Online" : "Assistant";
                    Map<String, String> info = solver.isReady() ? solver.execute(solver.createAction(GetInfo.class), null) : null;
                    String assigned = info == null ? null : info.get("Assigned variables");
                    String totVal = info == null ? null : info.get("Overall solution value");
                    String compSch = info == null ? null : info.get("Students with complete schedule");
                    String distConf = info == null ? null : info.get("Student distance conflicts");
                    String time = info == null ? null : info.get("Time overlapping conflicts");
                    String disb = info == null ? null : info.get("Average disbalance");
                    String disb10 = info == null ? null : info.get("Sections disbalanced by 10% or more");
                    String choice1 = info == null ? null : info.get("Assigned priority course requests");
                    Date loaded = new Date(solver.getConfig().getPropertyLong("General.StartUpDate", 0L));
                    Object op = "";
                    if (!this.sessionContext.getUser().getAuthorities(this.sessionContext.getUser().getCurrentAuthority().getRole(), new SimpleQualifier("Session", Long.valueOf(sessionId))).isEmpty()) {
                        if (solver.isReady()) {
                            op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionOnlineSolverReload() + "\" onClick=\"if (confirm('" + MESSAGES.confirmOnlineReload() + "')) document.location='manageSolvers.action?op=Reload&onlineId=" + sessionId + "'; event.cancelBubble=true;\">&nbsp;&nbsp;";
                        }
                        op = (String)op + "<input type=\"button\" value=\"" + MESSAGES.actionOnlineSolverShutdown() + "\" onClick=\"if (confirm('" + MESSAGES.confrimOnlineShutdown() + "')) document.location='manageSolvers.action?op=Unload&onlineId=" + sessionId + "&host=" + server.getHost() + "'; event.cancelBubble=true;\">";
                    }
                    if (mem) {
                        webTable.addLine(null, new String[]{loaded.getTime() <= 0L ? MESSAGES.itemNotApplicable() : sDF.format(loaded), sessionLabel, solver.getHost(), mode, "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>O" + server.getHost() + ":" + sessionId + "</span>", totVal == null ? "" : totVal, assigned == null ? "" : assigned, choice1 == null ? "" : choice1, compSch == null ? "" : compSch, distConf == null ? "" : distConf, time == null ? "" : time, disb == null ? "" : disb, disb10 == null ? "" : disb10, op}, new Comparable[]{loaded, sessionLabel, solver.getHost(), mode, null, totVal == null ? "" : totVal, assigned == null ? "" : assigned, choice1 == null ? "" : choice1, compSch == null ? "" : compSch, distConf == null ? "" : distConf, time == null ? "" : time, disb == null ? "" : disb, disb10 == null ? "" : disb10, null});
                    } else {
                        webTable.addLine(null, new String[]{loaded.getTime() <= 0L ? MESSAGES.itemNotApplicable() : sDF.format(loaded), sessionLabel, solver.getHost(), mode, totVal == null ? "" : totVal, assigned == null ? "" : assigned, choice1 == null ? "" : choice1, compSch == null ? "" : compSch, distConf == null ? "" : distConf, time == null ? "" : time, disb == null ? "" : disb, disb10 == null ? "" : disb10, op}, new Comparable[]{loaded, sessionLabel, solver.getHost(), mode, totVal == null ? "" : totVal, assigned == null ? "" : assigned, choice1 == null ? "" : choice1, compSch == null ? "" : compSch, distConf == null ? "" : distConf, time == null ? "" : time, disb == null ? "" : disb, disb10 == null ? "" : disb10, null});
                    }
                    ++nrLines;
                }
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>" + MESSAGES.infoNoOnlineSolverRunning() + "</i>"}, null, null);
            }
            return webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord[ONLINE]"));
        }
        catch (Exception e) {
            sLog.error((Object)e);
            return e.getMessage();
        }
    }

    public boolean canDeselect() {
        HttpSession session = this.request.getSession();
        return session.getAttribute("ManageSolver.puid") != null || session.getAttribute("ManageSolver.examPuid") != null || session.getAttribute("ManageSolver.sectionPuid") != null || session.getAttribute("ManageSolver.instrPuid") != null;
    }

    public String getDeselect() {
        return MESSAGES.actionSolverDeselect();
    }

    public static enum SolverProperties {
        CREATED(MESSAGES.colSolverCreated(), new DateSolverProperty(){

            @Override
            public Date getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return solver.getLoadedDate();
            }
        }),
        LAST_USED(MESSAGES.colSolverLastUsed(), new DateSolverProperty(){

            @Override
            public Date getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return solver.getLastUsed();
            }
        }),
        SESSION(MESSAGES.colSolverSession(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return ManageSolversAction.getSolverSession(properties);
            }
        }),
        HOST(MESSAGES.colSolverHost(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return solver.getHost();
            }
        }),
        CONFIG(MESSAGES.colSolverConfigShort(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return ManageSolversAction.getSolverConfiguration(properties);
            }
        }),
        STATUS(MESSAGES.colSolverStatus(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return ManageSolversAction.getSolverStatus(solver);
            }
        }),
        OWNER(MESSAGES.colSolverOwner(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                if (solver instanceof StudentSolverProxy && ((StudentSolverProxy)solver).isPublished()) {
                    return "Published";
                }
                return ManageSolversAction.getSolverOwner(properties);
            }
        }),
        MEMORY(MESSAGES.colSolverMem(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return ManageSolversAction.getSolverMemory(properties, type);
            }

            @Override
            public Comparable getComparable(String value) {
                return null;
            }

            @Override
            public boolean isVisible() {
                return ApplicationProperty.ManageSolversComputeMemoryUses.isTrue();
            }
        }),
        NR_CORES(MESSAGES.colSolverCores(), new IntegerSolverProperty(){

            @Override
            public Integer getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return Math.abs(properties.getPropertyInt("Parallel.NrSolvers", 4));
            }
        }),
        ASSIGNED_VAR(MESSAGES.colSolverAssignedVariables(), new InfoSolverProperty("Assigned variables", true)),
        TOTAL(MESSAGES.colSolverOverallValue(), new InfoSolverProperty("Overall solution value", true)),
        COURSE_TIME_PREF(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverTimePrefs(), new InfoSolverProperty("Time preferences", true)),
        COURSE_STUDENT_CONF(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverStudentConfs(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                String studConf;
                String string = studConf = info == null ? null : info.get("Student conflicts");
                if (studConf != null) {
                    return studConf.replaceAll(" \\[", "(").replaceAll("\\]", ")").replaceAll(", ", ",").replaceAll("hard:", "h").replaceAll("distance:", "d").replaceAll("commited:", "c").replaceAll("committed:", "c");
                }
                return null;
            }
        }),
        COURSE_ROOM_PREF(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverRoomPrefs(), new InfoSolverProperty("Room preferences", true)),
        COURSE_DIST_PREF(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverDistrPrefs(), new InfoSolverProperty("Distribution preferences", true)),
        COURSE_BTB_INSTR_PREF(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverBtbInstrPrefs(), new InfoSolverProperty("Back-to-back instructor preferences", true)),
        COURSE_PERTURBATIONS(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverPerturbations(), new InfoSolverProperty("Perturbations: Total penalty", false)),
        COURSE_NOTE(SolverParameterGroup.SolverType.COURSE, MESSAGES.colSolverNote(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return properties.getProperty("General.Note", "").replaceAll("\n", "<br>");
            }
        }),
        EXAM_STUD_CONF(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamStudentConfs(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                if (info == null) {
                    return null;
                }
                String dc = info.get("Direct Conflicts");
                String m2d = info.get("More Than 2 A Day Conflicts");
                String btb = info.get("Back-To-Back Conflicts");
                return (dc == null ? "0" : dc) + ", " + (m2d == null ? "0" : m2d) + ", " + (btb == null ? "0" : btb);
            }
        }),
        EXAM_INSTR_CONF(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamInstrConfs(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                if (info == null) {
                    return null;
                }
                String dc = info.get("Instructor Direct Conflicts");
                String m2d = info.get("Instructor More Than 2 A Day Conflicts");
                String btb = info.get("Instructor Back-To-Back Conflicts");
                return (dc == null ? "0" : dc) + ", " + (m2d == null ? "0" : m2d) + ", " + (btb == null ? "0" : btb);
            }
        }),
        EXAM_PERIOD_PREF(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamPeriodPref(), new InfoSolverProperty("Period Penalty", true)),
        EXAM_ROOM_PREF(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamRoomPref(), new InfoSolverProperty("Room Penalty", true)),
        EXAM_ROOM_SPLIT(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamRoomSplits(), new InfoSolverProperty("Room Split Penalty", true)),
        EXAM_ROOM_SIZE(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamRoomSize(), new InfoSolverProperty("Room Size Penalty", true)),
        EXAM_DIST_PREF(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamDistrPrefs(), new InfoSolverProperty("Distribution Penalty", true)),
        EXAM_ROTATION(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamRotation(), new InfoSolverProperty("Exam Rotation Penalty", true)),
        EXAM_PERTURBATIONS(SolverParameterGroup.SolverType.EXAM, MESSAGES.colSolverExamPerturbations(), new InfoSolverProperty("Perturbation Penalty", true)),
        STUDENT_ASSIGNED_CR(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudCourseReqs(), new InfoSolverProperty("Assigned course requests", true)),
        STUDENT_ASSIGNED_PRIORITY(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStud1stChoice(), new InfoSolverProperty("Assigned priority course requests", true)),
        STUDENT_COMPLETE(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudCompleteStuds(), new InfoSolverProperty("Students with complete schedule", true)),
        STUDENT_SELECTION(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudSelection(), new InfoSolverProperty("Selection", true)),
        STUDENT_DIST_CONF(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudDistanceConfs(), new InfoSolverProperty("Student distance conflicts", true)),
        STUDENT_TIME_OVERLAPS(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudTimeOverlaps(), new InfoSolverProperty("Time overlapping conflicts", true)),
        STUDENT_DISBALANCE_AVG(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudAvgDisbalance(), new InfoSolverProperty("Average disbalance", true)),
        STUDENT_DISBALANCE_10P(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudDisbOver10(), new InfoSolverProperty("Sections disbalanced by 10% or more", true)),
        STUDENT_PERTURBATIONS(SolverParameterGroup.SolverType.STUDENT, MESSAGES.colSolverStudPerturbations(), new InfoSolverProperty("Perturbations: Total penalty", true)),
        INSTRUCTOR_ATTR_PREF(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrAtributePrefs(), new InfoSolverProperty("Attribute Preferences", true)),
        INSTRUCTOR_COURSE_PREF(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrCoursePrefs(), new InfoSolverProperty("Course Preferences", true)),
        INSTRUCTOR_INSTR_PREF(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrInstructorPrefs(), new InfoSolverProperty("Instructor Preferences", true)),
        INSTRUCTOR_TEACH_PREF(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrTeachingPrefs(), new InfoSolverProperty("Teaching Preferences", true)),
        INSTRUCTOR_TIME_PREF(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrTimePrefs(), new InfoSolverProperty("Time Preferences", true)),
        INSTRUCTOR_SAME_INSTRUCTOR(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrSameInstructor(), new InfoSolverProperty("Same Instructor", true)),
        INSTRUCTOR_SAME_LECTURE(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrSameLecture(), new InfoSolverProperty("Same Lecture", true)),
        INSTRUCTOR_BTB(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrBTB(), new InfoSolverProperty("Back To Back", true)),
        INSTRUCTOR_SAME_DAYS(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrSameDays(), new InfoSolverProperty("Same Days", true)),
        INSTRUCTOR_SAME_ROOM(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrSameRoom(), new InfoSolverProperty("Same Room", true)),
        INSTRUCTOR_PERTURBATIONS(SolverParameterGroup.SolverType.INSTRUCTOR, MESSAGES.colSolverInstrOriginalInstructor(), new InfoSolverProperty("Original Instructor", true)),
        OPERATIONS(MESSAGES.colSolverOperations(), new StringSolverProperty(){

            @Override
            public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
                return ManageSolversAction.getSolverOperations(properties, type);
            }

            @Override
            public Comparable getComparable(String value) {
                return null;
            }
        });

        private String iName;
        private SolverProperty<?> iProperty;
        private SolverParameterGroup.SolverType iType;

        private SolverProperties(SolverParameterGroup.SolverType type, String name, SolverProperty<?> property) {
            this.iType = type;
            this.iName = name;
            this.iProperty = property;
        }

        private SolverProperties(String name, SolverProperty<?> property) {
            this(null, name, property);
        }

        public String getName() {
            return this.iName;
        }

        public String getAlignment() {
            return "left";
        }

        public boolean getDefaultOrder() {
            return true;
        }

        public SolverProperty<?> getProperty() {
            return this.iProperty;
        }

        public SolverParameterGroup.SolverType getType() {
            return this.iType;
        }

        public static List<SolverProperties> applicable(SolverParameterGroup.SolverType type) {
            ArrayList<SolverProperties> ret = new ArrayList<SolverProperties>();
            for (SolverProperties p : SolverProperties.values()) {
                if (p.getType() != null && p.getType() != type || !p.isVisible()) continue;
                ret.add(p);
            }
            return ret;
        }

        public boolean isVisible() {
            return this.iProperty.isVisible();
        }
    }

    public static interface SolverProperty<T> {
        public T getValue(CommonSolverInterface var1, SolverParameterGroup.SolverType var2, DataProperties var3, Map<String, String> var4);

        public String getText(T var1);

        public Comparable getComparable(T var1);

        public boolean isVisible();
    }

    public static class InfoSolverProperty
    extends StringSolverProperty {
        private String iName;
        private boolean iStrip;

        public InfoSolverProperty(String name, boolean strip) {
            this.iName = name;
            this.iStrip = strip;
        }

        @Override
        public String getValue(CommonSolverInterface solver, SolverParameterGroup.SolverType type, DataProperties properties, Map<String, String> info) {
            if (info == null) {
                return null;
            }
            String ret = info.get(this.iName);
            if (ret != null && this.iStrip && ret.indexOf(32) > 0) {
                ret = ret.substring(0, ret.indexOf(32));
            }
            return ret;
        }
    }

    public static abstract class IntegerSolverProperty
    implements SolverProperty<Integer> {
        @Override
        public String getText(Integer value) {
            return value == null ? "" : String.valueOf(value);
        }

        @Override
        public Comparable getComparable(Integer value) {
            return Integer.valueOf(value == null ? 0 : value);
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    public static abstract class StringSolverProperty
    implements SolverProperty<String> {
        @Override
        public String getText(String value) {
            return value == null ? "" : value;
        }

        @Override
        public Comparable getComparable(String value) {
            return value == null ? "" : value;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    public static abstract class DateSolverProperty
    implements SolverProperty<Date> {
        @Override
        public String getText(Date value) {
            return value == null ? "" : sDF.format(value);
        }

        @Override
        public Comparable getComparable(Date value) {
            return value == null ? new Date() : value;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }
}

