/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=ExamsInterface.ExamsRequest.class)
public class ExamsBackend
implements GwtRpcImplementation<ExamsInterface.ExamsRequest, OfferingsInterface.OfferingsResponse> {
    protected static ExaminationMessages MESSAGES = Localization.create(ExaminationMessages.class);
    protected static GwtMessages GWT = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public OfferingsInterface.OfferingsResponse execute(ExamsInterface.ExamsRequest request, SessionContext context) {
        context.checkPermission(Right.Examinations);
        String examType = request.getFilter().getParameterValue("examType");
        ExamType type = null;
        try {
            type = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(examType));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = ExamType.findByReference(examType);
        }
        if (type == null) {
            throw new GwtRpcException(MESSAGES.messageNoExamType());
        }
        String subjectArea = request.getFilter().getParameterValue("subjectArea");
        if (subjectArea == null || subjectArea.isEmpty()) {
            throw new GwtRpcException(MESSAGES.messageNoSubject());
        }
        OfferingsInterface.OfferingsResponse response = new OfferingsInterface.OfferingsResponse();
        ExaminationsTableBuilder builder = new ExaminationsTableBuilder(context, request.getBackType(), request.getBackId());
        for (FilterInterface.FilterParameterInterface p : request.getFilter().getParameters()) {
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if ("courseNbr".equals(p.getName())) {
                context.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if ("examType".equals(p.getName())) {
                context.setAttribute(SessionAttribute.ExamType, (Object)Long.valueOf(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if (p.getValue() == null) continue;
            context.getUser().setProperty("ExamList." + p.getName(), p.getValue());
        }
        String courseNbr = request.getFilter().getParameterValue("courseNbr");
        try {
            Object subjects = "";
            int count = 0;
            for (String id : subjectArea.split(",")) {
                if ("-1".equals(id)) {
                    subjects = GWT.itemAll();
                    break;
                }
                SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(id));
                if (sa == null) continue;
                context.checkPermission(sa.getDepartment(), Right.Classes);
                if (++count == 1) {
                    subjects = (String)subjects + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count <= 3) {
                    subjects = (String)subjects + ", " + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count != 4) continue;
                subjects = (String)subjects + "\u2026";
            }
            BackTracker.markForBack(context, "examinations?examType=" + type.getUniqueId() + "&subjectArea=" + request.getFilter().getParameterValue("subjectArea") + "&courseNbr=" + (courseNbr == null ? "" : URLEncoder.encode(courseNbr, "utf-8")), MESSAGES.backExams(type.getLabel(), (String)subjects + (String)(courseNbr == null || courseNbr.isEmpty() ? "" : " " + courseNbr)), true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.add(builder.generateTableForExams(type, this.examinationSolverService.getSolver(), request.getFilter(), subjectArea.split(",")));
        return response;
    }
}

