/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseReservation;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="reservation")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="reservation_type", discriminatorType=DiscriminatorType.INTEGER)
public abstract class Reservation
extends BaseReservation
implements Comparable<Reservation> {
    private static final long serialVersionUID = 1L;

    public Reservation() {
    }

    public Reservation(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public boolean isExpired() {
        if (this.getStartDate() == null && this.getExpirationDate() == null) {
            return false;
        }
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return this.getStartDate() != null && c.getTime().before(this.getStartDate()) || this.getExpirationDate() != null && this.getExpirationDate().before(c.getTime());
    }

    public abstract boolean isApplicable(Student var1, CourseRequest var2);

    @Transient
    public int getReservationLimit() {
        Integer cap = this.getLimitCap();
        if (cap != null) {
            return Reservation.min(cap, this.getLimit() == null ? -1 : this.getLimit());
        }
        return this.getLimit() == null ? -1 : this.getLimit();
    }

    private boolean hasClass(Class_ clazz) {
        for (Class_ other : this.getClasses()) {
            if (!clazz.equals(other) && !other.isParentOf(clazz) && !clazz.isParentOf(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching(List<StudentClassEnrollment> enrollment) {
        if (enrollment.isEmpty()) {
            return false;
        }
        if (this.isReservationInclusive()) {
            if (!this.getConfigurations().isEmpty()) {
                for (StudentClassEnrollment e : enrollment) {
                    if (this.getConfigurations().contains(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig())) continue;
                    return false;
                }
            }
            if (!this.getClasses().isEmpty()) {
                for (StudentClassEnrollment e : enrollment) {
                    if (this.hasClass(e.getClazz())) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.getConfigurations().isEmpty() && this.getClasses().isEmpty()) {
            return true;
        }
        for (StudentClassEnrollment e : enrollment) {
            if (this.getConfigurations().contains(e.getClazz().getSchedulingSubpart().getInstrOfferingConfig())) {
                return true;
            }
            if (!this.getClasses().contains(e.getClazz())) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching(Class_ clazz) {
        if (!this.getConfigurations().isEmpty() && !this.getConfigurations().contains(clazz.getSchedulingSubpart().getInstrOfferingConfig())) {
            return false;
        }
        return this.getClasses().isEmpty() || this.hasClass(clazz);
    }

    @Transient
    public abstract int getPriority();

    @Transient
    public abstract boolean isCanAssignOverLimit();

    @Transient
    public abstract boolean isMustBeUsed();

    @Transient
    public abstract boolean isAllowOverlap();

    @Transient
    public boolean isAlwaysExpired() {
        return false;
    }

    @Override
    public int compareTo(Reservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        return this.getUniqueId().compareTo(r.getUniqueId());
    }

    @Transient
    public double getRestrictivity() {
        if (this.getConfigurations().isEmpty()) {
            return 1.0;
        }
        double restrictivity = (double)this.getConfigurations().size() / (double)this.getInstructionalOffering().getInstrOfferingConfigs().size();
        if (this.getClasses().isEmpty()) {
            return restrictivity;
        }
        HashMap<SchedulingSubpart, Integer> counts = new HashMap<SchedulingSubpart, Integer>();
        for (Class_ class_ : this.getClasses()) {
            Integer old = (Integer)counts.get(class_.getSchedulingSubpart());
            counts.put(class_.getSchedulingSubpart(), 1 + (old == null ? 0 : old));
        }
        for (Map.Entry entry : counts.entrySet()) {
            restrictivity *= (double)((Integer)entry.getValue()).intValue() / (double)((SchedulingSubpart)entry.getKey()).getClasses().size();
        }
        return restrictivity;
    }

    @Transient
    protected Map<Long, Set<Long>> getSections() {
        HashMap<Long, Set<Long>> ret = new HashMap<Long, Set<Long>>();
        Iterator<Class_> iterator = this.getClasses().iterator();
        while (iterator.hasNext()) {
            for (Class_ clazz = iterator.next(); clazz != null; clazz = clazz.getParentClass()) {
                HashSet<Long> sections = (HashSet<Long>)ret.get(clazz.getSchedulingSubpart().getUniqueId());
                if (sections == null) {
                    sections = new HashSet<Long>();
                    ret.put(clazz.getSchedulingSubpart().getUniqueId(), sections);
                }
                sections.add(clazz.getUniqueId());
            }
        }
        return ret;
    }

    @Transient
    public int getReservedAvailableSpace() {
        if (this.getReservationLimit() < 0) {
            return Integer.MAX_VALUE;
        }
        return this.getReservationLimit() - this.countEnrollmentsForReservation();
    }

    private int countEnrollmentsForReservation() {
        HashSet<Long> checked = new HashSet<Long>();
        HashSet<Long> students = new HashSet<Long>();
        for (InstrOfferingConfig config : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    for (StudentClassEnrollment e : clazz.getStudentEnrollments()) {
                        if (e.getCourseRequest() == null || !checked.add(e.getCourseRequest().getUniqueId()) || !this.isApplicable(e.getStudent(), e.getCourseRequest()) || !this.isMatching(e.getCourseRequest().getClassEnrollments())) continue;
                        students.add(e.getStudent().getUniqueId());
                    }
                }
            }
        }
        return students.size();
    }

    @Transient
    protected Set<InstrOfferingConfig> getAllConfigurations() {
        HashSet<InstrOfferingConfig> configs = new HashSet<InstrOfferingConfig>();
        if (this.getConfigurations() != null) {
            configs.addAll(this.getConfigurations());
        }
        if (this.getClasses() != null) {
            for (Class_ clazz : this.getClasses()) {
                configs.add(clazz.getSchedulingSubpart().getInstrOfferingConfig());
            }
        }
        return configs;
    }

    @Transient
    protected Map<SchedulingSubpart, Set<Class_>> getAllSections() {
        HashMap<SchedulingSubpart, Set<Class_>> ret = new HashMap<SchedulingSubpart, Set<Class_>>();
        Iterator<Class_> iterator = this.getClasses().iterator();
        while (iterator.hasNext()) {
            for (Class_ clazz = iterator.next(); clazz != null; clazz = clazz.getParentClass()) {
                HashSet<Class_> sections = (HashSet<Class_>)ret.get(clazz.getSchedulingSubpart());
                if (sections == null) {
                    sections = new HashSet<Class_>();
                    ret.put(clazz.getSchedulingSubpart(), sections);
                }
                sections.add(clazz);
            }
        }
        return ret;
    }

    @Transient
    public Integer getLimitCap() {
        Set<InstrOfferingConfig> configs = this.getAllConfigurations();
        if (configs.isEmpty()) {
            return null;
        }
        int cap = 0;
        for (InstrOfferingConfig instrOfferingConfig : configs) {
            cap = Reservation.add(cap, instrOfferingConfig.isUnlimitedEnrollment() != false ? -1 : instrOfferingConfig.getLimit());
        }
        for (Set set : this.getAllSections().values()) {
            int subpartCap = 0;
            for (Class_ section : set) {
                subpartCap = Reservation.add(subpartCap, section.getClassLimit());
            }
            cap = Reservation.min(cap, subpartCap);
        }
        return cap < 0 ? null : Integer.valueOf(cap);
    }

    private static int min(int l1, int l2) {
        return l1 < 0 ? l2 : (l2 < 0 ? l1 : Math.min(l1, l2));
    }

    private static int add(int l1, int l2) {
        return l1 < 0 ? -1 : (l2 < 0 ? -1 : l1 + l2);
    }

    @Transient
    public boolean isReservationInclusive() {
        return this.isInclusive() == null ? ApplicationProperty.ReservationsAreInclusive.isTrue() : this.isInclusive().booleanValue();
    }
}

