/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.query.Query;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.dao.PosMajorDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="pos_major")
public class PosMajor
extends BasePosMajor {
    private static final long serialVersionUID = 1L;
    public static String POSMAJOR_ATTR_NAME = "posMajorList";

    public PosMajor() {
    }

    public PosMajor(Long uniqueId) {
        super(uniqueId);
    }

    public static List<PosMajor> getPosMajorList(Long sessionId) {
        Session hibSession = PosMajorDAO.getInstance().getSession();
        String query = "from PosMajor where academicArea.session.uniqueId=:acadSessionId order by name";
        Query q = hibSession.createQuery(query, PosMajor.class);
        q.setParameter("acadSessionId", (Object)sessionId);
        return q.list();
    }

    @Transient
    public String getLabelNameCode() {
        return this.getName() + " - " + this.getCode();
    }

    @Transient
    public String getLabelCodeName() {
        return this.getCode() + " - " + this.getName();
    }

    public static PosMajor findByCode(Long sessionId, String code) {
        return (PosMajor)PosMajorDAO.getInstance().getSession().createQuery("select a from PosMajor a where a.session.uniqueId=:sessionId and a.code=:code", PosMajor.class).setParameter("sessionId", (Object)sessionId).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByExternalIdAcadAreaExternalId(Long sessionId, String externalId, String academicArea) {
        return PosMajor.findByExternalIdAcadAreaExternalId(PosMajorDAO.getInstance().getSession(), sessionId, externalId, academicArea);
    }

    public static PosMajor findByExternalIdAcadAreaExternalId(Session hibSession, Long sessionId, String externalId, String academicArea) {
        return (PosMajor)hibSession.createQuery("select a from PosMajor a inner join a.academicAreas as areas where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalUniqueId and areas.externalUniqueId = :academicArea", PosMajor.class).setParameter("sessionId", (Object)sessionId).setParameter("externalUniqueId", (Object)externalId).setParameter("academicArea", (Object)academicArea).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByCodeAcadAreaId(Long sessionId, String code, Long areaId) {
        if (areaId == null) {
            return PosMajor.findByCode(sessionId, code);
        }
        return (PosMajor)PosMajorDAO.getInstance().getSession().createQuery("select p from PosMajor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.uniqueId=:areaId and p.code=:code", PosMajor.class).setParameter("sessionId", (Object)sessionId).setParameter("areaId", (Object)areaId).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByCodeAcadAreaAbbv(Long sessionId, String code, String areaAbbv) {
        return PosMajor.findByCodeAcadAreaAbbv(PosMajorDAO.getInstance().getSession(), sessionId, code, areaAbbv);
    }

    public static PosMajor findByCodeAcadAreaAbbv(Session hibSession, Long sessionId, String code, String areaAbbv) {
        if (areaAbbv == null || areaAbbv.trim().length() == 0) {
            return PosMajor.findByCode(sessionId, code);
        }
        return (PosMajor)hibSession.createQuery("select p from PosMajor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.academicAreaAbbreviation=:areaAbbv and p.code=:code", PosMajor.class).setParameter("sessionId", (Object)sessionId).setParameter("areaAbbv", (Object)areaAbbv).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        PosMajor m = new PosMajor();
        m.setExternalUniqueId(this.getExternalUniqueId());
        m.setCode(this.getCode());
        m.setName(this.getName());
        return m;
    }

    public boolean isUsed(Session hibSession) {
        return ((Number)(hibSession == null ? PosMajorDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from Curriculum c inner join c.majors m where m.uniqueId = :majorId", Number.class).setParameter("majorId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue() > 0;
    }
}

