/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.unitime.localization.impl.ExportTranslations;
import org.unitime.localization.impl.POHelper;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.util.Constants;

public class DeepLTranslator {
    private List<ExportTranslations.Locale> iLocales = new ArrayList<ExportTranslations.Locale>();
    private Project iProject;
    private File iBaseDir;
    private String iTranslations = "Documentation/Translations";
    private String iToken = null;

    public void setProject(Project project) {
        this.iProject = project;
        this.iBaseDir = project.getBaseDir();
    }

    public void setBaseDir(String baseDir) {
        this.iBaseDir = new File(baseDir);
    }

    public ExportTranslations.Locale createLocale() {
        ExportTranslations.Locale locale = new ExportTranslations.Locale();
        this.iLocales.add(locale);
        return locale;
    }

    public void addLocale(ExportTranslations.Locale locale) {
        this.iLocales.add(locale);
    }

    public void setLocales(String locales) {
        for (String value : locales.split(",")) {
            this.addLocale(new ExportTranslations.Locale(value));
        }
    }

    public void setToken(String token) {
        this.iToken = token;
    }

    public void info(String message) {
        if (this.iProject != null) {
            this.iProject.log(message);
        } else {
            System.out.println("     [info] " + message);
        }
    }

    public void warn(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 1);
        } else {
            System.out.println("  [warning] " + message);
        }
    }

    public void debug(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 4);
        } else {
            System.out.println("    [debug] " + message);
        }
    }

    public void error(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 0);
        } else {
            System.out.println("    [error] " + message);
        }
    }

    public void execute() throws BuildException {
        try {
            File translations = new File(this.iBaseDir, this.iTranslations);
            for (ExportTranslations.Locale locale : this.iLocales) {
                this.info("locale:     " + String.valueOf(locale));
                POHelper helper = new POHelper(locale.getValue(), null);
                helper.readPOFile(null, new InputStreamReader((InputStream)new FileInputStream(new File(translations, "UniTime" + Constants.VERSION + "_" + locale.getValue() + ".po")), StandardCharsets.UTF_8));
                CloseableHttpClient client = HttpClients.createDefault();
                for (POHelper.Bundle bundle : POHelper.Bundle.values()) {
                    this.info("bundle:     " + bundle.name());
                    for (POHelper.Block block : helper.getBlocks(bundle)) {
                        if (block.getTranslation() != null || block.getDefaultText().isEmpty()) continue;
                        String source = block.getDefaultText();
                        String access = UniTimeAction.guessAccessKey(source);
                        if (access != null) {
                            source = UniTimeAction.stripAccessKey(source);
                        }
                        if (source.length() <= 1) {
                            block.setTranslation(block.getDefaultText());
                            block.fuzzy = true;
                            continue;
                        }
                        this.info("original:   " + source);
                        HttpPost post = new HttpPost("https://api-free.deepl.com/v2/translate");
                        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
                        params.add(new BasicNameValuePair("text", source));
                        params.add(new BasicNameValuePair("source_lang", "EN"));
                        params.add(new BasicNameValuePair("target_lang", locale.getValue().toUpperCase()));
                        params.add(new BasicNameValuePair("formality", "prefer_more"));
                        params.add(new BasicNameValuePair("tag_handling", "html"));
                        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                        post.addHeader("Authorization", "DeepL-Auth-Key " + this.iToken);
                        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                        HttpEntity entity = response.getEntity();
                        String translated = null;
                        if (entity != null) {
                            try {
                                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(entity.getContent())).getAsJsonObject();
                                this.debug("response:   " + String.valueOf(json));
                                translated = json.get("translations").getAsJsonArray().get(0).getAsJsonObject().get("text").getAsString();
                            }
                            catch (IllegalStateException e) {
                                this.error(response.toString());
                                throw e;
                            }
                            if (translated != null) {
                                this.info("translated: " + translated);
                                block.setTranslation(translated);
                                block.fuzzy = true;
                            }
                        }
                        response.close();
                    }
                }
                client.close();
                helper.writePOFile(new File(translations, "UniTime" + Constants.VERSION + "_" + String.valueOf(locale) + ".po"));
            }
        }
        catch (Exception e) {
            throw new BuildException("Translation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            DeepLTranslator task = new DeepLTranslator();
            task.setBaseDir(System.getProperty("source", "/Users/muller/git/unitime"));
            task.setLocales(System.getProperty("locale", "cs"));
            task.setToken(System.getProperty("token", "FIXME"));
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

