/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ObjectNotFoundException;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.interfaces.RoomUrlProvider;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.base.BaseRoom;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;
import org.unitime.timetable.server.rooms.RoomSharingBackend;

@GwtRpcImplements(value=RoomInterface.RoomFilterRpcRequest.class)
public class RoomDetailsBackend
extends RoomFilterBackend {
    private static Log sLog = LogFactory.getLog(RoomDetailsBackend.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    public static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public EventInterface.FilterRpcResponse execute(EventInterface.RoomFilterRpcRequest request, EventAction.EventContext context) {
        return super.execute(request, context);
    }

    @Override
    protected void checkPermission(EventInterface.RoomFilterRpcRequest request, SessionContext context) {
        context.checkPermissionAnyAuthority(Right.Rooms, new SimpleQualifier("Session", request.getSessionId()));
    }

    @Override
    protected boolean checkEventStatus() {
        return false;
    }

    @Override
    protected boolean showRoomFeature(RoomFeatureType type) {
        return true;
    }

    @Override
    public RoomFilterBackend.RoomQuery getQuery(Long sessionId, Map<String, Set<String>> options, EventAction.EventContext context) {
        boolean fetch;
        RoomFilterBackend.RoomQuery query = super.getQuery(sessionId, options, context);
        Set<String> flags = options == null ? null : options.get("flag");
        boolean bl = fetch = flags != null && flags.contains("fetch");
        if (fetch && ApplicationProperty.RoomEditPrefetchRelations.isTrue()) {
            query.addFrom("fetch", "left join fetch l.roomDepts Frd  left join fetch l.examTypes Fxt left join fetch l.features Ff left join fetch l.roomGroups Fg left join fetch l.roomType Ft");
        }
        return query;
    }

    @Override
    public void enumarate(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(request);
        request.addOption("flag", "fetch");
        String department = request.getOption("department");
        boolean filterDepartments = !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        List<ExamType> types = ExamType.findAllApplicable(context.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        boolean html = true;
        if (request.hasOptions("flag") && request.getOptions("flag").contains("plain")) {
            html = false;
        }
        UserAuthority authority = context.getUser() == null ? null : context.getUser().getCurrentAuthority();
        boolean courses = context.hasPermission(Right.InstructionalOfferings) || context.hasPermission(Right.Classes) || authority != null && (authority.hasRight(Right.RoomEditChangeRoomProperties) || authority.hasRight(Right.RoomEditChangeControll) || authority.hasRight(Right.RoomDetailAvailability) || authority.hasRight(Right.RoomEditAvailability));
        boolean exams = context.hasPermission(Right.Examinations) || authority != null && (authority.hasRight(Right.RoomEditChangeExaminationStatus) || authority.hasRight(Right.RoomDetailPeriodPreferences));
        boolean events = context.hasPermission(Right.Events) || authority != null && (authority.hasRight(Right.RoomEditChangeEventProperties) || authority.hasRight(Right.RoomDetailEventAvailability) || authority.hasRight(Right.RoomEditEventAvailability));
        boolean editPermissions = request.hasOption("id");
        HashMap<Long, Double> distances = new HashMap<Long, Double>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), new Query(request.getText()), -1, distances, null, context)) {
            Double dist = (Double)distances.get(location.getUniqueId());
            RoomInterface.RoomDetailInterface e = this.load(location, department, html, context, filterDepartments, types, courses, exams, events, editPermissions);
            if (editPermissions) {
                RoomSharingBackend rsb = new RoomSharingBackend();
                if (e.isCanSeeEventAvailability()) {
                    e.setEventAvailabilityModel(rsb.loadEventAvailability(location, (SessionContext)context));
                }
                if (e.isCanSeeAvailability()) {
                    e.setRoomSharingModel(rsb.loadRoomSharing(location, true, context));
                }
                if (e.isCanSeePeriodPreferences()) {
                    PeriodPreferencesBackend ppb = new PeriodPreferencesBackend();
                    for (ExamType type : types) {
                        e.setPeriodPreferenceModel(ppb.loadPeriodPreferences(location, type, context));
                    }
                }
            }
            e.setProperty("permId", location.getPermanentId().toString());
            if (dist != null) {
                e.setProperty("distance", String.valueOf(dist == null ? 0L : Math.round(dist)));
            }
            e.setProperty("overbook", context.hasPermission(location, Right.EventLocationOverbook) ? "1" : "0");
            response.addResult(e);
        }
    }

    protected static RoomInterface.DepartmentInterface wrap(Department d, Location location, PreferenceLevel pref) {
        if (d == null) {
            return null;
        }
        RoomInterface.DepartmentInterface department = new RoomInterface.DepartmentInterface();
        department.setId(d.getUniqueId());
        department.setDeptCode(d.getDeptCode());
        department.setAbbreviation(d.getAbbreviation());
        department.setLabel(d.getName());
        department.setExternal(d.isExternalManager());
        department.setEvent(d.isAllowEvents());
        department.setExtAbbreviation(d.getExternalMgrAbbv());
        department.setExtLabel(d.getExternalMgrLabel());
        department.setTitle(d.getLabel());
        if (pref != null && !PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) {
            department.setPreference(new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2color(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), false));
        }
        if (location != null) {
            department.setColor("#" + d.getRoomSharingColor(null));
        }
        return department;
    }

    protected RoomInterface.RoomDetailInterface load(Location location, String department, boolean html, SessionContext context, boolean filterDepartments, List<ExamType> types, boolean courses, boolean exams, boolean events, boolean editPermissions) {
        RoomUrlProvider url;
        ChangeLog lch;
        String string;
        String minimap;
        RoomInterface.RoomDetailInterface response = new RoomInterface.RoomDetailInterface(location.getUniqueId(), location.getDisplayName(), location.getLabel(), new String[0]);
        response.setCanShowDetail(context.hasPermission(location, Right.RoomDetail));
        response.setCanSeeAvailability(context.hasPermission(location, Right.RoomDetailAvailability));
        response.setCanSeeEventAvailability(context.hasPermission(location, Right.RoomDetailEventAvailability));
        response.setCanSeePeriodPreferences(context.hasPermission(location, Right.RoomDetailPeriodPreferences));
        if (location instanceof Room) {
            response.setCanChange(context.hasPermission(location, Right.RoomEdit));
        } else {
            response.setCanChange(context.hasPermission(location, Right.NonUniversityLocationEdit));
        }
        response.setCanChangeFeatures(context.hasPermission(location, Right.RoomEditFeatures) || context.hasPermission(location, Right.RoomEditGlobalFeatures));
        response.setCanChangeGroups(context.hasPermission(location, Right.RoomEditGroups) || context.hasPermission(location, Right.RoomEditGlobalGroups));
        response.setCanChangeEventAvailability(context.hasPermission(location, Right.RoomEditEventAvailability));
        response.setCanChangeAvailability(context.hasPermission(location, Right.RoomEditAvailability));
        response.setCanChangePicture(context.hasPermission(location, Right.RoomEditChangePicture));
        response.setCanChangePreferences(context.hasPermission(location, Right.RoomEditPreference));
        if (editPermissions) {
            response.setCanChangeEventProperties(context.hasPermission(location, Right.RoomEditChangeEventProperties));
            if (response.isCanChange()) {
                response.setCanChangeCapacity(context.hasPermission(location, Right.RoomEditChangeCapacity));
                response.setCanChangeControll(context.hasPermission(location, Right.RoomEditChangeControll));
                response.setCanChangeExamStatus(context.hasPermission(location, Right.RoomEditChangeExaminationStatus));
                response.setCanChangeExternalId(context.hasPermission(location, Right.RoomEditChangeExternalId));
                response.setCanChangeRoomProperties(context.hasPermission(location, Right.RoomEditChangeRoomProperties));
                response.setCanChangeType(context.hasPermission(location, Right.RoomEditChangeType));
            } else if (response.isCanChangeAvailability()) {
                response.setCanChangeControll(context.hasPermission(location, Right.RoomEditChangeControll));
            }
            if (location instanceof Room) {
                response.setCanDelete(context.hasPermission(location, Right.RoomDelete));
            } else {
                response.setCanDelete(context.hasPermission(location, Right.NonUniversityLocationDelete));
            }
            for (Location location2 : location.getFutureLocations()) {
                RoomInterface.FutureRoomInterface f = new RoomInterface.FutureRoomInterface(location2.getUniqueId(), location2.getLabel());
                f.setSession(new RoomInterface.AcademicSessionInterface(location2.getSession().getUniqueId(), location2.getSession().getAcademicTerm() + " " + location2.getSession().getAcademicYear()));
                f.setDisplayName(location2.getDisplayName());
                f.setExternalId(location2.getExternalUniqueId());
                f.setCapacity(location2.getCapacity());
                f.setType(location2.getRoomTypeLabel());
                EventAction.EventContext cx = new EventAction.EventContext(context, context.getUser(), location2.getSession().getUniqueId());
                if (location2 instanceof Room) {
                    f.setCanDelete(cx.hasPermission(location2, Right.RoomDelete));
                    f.setCanChange(cx.hasPermission(location2, Right.RoomEdit));
                } else {
                    f.setCanDelete(cx.hasPermission(location2, Right.NonUniversityLocationDelete));
                    f.setCanChange(cx.hasPermission(location2, Right.NonUniversityLocationEdit));
                }
                if (!f.isCanChange() && !f.isCanDelete()) continue;
                response.addFutureRoom(f);
            }
        }
        if (location instanceof Room) {
            Iterator<Comparable> room = (Room)location;
            Building building = ((BaseRoom)((Object)room)).getBuilding();
            RoomInterface.BuildingInterface building2 = new RoomInterface.BuildingInterface(building.getUniqueId(), building.getAbbreviation(), building.getName());
            building2.setX(building.getCoordinateX());
            building2.setY(building.getCoordinateY());
            building2.setExternalId(building.getExternalUniqueId());
            response.setBuilding(building2);
            response.setName(((BaseRoom)((Object)room)).getRoomNumber());
            try {
                if (((BaseRoom)((Object)room)).getParentRoom() != null) {
                    response.setParent(new RoomInterface.RoomDetailInterface(((BaseRoom)((Object)room)).getParentRoom().getUniqueId(), ((BaseRoom)((Object)room)).getParentRoom().getDisplayName(), ((BaseRoom)((Object)room)).getParentRoom().getLabel(), new String[0]));
                }
            }
            catch (ObjectNotFoundException cx) {
                // empty catch block
            }
        }
        response.setSessionId(location.getSession().getUniqueId());
        response.setSessionName(location.getSession().getLabel());
        response.setExternalId(location.getExternalUniqueId());
        response.setRoomType(new RoomInterface.RoomTypeInterface(location.getRoomType().getUniqueId(), location.getRoomType().getReference(), location.getRoomType().getLabel(), location.getRoomType().isRoom(), location.getRoomType().getOrd()));
        response.setX(location.getCoordinateX());
        response.setY(location.getCoordinateY());
        response.setArea(location.getArea());
        response.setCapacity(location.getCapacity());
        response.setExamCapacity(location.getExamCapacity());
        for (RoomFeature roomFeature : location.getFeatures()) {
            RoomInterface.FeatureInterface feature = new RoomInterface.FeatureInterface(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel());
            feature.setDescription(roomFeature.getDescription());
            if (roomFeature.getFeatureType() != null) {
                feature.setType(new RoomInterface.FeatureTypeInterface(roomFeature.getFeatureType().getUniqueId(), roomFeature.getFeatureType().getReference(), roomFeature.getFeatureType().getLabel(), roomFeature.getFeatureType().isShowInEventManagement()));
            }
            if (roomFeature instanceof DepartmentRoomFeature) {
                if (!courses) continue;
                Department d = ((DepartmentRoomFeature)roomFeature).getDepartment();
                if (filterDepartments && !context.getUser().getCurrentAuthority().hasQualifier(d)) continue;
                feature.setDepartment(RoomDetailsBackend.wrap(d, location, null));
                feature.setTitle((roomFeature.getDescription() == null || roomFeature.getDescription().isEmpty() ? roomFeature.getLabel() : roomFeature.getDescription()) + " (" + d.getName() + (String)(roomFeature.getFeatureType() == null ? "" : ", " + roomFeature.getFeatureType().getLabel()) + ")");
            } else {
                feature.setTitle((roomFeature.getDescription() == null || roomFeature.getDescription().isEmpty() ? roomFeature.getLabel() : roomFeature.getDescription()) + (String)(roomFeature.getFeatureType() == null ? "" : " (" + roomFeature.getFeatureType().getLabel() + ")"));
            }
            response.addFeature(feature);
        }
        for (RoomGroup roomGroup : location.getRoomGroups()) {
            RoomInterface.GroupInterface group = new RoomInterface.GroupInterface(roomGroup.getUniqueId(), roomGroup.getAbbv(), roomGroup.getName());
            if (roomGroup.getDepartment() != null) {
                if (!courses || filterDepartments && !context.getUser().getCurrentAuthority().hasQualifier(roomGroup.getDepartment())) continue;
                group.setDepartment(RoomDetailsBackend.wrap(roomGroup.getDepartment(), location, null));
                group.setTitle((roomGroup.getDescription() == null || roomGroup.getDescription().isEmpty() ? roomGroup.getName() : roomGroup.getDescription()) + " (" + roomGroup.getDepartment().getName() + ")");
            }
            response.addGroup(group);
        }
        if (courses) {
            response.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
            response.setIgnoreTooFar(location.isIgnoreTooFar());
            for (RoomDept roomDept : location.getRoomDepts()) {
                RoomInterface.DepartmentInterface d = RoomDetailsBackend.wrap(roomDept.getDepartment(), location, roomDept.getPreference());
                response.addDepartment(d);
                if (!roomDept.isControl().booleanValue()) continue;
                response.setControlDepartment(d);
            }
            if (response.isCanSeeAvailability()) {
                if (html) {
                    response.setAvailability(location.getRoomSharingTable().getModel().toString().replaceAll(", ", "<br>"));
                } else {
                    response.setAvailability(location.getRoomSharingTable().getModel().toString().replaceAll(", ", "\n"));
                }
                response.setRoomSharingNote(location.getShareNote());
            }
        }
        if (events) {
            if (response.isCanSeeEventAvailability()) {
                if (html) {
                    response.setEventAvailability(location.getEventAvailabilityTable().getModel().toString().replaceAll(", ", "<br>"));
                } else {
                    response.setEventAvailability(location.getEventAvailabilityTable().getModel().toString().replaceAll(", ", "\n"));
                }
            }
            if (location.getEventDepartment() != null) {
                response.setEventDepartment(RoomDetailsBackend.wrap(location.getEventDepartment(), location, null));
            }
            response.setEventNote(location.getNote());
            response.setBreakTime(location.getBreakTime());
            response.setEventEmail(location.getEventEmail());
            if (location.getEventDepartment() != null) {
                response.setEventStatus(location.getEventStatus());
                RoomTypeOption rto = location.getRoomType().getOption(location.getEventDepartment());
                response.setDefaultEventStatus(rto.getStatus());
                response.setDefaultBreakTime(rto.getBreakTime());
                response.setDefaultEventNote(rto.getMessage());
                response.setDefaultEventEmail(rto.getEventEmail());
                for (EventServiceProvider p : location.getAllowedServices()) {
                    if (!p.isVisible().booleanValue() || p.isAllRooms().booleanValue()) continue;
                    EventInterface.EventServiceProviderInterface provider = new EventInterface.EventServiceProviderInterface();
                    provider.setId(p.getUniqueId());
                    provider.setReference(p.getReference());
                    provider.setLabel(p.getLabel());
                    provider.setMessage(p.getNote());
                    provider.setEmail(p.getEmail());
                    if (p.getDepartment() != null) {
                        provider.setDepartmentId(p.getDepartment().getUniqueId());
                    }
                    response.addService(provider);
                }
            } else {
                response.setDefaultEventStatus(RoomTypeOption.Status.NoEventManagement.ordinal());
            }
        }
        if (exams) {
            for (ExamType examType : location.getExamTypes()) {
                if (types != null && !types.contains(examType)) continue;
                if (examType.getReference().equals(department) && response.isCanSeePeriodPreferences()) {
                    if (html) {
                        response.setPeriodPreference(location.getExamPreferencesAbbreviationHtml(examType));
                    } else {
                        response.setPeriodPreference(location.getExamPreferencesAbbreviation(examType));
                    }
                }
                response.addExamType(new RoomInterface.ExamTypeInterface(examType.getUniqueId(), examType.getReference(), examType.getLabel(), examType.getType() == 0));
            }
        }
        if ((minimap = ApplicationProperty.RoomHintMinimapUrl.value()) != null && location.getCoordinateX() != null && location.getCoordinateY() != null) {
            response.setMiniMapUrl(minimap.replace("%x", location.getCoordinateX().toString()).replace("%y", location.getCoordinateY().toString()).replace("%n", location.getLabel()).replace("%i", location.getExternalUniqueId() == null ? "" : location.getExternalUniqueId()));
        }
        if ((string = ApplicationProperty.RoomMapStatic.value()) != null && location.getCoordinateX() != null && location.getCoordinateY() != null) {
            response.setMapUrl(string.replace("%x", location.getCoordinateX().toString()).replace("%y", location.getCoordinateY().toString()).replace("%n", location.getLabel()).replace("%i", location.getExternalUniqueId() == null ? "" : location.getExternalUniqueId()));
        }
        String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
        String secret = ApplicationProperty.RoomMapStaticSecret.value();
        if (response.hasMapUrl() && apikey != null && !apikey.isEmpty()) {
            response.setMapUrl(response.getMapUrl() + "&key=" + apikey);
            if (secret != null && !secret.isEmpty()) {
                try {
                    response.setMapUrl(response.getMapUrl() + "&signature=" + new UrlSigner(secret).signRequest(response.getMapUrl()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (response.hasMiniMapUrl() && apikey != null && !apikey.isEmpty()) {
            response.setMiniMapUrl(response.getMiniMapUrl() + "&key=" + apikey);
            if (secret != null && !secret.isEmpty()) {
                try {
                    response.setMiniMapUrl(response.getMiniMapUrl() + "&signature=" + new UrlSigner(secret).signRequest(response.getMiniMapUrl()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (LocationPicture locationPicture : new TreeSet<LocationPicture>(location.getRoomPictures())) {
            response.addPicture(new RoomInterface.RoomPictureInterface(locationPicture.getUniqueId(), locationPicture.getFileName(), locationPicture.getContentType(), locationPicture.getTimeStamp().getTime(), RoomPicturesBackend.getPictureType(locationPicture.getType())));
        }
        if (context.hasPermission(Right.HasRole) && CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges)) && (lch = ChangeLog.findLastChange(location.getClass().getName(), location.getUniqueId(), null)) != null) {
            response.setLastChange(lch.getShortLabel());
        }
        if ((url = (RoomUrlProvider)Customization.RoomUrlProvider.getProvider()) != null) {
            try {
                response.setUrl(url.getRoomUrl(location));
            }
            catch (Exception exception) {
                sLog.error((Object)("Failed to get room URL: " + exception.getMessage()), (Throwable)exception);
            }
        }
        return response;
    }

    public static void main(String[] args) throws Exception {
        String url = "https://maps.googleapis.com/maps/api/staticmap?key=AIzaSyDpUnTRgd4mB7HdVt5ug_LwKzdNfTQVA14&center=48.8584,2.2945&size=600x400&zoom=16&maptype=roadmap&sensor=false&markers=color:blue%7c48.8584,2.2945";
        System.out.println(url + "&signature=" + new UrlSigner("oJaEChTm5G0AZsqWVQJcb-9SXHY=").signRequest(url));
    }

    public static class UrlSigner {
        private static byte[] key;

        public UrlSigner(String keyString) throws IOException {
            keyString = keyString.replace('-', '+');
            keyString = keyString.replace('_', '/');
            key = Base64.getDecoder().decode(keyString.getBytes());
        }

        public String signRequest(String mapsUrl) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, URISyntaxException, MalformedURLException {
            URL url = new URL(mapsUrl);
            String resource = url.getPath() + "?" + url.getQuery();
            SecretKeySpec sha1Key = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(sha1Key);
            byte[] sigBytes = mac.doFinal(resource.getBytes());
            String signature = new String(Base64.getEncoder().encode(sigBytes));
            signature = signature.replace('+', '-');
            signature = signature.replace('/', '_');
            return signature;
        }
    }
}

