/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.dao.PositionTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=InstructorInterface.InstructorsFilterRequest.class)
public class InstructorsFilterBackend
implements GwtRpcImplementation<InstructorInterface.InstructorsFilterRequest, InstructorInterface.InstructorsFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);

    @Override
    public InstructorInterface.InstructorsFilterResponse execute(InstructorInterface.InstructorsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.Instructors);
        InstructorInterface.InstructorsFilterResponse filter = new InstructorInterface.InstructorsFilterResponse();
        TreeSet<Department> departments = Department.getUserDepartments(context.getUser());
        if (departments.isEmpty()) {
            throw new GwtRpcException(MESSAGES.exceptionNoDepartmentToManage());
        }
        String defaultDeptId = (String)context.getAttribute(SessionAttribute.DepartmentId);
        if (departments.size() == 1) {
            defaultDeptId = ((Department)departments.iterator().next()).getUniqueId().toString();
            context.setAttribute(SessionAttribute.DepartmentId, (Object)defaultDeptId);
        }
        FilterInterface.FilterParameterInterface positions = new FilterInterface.FilterParameterInterface();
        positions.setName("positions");
        positions.setLabel(MESSAGES.propertyInstructorPosition());
        positions.setType("list");
        positions.setMultiSelect(true);
        positions.addOption("-1", MESSAGES.instructorPositionNotSpecified());
        for (PositionType pos : new TreeSet(PositionTypeDAO.getInstance().findAll())) {
            positions.addOption(pos.getUniqueId().toString(), pos.getLabel());
        }
        positions.setMaxLinesToShow(Math.min(positions.getOptions().size(), 5));
        positions.setDefaultValue(context.getUser().getProperty("Instructoros.positions"));
        filter.addParameter(positions);
        FilterInterface.FilterParameterInterface depts = new FilterInterface.FilterParameterInterface();
        depts.setName("deptId");
        depts.setLabel(MESSAGES.filterDepartment());
        depts.setType("list");
        depts.setCollapsible(false);
        if (defaultDeptId != null) {
            depts.setDefaultValue(defaultDeptId);
        }
        for (Department d : departments) {
            depts.addOption(d.getUniqueId().toString(), d.getDeptCode() + " - " + d.getName());
        }
        filter.addParameter(depts);
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        return filter;
    }
}

