/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.UniversalOverrideReservation;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.CurriculumReservationDAO;
import org.unitime.timetable.model.dao.LearningCommunityReservationDAO;
import org.unitime.timetable.model.dao.StudentGroupReservationDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XUniversalReservation;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Constants;

public class GetReservationsAction
implements OnlineSectioningAction<List<ReservationInterface>> {
    private static final long serialVersionUID = 1L;
    private Long iOfferingId;

    public GetReservationsAction forOfferingId(Long id) {
        this.iOfferingId = id;
        return this;
    }

    @Override
    public List<ReservationInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (server instanceof StudentSolverProxy) {
            return ((StudentSolverProxy)server).getReservations(this.iOfferingId);
        }
        if (server instanceof DatabaseServer) {
            ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
            for (Reservation reservation : helper.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.uniqueId = :offeringId", Reservation.class).setParameter("offeringId", (Object)this.iOfferingId).setCacheable(true).list()) {
                ReservationInterface r = this.convert(reservation, helper);
                if (r == null) continue;
                results.add(r);
            }
            Collections.sort(results);
            return results;
        }
        XOffering offering = server.getOffering(this.iOfferingId);
        if (offering == null) {
            return null;
        }
        XEnrollments enrollments = server.getEnrollments(this.iOfferingId);
        ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
        for (XReservation reservation : offering.getReservations()) {
            ReservationInterface r = this.convert(offering, reservation, enrollments, server, helper);
            if (r == null) continue;
            results.add(r);
        }
        Collections.sort(results);
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private ReservationInterface convert(Reservation reservation, OnlineSectioningHelper helper) {
        void var9_42;
        ReservationInterface r = null;
        CourseOffering co = reservation.getInstructionalOffering().getControllingCourseOffering();
        if (reservation instanceof CourseReservation) {
            co = ((CourseReservation)reservation).getCourse();
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isIsControl());
            course.setName(co.getTitle());
            course.setLimit(co.getReservation());
            r = new ReservationInterface.CourseReservation();
            ((ReservationInterface.CourseReservation)r).setCourse(course);
        } else if (reservation instanceof IndividualReservation) {
            r = new ReservationInterface.IndividualReservation();
            if (reservation instanceof OverrideReservation) {
                r = new ReservationInterface.OverrideReservation(((OverrideReservation)reservation).getOverrideType());
            }
            for (Student student : ((IndividualReservation)reservation).getStudents()) {
                Iterator<Serializable> s = new ReservationInterface.IdName();
                ((ReservationInterface.IdName)((Object)s)).setId(student.getUniqueId());
                ((ReservationInterface.IdName)((Object)s)).setAbbv(student.getExternalUniqueId());
                ((ReservationInterface.IdName)((Object)s)).setName(helper.getStudentNameFormat().format(student));
                ((ReservationInterface.IndividualReservation)r).getStudents().add((ReservationInterface.IdName)((Object)s));
            }
            Collections.sort(((ReservationInterface.IndividualReservation)r).getStudents(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getAbbv().compareTo(s2.getAbbv());
                }
            });
        } else if (reservation instanceof CurriculumReservation) {
            CurriculumReservation cr = (CurriculumReservation)reservation;
            r = new ReservationInterface.CurriculumReservation();
            ReservationInterface.Areas curriculum = new ReservationInterface.Areas();
            for (AcademicArea academicArea : cr.getAreas()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(academicArea.getUniqueId());
                idName.setAbbv(academicArea.getAcademicAreaAbbreviation());
                idName.setName(Constants.curriculaToInitialCase(academicArea.getTitle()));
                curriculum.getAreas().add(idName);
            }
            for (AcademicClassification academicClassification : cr.getClassifications()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(academicClassification.getUniqueId());
                idName.setName(Constants.curriculaToInitialCase(academicClassification.getName()));
                idName.setAbbv(academicClassification.getCode());
                curriculum.getClassifications().add(idName);
            }
            for (PosMajor posMajor : cr.getMajors()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(posMajor.getUniqueId());
                idName.setAbbv(posMajor.getCode());
                idName.setName(Constants.curriculaToInitialCase(posMajor.getName()));
                for (AcademicArea aa : posMajor.getAcademicAreas()) {
                    if (!cr.getAreas().contains(aa)) continue;
                    idName.setParentId(aa.getUniqueId());
                    break;
                }
                curriculum.getMajors().add(idName);
            }
            for (PosMinor posMinor : cr.getMinors()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(posMinor.getUniqueId());
                idName.setAbbv(posMinor.getCode());
                idName.setName(Constants.curriculaToInitialCase(posMinor.getName()));
                for (AcademicArea aa : posMinor.getAcademicAreas()) {
                    if (!cr.getAreas().contains(aa)) continue;
                    idName.setParentId(aa.getUniqueId());
                    break;
                }
                curriculum.getMinors().add(idName);
            }
            for (PosMajorConcentration posMajorConcentration : cr.getConcentrations()) {
                ReservationInterface.IdName idName = new ReservationInterface.IdName();
                idName.setId(posMajorConcentration.getUniqueId());
                idName.setAbbv(posMajorConcentration.getCode());
                idName.setName(Constants.curriculaToInitialCase(posMajorConcentration.getName()));
                idName.setParentId(posMajorConcentration.getMajor().getUniqueId());
                curriculum.getConcentrations().add(idName);
            }
            if (curriculum.getAreas().size() > 1) {
                Collections.sort(curriculum.getAreas(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
            }
            Collections.sort(curriculum.getMajors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getClassifications(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getMinors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getConcentrations(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
        } else if (reservation instanceof LearningCommunityReservation) {
            r = new ReservationInterface.LCReservation();
            sg = ((LearningCommunityReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            group.setId(sg.getUniqueId());
            group.setName(sg.getGroupName());
            group.setAbbv(sg.getGroupAbbreviation());
            group.setLimit(sg.getStudents().size());
            ((ReservationInterface.LCReservation)r).setGroup(group);
            co = ((LearningCommunityReservation)reservation).getCourse();
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isIsControl());
            course.setName(co.getTitle());
            course.setLimit(co.getReservation());
            ((ReservationInterface.LCReservation)r).setCourse(course);
        } else if (reservation instanceof StudentGroupReservation) {
            r = new ReservationInterface.GroupReservation();
            sg = ((StudentGroupReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            group.setId(sg.getUniqueId());
            group.setName(sg.getGroupName());
            group.setAbbv(sg.getGroupAbbreviation());
            group.setLimit(sg.getStudents().size());
            ((ReservationInterface.GroupReservation)r).setGroup(group);
        } else if (reservation instanceof UniversalOverrideReservation) {
            r = new ReservationInterface.UniversalReservation();
            ((ReservationInterface.UniversalReservation)r).setFilter(((UniversalOverrideReservation)reservation).getFilter());
        } else {
            return null;
        }
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(co.getCourseName());
        offering.setName(co.getTitle());
        offering.setId(reservation.getInstructionalOffering().getUniqueId());
        offering.setOffered(reservation.getInstructionalOffering().isNotOffered() == false);
        r.setOffering(offering);
        boolean showClassSuffixes = ApplicationProperty.ReservationsShowClassSufix.isTrue();
        for (CourseOffering courseOffering : reservation.getInstructionalOffering().getCourseOfferings()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(courseOffering.getUniqueId());
            course.setAbbv(courseOffering.getCourseName());
            course.setName(courseOffering.getTitle());
            course.setControl(courseOffering.isIsControl());
            course.setLimit(courseOffering.getReservation());
            offering.getCourses().add(course);
        }
        ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(reservation.getConfigurations());
        Collections.sort(configs, new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig instrOfferingConfig : configs) {
            ReservationInterface.Config config = new ReservationInterface.Config();
            config.setId(instrOfferingConfig.getUniqueId());
            config.setName(instrOfferingConfig.getName());
            config.setAbbv(instrOfferingConfig.getName());
            config.setLimit(instrOfferingConfig.isUnlimitedEnrollment() != false ? null : instrOfferingConfig.getLimit());
            r.getConfigs().add(config);
        }
        ArrayList<Class_> arrayList = new ArrayList<Class_>(reservation.getClasses());
        Collections.sort(arrayList, new ClassComparator(5));
        for (Class_ c : arrayList) {
            ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
            clazz.setId(c.getUniqueId());
            clazz.setAbbv(c.getSchedulingSubpart().getItypeDesc() + " " + c.getSectionNumberString(helper.getHibSession()));
            clazz.setName(c.getClassLabel(co, showClassSuffixes));
            clazz.setLimit(c.getClassLimit());
            r.getClasses().add(clazz);
        }
        r.setStartDate(reservation.getStartDate());
        r.setExpirationDate(reservation.getExpirationDate());
        r.setExpired(reservation.isExpired());
        r.setLimit(reservation.getLimit());
        r.setInclusive(reservation.getInclusive());
        r.setId(reservation.getUniqueId());
        r.setOverride(reservation instanceof IndividualOverrideReservation || reservation instanceof GroupOverrideReservation || reservation instanceof CurriculumOverrideReservation || reservation instanceof UniversalOverrideReservation);
        r.setAllowOverlaps(reservation.isAllowOverlap());
        r.setMustBeUsed(reservation.isMustBeUsed());
        r.setAlwaysExpired(reservation.isAlwaysExpired());
        r.setOverLimit(reservation.isCanAssignOverLimit());
        Object var9_36 = null;
        if (reservation instanceof CourseReservation) {
            List list = helper.getHibSession().createQuery("select cr from CourseRequest cr inner join fetch cr.courseDemand cd inner join fetch cd.student s where cr.courseOffering.uniqueId = :courseId", CourseRequest.class).setParameter("courseId", (Object)((CourseReservation)reservation).getCourse().getUniqueId()).setCacheable(true).list();
        } else if (reservation instanceof LearningCommunityReservation) {
            List list = helper.getHibSession().createQuery("select cr from CourseRequest cr inner join fetch cr.courseDemand cd inner join fetch cd.student s where cr.courseOffering.uniqueId = :courseId and s.uniqueId in (select s.uniqueId from StudentGroupReservation r inner join r.group.students s where r.uniqueId = :reservationId)", CourseRequest.class).setParameter("courseId", (Object)((LearningCommunityReservation)reservation).getCourse().getUniqueId()).setParameter("reservationId", (Object)reservation.getUniqueId()).setCacheable(true).list();
        } else if (reservation instanceof IndividualReservation) {
            List list = helper.getHibSession().createQuery("select cr from CourseRequest cr inner join fetch cr.courseDemand cd inner join fetch cd.student s where cr.courseOffering.instructionalOffering.uniqueId = :offeringId and s.uniqueId in (select s.uniqueId from IndividualReservation r inner join r.students s where r.uniqueId = :reservationId)", CourseRequest.class).setParameter("offeringId", (Object)reservation.getInstructionalOffering().getUniqueId()).setParameter("reservationId", (Object)reservation.getUniqueId()).setCacheable(true).list();
        } else if (reservation instanceof StudentGroupReservation) {
            List list = helper.getHibSession().createQuery("select cr from CourseRequest cr inner join fetch cr.courseDemand cd inner join fetch cd.student s where cr.courseOffering.instructionalOffering.uniqueId = :offeringId and s.uniqueId in (select s.uniqueId from StudentGroupReservation r inner join r.group.students s where r.uniqueId = :reservationId)", CourseRequest.class).setParameter("offeringId", (Object)reservation.getInstructionalOffering().getUniqueId()).setParameter("reservationId", (Object)reservation.getUniqueId()).setCacheable(true).list();
        } else {
            List list = helper.getHibSession().createQuery("select cr from CourseRequest cr inner join fetch cr.courseDemand cd inner join fetch cd.student s where cr.courseOffering.instructionalOffering.uniqueId = :offeringId", CourseRequest.class).setParameter("offeringId", (Object)reservation.getInstructionalOffering().getUniqueId()).setCacheable(true).list();
        }
        int enrolled = 0;
        for (CourseRequest request : var9_42) {
            if (!reservation.isApplicable(request.getCourseDemand().getStudent(), request) || !reservation.isMatching(request.getClassEnrollments())) continue;
            ++enrolled;
        }
        r.setEnrollment(enrolled);
        return r;
    }

    private ReservationInterface convert(XOffering offering, XReservation reservation, XEnrollments enrollments, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ReservationInterface r = null;
        XCourse co = offering.getControllingCourse();
        if (reservation instanceof XCourseReservation) {
            co = offering.getCourse(((XCourseReservation)reservation).getCourseId());
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getCourseId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isControlling());
            course.setName(co.getTitle());
            course.setLimit(co.getLimit() < 0 ? null : Integer.valueOf(co.getLimit()));
            r = new ReservationInterface.CourseReservation();
            ((ReservationInterface.CourseReservation)r).setCourse(course);
        } else if (reservation instanceof XIndividualReservation) {
            r = new ReservationInterface.IndividualReservation();
            if (reservation.getType() == XReservationType.IndividualOverride) {
                r = new ReservationInterface.OverrideReservation(reservation.canAssignOverLimit() && reservation.isAllowOverlap() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowOverLimitTimeConflictLink : (reservation.canAssignOverLimit() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowOverLimitLink : (reservation.isAllowOverlap() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowTimeConflictLink : (reservation.isAllowOverlap() && reservation.canAssignOverLimit() ? ReservationInterface.OverrideType.AllowOverLimitTimeConflict : (reservation.isAllowOverlap() ? ReservationInterface.OverrideType.AllowTimeConflict : (reservation.canAssignOverLimit() ? ReservationInterface.OverrideType.AllowOverLimit : (reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.CoReqOverride : ReservationInterface.OverrideType.Other)))))));
            }
            for (Long studentId : ((XIndividualReservation)reservation).getStudentIds()) {
                XStudent student = server.getStudent(studentId);
                if (student == null) continue;
                ReservationInterface.IdName s = new ReservationInterface.IdName();
                s.setId(student.getStudentId());
                s.setAbbv(student.getExternalId());
                s.setName(student.getName());
                ((ReservationInterface.IndividualReservation)r).getStudents().add(s);
            }
            Collections.sort(((ReservationInterface.IndividualReservation)r).getStudents(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getAbbv().compareTo(s2.getAbbv());
                }
            });
        } else if (reservation instanceof XCurriculumReservation) {
            XCurriculumReservation cr = (XCurriculumReservation)reservation;
            r = new ReservationInterface.CurriculumReservation();
            ReservationInterface.Areas curriculum = new ReservationInterface.Areas();
            CurriculumReservation ccr = (CurriculumReservation)CurriculumReservationDAO.getInstance().get(reservation.getReservationId(), helper.getHibSession());
            if (ccr != null) {
                for (AcademicArea academicArea : ccr.getAreas()) {
                    ReservationInterface.IdName aa = new ReservationInterface.IdName();
                    aa.setId(academicArea.getUniqueId());
                    aa.setAbbv(academicArea.getAcademicAreaAbbreviation());
                    aa.setName(Constants.curriculaToInitialCase(academicArea.getTitle()));
                    curriculum.getAreas().add(aa);
                }
                for (AcademicClassification academicClassification : ccr.getClassifications()) {
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(academicClassification.getUniqueId());
                    clasf.setName(Constants.curriculaToInitialCase(academicClassification.getName()));
                    clasf.setAbbv(academicClassification.getCode());
                    curriculum.getClassifications().add(clasf);
                }
                for (PosMajor posMajor : ccr.getMajors()) {
                    ReservationInterface.IdName mj = new ReservationInterface.IdName();
                    mj.setId(posMajor.getUniqueId());
                    mj.setAbbv(posMajor.getCode());
                    mj.setName(Constants.curriculaToInitialCase(posMajor.getName()));
                    for (AcademicArea aa : posMajor.getAcademicAreas()) {
                        if (!ccr.getAreas().contains(aa)) continue;
                        mj.setParentId(aa.getUniqueId());
                        break;
                    }
                    curriculum.getMajors().add(mj);
                }
                for (PosMinor posMinor : ccr.getMinors()) {
                    ReservationInterface.IdName mn = new ReservationInterface.IdName();
                    mn.setId(posMinor.getUniqueId());
                    mn.setAbbv(posMinor.getCode());
                    mn.setName(Constants.curriculaToInitialCase(posMinor.getName()));
                    for (AcademicArea aa : posMinor.getAcademicAreas()) {
                        if (!ccr.getAreas().contains(aa)) continue;
                        mn.setParentId(aa.getUniqueId());
                        break;
                    }
                    curriculum.getMinors().add(mn);
                }
                for (PosMajorConcentration posMajorConcentration : ccr.getConcentrations()) {
                    ReservationInterface.IdName cc = new ReservationInterface.IdName();
                    cc.setId(posMajorConcentration.getUniqueId());
                    cc.setAbbv(posMajorConcentration.getCode());
                    cc.setName(Constants.curriculaToInitialCase(posMajorConcentration.getName()));
                    cc.setParentId(posMajorConcentration.getMajor().getUniqueId());
                    curriculum.getConcentrations().add(cc);
                }
            } else {
                long areaId = 0L;
                for (String string : cr.getAcademicAreas()) {
                    ReservationInterface.IdName aa = new ReservationInterface.IdName();
                    aa.setId(areaId++);
                    aa.setAbbv(string);
                    aa.setName(string);
                    curriculum.getAreas().add(aa);
                }
                long clasfId = 0L;
                for (String classification : cr.getClassifications()) {
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(clasfId++);
                    clasf.setAbbv(classification);
                    clasf.setName(classification);
                    curriculum.getClassifications().add(clasf);
                }
                long majorId = 0L;
                long concId = 0L;
                for (String major : cr.getMajors()) {
                    ReservationInterface.IdName mj = new ReservationInterface.IdName();
                    mj.setId(majorId);
                    mj.setAbbv(major);
                    mj.setName(major);
                    curriculum.getMajors().add(mj);
                    if (cr.getConcentrations(major) != null) {
                        for (String conc : cr.getConcentrations(major)) {
                            ReservationInterface.IdName cc = new ReservationInterface.IdName();
                            cc.setId(concId++);
                            cc.setAbbv(conc);
                            cc.setParentId(majorId);
                            cc.setName(conc);
                            curriculum.getConcentrations().add(cc);
                        }
                    }
                    ++majorId;
                }
                for (String minor : cr.getMinors()) {
                    ReservationInterface.IdName mn = new ReservationInterface.IdName();
                    mn.setAbbv(minor);
                    mn.setName(minor);
                    curriculum.getMinors().add(mn);
                }
            }
            if (curriculum.getAreas().size() > 1) {
                Collections.sort(curriculum.getAreas(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
            }
            Collections.sort(curriculum.getMajors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getClassifications(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getMinors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getConcentrations(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
        } else if (reservation instanceof XLearningCommunityReservation) {
            r = new ReservationInterface.LCReservation();
            sg = ((XLearningCommunityReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            ((ReservationInterface.IdName)((Object)group)).setName(sg.getTitle());
            ((ReservationInterface.IdName)((Object)group)).setAbbv(sg.getAbbreviation());
            ((ReservationInterface.IdName)((Object)group)).setLimit(((XLearningCommunityReservation)reservation).getStudentIds().size());
            ((ReservationInterface.LCReservation)r).setGroup((ReservationInterface.IdName)((Object)group));
            LearningCommunityReservation lcr = (LearningCommunityReservation)LearningCommunityReservationDAO.getInstance().get(reservation.getReservationId());
            if (lcr != null) {
                ((ReservationInterface.IdName)((Object)group)).setId(lcr.getGroup().getUniqueId());
                ((ReservationInterface.IdName)((Object)group)).setLimit(lcr.getGroup().getStudents().size());
            }
            co = offering.getCourse(((XLearningCommunityReservation)reservation).getCourseId());
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getCourseId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isControlling());
            course.setName(co.getTitle());
            course.setLimit(co.getLimit() < 0 ? null : Integer.valueOf(co.getLimit()));
            ((ReservationInterface.LCReservation)r).setCourse(course);
        } else if (reservation instanceof XGroupReservation) {
            r = new ReservationInterface.GroupReservation();
            sg = ((XGroupReservation)reservation).getGroup();
            group = new ReservationInterface.IdName();
            ((ReservationInterface.IdName)((Object)group)).setName(sg.getTitle());
            ((ReservationInterface.IdName)((Object)group)).setAbbv(sg.getAbbreviation());
            ((ReservationInterface.IdName)((Object)group)).setLimit(0);
            StudentGroupReservation gr = (StudentGroupReservation)StudentGroupReservationDAO.getInstance().get(reservation.getReservationId(), helper.getHibSession());
            if (gr != null) {
                ((ReservationInterface.IdName)((Object)group)).setId(gr.getGroup().getUniqueId());
                ((ReservationInterface.IdName)((Object)group)).setLimit(gr.getGroup().getStudents().size());
            }
            ((ReservationInterface.GroupReservation)r).setGroup((ReservationInterface.IdName)((Object)group));
        } else if (reservation instanceof XUniversalReservation) {
            r = new ReservationInterface.UniversalReservation();
            ((ReservationInterface.UniversalReservation)r).setFilter(((XUniversalReservation)reservation).getFilter());
        } else {
            return null;
        }
        ReservationInterface.Offering io = new ReservationInterface.Offering();
        io.setAbbv(co.getCourseName());
        io.setName(co.getTitle());
        io.setId(offering.getOfferingId());
        io.setOffered(true);
        r.setOffering(io);
        for (XCourse cx : offering.getCourses()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(cx.getCourseId());
            course.setAbbv(cx.getCourseName());
            course.setName(cx.getTitle());
            course.setControl(cx.isControlling());
            course.setLimit(cx.getLimit() < 0 ? null : Integer.valueOf(cx.getLimit()));
            io.getCourses().add(course);
        }
        for (XConfig ioc : offering.getConfigs()) {
            if (reservation.hasConfigRestriction(ioc.getConfigId())) {
                boolean hasSection = false;
                for (XSubpart subpart : ioc.getSubparts()) {
                    for (XSection c : subpart.getSections()) {
                        if (!reservation.hasSectionRestriction(c.getSectionId())) continue;
                        hasSection = true;
                        ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                        clazz.setId(c.getSectionId());
                        clazz.setAbbv(c.getName(co.getCourseId()));
                        clazz.setName(subpart.getName() + " " + c.getName(co.getCourseId()));
                        clazz.setLimit(c.getLimit() < 0 ? null : Integer.valueOf(c.getLimit()));
                        r.getClasses().add(clazz);
                    }
                }
                if (hasSection) continue;
                ReservationInterface.Config config = new ReservationInterface.Config();
                config.setId(ioc.getConfigId());
                config.setName(ioc.getName());
                config.setAbbv(ioc.getName());
                config.setLimit(ioc.getLimit() < 0 ? null : Integer.valueOf(ioc.getLimit()));
                r.getConfigs().add(config);
                continue;
            }
            for (XSubpart xSubpart : ioc.getSubparts()) {
                for (XSection xSection : xSubpart.getSections()) {
                    if (!reservation.hasSectionRestriction(xSection.getSectionId())) continue;
                    ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                    clazz.setId(xSection.getSectionId());
                    clazz.setAbbv(xSection.getName(co.getCourseId()));
                    clazz.setName(xSubpart.getName() + " " + xSection.getName(co.getCourseId()));
                    clazz.setLimit(xSection.getLimit() < 0 ? null : Integer.valueOf(xSection.getLimit()));
                    r.getClasses().add(clazz);
                }
            }
        }
        r.setStartDate(reservation.getStartDate());
        r.setExpirationDate(reservation.getExpirationDate());
        r.setExpired(reservation.isExpired());
        r.setLimit(reservation.getReservationLimit() < 0 ? null : Integer.valueOf(reservation.getReservationLimit()));
        r.setInclusive(reservation.isInclusive());
        r.setId(reservation.getReservationId());
        r.setOverride(reservation.getType() == XReservationType.IndividualOverride || reservation.getType() == XReservationType.CurriculumOverride || reservation.getType() == XReservationType.GroupOverride || reservation.getType() == XReservationType.Universal);
        r.setAllowOverlaps(reservation.isAllowOverlap());
        r.setMustBeUsed(reservation.mustBeUsed());
        r.setAlwaysExpired(reservation.isAlwaysExpired());
        r.setOverLimit(reservation.canAssignOverLimit());
        int enrolled = 0;
        if (enrollments != null) {
            for (XEnrollment enrollment : enrollments.getEnrollments()) {
                if (!reservation.isApplicable(server.getStudent(enrollment.getStudentId()), enrollment) || !reservation.isIncluded(enrollment.getConfigId(), offering.getSections(enrollment))) continue;
                ++enrolled;
            }
        }
        r.setEnrollment(enrolled);
        return r;
    }

    @Override
    public String name() {
        return "get-reservations";
    }
}

