/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XSection;

public class XClassEnrollment
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private XCourseId iCourseId;
    private XSection iSection;
    private int iShiftDays = 0;
    private int iEnrollment = 0;
    private String iParentSectionName;
    private String iCredit;
    private Date iTimeStamp;

    public XClassEnrollment() {
    }

    public XClassEnrollment(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XClassEnrollment(StudentClassEnrollment enrollment, OnlineSectioningHelper helper) {
        this.iCourseId = new XCourseId(enrollment.getCourseOffering());
        this.iSection = new XSection(enrollment.getClazz(), helper);
        this.iTimeStamp = enrollment.getTimestamp();
    }

    public XClassEnrollment(XEnrollment courseId, XSection section) {
        this.iCourseId = new XCourseId(courseId);
        this.iSection = section;
        this.iTimeStamp = courseId.getTimeStamp();
    }

    public XCourseId getCourseId() {
        return this.iCourseId;
    }

    public XSection getSection() {
        return this.iSection;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public XSection getShiftedSection() {
        if (this.iShiftDays == 0 || this.iSection.getTime() == null) {
            return this.iSection;
        }
        XSection section = new XSection(this.iSection);
        section.getTime().datePatternShiftDays(this.iShiftDays);
        return section;
    }

    public int getShiftDays() {
        return this.iShiftDays;
    }

    public void setShiftDays(int shiftDays) {
        this.iShiftDays = shiftDays;
    }

    public int getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(int enrollment) {
        this.iEnrollment = enrollment;
    }

    public String getParentSectionName() {
        return this.iParentSectionName;
    }

    public void setParentSectionName(String name) {
        this.iParentSectionName = name;
    }

    public String getCredit() {
        return this.iCredit;
    }

    public void setCredit(String credit) {
        this.iCredit = credit;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.iCourseId.writeExternal(out);
        this.iSection.writeExternal(out);
        out.writeInt(this.iShiftDays);
        out.writeInt(this.iEnrollment);
        out.writeObject(this.iParentSectionName);
        out.writeObject(this.iCredit);
        out.writeObject(this.iTimeStamp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iCourseId = new XCourseId(in);
        this.iSection = new XSection(in);
        this.iShiftDays = in.readInt();
        this.iEnrollment = in.readInt();
        this.iParentSectionName = (String)in.readObject();
        this.iCredit = (String)in.readObject();
        this.iTimeStamp = (Date)in.readObject();
    }
}

