/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Hashtable;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseCurriculumProjectionRule;
import org.unitime.timetable.model.dao.CurriculumProjectionRuleDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="curriculum_rule")
public class CurriculumProjectionRule
extends BaseCurriculumProjectionRule {
    private static final long serialVersionUID = 1L;

    public CurriculumProjectionRule() {
    }

    public CurriculumProjectionRule(Long uniqueId) {
        super(uniqueId);
    }

    public static List<CurriculumProjectionRule> findAll(Long sessionId) {
        return CurriculumProjectionRuleDAO.getInstance().getSession().createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId=:sessionId", CurriculumProjectionRule.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<CurriculumProjectionRule> findByAcademicArea(Long acadAreaId) {
        return CurriculumProjectionRuleDAO.getInstance().getSession().createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId", CurriculumProjectionRule.class).setParameter("acadAreaId", (Object)acadAreaId).setCacheable(true).list();
    }

    public static Hashtable<String, Float> getProjections(Long acadAreaId, Long acadClasfId) {
        Hashtable<String, Float> ret = new Hashtable<String, Float>();
        for (CurriculumProjectionRule r : CurriculumProjectionRuleDAO.getInstance().getSession().createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId and r.academicClassification.uniqueId=:acadClasfId", CurriculumProjectionRule.class).setParameter("acadAreaId", (Object)acadAreaId).setParameter("acadClasfId", (Object)acadClasfId).setCacheable(true).list()) {
            ret.put(r.getMajor() == null ? "" : r.getMajor().getCode(), r.getProjection());
        }
        return ret;
    }
}

