/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.UserTypeJavaTypeWrapper;
import org.hibernate.type.internal.UserTypeSqlTypeAdapter;
import org.hibernate.type.internal.UserTypeVersionJavaTypeWrapper;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.UserVersionType;

public class CustomType<J>
extends AbstractType
implements ConvertedBasicType<J>,
ProcedureParameterNamedBinder<J>,
ProcedureParameterExtractionAware<J> {
    private final UserType<J> userType;
    private final String[] registrationKeys;
    private final String name;
    private final JavaType<J> mappedJavaType;
    private final JavaType<?> jdbcJavaType;
    private final JdbcType jdbcType;
    private final ValueExtractor<J> valueExtractor;
    private final ValueBinder<J> valueBinder;
    private final JdbcLiteralFormatter<J> jdbcLiteralFormatter;

    public CustomType(UserType<J> userType, TypeConfiguration typeConfiguration) throws MappingException {
        this(userType, ArrayHelper.EMPTY_STRING_ARRAY, typeConfiguration);
    }

    public CustomType(UserType<J> userType, String[] registrationKeys, TypeConfiguration typeConfiguration) throws MappingException {
        this.userType = userType;
        this.name = userType.getClass().getName();
        this.mappedJavaType = userType instanceof JavaType ? (JavaType)((Object)userType) : (userType instanceof JavaTypedExpressible ? ((JavaTypedExpressible)((Object)userType)).getExpressibleJavaType() : (userType instanceof UserVersionType ? new UserTypeVersionJavaTypeWrapper((UserVersionType)userType) : new UserTypeJavaTypeWrapper<J>(userType)));
        BasicValueConverter<J, Object> valueConverter = userType.getValueConverter();
        if (valueConverter != null) {
            this.jdbcType = userType.getJdbcType(typeConfiguration);
            this.jdbcJavaType = valueConverter.getRelationalJavaType();
            this.valueExtractor = this.jdbcType.getExtractor(this.jdbcJavaType);
            this.valueBinder = this.jdbcType.getBinder(this.jdbcJavaType);
            this.jdbcLiteralFormatter = this.jdbcType.getJdbcLiteralFormatter(this.jdbcJavaType);
        } else {
            this.jdbcType = new UserTypeSqlTypeAdapter<J>(userType, this.mappedJavaType, typeConfiguration);
            this.jdbcJavaType = this.jdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
            this.valueExtractor = this.jdbcType.getExtractor(this.mappedJavaType);
            this.valueBinder = this.jdbcType.getBinder(this.mappedJavaType);
            this.jdbcLiteralFormatter = userType instanceof EnhancedUserType ? this.jdbcType.getJdbcLiteralFormatter(this.mappedJavaType) : null;
        }
        this.registrationKeys = registrationKeys;
    }

    public UserType<J> getUserType() {
        return this.userType;
    }

    @Override
    public ValueExtractor<J> getJdbcValueExtractor() {
        return this.valueExtractor;
    }

    @Override
    public ValueBinder<J> getJdbcValueBinder() {
        return this.valueBinder;
    }

    @Override
    public JdbcLiteralFormatter<J> getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public int[] getSqlTypeCodes(Mapping pi) {
        return new int[]{this.jdbcType.getDdlTypeCode()};
    }

    @Override
    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    @Override
    public int getColumnSpan(Mapping session) {
        return 1;
    }

    public Class<J> getReturnedClass() {
        return this.getUserType().returnedClass();
    }

    @Override
    public boolean isEqual(Object x, Object y) throws HibernateException {
        return this.getUserType().equals(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        return this.getUserType().hashCode(x);
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) {
        J assembled = this.getUserType().assemble(cached, owner);
        if (assembled == null && cached != null) {
            BasicValueConverter<J, Object> valueConverter = this.getUserType().getValueConverter();
            if (valueConverter == null) {
                return cached;
            }
            return valueConverter.toDomainValue(cached);
        }
        return assembled;
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) {
        return this.disassembleForCache(value);
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        return this.disassembleForCache(value);
    }

    private Serializable disassembleForCache(Object value) {
        Serializable disassembled = this.getUserType().disassemble(value);
        if (disassembled == null) {
            BasicValueConverter<J, Object> valueConverter = this.getUserType().getValueConverter();
            if (valueConverter == null) {
                return disassembled;
            }
            return (Serializable)valueConverter.toRelationalValue(value);
        }
        return disassembled;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        BasicValueConverter<J, Object> valueConverter = this.getUserType().getValueConverter();
        if (valueConverter == null) {
            return value;
        }
        return valueConverter.toRelationalValue(value);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        Serializable disassembled = this.getUserType().disassemble(value);
        if (disassembled == null) {
            CacheHelper.addBasicValueToCacheKey(cacheKey, value, this, session);
        } else {
            cacheKey.addValue(disassembled);
            if (value == null) {
                cacheKey.addHashCode(0);
            } else {
                cacheKey.addHashCode(this.getUserType().hashCode(value));
            }
        }
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) throws HibernateException {
        return this.getUserType().replace(original, target, owner);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws SQLException {
        if (settable[0]) {
            this.getUserType().nullSafeSet(st, value, index, session);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.getUserType().nullSafeSet(st, value, index, session);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.getUserType().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.getUserType().isMutable();
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == null) {
            return "null";
        }
        if (this.userType instanceof LoggableUserType) {
            return ((LoggableUserType)((Object)this.userType)).toLoggableString(value, factory);
        }
        if (this.userType instanceof EnhancedUserType) {
            return ((EnhancedUserType)this.userType).toString(value);
        }
        return value.toString();
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }

    @Override
    public boolean canDoSetting() {
        if (this.getUserType() instanceof ProcedureParameterNamedBinder) {
            return ((ProcedureParameterNamedBinder)((Object)this.getUserType())).canDoSetting();
        }
        return false;
    }

    @Override
    public void nullSafeSet(CallableStatement statement, J value, String name, SharedSessionContractImplementor session) throws SQLException {
        if (!this.canDoSetting()) {
            throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter binding by name");
        }
        ((ProcedureParameterNamedBinder)((Object)this.getUserType())).nullSafeSet(statement, value, name, session);
    }

    @Override
    public boolean canDoExtraction() {
        if (this.getUserType() instanceof ProcedureParameterExtractionAware) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).canDoExtraction();
        }
        return false;
    }

    @Override
    public J extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, startIndex, session);
        }
        throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter value extraction");
    }

    @Override
    public J extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, paramName, session);
        }
        throw new UnsupportedOperationException("Type [" + String.valueOf(this.getUserType()) + "] does support parameter value extraction");
    }

    public int hashCode() {
        return this.getUserType().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CustomType && this.getUserType().equals(((CustomType)obj).getUserType());
    }

    public Class<J> getJavaType() {
        return this.mappedJavaType.getJavaTypeClass();
    }

    @Override
    public JavaType<J> getMappedJavaType() {
        return this.mappedJavaType;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.getMappedJavaType();
    }

    @Override
    public JavaType<J> getJavaTypeDescriptor() {
        return this.getMappedJavaType();
    }

    @Override
    public JavaType<?> getJdbcJavaType() {
        return this.jdbcJavaType;
    }

    @Override
    public BasicValueConverter<J, Object> getValueConverter() {
        return this.userType.getValueConverter();
    }
}

