/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import org.unitime.timetable.model.base.BaseFixedCreditUnitConfig;

@Entity
@DiscriminatorValue(value="fixedUnit")
public class FixedCreditUnitConfig
extends BaseFixedCreditUnitConfig {
    private static final long serialVersionUID = 1L;
    public static String CREDIT_FORMAT = "fixedUnit";

    public FixedCreditUnitConfig() {
    }

    public FixedCreditUnitConfig(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String creditText() {
        StringBuffer sb = new StringBuffer();
        sb.append(sCreditFormat.format(this.getFixedUnits()));
        sb.append(" ");
        sb.append(this.getCreditUnitType().getLabel());
        sb.append(" of ");
        sb.append(this.getCreditType().getLabel());
        return sb.toString();
    }

    @Override
    public String creditAbbv() {
        return (this.getCreditFormatAbbv() + " " + sCreditFormat.format(this.getFixedUnits()) + " " + this.getCreditUnitType().getAbbv() + " " + this.getCreditType().getAbbv()).trim();
    }

    @Override
    public Object clone() {
        FixedCreditUnitConfig newCreditConfig = new FixedCreditUnitConfig();
        this.baseClone(newCreditConfig);
        newCreditConfig.setFixedUnits(this.getFixedUnits());
        return newCreditConfig;
    }

    @Override
    @Transient
    public float getMinCredit() {
        return this.getFixedUnits() == null ? 0.0f : this.getFixedUnits().floatValue();
    }

    @Override
    @Transient
    public float getMaxCredit() {
        return this.getFixedUnits() == null ? 0.0f : this.getFixedUnits().floatValue();
    }

    public static String formatCredit(float credit) {
        return credit == 0.0f ? "" : sCreditFormat.format(credit);
    }
}

