/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassAssignmentsTableBuilder;
import org.unitime.timetable.server.courses.ClassesTableBuilder;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.server.courses.InstructionalOfferingTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="org.unitime.timetable.export.Exporter:offerings.csv")
public class OfferingsCSV
implements Exporter {
    protected static ExaminationMessages EXAM = Localization.create(ExaminationMessages.class);
    @Autowired
    protected AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    protected SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public String reference() {
        return "offerings.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.InstructionalOfferingsExportPDF);
        this.exportDataCsv(this.getOfferings(helper), helper);
    }

    protected void checkPermission(ExportHelper helper, Right right) {
        ArrayList<SubjectArea> subjectAreas = new ArrayList<SubjectArea>();
        for (String subjectAreaId : helper.getParameter("subjectArea").split(",")) {
            SubjectArea subjectArea;
            if (subjectAreaId.isEmpty() || (subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            subjectAreas.add(subjectArea);
            helper.getSessionContext().checkPermissionAnySession((Object)subjectArea.getDepartment(), right, new Qualifiable[0]);
        }
    }

    protected List<TableInterface> getOfferings(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        InstructionalOfferingTableBuilder builder = new InstructionalOfferingTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForInstructionalOfferings(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getClasses(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        ClassesTableBuilder builder = new ClassesTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForClasses(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getClassAssignments(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        ClassAssignmentsTableBuilder builder = new ClassAssignmentsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForClassAssignments(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getDistributions(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        DistributionsTableBuilder builder = new DistributionsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        Filter filter = new Filter(helper);
        for (String subjectAreaId : helper.getParameter("subjectArea").split(",")) {
            SubjectArea area;
            if (subjectAreaId.isEmpty() || (area = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            TableInterface table = builder.getDistPrefsTableForFilter(filter, area.getUniqueId());
            table.setName(area.getLabel());
            table.setId(subjectAreaId);
            response.add(table);
        }
        return response;
    }

    protected List<TableInterface> getExamDistributions(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        DistributionsTableBuilder builder = new DistributionsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        Filter filter = new Filter(helper);
        String examType = filter.getParameterValue("examType");
        ExamType type = null;
        try {
            type = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(examType));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = ExamType.findByReference(examType);
        }
        if (type == null) {
            throw new GwtRpcException(EXAM.messageNoExamType());
        }
        TableInterface table = builder.getExamDistPrefsTableForFilter(filter, type);
        table.setName(EXAM.sectionDistributionPreferences(type.getLabel()));
        response.add(this.sorted(table, helper));
        return response;
    }

    protected List<TableInterface> getExams(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        ExaminationsTableBuilder builder = new ExaminationsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        Filter filter = new Filter(helper);
        String examType = filter.getParameterValue("examType");
        ExamType type = null;
        try {
            type = (ExamType)ExamTypeDAO.getInstance().get(Long.valueOf(examType));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = ExamType.findByReference(examType);
        }
        if (type == null) {
            throw new GwtRpcException(EXAM.messageNoExamType());
        }
        response.add(this.sorted(builder.generateTableForExams(type, this.examinationSolverService.getSolver(), filter, helper.getParameter("subjectArea").split(",")), helper));
        return response;
    }

    protected TableInterface sorted(TableInterface table, ExportHelper helper) {
        String sort = helper.getParameter("sort");
        if (sort != null && !sort.isEmpty() && table.hasLines()) {
            Iterator<TableInterface.LineInterface> iterator;
            int sortColumn = -1;
            boolean sortAsc = true;
            if (table.getHeader() != null && (iterator = table.getHeader().iterator()).hasNext()) {
                TableInterface.LineInterface line = iterator.next();
                for (int col = 0; col < line.getCells().size(); ++col) {
                    TableInterface.CellInterface cell = line.getCells().get(col);
                    if (cell.hasText() && sort.equals(cell.getText())) {
                        sortColumn = col;
                        sortAsc = true;
                        break;
                    }
                    if (!cell.hasText() || !sort.equals("!" + cell.getText())) continue;
                    sortColumn = col;
                    sortAsc = false;
                    break;
                }
            }
            if (sortColumn >= 0) {
                final int col = sortColumn;
                final boolean asc = sortAsc;
                Collections.sort(table.getLines(), new Comparator<TableInterface.LineInterface>(){

                    @Override
                    public int compare(TableInterface.LineInterface l1, TableInterface.LineInterface l2) {
                        TableInterface.CellInterface c1 = l1.getCells().get(col);
                        TableInterface.CellInterface c2 = l2.getCells().get(col);
                        Comparable<?> o1 = c1.getComparable();
                        Comparable<?> o2 = c2.getComparable();
                        if (o1 instanceof String) {
                            return asc ? TableInterface.NaturalOrderComparator.compare(o1.toString(), o2.toString()) : TableInterface.NaturalOrderComparator.compare(o2.toString(), o1.toString());
                        }
                        return asc ? o1.compareTo(o2) : o2.compareTo(o1);
                    }
                });
            }
        }
        return table;
    }

    protected void exportDataCsv(List<TableInterface> response, ExportHelper helper) throws IOException {
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), this.reference(), false);
        for (TableInterface table : response) {
            if (table.hasName()) {
                printer.printLine(table.getName());
            }
            if (table.hasErrorMessage()) {
                printer.printLine(table.getErrorMessage());
            }
            if (table.getHeader() != null) {
                for (TableInterface.LineInterface line : table.getHeader()) {
                    printer.printHeader(this.toLine(line));
                }
            }
            if (table.getLines() == null) continue;
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(this.toLine(line));
            }
        }
        printer.flush();
        printer.close();
    }

    protected String[] toLine(TableInterface.LineInterface line) {
        ArrayList<String> row = new ArrayList<String>();
        if (line.hasCells()) {
            for (TableInterface.CellInterface cell : line.getCells()) {
                row.add(cell.toString());
                for (int i = 1; i < cell.getColSpan(); ++i) {
                    row.add("");
                }
            }
        }
        return row.toArray(new String[0]);
    }

    public static class Filter
    implements TableInterface.FilterInterface {
        ExportHelper iHelper;

        public Filter(ExportHelper helper) {
            this.iHelper = helper;
        }

        @Override
        public boolean hasParameter(String name) {
            return this.iHelper.getParameter(name) != null;
        }

        @Override
        public String getParameterValue(String name) {
            return this.iHelper.getParameter(name);
        }

        @Override
        public String getParameterValue(String name, String defaultValue) {
            String value = this.iHelper.getParameter(name);
            return value == null ? defaultValue : value;
        }
    }
}

