/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.util;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.hibernate.util.UniTimeCoreDatabaseUpdate;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.dao._RootDAO;

public abstract class DatabaseUpdate {
    protected static Log sLog = LogFactory.getLog(DatabaseUpdate.class);
    private Element iRoot = null;
    private String iDialectSQL = null;

    protected abstract String findDbUpdateFileName();

    protected abstract String versionParameterName();

    protected abstract String updateName();

    protected DatabaseUpdate(Document document) throws Exception {
        if (!"dbupdate".equals(document.getRootElement().getName())) {
            throw new Exception("Unknown format.");
        }
        this.iRoot = document.getRootElement();
    }

    protected DatabaseUpdate() throws Exception {
        Document document = null;
        String dbUpdateFile = this.findDbUpdateFileName();
        URL dbUpdateFileUrl = ApplicationProperties.class.getClassLoader().getResource(dbUpdateFile);
        if (dbUpdateFileUrl != null) {
            Debug.info("Reading " + URLDecoder.decode(dbUpdateFileUrl.getPath(), "UTF-8") + " ...");
            document = new SAXReader().read(dbUpdateFileUrl.openStream());
        } else if (new File(dbUpdateFile).exists()) {
            Debug.info("Reading " + dbUpdateFile + " ...");
            document = new SAXReader().read(new File(dbUpdateFile));
        }
        if (document == null) {
            sLog.error((Object)("Unable to execute " + this.updateName() + " database auto-update, reason: resource " + dbUpdateFile + " not found."));
            return;
        }
        if (!"dbupdate".equals(document.getRootElement().getName())) {
            throw new Exception("Unknown format.");
        }
        this.iRoot = document.getRootElement();
    }

    public int getVersion() {
        return Integer.parseInt(ApplicationConfig.getConfigValue(this.versionParameterName(), "0"));
    }

    public void performUpdate() {
        Element updateElement;
        int updateVersion;
        sLog.info((Object)("Current " + this.updateName() + " database version: " + this.getVersion()));
        String dialect = HibernateUtil.getConfiguration().getProperty("hibernate.dialect");
        Iterator i = this.iRoot.elementIterator("dialect");
        while (i.hasNext()) {
            Element dialectElement = (Element)i.next();
            if (!dialect.equals(dialectElement.getTextTrim())) continue;
            this.iDialectSQL = dialectElement.attributeValue("type");
        }
        if (this.iDialectSQL == null) {
            sLog.warn((Object)("Dialect " + dialect + " not recognized, falling back to mysql."));
            this.iDialectSQL = "mysql";
        }
        i = this.iRoot.elementIterator("update");
        while (i.hasNext() && ((updateVersion = Integer.parseInt((updateElement = (Element)i.next()).attributeValue("version"))) <= this.getVersion() || this.performUpdate(updateElement))) {
        }
        sLog.info((Object)("New " + this.updateName() + " database version: " + this.getVersion()));
    }

    public boolean performUpdate(Element updateElement) {
        int version = Integer.parseInt(updateElement.attributeValue("version"));
        Session hibSession = new _RootDAO().getSession();
        String schema = HibernateUtil.getConfiguration().getProperty("hibernate.default_schema");
        Transaction tx = null;
        Hashtable<String, String> variables = new Hashtable<String, String>();
        try {
            ApplicationConfig versionCfg;
            tx = hibSession.beginTransaction();
            sLog.info((Object)("  Performing " + this.updateName() + " update to version " + version + " (" + updateElement.attributeValue("comment") + ")"));
            Iterator i = updateElement.elementIterator();
            while (i.hasNext()) {
                Element queryElement = (Element)i.next();
                String type = queryElement.getName();
                String query = queryElement.getText().trim().replaceAll("%SCHEMA%", schema);
                for (Map.Entry entry : variables.entrySet()) {
                    query = query.replaceAll("%" + String.valueOf(entry.getKey()) + "%", entry.getValue().toString());
                }
                String condition = queryElement.attributeValue("condition", "none");
                String action = queryElement.attributeValue("action", "next");
                String value = queryElement.attributeValue("value");
                String into = queryElement.attributeValue("into");
                if (queryElement.attribute("onFail") != null) {
                    condition = "fail";
                    action = queryElement.attributeValue("onFail");
                }
                if (queryElement.attribute("onEqual") != null) {
                    condition = "equal";
                    action = queryElement.attributeValue("onEqual");
                }
                if (queryElement.attribute("onNotEqual") != null) {
                    condition = "notEqual";
                    action = queryElement.attributeValue("onNotEqual");
                }
                if (query.length() == 0) continue;
                try {
                    if (type.equals("hql") || type.equals("sql") || type.equals(this.iDialectSQL)) {
                        sLog.debug((Object)("  -- HQL: " + query + " (con:" + condition + ", act:" + action + ", val:" + value + ")"));
                        Query q = null;
                        try {
                            q = type.equals("hql") ? hibSession.createQuery(query) : hibSession.createNativeQuery(query);
                        }
                        catch (QueryException e) {
                            if (!"hql".equals(type)) {
                                final String sql = query;
                                hibSession.doWork(new Work(){

                                    public void execute(Connection connection) throws SQLException {
                                        Statement statement = connection.createStatement();
                                        int lines = statement.executeUpdate(sql);
                                        sLog.debug((Object)("  -- " + lines + " lines affected."));
                                        statement.close();
                                    }
                                });
                            }
                            throw e;
                        }
                        boolean ok = true;
                        if (into != null) {
                            variables.put(into, q.uniqueResult().toString());
                        } else if ("equal".equals(condition) && value != null) {
                            ok = value.equals(q.uniqueResult().toString());
                        } else if ("notEqual".equals(condition) && value != null) {
                            ok = !value.equals(q.uniqueResult().toString());
                        } else if (q != null) {
                            int lines = q.executeUpdate();
                            sLog.debug((Object)("  -- " + lines + " lines affected."));
                            if ("noChange".equals(condition)) {
                                ok = lines == 0;
                            } else if ("change".equals(condition)) {
                                boolean bl = ok = lines > 0;
                            }
                        }
                        if (!ok || "next".equals(action)) continue;
                        if ("done".equals(action)) break;
                        if (!"fail".equals(action)) continue;
                        sLog.error((Object)("Update to " + this.updateName() + " version " + version + " failed (condition not met for query '" + query + "', con:" + condition + ", act:" + action + ", val:" + value + ")."));
                        tx.rollback();
                        return false;
                    }
                    sLog.debug((Object)("  -- skip: " + query + " (con:" + condition + ", act:" + action + ", val:" + value + ")"));
                }
                catch (Exception e) {
                    sLog.warn((Object)("Query '" + query + "' failed, " + e.getMessage()), (Throwable)e);
                    if (e.getCause() != null && e.getCause().getMessage() != null) {
                        sLog.warn((Object)("Cause: " + e.getCause().getMessage()));
                    }
                    if ("fail".equals(condition)) {
                        if ("next".equals(action)) continue;
                        if ("done".equals(action)) break;
                    }
                    sLog.error((Object)("Update to version " + version + " failed."));
                    tx.rollback();
                    return false;
                }
            }
            if ((versionCfg = ApplicationConfig.getConfig(this.versionParameterName())) == null) {
                versionCfg = new ApplicationConfig(this.versionParameterName());
                versionCfg.setDescription("Timetabling " + this.updateName() + " DB version (do not change -- this is used by automatic database update)");
            }
            versionCfg.setValue(String.valueOf(version));
            hibSession.saveOrUpdate((Object)versionCfg);
            sLog.info((Object)("    " + this.updateName() + " Database version increased to: " + version));
            if (tx != null && tx.isActive()) {
                tx.commit();
            }
            HibernateUtil.clearCache();
            return true;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            sLog.error((Object)("Update to version " + version + " failed, reason:" + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static void update() {
        try {
            new UniTimeCoreDatabaseUpdate().performUpdate();
            String additionalUpdates = ApplicationProperty.DatabaseUpdateAddonClass.value();
            if (additionalUpdates != null && !additionalUpdates.trim().isEmpty()) {
                DatabaseUpdate du = (DatabaseUpdate)Class.forName(additionalUpdates).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                du.performUpdate();
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to execute database auto-update, reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }
}

