/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.activation.DataSource;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseAdvisor;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.dao.CourseDemandDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorConfirmationPDF;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.StudentEmailProvider;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CalendarExport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

public class StudentEmail
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private static GwtMessages GWT = Localization.create(GwtMessages.class);
    private Date iTimeStamp = new Date();
    private static Formats.Format<Date> sTimeStampFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private static Formats.Format<Date> sConsentApprovalDateFormat = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
    private String iSubject = MSG.emailDeafultSubject();
    private String iSubjectExt = null;
    private String iMessage = null;
    private String iCC = null;
    private static Hashtable<Long, String> sLastMessage = new Hashtable();
    private byte[] iTimetableImage = null;
    private byte[] iAdvisorRequestsPDF = null;
    private Long iStudentId;
    private XOffering iOldOffering;
    private XCourseId iOldCourseId;
    private XEnrollment iOldEnrollment;
    private XStudent iOldStudent;
    private XOffering iFailedOffering;
    private XCourseId iFailedCourseId;
    private XEnrollment iFailedEnrollment;
    private XEnrollment iDropEnrollment;
    private SectioningException iFailure;
    private XStudent iStudent;
    private CourseUrlProvider iCourseUrlProvider = null;
    private boolean iPermisionCheck = true;
    private boolean iIncludeCourseRequests = true;
    private boolean iIncludeClassSchedule = true;
    private boolean iIncludeAdvisorRequests = false;
    private boolean iIncludeAdvisorRequestsPDF = false;
    private Boolean iOptional = null;
    private String iSourceAction = "not-set";
    private SectioningRequest.ReschedulingReason iReason = null;
    private StudentSectioningStatus.NotificationType iNotificationType;
    private boolean iSkipWhenNoChange = false;
    private static String[] sColor1 = new String[]{"2952A3", "B1365F", "7A367A", "5229A3", "29527A", "1B887A", "28754E", "0D7813", "528800", "88880E", "AB8B00", "BE6D00", "B1440E", "865A5A", "705770", "4E5D6C", "5A6986", "4A716C", "6E6E41", "8D6F47"};
    private static String[] sColor2 = new String[]{"668CD9", "E67399", "B373B3", "8C66D9", "668CB3", "59BFB3", "65AD89", "4CB052", "8CBF40", "BFBF4D", "E0C240", "F2A640", "E6804D", "BE9494", "A992A9", "8997A5", "94A2bE", "85AAA5", "A7A77D", "C4A883"};

    public StudentEmail forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public StudentEmail forStudent(XStudent student) {
        this.iStudent = student;
        this.iStudentId = student.getStudentId();
        return this;
    }

    public StudentEmail fromAction(String actionName) {
        this.iSourceAction = actionName;
        return this;
    }

    public StudentEmail withType(StudentSectioningStatus.NotificationType notificationType) {
        this.iNotificationType = notificationType;
        return this;
    }

    public StudentEmail oldEnrollment(XOffering oldOffering, XCourseId oldCourseId, XEnrollment oldEnrollment) {
        this.iOldOffering = oldOffering;
        this.iOldCourseId = oldCourseId;
        this.iOldEnrollment = oldEnrollment;
        return this;
    }

    public StudentEmail oldStudent(XStudent oldStudent) {
        this.iOldStudent = oldStudent;
        return this;
    }

    public StudentEmail failedEnrollment(XOffering failedOffering, XCourseId failedCourseId, XEnrollment failedEnrollment, SectioningException failure) {
        this.iFailedOffering = failedOffering;
        this.iFailedCourseId = failedCourseId;
        this.iFailedEnrollment = failedEnrollment;
        this.iFailure = failure;
        return this;
    }

    public StudentEmail dropEnrollment(XEnrollment dropEnrollment) {
        this.iDropEnrollment = dropEnrollment;
        return this;
    }

    public StudentEmail overridePermissions(boolean courseRequests, boolean classSchedule, boolean advisorRequests) {
        this.iPermisionCheck = false;
        this.iIncludeCourseRequests = courseRequests;
        this.iIncludeClassSchedule = classSchedule;
        this.iIncludeAdvisorRequests = advisorRequests;
        return this;
    }

    public StudentEmail includeAdvisorRequestsPDF() {
        this.iIncludeAdvisorRequestsPDF = true;
        return this;
    }

    public StudentEmail setOptional(Boolean optional) {
        this.iOptional = optional;
        return this;
    }

    public StudentEmail rescheduling(SectioningRequest.ReschedulingReason reason) {
        this.iReason = reason;
        return this;
    }

    public StudentEmail skipWhenNoChange(boolean skipWhenNoChange) {
        this.iSkipWhenNoChange = skipWhenNoChange;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    private String getSubject() {
        return this.iSubject;
    }

    private void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getEmailSubject() {
        return this.iSubjectExt;
    }

    public void setEmailSubject(String subject) {
        this.iSubjectExt = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getCC() {
        return this.iCC;
    }

    public void setCC(String cc) {
        this.iCC = cc;
    }

    public XEnrollment getOldEnrollment() {
        return this.iOldEnrollment;
    }

    public XOffering getOldOffering() {
        return this.iOldOffering;
    }

    public XCourse getOldCourse() {
        return this.iOldOffering == null || this.iOldCourseId == null ? null : this.iOldOffering.getCourse(this.iOldCourseId);
    }

    public XStudent getOldStudent() {
        return this.iOldStudent;
    }

    public XEnrollment getFailedEnrollment() {
        return this.iFailedEnrollment;
    }

    public XOffering getFailedOffering() {
        return this.iFailedOffering;
    }

    public XCourse getFailedCourse() {
        return this.iFailedOffering == null || this.iFailedCourseId == null ? null : this.iFailedOffering.getCourse(this.iFailedCourseId);
    }

    public XEnrollment getDropEnrollment() {
        return this.iDropEnrollment;
    }

    public XStudent getStudent() {
        return this.iStudent;
    }

    public void setStudent(XStudent student) {
        this.iStudent = student;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean execute(final OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            String providerClass = ApplicationProperty.CustomizationCourseLink.value();
            if (providerClass != null) {
                this.iCourseUrlProvider = (CourseUrlProvider)Class.forName(providerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception providerClass) {
            // empty catch block
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            boolean bl;
            XStudent student;
            Object dropOffering;
            OnlineSectioningLog.Enrollment.Builder enrollment;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            if (this.getOldEnrollment() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XSection xSection : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(xSection, this.getOldEnrollment()));
                }
                if (this.getDropEnrollment() != null && !this.getDropEnrollment().getCourseId().equals(this.getOldCourse() == null ? null : this.getOldCourse().getCourseId()) && (dropOffering = server.getOffering(this.getDropEnrollment().getOfferingId())) != null) {
                    for (XSection section : ((XOffering)dropOffering).getSections(this.getDropEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(section, this.getDropEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            } else if (this.getOldStudent() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest xRequest : this.getOldStudent().getRequests()) {
                    XEnrollment e = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                    if (e == null) continue;
                    for (XSection xSection : server.getOffering(e.getOfferingId()).getSections(e)) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(xSection, e));
                    }
                }
                action.addEnrollment(enrollment);
            } else if (this.getDropEnrollment() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                dropOffering = server.getOffering(this.getDropEnrollment().getOfferingId());
                if (dropOffering != null) {
                    for (XSection section : ((XOffering)dropOffering).getSections(this.getDropEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(section, this.getDropEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            }
            if (this.getFailedEnrollment() != null) {
                enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
                for (XSection xSection : this.getFailedOffering().getSections(this.getFailedEnrollment())) {
                    enrollment.addSection(OnlineSectioningHelper.toProto(xSection, this.getFailedEnrollment()));
                }
                action.addEnrollment(enrollment);
            }
            XStudent xStudent = student = this.getStudent() != null ? this.getStudent() : server.getStudent(this.getStudentId());
            if (student == null) {
                dropOffering = false;
                return dropOffering;
            }
            this.setStudent(student);
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            OnlineSectioningLog.Enrollment.Builder enrollment2 = OnlineSectioningLog.Enrollment.newBuilder();
            enrollment2.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
            for (XRequest r : student.getRequests()) {
                action.addRequest(OnlineSectioningHelper.toProto(r));
                XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                if (e == null) continue;
                for (XSection section : server.getOffering(e.getOfferingId()).getSections(e)) {
                    enrollment2.addSection(OnlineSectioningHelper.toProto(section, e));
                }
            }
            action.addEnrollment(enrollment2);
            boolean bl2 = false;
            Student dbStudent = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (dbStudent != null && dbStudent.getEmail() != null && !dbStudent.getEmail().isEmpty()) {
                XCourseRequest cr;
                void var10_31;
                String string;
                action.getStudentBuilder().setName(helper.getStudentNameFormat().format(dbStudent));
                boolean emailEnabled = true;
                if (this.iPermisionCheck) {
                    StudentSectioningStatus studentSectioningStatus = dbStudent.getEffectiveStatus();
                    if (studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.email)) {
                        emailEnabled = false;
                    }
                    if (studentSectioningStatus != null && this.iNotificationType != null && !studentSectioningStatus.hasNotification(this.iNotificationType)) {
                        emailEnabled = false;
                    }
                    if (this.iIncludeClassSchedule && studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.enabled)) {
                        this.iIncludeClassSchedule = false;
                    }
                    if (this.iIncludeCourseRequests && studentSectioningStatus != null && !studentSectioningStatus.hasOption(StudentSectioningStatus.Option.registration)) {
                        this.iIncludeCourseRequests = false;
                    }
                    if (this.iIncludeClassSchedule && !ApplicationProperty.OnlineSchedulingEmailConfirmationOverride.isTrue(this.iSourceAction + ".classes", true)) {
                        this.iIncludeClassSchedule = false;
                    }
                    if (this.iIncludeCourseRequests && !ApplicationProperty.OnlineSchedulingEmailConfirmationOverride.isTrue(this.iSourceAction + ".requests", true)) {
                        this.iIncludeCourseRequests = false;
                    }
                } else {
                    emailEnabled = true;
                }
                String string2 = string = this.iFailedCourseId == null || this.iFailure == null || this.iFailure.getMessage().isEmpty() ? null : this.iFailure.getMessage();
                if (string != null && string.length() > 255) {
                    String string3 = string.substring(0, 252) + "...";
                }
                if (var10_31 != null) {
                    helper.logOption("failed-course", this.iFailedCourseId.getCourseName());
                    helper.logOption("failed-error", (String)var10_31);
                }
                if (emailEnabled && this.iFailure != null) {
                    String skipOnErrorMessage;
                    String skipOnErrorCodes = ApplicationProperty.OnlineSchedulingEmailSkipOnErrorCodes.value();
                    if (skipOnErrorCodes != null && !skipOnErrorCodes.isEmpty() && this.iFailure.hasErrors()) {
                        for (ClassAssignmentInterface.ErrorMessage em : this.iFailure.getErrors()) {
                            if (em.getCode() == null || !em.getCode().matches(skipOnErrorCodes)) continue;
                            helper.logOption("skip-on-error", em.toString());
                            emailEnabled = false;
                        }
                    }
                    if ((skipOnErrorMessage = ApplicationProperty.OnlineSchedulingEmailSkipOnErrorMessage.value()) != null && !skipOnErrorMessage.isEmpty() && this.iFailure.getMessage() != null && this.iFailure.getMessage().matches(skipOnErrorMessage)) {
                        helper.logOption("skip-on-error", this.iFailure.getMessage());
                        emailEnabled = false;
                    }
                }
                if (emailEnabled && var10_31 != null && (cr = student.getRequestForCourse(this.iFailedCourseId.getCourseId())) != null && var10_31.equals(cr.getEnrollmentMessage())) {
                    emailEnabled = false;
                    student.markFailedWaitList(this.iFailedCourseId);
                    server.update(student, false);
                }
                if (this.iSourceAction != null) {
                    helper.logOption("source-action", this.iSourceAction);
                }
                if (this.iNotificationType != null) {
                    helper.logOption("type", this.iNotificationType.name());
                }
                if (this.iSkipWhenNoChange) {
                    helper.logOption("skipWhenNoChange", "true");
                }
                if (emailEnabled) {
                    String html;
                    Boolean epPlainText;
                    StudentEmailProvider emailProvider = null;
                    if (Customization.StudentEmailProvider.hasProvider()) {
                        emailProvider = (StudentEmailProvider)Customization.StudentEmailProvider.getProvider();
                    }
                    boolean plainText = ApplicationProperty.OnlineSchedulingEmailPlainText.isTrue();
                    if (emailProvider != null && (epPlainText = emailProvider.isPlainText(server, helper, this.iOptional, this.iSourceAction)) != null) {
                        plainText = epPlainText;
                    }
                    if ((html = this.generateMessage(dbStudent, server, helper, plainText)) != null) {
                        String string4;
                        String additionalCC;
                        Email email = null;
                        email = emailProvider != null ? emailProvider.createEmail(server, helper, this.iOptional, this.iSourceAction) : Email.createEmail();
                        email.addRecipient(dbStudent.getEmail(), helper.getStudentNameFormat().format(dbStudent));
                        helper.logOption("recipient", dbStudent.getEmail());
                        String firstCarbonCopy = null;
                        if (this.getCC() != null && !this.getCC().isEmpty()) {
                            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                            StringTokenizer s = new StringTokenizer(this.getCC(), ",;\n");
                            while (s.hasMoreTokens()) {
                                void var18_40;
                                String string5 = s.nextToken().trim();
                                if (string5.isEmpty()) continue;
                                if (suffix != null && string5.indexOf(64) < 0) {
                                    String string6 = string5 + suffix;
                                }
                                try {
                                    new InternetAddress((String)var18_40, true);
                                }
                                catch (AddressException e) {
                                    helper.warn(GWT.badEmailAddress((String)var18_40, e.getMessage()));
                                    continue;
                                }
                                email.addRecipientCC((String)var18_40, null);
                                helper.logOption("cc", (String)var18_40);
                                if (firstCarbonCopy != null) continue;
                                firstCarbonCopy = var18_40;
                            }
                        }
                        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
                            email.setSubject(this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                            helper.logOption("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
                        } else {
                            email.setSubject(this.getSubject().replace("%session%", server.getAcademicSession().toString()));
                            helper.logOption("subject", this.getSubject().replace("%session%", server.getAcademicSession().toString()));
                        }
                        if (this.getMessage() != null && !this.getMessage().isEmpty()) {
                            helper.logOption("message", this.getMessage());
                        }
                        if (helper.getUser() != null && this.getOldOffering() == null && this.getOldStudent() == null) {
                            TimetableManager manager = (TimetableManager)helper.getHibSession().createQuery("from TimetableManager where externalUniqueId = :id", TimetableManager.class).setParameter("id", (Object)helper.getUser().getExternalId()).uniqueResult();
                            BaseAdvisor advisor = null;
                            if (manager == null || manager.getEmailAddress() == null) {
                                advisor = (Advisor)helper.getHibSession().createQuery("from Advisor where externalUniqueId = :externalId and session.uniqueId = :sessionId", Advisor.class).setParameter("externalId", (Object)helper.getUser().getExternalId()).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setMaxResults(1).uniqueResult();
                            }
                            if (manager != null && manager.getEmailAddress() != null) {
                                email.setReplyTo(manager.getEmailAddress(), helper.getInstructorNameFormat().format(manager));
                                helper.logOption("reply-to", helper.getInstructorNameFormat().format(manager) + " <" + manager.getEmailAddress() + ">");
                            } else if (advisor != null && advisor.getEmail() != null) {
                                email.setReplyTo(advisor.getEmail(), helper.getInstructorNameFormat().format((NameInterface)((Object)advisor)));
                                helper.logOption("reply-to", helper.getInstructorNameFormat().format((NameInterface)((Object)advisor)) + " <" + advisor.getEmail() + ">");
                            } else if (firstCarbonCopy != null) {
                                email.setReplyTo(firstCarbonCopy, null);
                                helper.logOption("reply-to", firstCarbonCopy);
                            }
                        }
                        if ((additionalCC = ApplicationProperty.OnlineSchedulingEmailCarbonCopy.value()) != null) {
                            String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                            for (String address : additionalCC.split("[\n,]")) {
                                Object cc = address.trim();
                                if (((String)cc).isEmpty()) continue;
                                if (suffix != null && ((String)cc).indexOf(64) < 0) {
                                    cc = (String)cc + (String)suffix;
                                }
                                email.addRecipientCC((String)cc, null);
                                helper.logOption("cc", (String)cc);
                            }
                        }
                        if (ApplicationProperty.OnlineSchedulingEmailCCAdvisors.isTrue(this.iSourceAction)) {
                            for (Advisor advisor : dbStudent.getAdvisors()) {
                                if (advisor.getEmail() == null || advisor.getEmail().isEmpty()) continue;
                                email.addRecipientCC(advisor.getEmail(), helper.getInstructorNameFormat().format(advisor));
                                helper.logOption("cc", advisor.getEmail());
                            }
                        }
                        final StringWriter buffer = new StringWriter();
                        if (ApplicationProperty.OnlineSchedulingEmailIncludeMessage.isTrue()) {
                            PrintWriter printWriter = new PrintWriter(buffer);
                            this.generateTimetable(printWriter, server, helper);
                            printWriter.flush();
                            printWriter.close();
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "message.html";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(html.replace("<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>", buffer.toString()).getBytes("UTF-8"));
                                }

                                public String getContentType() {
                                    return "text/html; charset=UTF-8";
                                }
                            });
                        }
                        if (this.iTimetableImage != null) {
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "timetable.png";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(StudentEmail.this.iTimetableImage);
                                }

                                public String getContentType() {
                                    return "image/png";
                                }
                            });
                        }
                        if (this.iAdvisorRequestsPDF != null) {
                            email.addAttachment(new DataSource(){

                                public OutputStream getOutputStream() throws IOException {
                                    throw new IOException("No output stream.");
                                }

                                public String getName() {
                                    return "recommendations-" + server.getAcademicSession().getTerm() + server.getAcademicSession().getYear() + "-" + student.getName().replaceAll("[&$\\+,/:;=\\?@<>\\[\\]\\{\\}\\|\\^\\~%#`\\t\\s\\n\\r \\\\]", "") + ".pdf";
                                }

                                public InputStream getInputStream() throws IOException {
                                    return new ByteArrayInputStream(StudentEmail.this.iAdvisorRequestsPDF);
                                }

                                public String getContentType() {
                                    return "application/pdf";
                                }
                            });
                        }
                        if (ApplicationProperty.OnlineSchedulingEmailICalendar.isTrue() && this.iIncludeClassSchedule) {
                            try {
                                final String string7 = CalendarExport.getCalendar(server, helper, student);
                                if (string7 != null) {
                                    email.addAttachment(new DataSource(){

                                        public OutputStream getOutputStream() throws IOException {
                                            throw new IOException("No output stream.");
                                        }

                                        public String getName() {
                                            return "timetable.ics";
                                        }

                                        public InputStream getInputStream() throws IOException {
                                            return new ByteArrayInputStream(string7.getBytes("UTF-8"));
                                        }

                                        public String getContentType() {
                                            return "text/calendar; charset=UTF-8";
                                        }
                                    });
                                }
                            }
                            catch (IOException iOException) {
                                helper.warn("Unable to create calendar for student " + student.getStudentId() + ":" + iOException.getMessage());
                            }
                        }
                        if ((string4 = sLastMessage.get(student.getStudentId())) != null) {
                            email.setInReplyTo(string4);
                        }
                        if (plainText) {
                            email.setText(html);
                        } else {
                            email.setHTML(html);
                        }
                        helper.logOption("email", html.replace("<img src='cid:timetable.png' border='0' alt='Timetable Image'/>", buffer.toString()));
                        email.send();
                        String messageId = email.getMessageId();
                        if (messageId != null) {
                            sLastMessage.put(student.getStudentId(), messageId);
                        }
                        Date ts = new Date();
                        dbStudent.setScheduleEmailedDate(ts);
                        student.setEmailTimeStamp(ts);
                        if (this.iFailedCourseId != null) {
                            XCourseRequest cr2;
                            student.markFailedWaitList(this.iFailedCourseId);
                            if (var10_31 != null && (cr2 = student.getRequestForCourse(this.iFailedCourseId.getCourseId())) != null) {
                                cr2.setEnrollmentMessage((String)var10_31);
                                CourseDemand cd = (CourseDemand)CourseDemandDAO.getInstance().get(cr2.getRequestId());
                                if (cd != null) {
                                    if (cd.getEnrollmentMessages() != null) {
                                        Iterator<StudentEnrollmentMessage> i = cd.getEnrollmentMessages().iterator();
                                        while (i.hasNext()) {
                                            StudentEnrollmentMessage message = i.next();
                                            helper.getHibSession().remove((Object)message);
                                            i.remove();
                                        }
                                    }
                                    StudentEnrollmentMessage m = new StudentEnrollmentMessage();
                                    m.setCourseDemand(cd);
                                    m.setLevel(0);
                                    m.setType(0);
                                    m.setTimestamp(ts);
                                    m.setMessage((String)var10_31);
                                    m.setOrder(0);
                                    cd.getEnrollmentMessages().add(m);
                                    helper.getHibSession().persist((Object)m);
                                }
                            }
                        }
                        helper.getHibSession().merge((Object)dbStudent);
                        helper.getHibSession().flush();
                        server.update(student, false);
                        bl = true;
                    } else if (this.iSkipWhenNoChange) {
                        helper.debug(MSG.emailNoChange());
                    } else {
                        helper.debug("Email notification failed to generate for student " + student.getName() + ".");
                    }
                } else {
                    helper.debug("Email notification is disabled for student " + student.getName() + ".");
                }
            } else {
                helper.debug("Student " + student.getName() + " has no email address on file.");
            }
            Boolean bl3 = bl;
            return bl3;
        }
        catch (Exception e) {
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "student-email";
    }

    protected URL getCourseUrl(AcademicSessionInfo session, XCourse course) {
        if (this.iCourseUrlProvider == null) {
            return null;
        }
        return this.iCourseUrlProvider.getCourseUrl(session, course.getSubjectArea(), course.getCourseNumber());
    }

    protected URL getCourseUrl(OnlineSectioningServer server, CourseRequestInterface.RequestedCourse rc) {
        if (this.iCourseUrlProvider == null || rc == null || !rc.hasCourseId()) {
            return null;
        }
        XCourse course = server.getCourse(rc.getCourseId());
        if (course == null) {
            return null;
        }
        return this.iCourseUrlProvider.getCourseUrl(server.getAcademicSession(), course.getSubjectArea(), course.getCourseNumber());
    }

    /*
     * WARNING - void declaration
     */
    private String generateMessage(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper, boolean plainText) throws IOException, TemplateException {
        CourseRequestInterface requests;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        cfg.setClassForTemplateLoading(StudentEmail.class, "/");
        cfg.setLocale(Localization.getJavaLocale());
        cfg.setOutputEncoding("utf-8");
        Template template = cfg.getTemplate(plainText ? ApplicationProperty.OnlineSchedulingEmailPlainTextTemplate.value() : ApplicationProperty.OnlineSchedulingEmailTemplate.value());
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("msg", MSG);
        input.put("student", this.getStudent());
        input.put("name", helper.getStudentNameFormat().format(student));
        input.put("server", server);
        input.put("helper", helper);
        input.put("message", this.getMessage());
        input.put("dfConsentApproval", sConsentApprovalDateFormat);
        input.put("source", this.iSourceAction);
        StudentSectioningStatus status = student.getEffectiveStatus();
        OnlineSectioningInterface.WaitListMode wlMode = OnlineSectioningInterface.WaitListMode.None;
        if (CustomStudentEnrollmentHolder.isAllowWaitListing() && (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist))) {
            wlMode = OnlineSectioningInterface.WaitListMode.WaitList;
        } else if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
            wlMode = OnlineSectioningInterface.WaitListMode.NoSubs;
        }
        input.put("wlMode", wlMode.name());
        String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(student.getSession());
        OnlineSectioningInterface.WaitListMode awlMode = OnlineSectioningInterface.WaitListMode.None;
        awlMode = "Student".equalsIgnoreCase(advWlMode) ? wlMode : OnlineSectioningInterface.WaitListMode.valueOf(advWlMode);
        input.put("awlMode", awlMode.name());
        if (this.iIncludeCourseRequests) {
            helper.getAction().clearRequest();
            requests = server.createAction(GetRequest.class).forStudent(student.getUniqueId()).withCustomValidation(status != null && status.hasOption(StudentSectioningStatus.Option.reqval)).withWaitListValidation(status != null && status.hasOption(StudentSectioningStatus.Option.specreg)).withCustomRequest(false).withAdvisorRequests(false).withWaitListMode(wlMode).execute(server, helper);
            input.put("requests", this.generateCourseRequests(student, requests, server, helper, wlMode));
        }
        if (this.iIncludeAdvisorRequests && (requests = server.createAction(AdvisorGetCourseRequests.class).forStudent(student.getUniqueId()).checkDemands(false).execute(server, helper)) != null && (!requests.isEmpty() || requests.hasCreditNote())) {
            input.put("advisor", this.generateAdvisorRequests(student, requests, server, helper, awlMode));
            String disclaimer = ApplicationProperty.AdvisorCourseRequestsPDFDisclaimer.value();
            if (disclaimer != null && !disclaimer.isEmpty()) {
                input.put("disclaimer", disclaimer);
            }
            if (this.iIncludeAdvisorRequestsPDF) {
                TimetableManager manager;
                OnlineSectioningInterface.AdvisingStudentDetails details = new OnlineSectioningInterface.AdvisingStudentDetails();
                details.setSessionId(server.getAcademicSession().getUniqueId());
                details.setStudentId(student.getUniqueId());
                details.setStudentName(student.getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
                details.setSessionName(student.getSession().getLabel());
                details.setWaitListMode(awlMode);
                Object advisor = Advisor.findByExternalId(helper.getUser().getExternalId(), server.getAcademicSession().getUniqueId());
                if (advisor != null) {
                    details.setAdvisorEmail(((BaseAdvisor)advisor).getEmail());
                }
                if (!details.hasAdvisorEmail()) {
                    BaseAdvisorCourseRequest lastAcr = null;
                    for (AdvisorCourseRequest advisorCourseRequest : student.getAdvisorCourseRequests()) {
                        if (lastAcr != null && !lastAcr.getTimestamp().before(advisorCourseRequest.getTimestamp())) continue;
                        lastAcr = advisorCourseRequest;
                    }
                    if (lastAcr != null && (advisor = Advisor.findByExternalId(lastAcr.getChangedBy(), server.getAcademicSession().getUniqueId())) != null) {
                        details.setAdvisorEmail(((BaseAdvisor)advisor).getEmail());
                    }
                }
                if (!details.hasAdvisorEmail()) {
                    String email = null;
                    for (Advisor advisor2 : student.getAdvisors()) {
                        if (advisor2.getEmail() == null || advisor2.getEmail().isEmpty()) continue;
                        email = (String)(email == null ? "" : email + "\n") + advisor2.getEmail();
                    }
                    details.setAdvisorEmail(email);
                }
                if (!details.hasAdvisorEmail() && (manager = TimetableManager.findByExternalId(helper.getUser().getExternalId())) != null) {
                    details.setAdvisorEmail(manager.getEmailAddress());
                }
                if (student.getSectioningStatus() != null) {
                    info = new OnlineSectioningInterface.StudentStatusInfo();
                    info.setUniqueId(student.getSectioningStatus().getUniqueId());
                    info.setReference(student.getSectioningStatus().getReference());
                    info.setLabel(student.getSectioningStatus().getLabel());
                    details.setStatus(info);
                } else if (student.getSession().getDefaultSectioningStatus() != null) {
                    info = new OnlineSectioningInterface.StudentStatusInfo();
                    info.setUniqueId(null);
                    info.setReference("");
                    info.setLabel(MSG.studentStatusSessionDefault(student.getSession().getDefaultSectioningStatus().getLabel()));
                    info.setEffectiveStart(null);
                    info.setEffectiveStop(null);
                    details.setStatus(info);
                } else {
                    info = new OnlineSectioningInterface.StudentStatusInfo();
                    info.setReference("");
                    info.setLabel(MSG.studentStatusSystemDefault());
                    info.setAllEnabled();
                    details.setStatus(info);
                }
                details.setRequest(requests);
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    new AdvisorConfirmationPDF(details).generatePdfConfirmation(bytes);
                    bytes.flush();
                    bytes.close();
                    this.iAdvisorRequestsPDF = bytes.toByteArray();
                }
                catch (Exception e) {
                    helper.error("Failed to generate PDF confirmation: " + e.getMessage(), e);
                }
            }
        }
        if (this.iIncludeClassSchedule) {
            Table classes = this.generateListOfClasses(student, server, helper, wlMode, plainText);
            input.put("classes", classes);
            float totalCredit = 0.0f;
            Pattern pattern = Pattern.compile("\\d+\\.?\\d*");
            for (TableLine line : classes) {
                Matcher matcher;
                String credit = line.getCredit();
                if (credit == null || !(matcher = pattern.matcher(credit)).find()) continue;
                totalCredit += Float.parseFloat(matcher.group());
            }
            input.put("credit", Float.valueOf(totalCredit));
            if (!this.getStudent().getRequests().isEmpty() && ApplicationProperty.OnlineSchedulingEmailIncludeImage.isTrue()) {
                try {
                    this.iTimetableImage = this.generateTimetableImage(server);
                }
                catch (Exception e) {
                    helper.error("Unable to create timetable image: " + e.getMessage(), e);
                    StringWriter buffer = new StringWriter();
                    PrintWriter out = new PrintWriter(buffer);
                    this.generateTimetable(out, server, helper);
                    out.flush();
                    out.close();
                    input.put("timetable", buffer.toString());
                }
                if (this.iTimetableImage != null) {
                    input.put("timetable", "<img src='cid:timetable.png' border='0' alt='Timetable Grid'/>");
                }
            }
        }
        if (this.iReason != null) {
            switch (this.iReason) {
                case CLASS_CANCELLED: {
                    input.put("reason", MSG.reschedulingReasonCancelledClass());
                    break;
                }
                case TIME_CONFLICT: {
                    input.put("reason", MSG.reschedulingReasonTimeConflict());
                    break;
                }
                case CLASS_LINK: {
                    input.put("reason", MSG.reschedulingReasonClassLink());
                    break;
                }
                case MISSING_CLASS: {
                    input.put("reason", MSG.reschedulingReasonMissingClass());
                    break;
                }
                case MULTIPLE_CONFIGS: {
                    input.put("reason", MSG.reschedulingReasonMultipleConfigs());
                    break;
                }
                case MULTIPLE_ENRLS: {
                    input.put("reason", MSG.reschedulingReasonMultipleClasses());
                    break;
                }
                case NO_REQUEST: {
                    input.put("reason", MSG.reschedulingReasonNoRequest());
                }
            }
        }
        AcademicSessionInfo session = server.getAcademicSession();
        if (this.getFailedOffering() != null) {
            Object requires;
            Object dropOffering;
            listOfChanges = new Table();
            newRequest = null;
            newOffering = null;
            XCourse xCourse = course = this.getFailedEnrollment() != null ? this.getFailedOffering().getCourse(this.getFailedEnrollment().getCourseId()) : this.getFailedCourse();
            if (course == null) {
                course = this.getFailedCourse() == null ? this.getFailedOffering().getControllingCourse() : this.getFailedCourse();
            }
            for (XRequest xRequest : this.getStudent().getRequests()) {
                if (!(xRequest instanceof XCourseRequest) || (this.getFailedCourse() != null || ((XCourseRequest)xRequest).getCourseIdByOfferingId(this.getFailedOffering().getOfferingId()) == null) && (this.getFailedCourse() == null || !((XCourseRequest)xRequest).hasCourse(this.getFailedCourse().getCourseId()))) continue;
                newRequest = (XCourseRequest)xRequest;
                newOffering = server.getOffering(this.getFailedOffering().getOfferingId());
                if (((XCourseRequest)newRequest).getEnrollment() == null) break;
                course = newOffering.getCourse(((XCourseRequest)newRequest).getEnrollment().getCourseId());
                break;
            }
            input.put("changedCourse", course);
            this.setSubject(MSG.emailEnrollmentFailed(course.getSubjectArea(), course.getCourseNumber(), this.iFailure == null ? null : this.iFailure.getMessage()));
            if (newRequest != null && ((XCourseRequest)newRequest).isWaitlist()) {
                this.setSubject(MSG.emailEnrollmentFailedWaitListed(course.getSubjectArea(), course.getCourseNumber()));
            }
            if (this.getDropEnrollment() != null && !this.getDropEnrollment().getCourseId().equals(this.getFailedCourse().getCourseId()) && (dropOffering = server.getOffering(this.getDropEnrollment().getOfferingId())) != null) {
                XCourse xCourse2 = ((XOffering)dropOffering).getCourse(this.getDropEnrollment().getCourseId());
                XCourseRequest dropRequest = this.getStudent().getRequestForCourse(xCourse2.getCourseId());
                for (XSection old : ((XOffering)dropOffering).getSections(this.getDropEnrollment())) {
                    XSubpart subpart = ((XOffering)dropOffering).getSubpart(old.getSubpartId());
                    XSection parent = old.getParentId() == null ? null : ((XOffering)dropOffering).getSection(old.getParentId());
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(xCourse2.getCourseId());
                    }
                    listOfChanges.add(new TableSectionDeletedLine(dropRequest, xCourse2, subpart, old, (String)requires, this.getCourseUrl(session, xCourse2), plainText));
                }
            }
            if (this.getFailedEnrollment() != null && (newRequest == null || ((XCourseRequest)newRequest).getEnrollment() == null)) {
                for (XSection xSection : this.getFailedOffering().getSections(this.getFailedEnrollment())) {
                    XSection parent = xSection.getParentId() == null ? null : this.getFailedOffering().getSection(xSection.getParentId());
                    subpart = this.getFailedOffering().getSubpart(xSection.getSubpartId());
                    requires = null;
                    requires = parent != null ? parent.getName(course.getCourseId()) : null;
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, xSection, requires, this.getCourseUrl(session, course), plainText));
                }
                input.put("changes", listOfChanges);
            } else if (this.getFailedEnrollment() != null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                Object consent = this.consent(server, ((XCourseRequest)newRequest).getEnrollment());
                block19: for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                    parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart = newOffering.getSubpart(section.getSubpartId());
                    for (XSection failed : this.getFailedOffering().getSections(this.getFailedEnrollment())) {
                        if (!failed.getSubpartId().equals(section.getSubpartId())) continue;
                        requires = null;
                        if (parent != null) {
                            requires = ((XSection)parent).getName(course.getCourseId());
                        }
                        XSubpart failedSubpart = this.getFailedOffering().getSubpart(failed.getSubpartId());
                        XSection failedParent = failed.getParentId() == null ? null : this.getFailedOffering().getSection(failed.getParentId());
                        Object failedRequires = null;
                        if (failedParent != null) {
                            failedRequires = failedParent.getName(course.getCourseId());
                        }
                        if (failedRequires == null && requires == null) {
                            requires = consent;
                            failedRequires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionModifiedLine((XCourseRequest)newRequest, course, subpart, failedSubpart, section, failed, (String)requires, (String)failedRequires, this.getCourseUrl(session, course), plainText));
                        continue block19;
                    }
                    Object requires2 = null;
                    if (parent != null) {
                        requires2 = ((XSection)parent).getName(course.getCourseId());
                    } else {
                        requires2 = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, course, subpart, section, (String)requires2, this.getCourseUrl(session, course), plainText));
                }
                block21: for (XSection failed : this.getFailedOffering().getSections(this.getFailedEnrollment())) {
                    for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                        if (!failed.getSubpartId().equals(section.getSubpartId())) continue;
                        continue block21;
                    }
                    subpart = this.getFailedOffering().getSubpart(failed.getSubpartId());
                    XSection parent = failed.getParentId() == null ? null : this.getFailedOffering().getSection(failed.getParentId());
                    String requires2 = null;
                    if (parent != null) {
                        requires2 = parent.getName(course.getCourseId());
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart, failed, requires2, this.getCourseUrl(session, course), plainText));
                }
                input.put("changes", listOfChanges);
            } else {
                if (this.getOldOffering() != null && this.getOldEnrollment() != null) {
                    for (XSection xSection : this.getOldOffering().getSections(this.getOldEnrollment())) {
                        XSubpart subpart = this.getOldOffering().getSubpart(xSection.getSubpartId());
                        parent = xSection.getParentId() == null ? null : this.getOldOffering().getSection(xSection.getParentId());
                        requires = null;
                        if (parent != null) {
                            requires = ((XSection)parent).getName(course.getCourseId());
                        }
                        listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, course, subpart, xSection, requires, this.getCourseUrl(session, course), plainText));
                    }
                    input.put("changes", listOfChanges);
                }
                this.setSubject(MSG.emailDropFailed(course.getSubjectArea(), course.getCourseNumber(), this.iFailure == null ? null : this.iFailure.getMessage()));
            }
            if (this.iFailure != null) {
                Object message = MSG.emailEnrollmentFailedMessage(this.iFailure.getMessage());
                if (this.iFailure.hasErrors()) {
                    for (ClassAssignmentInterface.ErrorMessage error : this.iFailure.getErrors()) {
                        message = (String)message + "<br>" + String.valueOf(error);
                    }
                }
                input.put("changeMessage", message);
            }
        } else if (this.getOldOffering() != null) {
            String requires;
            Object subpart;
            XOffering xOffering;
            listOfChanges = new Table();
            newRequest = null;
            newOffering = null;
            XCourse oldCourse = course = this.getOldEnrollment() != null ? this.getOldOffering().getCourse(this.getOldEnrollment().getCourseId()) : this.getOldCourse();
            for (XRequest r : this.getStudent().getRequests()) {
                if (!(r instanceof XCourseRequest) || (this.getOldCourse() != null || ((XCourseRequest)r).getCourseIdByOfferingId(this.getOldOffering().getOfferingId()) == null) && (this.getOldCourse() == null || !((XCourseRequest)r).hasCourse(this.getOldCourse().getCourseId()))) continue;
                newRequest = (XCourseRequest)r;
                if (((XCourseRequest)newRequest).getEnrollment() != null) {
                    newOffering = server.getOffering(((XCourseRequest)newRequest).getEnrollment().getOfferingId());
                    course = newOffering.getCourse(((XCourseRequest)newRequest).getEnrollment().getCourseId());
                    break;
                }
                newOffering = server.getOffering(this.getOldOffering().getOfferingId());
                break;
            }
            input.put("changedCourse", course);
            if (this.getDropEnrollment() != null && !course.equals(this.getDropEnrollment()) && (xOffering = server.getOffering(this.getDropEnrollment().getOfferingId())) != null) {
                XCourse dropCourse = xOffering.getCourse(this.getDropEnrollment().getCourseId());
                XCourseRequest dropRequest = this.getStudent().getRequestForCourse(dropCourse.getCourseId());
                for (XSection old : xOffering.getSections(this.getDropEnrollment())) {
                    subpart = xOffering.getSubpart(old.getSubpartId());
                    XSection parent = old.getParentId() == null ? null : xOffering.getSection(old.getParentId());
                    requires = null;
                    if (parent != null) {
                        requires = parent.getName(dropCourse.getCourseId());
                    }
                    listOfChanges.add(new TableSectionDeletedLine(dropRequest, dropCourse, (XSubpart)subpart, old, requires, this.getCourseUrl(session, dropCourse), plainText));
                }
            }
            if (this.getOldEnrollment() == null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                this.setSubject(MSG.emailEnrollmentNew(course.getSubjectArea(), course.getCourseNumber()));
                XEnrollment xEnrollment = ((XCourseRequest)newRequest).getEnrollment();
                Iterator<XSection> consent = this.consent(server, xEnrollment);
                for (XSection section : newOffering.getSections(xEnrollment)) {
                    parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    subpart = newOffering.getSubpart(section.getSubpartId());
                    Object requires3 = null;
                    if (parent != null) {
                        requires3 = parent.getName(course.getCourseId());
                    } else {
                        requires3 = consent;
                        consent = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, (XSubpart)subpart, section, (String)requires3, this.getCourseUrl(session, course), plainText));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && newRequest != null && ((XCourseRequest)newRequest).getEnrollment() != null) {
                if (oldCourse.equals(course)) {
                    this.setSubject(MSG.emailEnrollmentChanged(course.getSubjectArea(), course.getCourseNumber()));
                } else {
                    this.setSubject(MSG.emailEnrollmentNew(course.getSubjectArea(), course.getCourseNumber()));
                }
                String string = this.consent(server, ((XCourseRequest)newRequest).getEnrollment());
                block28: for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                    void var18_45;
                    parent = section.getParentId() == null ? null : newOffering.getSection(section.getParentId());
                    XSubpart subpart2 = newOffering.getSubpart(section.getSubpartId());
                    for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        requires = null;
                        if (parent != null) {
                            requires = ((XSection)parent).getName(course.getCourseId());
                        }
                        XSubpart oldSubpart = this.getOldOffering().getSubpart(old.getSubpartId());
                        XSection oldParent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                        String oldRequires = null;
                        if (oldParent != null) {
                            oldRequires = oldParent.getName(course.getCourseId());
                        }
                        if (oldRequires == null && requires == null) {
                            requires = var18_45;
                            oldRequires = var18_45;
                            Object var18_46 = null;
                        }
                        listOfChanges.add(new TableSectionModifiedLine((XCourseRequest)newRequest, course, oldSubpart, subpart2, old, section, oldRequires, requires, this.getCourseUrl(session, course), plainText));
                        continue block28;
                    }
                    String requires4 = null;
                    if (parent != null) {
                        requires4 = ((XSection)parent).getName(course.getCourseId());
                    } else {
                        requires4 = var18_45;
                        Object var18_47 = null;
                    }
                    listOfChanges.add(new TableSectionLine((XCourseRequest)newRequest, course, subpart2, section, requires4, this.getCourseUrl(session, course), plainText));
                }
                block30: for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                    for (XSection section : newOffering.getSections(((XCourseRequest)newRequest).getEnrollment())) {
                        if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                        continue block30;
                    }
                    XSubpart subpart3 = this.getOldOffering().getSubpart(old.getSubpartId());
                    parent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                    String requires3 = null;
                    if (parent != null) {
                        requires3 = parent.getName(oldCourse.getCourseId());
                    }
                    listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, oldCourse, subpart3, old, requires3, this.getCourseUrl(session, course), plainText));
                }
                input.put("changes", listOfChanges);
            } else if (this.getOldEnrollment() != null && (newRequest == null || ((XCourseRequest)newRequest).getEnrollment() == null)) {
                this.setSubject(newRequest == null ? MSG.emailCourseDropReject(course.getSubjectArea(), course.getCourseNumber()) : MSG.emailCourseDropChange(course.getSubjectArea(), course.getCourseNumber()));
                if (newRequest != null && this.getStudent().canAssign((XCourseRequest)newRequest, wlMode)) {
                    input.put("changeMessage", ((XRequest)newRequest).isAlternative() ? (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListedAlternative() : MSG.emailCourseNotEnrolledAlternative()) : (((XCourseRequest)newRequest).isWaitlist() ? MSG.emailCourseWaitListed() : MSG.emailCourseNotEnrolled()));
                } else if (newRequest == null && course.getConsentLabel() != null) {
                    input.put("changeMessage", MSG.emailConsentRejected(course.getConsentLabel().toLowerCase()));
                }
                if (this.getOldOffering() != null && this.getOldEnrollment() != null) {
                    for (XSection old : this.getOldOffering().getSections(this.getOldEnrollment())) {
                        XSubpart subpart4 = this.getOldOffering().getSubpart(old.getSubpartId());
                        parent = old.getParentId() == null ? null : this.getOldOffering().getSection(old.getParentId());
                        String requires5 = null;
                        if (parent != null) {
                            requires5 = ((XSection)parent).getName(course.getCourseId());
                        }
                        listOfChanges.add(new TableSectionDeletedLine((XCourseRequest)newRequest, course, subpart4, old, requires5, this.getCourseUrl(session, course), plainText));
                    }
                    input.put("changes", listOfChanges);
                }
            }
        } else if (this.getOldStudent() != null) {
            boolean somethingWasOrIsAssigned = false;
            for (XRequest or : this.getOldStudent().getRequests()) {
                if (!(or instanceof XCourseRequest) || ((XCourseRequest)or).getEnrollment() == null) continue;
                somethingWasOrIsAssigned = true;
                break;
            }
            if (!this.iIncludeClassSchedule) {
                for (XRequest nr : this.getStudent().getRequests()) {
                    if (!(nr instanceof XCourseRequest) || ((XCourseRequest)nr).getEnrollment() == null) continue;
                    somethingWasOrIsAssigned = true;
                    break;
                }
            }
            if (somethingWasOrIsAssigned) {
                XCourse course;
                Table listOfChanges = new Table();
                block35: for (XRequest nr : this.getStudent().getRequests()) {
                    if (nr instanceof XFreeTimeRequest) continue;
                    XCourseRequest ncr = (XCourseRequest)nr;
                    for (XRequest or : this.getOldStudent().getRequests()) {
                        String requires;
                        XSection parent;
                        Object subpart;
                        if (or instanceof XFreeTimeRequest) continue;
                        XCourseRequest ocr = (XCourseRequest)or;
                        if (!or.getRequestId().equals(nr.getRequestId())) continue;
                        if (ocr.getEnrollment() == null) {
                            if (ncr.getEnrollment() == null) continue;
                            String consent = this.consent(server, ncr.getEnrollment());
                            XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                            XCourse course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                XSubpart subpart5 = no.getSubpart(section.getSubpartId());
                                XSection parent2 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires6 = null;
                                if (parent2 != null) {
                                    requires6 = parent2.getName(course2.getCourseId());
                                } else {
                                    requires6 = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionLine(ncr, course2, subpart5, section, requires6, this.getCourseUrl(session, course2), plainText));
                            }
                            continue block35;
                        }
                        if (ncr.getEnrollment() == null) {
                            XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                            XCourse course3 = oo.getCourse(ocr.getEnrollment().getCourseId());
                            for (XSection section : oo.getSections(ocr.getEnrollment())) {
                                Iterator<XSection> subpart6 = oo.getSubpart(section.getSubpartId());
                                XSection parent3 = section.getParentId() == null ? null : oo.getSection(section.getParentId());
                                Object requires7 = null;
                                if (parent3 != null) {
                                    requires7 = parent3.getName(course3.getCourseId());
                                }
                                listOfChanges.add(new TableSectionDeletedLine(ncr, course3, (XSubpart)((Object)subpart6), section, (String)requires7, this.getCourseUrl(session, course3), plainText));
                            }
                            continue block35;
                        }
                        XOffering no = server.getOffering(ncr.getEnrollment().getOfferingId());
                        XOffering oo = server.getOffering(ocr.getEnrollment().getOfferingId());
                        XCourse course2 = no.getCourse(ncr.getEnrollment().getCourseId());
                        String consent = this.consent(server, ncr.getEnrollment());
                        block39: for (XSection section : no.getSections(ncr.getEnrollment())) {
                            for (XSection old : oo.getSections(ocr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                if (StudentEmail.equals(section, old)) continue block39;
                                XSubpart subpart7 = no.getSubpart(section.getSubpartId());
                                XSection parent4 = section.getParentId() == null ? null : no.getSection(section.getParentId());
                                String requires8 = null;
                                if (parent4 != null) {
                                    requires8 = parent4.getName(course2.getCourseId());
                                }
                                XSubpart oldSubpart = oo.getSubpart(old.getSubpartId());
                                XSection oldParent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                                String oldRequires = null;
                                if (oldParent != null) {
                                    oldRequires = oldParent.getName(course2.getCourseId());
                                }
                                if (oldRequires == null && requires8 == null) {
                                    requires8 = consent;
                                    oldRequires = consent;
                                    consent = null;
                                }
                                listOfChanges.add(new TableSectionModifiedLine(ncr, course2, oldSubpart, subpart7, old, section, oldRequires, requires8, this.getCourseUrl(session, course2), plainText));
                                continue block39;
                            }
                            subpart = no.getSubpart(section.getSubpartId());
                            parent = section.getParentId() == null ? null : no.getSection(section.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(course2.getCourseId());
                            } else {
                                requires = consent;
                                consent = null;
                            }
                            listOfChanges.add(new TableSectionLine(ncr, course2, (XSubpart)subpart, section, requires, this.getCourseUrl(session, course2), plainText));
                        }
                        course2 = oo.getCourse(ocr.getEnrollment().getCourseId());
                        block41: for (XSection old : oo.getSections(ocr.getEnrollment())) {
                            for (XSection section : no.getSections(ncr.getEnrollment())) {
                                if (!old.getSubpartId().equals(section.getSubpartId())) continue;
                                continue block41;
                            }
                            subpart = oo.getSubpart(old.getSubpartId());
                            parent = old.getParentId() == null ? null : oo.getSection(old.getParentId());
                            requires = null;
                            if (parent != null) {
                                requires = parent.getName(course2.getCourseId());
                            }
                            listOfChanges.add(new TableSectionDeletedLine(ocr, course2, (XSubpart)subpart, old, requires, this.getCourseUrl(session, course2), plainText));
                        }
                        continue block35;
                    }
                    if (ncr.getEnrollment() == null) continue;
                    XOffering xOffering = server.getOffering(ncr.getEnrollment().getOfferingId());
                    course = xOffering.getCourse(ncr.getEnrollment().getCourseId());
                    String consent = this.consent(server, ncr.getEnrollment());
                    for (XSection section : xOffering.getSections(ncr.getEnrollment())) {
                        XSubpart subpart = xOffering.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : xOffering.getSection(section.getParentId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfChanges.add(new TableSectionLine(ncr, course, subpart, section, requires, this.getCourseUrl(session, course), plainText));
                    }
                }
                block44: for (XRequest or : this.getOldStudent().getRequests()) {
                    if (or instanceof XFreeTimeRequest || ((XCourseRequest)or).getEnrollment() == null) continue;
                    for (XRequest xRequest : this.getStudent().getRequests()) {
                        if (or instanceof XFreeTimeRequest || !or.getRequestId().equals(xRequest.getRequestId())) continue;
                        continue block44;
                    }
                    XCourseRequest ocr = (XCourseRequest)or;
                    XOffering xOffering = server.getOffering(ocr.getEnrollment().getOfferingId());
                    course = xOffering.getCourse(ocr.getEnrollment().getCourseId());
                    for (XSection section : xOffering.getSections(((XCourseRequest)or).getEnrollment())) {
                        XSubpart subpart = xOffering.getSubpart(section.getSubpartId());
                        XSection parent = section.getParentId() == null ? null : xOffering.getSection(section.getParentId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        }
                        listOfChanges.add(new TableSectionDeletedLine(ocr, course, subpart, section, requires, this.getCourseUrl(session, course), plainText));
                    }
                }
                if (this.iSkipWhenNoChange && listOfChanges.isEmpty()) {
                    return null;
                }
                input.put("changes", listOfChanges);
            } else {
                if (this.iSkipWhenNoChange) {
                    return null;
                }
                if (this.iIncludeClassSchedule) {
                    this.setSubject(MSG.emailSubjectNotificationClassSchedule());
                } else if (this.iIncludeCourseRequests) {
                    this.setSubject(MSG.emailSubjectNotificationCourseRequests());
                } else {
                    this.setSubject(MSG.emailSubjectNotification());
                }
            }
        } else if (this.iIncludeClassSchedule) {
            this.setSubject(MSG.emailSubjectNotificationClassSchedule());
        } else if (this.iIncludeCourseRequests) {
            this.setSubject(MSG.emailSubjectNotificationCourseRequests());
        } else {
            this.setSubject(MSG.emailSubjectNotification());
        }
        if (this.getEmailSubject() != null && !this.getEmailSubject().isEmpty()) {
            input.put("subject", this.getEmailSubject().replace("%session%", server.getAcademicSession().toString()));
        } else if (this.getSubject() != null && !this.getSubject().isEmpty()) {
            input.put("subject", this.getSubject().replace("%session%", server.getAcademicSession().toString()));
        }
        if (!this.iPermisionCheck) {
            input.put("manager", true);
        } else if ("not-set".equals(this.iSourceAction) || "enroll".equals(this.iSourceAction) || "advisor-submit".equals(this.iSourceAction) || "mass-cancel".equals(this.iSourceAction) || "reject-enrollments".equals(this.iSourceAction) || "approve-enrollments".equals(this.iSourceAction) || "save-request".equals(this.iSourceAction)) {
            input.put("manager", helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER);
        } else {
            input.put("manager", false);
        }
        input.put("changed", this.getOldEnrollment() != null || this.getOldStudent() != null);
        input.put("version", GWT.unitimeVersion(Constants.getVersion()));
        input.put("copyright", GWT.pageCopyright());
        input.put("ts", sTimeStampFormat.format(this.getTimeStamp()));
        if (ApplicationProperty.OnlineSchedulingEmailIncludeLink.isTrue()) {
            input.put("link", ApplicationProperty.UniTimeUrl.value());
        }
        StringWriter s = new StringWriter();
        template.process(input, (Writer)new PrintWriter(s));
        s.flush();
        s.close();
        return s.toString();
    }

    CourseRequestsTable generateCourseRequests(Student student, CourseRequestInterface requests, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.WaitListMode wlMode) {
        Object free;
        CourseRequestLine line;
        CourseRequestLine line2;
        Object note;
        String credit;
        String status;
        AbstractCollection prefs;
        Object msg;
        Object iconText;
        String icon;
        Object firstChoice;
        int idx;
        boolean first;
        if (requests.getWaitListMode() == null) {
            requests.setWaitListMode(wlMode);
        }
        Set<Long> advisorWaitListedCourseIds = this.iStudent == null ? null : this.iStudent.getAdvisorWaitListedCourseIds(server);
        CourseRequestsTable courseRequests = new CourseRequestsTable();
        Formats.Format<Number> df = Formats.getNumberFormat("0.#");
        CourseRequestInterface.CheckCoursesResponse check = new CourseRequestInterface.CheckCoursesResponse(requests.getConfirmations());
        courseRequests.hasWarn = requests.hasConfirmations();
        int priority = 1;
        for (CourseRequestInterface.Request request : requests.getCourses()) {
            if (!request.hasRequestedCourse()) continue;
            first = true;
            idx = 0;
            firstChoice = null;
            if (request.isWaitlistOrNoSub(wlMode)) {
                courseRequests.hasWait = true;
            }
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isCourse()) {
                    icon = null;
                    iconText = null;
                    msg = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                        icon = "stop.png";
                        iconText = msg;
                    } else if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                icon = "login.png";
                                iconText = MSG.enrolled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NEEDED: {
                                icon = "attention.png";
                                iconText = MSG.overrideNeeded((String)msg);
                                break;
                            }
                            case SAVED: {
                                icon = "action_check.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.requested(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                icon = "stop.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideRejected(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                icon = "time.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overridePending(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                icon = "attention.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideCancelled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                icon = "action_check.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideApproved(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NOT_NEEDED: {
                                icon = "action_check_gray.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideNotNeeded(rc.getCourseName());
                                break;
                            }
                            case WAITLIST_INACTIVE: {
                                icon = "action_check_gray.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.waitListInactive(rc.getCourseName());
                                break;
                            }
                            default: {
                                if (check.isError(rc.getCourseName())) {
                                    icon = "stop.png";
                                }
                                iconText = msg;
                            }
                        }
                    }
                    if (rc.hasStatusNote()) {
                        iconText = (String)iconText + "\n" + MSG.overrideNote(rc.getStatusNote());
                    }
                    prefs = null;
                    if (rc.hasSelectedIntructionalMethods()) {
                        if (rc.hasSelectedClasses()) {
                            prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                        }
                    } else if (rc.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                    }
                    status = "";
                    if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                status = MSG.reqStatusEnrolled();
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                status = MSG.reqStatusApproved();
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                status = MSG.reqStatusCancelled();
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                status = MSG.reqStatusPending();
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                status = MSG.reqStatusRejected();
                                break;
                            }
                            case OVERRIDE_NOT_NEEDED: {
                                status = MSG.reqStatusNotNeeded();
                            }
                        }
                    }
                    if (status.isEmpty()) {
                        status = request.isWaitList() ? MSG.reqStatusWaitListed() : MSG.reqStatusRegistered();
                    }
                    if (prefs != null) {
                        courseRequests.hasPref = true;
                    }
                    credit = rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format(rc.getCreditMin()) : df.format(rc.getCreditMin()) + " - " + df.format(rc.getCreditMax())) : "";
                    note = null;
                    if (check != null) {
                        note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                    }
                    if (rc.hasStatusNote()) {
                        note = (String)(note == null ? "" : note + "<br>") + rc.getStatusNote();
                    }
                    line2 = new CourseRequestLine();
                    line2.priority = first ? MSG.courseRequestsPriority(priority) : "";
                    line2.courseName = rc.getCourseName();
                    line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                    line2.url = this.getCourseUrl(server, rc);
                    line2.credit = credit;
                    line2.prefs = StudentEmail.toString(prefs);
                    line2.note = note;
                    line2.icon = icon;
                    line2.iconText = iconText;
                    line2.status = status;
                    boolean bl = line2.waitlist = first && request.isWaitlistOrNoSub(wlMode);
                    if (first && request.isWaitList() && wlMode == OnlineSectioningInterface.WaitListMode.WaitList && request.getWaitListedTimeStamp() != null) {
                        line2.waitListDate = sTimeStampFormat.format(request.getWaitListedTimeStamp());
                    }
                    line2.first = priority > 1 && first;
                    line2.idx = idx;
                    if (firstChoice == null) {
                        firstChoice = rc.getCourseName();
                    }
                    line2.firstChoice = firstChoice;
                    courseRequests.add(line2);
                } else if (rc.isFreeTime()) {
                    line = new CourseRequestLine();
                    free = "";
                    for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                        if (!((String)free).isEmpty()) {
                            free = (String)free + ", ";
                        }
                        free = (String)free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                    }
                    Object note2 = null;
                    line.priority = first ? MSG.courseRequestsPriority(priority) : "";
                    line.courseName = CONST.freePrefix() + (String)free;
                    line.courseTitle = "";
                    line.credit = "";
                    line.prefs = "";
                    line.note = note2;
                    line.icon = "action_check.png";
                    line.iconText = MSG.requested((String)free);
                    line.status = MSG.reqStatusRegistered();
                    line.waitlist = false;
                    line.first = priority > 1 && first;
                    line.idx = idx;
                    if (firstChoice == null) {
                        firstChoice = CONST.freePrefix() + (String)free;
                    }
                    line.firstChoice = firstChoice;
                    courseRequests.add(line);
                }
                first = false;
                ++idx;
            }
            ++priority;
        }
        priority = 1;
        for (CourseRequestInterface.Request request : requests.getAlternatives()) {
            if (!request.hasRequestedCourse()) continue;
            first = true;
            idx = 0;
            firstChoice = null;
            if (request.isWaitlistOrNoSub(wlMode)) {
                courseRequests.hasWait = true;
            }
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isCourse()) {
                    icon = null;
                    iconText = null;
                    msg = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                    if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                        icon = "stop.png";
                        iconText = msg;
                    } else if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                icon = "login.png";
                                iconText = MSG.enrolled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NEEDED: {
                                icon = "attention.png";
                                iconText = MSG.overrideNeeded((String)msg);
                                break;
                            }
                            case SAVED: {
                                icon = "action_check.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.requested(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                icon = "stop.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideRejected(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                icon = "time.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overridePending(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                icon = "attention.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideCancelled(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                icon = "action_check.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideApproved(rc.getCourseName());
                                break;
                            }
                            case OVERRIDE_NOT_NEEDED: {
                                icon = "action_check_gray.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.overrideNotNeeded(rc.getCourseName());
                                break;
                            }
                            case WAITLIST_INACTIVE: {
                                icon = "action_check_gray.png";
                                iconText = (String)(msg == null ? "" : MSG.requestWarnings((String)msg) + "\n\n") + MSG.waitListInactive(rc.getCourseName());
                                break;
                            }
                            default: {
                                if (check.isError(rc.getCourseName())) {
                                    icon = "stop.png";
                                }
                                iconText = msg;
                            }
                        }
                    }
                    if (rc.hasStatusNote()) {
                        iconText = (String)iconText + "\n" + MSG.overrideNote(rc.getStatusNote());
                    }
                    prefs = null;
                    if (rc.hasSelectedIntructionalMethods()) {
                        if (rc.hasSelectedClasses()) {
                            prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                        }
                    } else if (rc.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                    }
                    status = "";
                    if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case ENROLLED: {
                                status = MSG.reqStatusEnrolled();
                                break;
                            }
                            case OVERRIDE_APPROVED: {
                                status = MSG.reqStatusApproved();
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                status = MSG.reqStatusCancelled();
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                status = MSG.reqStatusPending();
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                status = MSG.reqStatusRejected();
                                break;
                            }
                            case OVERRIDE_NOT_NEEDED: {
                                status = MSG.reqStatusNotNeeded();
                            }
                        }
                    }
                    if (status.isEmpty()) {
                        status = MSG.reqStatusRegistered();
                    }
                    if (prefs != null) {
                        courseRequests.hasPref = true;
                    }
                    credit = rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format(rc.getCreditMin()) : df.format(rc.getCreditMin()) + " - " + df.format(rc.getCreditMax())) : "";
                    note = null;
                    if (check != null) {
                        note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                    }
                    if (rc.hasStatusNote()) {
                        note = (String)(note == null ? "" : (String)note + "<br>") + rc.getStatusNote();
                    }
                    line2 = new CourseRequestLine();
                    line2.priority = first ? MSG.courseRequestsAlternate(priority) : "";
                    line2.courseName = rc.getCourseName();
                    line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                    line2.url = this.getCourseUrl(server, rc);
                    line2.credit = credit;
                    line2.prefs = StudentEmail.toString(prefs);
                    line2.note = note;
                    line2.icon = icon;
                    line2.iconText = iconText;
                    line2.status = status;
                    boolean bl = line2.waitlist = first && request.isWaitlistOrNoSub(wlMode);
                    if (first && request.isWaitList() && wlMode == OnlineSectioningInterface.WaitListMode.WaitList && request.getWaitListedTimeStamp() != null) {
                        line2.waitListDate = sTimeStampFormat.format(request.getWaitListedTimeStamp());
                    }
                    line2.first = first;
                    line2.idx = idx;
                    boolean bl2 = line2.firstalt = first && priority == 1;
                    if (firstChoice == null) {
                        firstChoice = rc.getCourseName();
                    }
                    line2.firstChoice = firstChoice;
                    courseRequests.add(line2);
                } else if (rc.isFreeTime()) {
                    line = new CourseRequestLine();
                    free = "";
                    for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                        if (!((String)free).isEmpty()) {
                            free = (String)free + ", ";
                        }
                        free = (String)free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                    }
                    line.priority = first ? MSG.courseRequestsAlternate(priority) : "";
                    line.courseName = CONST.freePrefix() + (String)free;
                    line.courseTitle = "";
                    line.credit = "";
                    line.prefs = "";
                    line.icon = "action_check.png";
                    line.iconText = MSG.requested((String)free);
                    line.status = MSG.reqStatusRegistered();
                    line.waitlist = false;
                    line.first = first;
                    line.idx = idx;
                    boolean bl = line.firstalt = first && priority == 1;
                    if (firstChoice == null) {
                        firstChoice = CONST.freePrefix() + (String)free;
                    }
                    line.firstChoice = firstChoice;
                    courseRequests.add(line);
                }
                first = false;
                ++idx;
            }
            ++priority;
        }
        if (requests.getMaxCreditOverrideStatus() != null) {
            float[] range;
            String icon2 = null;
            String status2 = "";
            Object note3 = null;
            Object iconText2 = null;
            if (requests.hasCreditWarning()) {
                note3 = requests.getCreditWarning();
                iconText2 = requests.getCreditWarning();
                courseRequests.hasWarn = true;
            }
            switch (requests.getMaxCreditOverrideStatus()) {
                case CREDIT_HIGH: {
                    icon2 = "attention.png";
                    status2 = MSG.reqStatusWarning();
                    iconText2 = (String)iconText2 + "\n" + MSG.creditStatusTooHigh();
                    break;
                }
                case OVERRIDE_REJECTED: {
                    icon2 = "stop.png";
                    status2 = MSG.reqStatusRejected();
                    iconText2 = (String)iconText2 + "\n" + MSG.creditStatusDenied();
                    break;
                }
                case OVERRIDE_NEEDED: 
                case CREDIT_LOW: {
                    icon2 = "attention.png";
                    status2 = MSG.reqStatusWarning();
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    icon2 = "attention.png";
                    status2 = MSG.reqStatusCancelled();
                    iconText2 = (String)iconText2 + "\n" + MSG.creditStatusCancelled();
                    break;
                }
                case OVERRIDE_PENDING: {
                    icon2 = "time.png";
                    status2 = MSG.reqStatusPending();
                    iconText2 = (String)iconText2 + "\n" + MSG.creditStatusPending();
                    break;
                }
                case OVERRIDE_APPROVED: {
                    icon2 = "action_check.png";
                    status2 = MSG.reqStatusApproved();
                    iconText2 = (String)iconText2 + (String)(iconText2 == null ? "" : (String)iconText2 + "\n") + MSG.creditStatusApproved();
                    break;
                }
                case SAVED: {
                    icon2 = "action_check.png";
                    status2 = MSG.reqStatusRegistered();
                }
            }
            if (requests.hasCreditNote()) {
                note3 = (String)(note3 == null ? "" : (String)note3 + "\n") + requests.getCreditNote();
                courseRequests.hasWarn = true;
            }
            String credit2 = (range = requests.getCreditRange(advisorWaitListedCourseIds)) != null ? (range[0] < range[1] ? df.format(Float.valueOf(range[0])) + " - " + df.format(Float.valueOf(range[1])) : df.format(Float.valueOf(range[0]))) : "";
            CourseRequestLine line3 = new CourseRequestLine();
            line3.priority = "";
            line3.courseName = MSG.rowRequestedCredit();
            line3.courseTitle = "";
            line3.credit = credit2;
            line3.prefs = "";
            line3.note = note3;
            line3.icon = icon2;
            line3.iconText = iconText2;
            line3.status = status2;
            line3.last = true;
            courseRequests.add(line3);
        } else {
            float[] range = requests.getCreditRange(advisorWaitListedCourseIds);
            if (range != null && range[1] > 0.0f) {
                String credit3 = range != null ? (range[0] < range[1] ? df.format(Float.valueOf(range[0])) + " - " + df.format(Float.valueOf(range[1])) : df.format(Float.valueOf(range[0]))) : "";
                CourseRequestLine line4 = new CourseRequestLine();
                line4.priority = "";
                line4.courseName = MSG.rowRequestedCredit();
                line4.courseTitle = "";
                line4.credit = credit3;
                line4.prefs = "";
                line4.note = null;
                line4.icon = "";
                line4.iconText = "";
                line4.status = "";
                line4.last = true;
                courseRequests.add(line4);
            }
        }
        return courseRequests;
    }

    CourseRequestsTable generateAdvisorRequests(Student student, CourseRequestInterface requests, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.WaitListMode wlMode) {
        CourseRequestLine line;
        CourseRequestLine line2;
        Object note;
        Object credit;
        AbstractCollection prefs;
        Object firstChoice;
        CourseRequestsTable courseRequests = new CourseRequestsTable();
        Formats.Format<Number> df = Formats.getNumberFormat("0.#");
        int priority = 1;
        Integer critical = null;
        if ("Critical".equals(ApplicationProperty.AdvisorCourseRequestsAllowCritical.value())) {
            critical = CourseDemand.Critical.CRITICAL.ordinal();
            courseRequests.criticalColumn = MSG.opSetCritical();
            courseRequests.criticalColumnDescription = MSG.descriptionRequestCritical();
        } else if ("Vital".equals(ApplicationProperty.AdvisorCourseRequestsAllowCritical.value())) {
            critical = CourseDemand.Critical.VITAL.ordinal();
            courseRequests.criticalColumn = MSG.opSetVital();
            courseRequests.criticalColumnDescription = MSG.descriptionRequestVital();
        } else if ("Important".equals(ApplicationProperty.AdvisorCourseRequestsAllowCritical.value())) {
            critical = CourseDemand.Critical.IMPORTANT.ordinal();
            courseRequests.criticalColumn = MSG.opSetImportant();
            courseRequests.criticalColumnDescription = MSG.descriptionRequestImportant();
        }
        for (CourseRequestInterface.Request request : requests.getCourses()) {
            if (request.hasRequestedCourse()) {
                boolean first = true;
                int idx = 0;
                firstChoice = null;
                if (request.isWaitlistOrNoSub(wlMode)) {
                    courseRequests.hasWait = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            courseRequests.hasPref = true;
                        }
                        credit = first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                        note = first && request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                        line2 = new CourseRequestLine();
                        line2.priority = first ? MSG.courseRequestsPriority(priority) : "";
                        line2.courseName = rc.getCourseName();
                        line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                        line2.url = this.getCourseUrl(server, rc);
                        line2.credit = credit;
                        line2.prefs = StudentEmail.toString(prefs);
                        line2.note = note;
                        line2.first = priority > 1 && first;
                        line2.rows = first ? request.getRequestedCourse().size() : 0;
                        line2.idx = idx;
                        boolean bl = line2.waitlist = first && request.isWaitlistOrNoSub(wlMode);
                        if (first && critical != null && critical.equals(request.getCritical())) {
                            line2.critical = true;
                            courseRequests.hasCritical = true;
                        }
                        if (firstChoice == null) {
                            firstChoice = rc.getCourseName();
                        }
                        line2.firstChoice = firstChoice;
                        courseRequests.add(line2);
                    } else if (rc.isFreeTime()) {
                        Object free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                        }
                        credit = first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                        note = first && request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                        line2 = new CourseRequestLine();
                        line2.priority = first ? MSG.courseRequestsPriority(priority) : "";
                        line2.courseName = CONST.freePrefix() + (String)free;
                        line2.courseTitle = "";
                        line2.credit = credit;
                        line2.note = note;
                        line2.prefs = "";
                        line2.first = priority > 1 && first;
                        line2.idx = idx;
                        line2.rows = first ? request.getRequestedCourse().size() : 0;
                        line2.waitlist = false;
                        if (firstChoice == null) {
                            firstChoice = CONST.freePrefix() + (String)free;
                        }
                        line2.firstChoice = firstChoice;
                        courseRequests.add(line2);
                    }
                    first = false;
                    ++idx;
                }
            } else {
                String credit2 = request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                String note2 = request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                line = new CourseRequestLine();
                line.priority = MSG.courseRequestsPriority(priority);
                line.courseName = "";
                line.courseTitle = "";
                line.credit = credit2;
                line.note = note2;
                line.prefs = "";
                line.first = priority > 1;
                line.idx = 0;
                courseRequests.add(line);
            }
            ++priority;
        }
        priority = 1;
        for (CourseRequestInterface.Request request : requests.getAlternatives()) {
            if (request.hasRequestedCourse()) {
                boolean first = true;
                int idx = 0;
                firstChoice = null;
                if (request.isWaitlistOrNoSub(wlMode)) {
                    courseRequests.hasWait = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            courseRequests.hasPref = true;
                        }
                        credit = first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                        note = first && request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                        line2 = new CourseRequestLine();
                        line2.priority = first ? MSG.courseRequestsAlternate(priority) : "";
                        line2.courseName = rc.getCourseName();
                        line2.courseTitle = rc.hasCourseTitle() ? rc.getCourseTitle() : "";
                        line2.credit = credit;
                        line2.prefs = StudentEmail.toString(prefs);
                        line2.note = note;
                        line2.first = first;
                        line2.idx = idx;
                        line2.firstalt = first && priority == 1;
                        line2.rows = first ? request.getRequestedCourse().size() : 0;
                        boolean bl = line2.waitlist = first && request.isWaitlistOrNoSub(wlMode);
                        if (firstChoice == null) {
                            firstChoice = rc.getCourseName();
                        }
                        line2.firstChoice = firstChoice;
                        courseRequests.add(line2);
                    } else if (rc.isFreeTime()) {
                        CourseRequestLine line3 = new CourseRequestLine();
                        Object free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONST.shortDays(), CONST.useAmPm());
                        }
                        String credit3 = first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                        String note3 = first && request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                        line3.priority = first ? MSG.courseRequestsAlternate(priority) : "";
                        line3.courseName = CONST.freePrefix() + (String)free;
                        line3.courseTitle = "";
                        line3.credit = credit3;
                        line3.prefs = "";
                        line3.note = note3;
                        line3.first = first;
                        line3.idx = idx;
                        line3.firstalt = first && priority == 1;
                        line3.rows = first ? request.getRequestedCourse().size() : 0;
                        line3.waitlist = false;
                        if (firstChoice == null) {
                            firstChoice = CONST.freePrefix() + (String)free;
                        }
                        line3.firstChoice = firstChoice;
                        courseRequests.add(line3);
                    }
                    first = false;
                    ++idx;
                }
            } else {
                String credit4 = request.hasAdvisorCredit() ? request.getAdvisorCredit() : "";
                String note4 = request.hasAdvisorNote() ? request.getAdvisorNote() : "";
                line = new CourseRequestLine();
                line.priority = MSG.courseRequestsAlternate(priority);
                line.courseName = "";
                line.courseTitle = "";
                line.credit = credit4;
                line.note = note4;
                line.prefs = "";
                line.first = priority > 1;
                line.idx = 0;
                courseRequests.add(line);
            }
            ++priority;
        }
        float[] minMax = requests.getAdvisorCreditRange();
        String note5 = requests.hasCreditNote() ? requests.getCreditNote() : "";
        String credit5 = minMax[0] < minMax[1] ? df.format(Float.valueOf(minMax[0])) + " - " + df.format(Float.valueOf(minMax[1])) : df.format(Float.valueOf(minMax[0]));
        CourseRequestLine line4 = new CourseRequestLine();
        line4.priority = "";
        line4.courseName = MSG.rowTotalPriorityCreditHours();
        line4.courseTitle = "";
        line4.credit = credit5;
        line4.prefs = "";
        line4.note = note5;
        line4.last = true;
        courseRequests.add(line4);
        return courseRequests;
    }

    Table generateListOfClasses(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.WaitListMode wlMode, boolean plainText) {
        Table listOfClasses = new Table();
        AcademicSessionInfo session = server.getAcademicSession();
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)request;
                XEnrollment enrollment = cr.getEnrollment();
                if (enrollment == null) {
                    XCourseRequest swap;
                    if (!this.getStudent().canAssign(cr, wlMode) || !cr.isWaitlist(wlMode)) continue;
                    XCourse course = server.getCourse(cr.getCourseIds().get(0).getCourseId());
                    XCourse swapCourse = null;
                    if (cr.getWaitListSwapWithCourseOffering() != null && wlMode == OnlineSectioningInterface.WaitListMode.WaitList && cr.isWaitlist(wlMode) && (swap = this.getStudent().getRequestForCourse(cr.getWaitListSwapWithCourseOffering().getCourseId())) != null && swap.getEnrollment() != null && swap.getEnrollment().getCourseId().equals(cr.getWaitListSwapWithCourseOffering().getCourseId())) {
                        swapCourse = server.getCourse(swap.getEnrollment().getCourseId());
                    }
                    listOfClasses.add(new TableCourseLine(cr, course, this.getCourseUrl(session, course), wlMode == OnlineSectioningInterface.WaitListMode.WaitList, swapCourse, plainText));
                } else {
                    XOffering offering = server.getOffering(enrollment.getOfferingId());
                    XCourse course = offering.getCourse(enrollment.getCourseId());
                    String consent = this.consent(server, enrollment);
                    for (XSection section : offering.getSections(enrollment)) {
                        XSection parent = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                        XSubpart subpart = offering.getSubpart(section.getSubpartId());
                        String requires = null;
                        if (parent != null) {
                            requires = parent.getName(course.getCourseId());
                        } else {
                            requires = consent;
                            consent = null;
                        }
                        listOfClasses.add(new TableSectionLine(cr, course, subpart, section, requires, this.getCourseUrl(session, course), plainText));
                    }
                    if (cr.isWaitlist(wlMode) && this.getStudent().canAssign(cr, wlMode) && enrollment.equals(cr.getWaitListSwapWithCourseOffering()) && !cr.isRequired(enrollment, offering)) {
                        listOfClasses.add(new TableCourseLine(cr, course, this.getCourseUrl(session, course), true, null, plainText));
                    }
                }
            }
            if (!(request instanceof XFreeTimeRequest)) continue;
            listOfClasses.add(new TableLineFreeTime((XFreeTimeRequest)request));
        }
        return listOfClasses;
    }

    public static boolean equals(XSection a, XSection b) {
        return ToolBox.equals((Object)a.getName(), (Object)b.getName()) && ToolBox.equals((Object)a.getTime(), (Object)b.getTime()) && ToolBox.equals(a.getRooms(), b.getRooms()) && ToolBox.equals(a.getInstructors(), b.getInstructors()) && ToolBox.equals((Object)a.getParentId(), (Object)b.getParentId());
    }

    private static String startTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot());
    }

    private static String endTime(XTime time) {
        return OnlineSectioningHelper.getTimeString(time.getSlot() + time.getLength(), time.getBreakTime());
    }

    private String consent(OnlineSectioningServer server, XEnrollment enrollment) {
        if (enrollment == null || enrollment.getCourseId() == null) {
            return null;
        }
        XCourse info = server.getCourse(enrollment.getCourseId());
        if (info == null || info.getConsentLabel() == null) {
            return null;
        }
        if (enrollment.getApproval() == null) {
            return MSG.consentWaiting(info.getConsentLabel().toLowerCase());
        }
        return MSG.consentApproved(sConsentApprovalDateFormat.format(enrollment.getApproval().getTimeStamp()));
    }

    public void generateTimetable(PrintWriter out, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Enumeration<Integer> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        out.println("<table cellspacing='0' cellpadding='0'>");
        out.println("<tr><td align='left' style='vertical-align: top;'><table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 30px;'></div></td>");
        for (int i = 0; i < nrDays; ++i) {
            out.println("<td align='center' style='vertical-align: top;'><div style='font-size: x-small; text-align: center; color: #6991CE; display: block; width: 180px; '>" + DayCode.values()[i].getName() + "</div></td>");
        }
        out.println("</tr></table></td></tr>");
        out.println("<tr><td align='left' style='vertical-align: top;'><div style='width: " + (35 + 180 * nrDays) + "px; '>");
        out.println("<table cellspacing='0' cellpadding='0'><tr>");
        out.println("<td align='left' style='vertical-align: top; '><div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 30px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px; white-space: nowrap; position: absolute; left: 0px; top: " + top + "px;'>" + (String)(CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h)) + "</div>");
            out.println("<div style='font-size: x-small; text-align: center; padding-right: 2px; color: #6991CE; display: block; border-top: 1px solid transparent; height: 100%; width: 28px;position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        out.println("</div></td>");
        out.println("<td align='left' style='vertical-align: top; '>");
        out.println("<div style='border-bottom: 1px solid #DDDDDD; position: relative; overflow-x: hidden; overflow-y: hidden; width: " + (5 + 180 * nrDays) + "px; height: " + 50 * (lastHour - firstHour) + "px; '>");
        out.println("<div style='position: relative; overflow-x: hidden; overflow-y: hidden; width: 100%; height: 100%; '>");
        out.println("<div style='background: #FFFDDD; width: " + (2 + 180 * nrDays) + "px; height: 500px; position: absolute; left: 0px; top: " + (25 + 50 * (7 - firstHour)) + "px;'></div>");
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                if (dow.getIndex() >= nrDays || fr.getTime().getSlot() + fr.getTime().getLength() < 12 * firstHour || fr.getTime().getSlot() > 12 * lastHour) continue;
                out.println("<div style='background: #FFE1DD; width: 100%; color: #BA5353; font-size: x-small; text-align: left; white-space: nowrap; overflow: hidden;width: 183px; height: " + 125 * fr.getTime().getLength() / 30 + "px; position: absolute; left: " + 180 * dow.getIndex() + "px;top: " + (125 * fr.getTime().getSlot() / 30 - 50 * firstHour) + "px; '>");
                out.println("<div style='padding-left: 5px; white-space: nowrap; '>Free " + DayCode.toString(fr.getTime().getDays()) + " " + StudentEmail.startTime(fr.getTime()) + " - " + StudentEmail.endTime(fr.getTime()) + "</div>");
                out.println("</div>");
            }
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 50 * (h - firstHour);
            out.println("<div style='display: block; border-top: 1px solid #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + top + "px; '></div>");
            out.println("<div style='display: block; border-top: 1px dotted #DDDDDD; width: 100%; position: absolute; left: 0px; top: " + (25 + top) + "px; '></div>");
        }
        for (int i = 0; i <= nrDays; ++i) {
            int left = 180 * i;
            out.println("<div style='height: 100%; position: absolute; top: 0px; left: 0%; border-left: 1px solid #DDDDDD; border-right: 1px solid #DDDDDD; width: 2px; position: absolute; left: " + left + "px; top: 0px; '></div>");
        }
        out.println("</div>");
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 174 / col + (index + 1 != col && col > 1 ? -3 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 3;
                    int l = 4 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 1 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    out.println("<div style='overflow-x: hidden; overflow-y: hidden; width: " + w + "px; height: " + h + "px; position: absolute; left: " + l + "px; top: " + t + "px; position: absolute; font-size: x-small; font-family: arial; overflow: hidden; -webkit-border-radius: 6px; -moz-border-radius: 6px; color: #FFFFFF; border: 1px solid #" + sColor1[color] + "; background: #" + sColor2[color] + ";'>");
                    out.println("<table cellspacing='0' cellpadding='0' style='padding-left: 4px; padding-right: 4px; padding-bottom: 2px; padding-top: 2px; width: 100%; -webkit-border-top-left-radius: 5px; -webkit-border-top-right-radius: 5px; -moz-border-radius-topleft: 5px; -moz-border-radius-topright: 5px;background: #" + sColor1[color] + ";'><tr><td align='left' style='vertical-align: top; '>");
                    out.println("<div style='padding-left: 2px; width: 100%; font-size: x-small; white-space: nowrap; overflow: hidden; color: #FFFFFF;'>" + MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName() + "</div></td></tr></tbody></table>");
                    out.println("<div style='font-size: x-small; padding-left: 4px; white-space: wrap; -webkit-border-bottom-left-radius: 5px; -webkit-border-bottom-right-radius: 5px; -moz-border-radius-bottomleft: 5px; -moz-border-radius-bottomright: 5px;'>");
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            out.println("<span style='white-space: nowrap'>" + room.getName() + ",</span>");
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        out.println("<span style='white-space: nowrap'>" + instructor.getName() + ",</span>");
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        out.println("<span style='white-space: nowrap'>" + section.getTime().getDatePatternName() + "</span>");
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        out.println("<br>" + course.getNote().replace("\n", "<br>"));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        out.println("<br>" + section.getNote().replace("\n", "<br>"));
                    }
                    out.println("</div></div>");
                }
            }
            color = (1 + color) % sColor1.length;
        }
        out.println("</div></td></tr></table></div></td></tr>");
        out.println("</table>");
    }

    public byte[] generateTimetableImage(OnlineSectioningServer server) throws IOException {
        int nrDays = 5;
        int firstHour = 7;
        int lastHour = 18;
        boolean hasSat = false;
        boolean hasSun = false;
        List[][] table = new List[Constants.NR_DAYS][288];
        for (XRequest request : this.getStudent().getRequests()) {
            if (request instanceof XFreeTimeRequest) {
                int endHour;
                int startHour;
                XFreeTimeRequest ft = (XFreeTimeRequest)request;
                int dayCode = ft.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (ft.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((ft.getTime().getSlot() + ft.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) <= lastHour) continue;
                lastHour = endHour;
                continue;
            }
            if (((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                int endHour;
                int startHour;
                if (section.getTime() == null) continue;
                int dayCode = section.getTime().getDays();
                if ((dayCode & Constants.DAY_CODES[5]) != 0) {
                    hasSat = true;
                }
                if ((dayCode & Constants.DAY_CODES[6]) != 0) {
                    hasSun = true;
                }
                if ((startHour = (section.getTime().getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) / 60) < firstHour) {
                    firstHour = startHour;
                }
                if ((endHour = ((section.getTime().getSlot() + section.getTime().getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + 59) / 60) > lastHour) {
                    lastHour = endHour;
                }
                Iterator<DayCode> e = section.getTime().getSlots();
                while (e.hasMoreElements()) {
                    int time;
                    int slot = e.nextElement();
                    int day = slot / 288;
                    if (table[day][time = slot % 288] == null) {
                        table[day][time] = new ArrayList();
                    }
                    table[day][time].add(section);
                }
            }
        }
        if (hasSat) {
            nrDays = 6;
        }
        if (hasSun) {
            nrDays = 7;
        }
        BufferedImage image = new BufferedImage(39 + 180 * nrDays, 21 + 50 * (lastHour - firstHour), 1);
        Graphics2D g = image.createGraphics();
        g.setFont(new Font("Sans Serif", 0, 11));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(255, 255, 255));
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int fh = g.getFontMetrics().getHeight();
        g.setColor(new Color(105, 145, 206));
        for (int i = 0; i < nrDays; ++i) {
            g.drawString(DayCode.values()[i].getName(), 40 + i * 180, 17);
        }
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.drawString((String)(CONST.useAmPm() ? (h > 12 ? h - 12 : h) + (h < 12 ? "am" : "pm") : String.valueOf(h)), 2, top + fh);
        }
        g.setColor(new Color(255, 253, 221));
        g.fillRect(35, 45 + 50 * (7 - firstHour), 5 + 180 * nrDays, 501);
        Stroke noStroke = g.getStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
        g.setColor(new Color(221, 221, 221));
        for (int h = firstHour; h < lastHour; ++h) {
            int top = 20 + 50 * (h - firstHour);
            g.setStroke(noStroke);
            g.drawLine(35, top, 39 + 180 * nrDays, top);
            g.setStroke(dotted);
            g.drawLine(35, top + 25, 39 + 180 * nrDays, top + 25);
        }
        g.setStroke(noStroke);
        g.drawLine(35, 20 + 50 * (lastHour - firstHour), 39 + 180 * nrDays, 20 + 50 * (lastHour - firstHour));
        g.setColor(new Color(255, 225, 221));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.fillRect(36 + 180 * dow.getIndex(), 21 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour, 182, 125 * fr.getTime().getLength() / 30 - 1);
            }
        }
        g.setColor(new Color(221, 221, 221));
        for (int i = 0; i <= nrDays; ++i) {
            g.drawLine(35 + 180 * i, 20, 35 + 180 * i, 20 + 50 * (lastHour - firstHour));
            g.drawLine(38 + 180 * i, 20, 38 + 180 * i, 20 + 50 * (lastHour - firstHour));
        }
        g.setColor(new Color(186, 83, 83));
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XFreeTimeRequest)) continue;
            XFreeTimeRequest fr = (XFreeTimeRequest)request;
            for (DayCode dow : DayCode.toDayCodes(fr.getTime().getDays())) {
                g.drawString(OnlineSectioningHelper.toString(fr), 42 + 180 * dow.getIndex(), 20 + 125 * fr.getTime().getSlot() / 30 - 50 * firstHour + fh);
            }
        }
        int color = 0;
        for (XRequest request : this.getStudent().getRequests()) {
            if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
            XOffering offering = server.getOffering(((XCourseRequest)request).getEnrollment().getOfferingId());
            XCourse course = offering.getCourse(((XCourseRequest)request).getEnrollment().getCourseId());
            for (XSection section : offering.getSections(((XCourseRequest)request).getEnrollment())) {
                if (section.getTime() == null) continue;
                block13: for (DayCode dow : DayCode.toDayCodes(section.getTime().getDays())) {
                    int col = 0;
                    int index = 0;
                    for (int i = 0; i < section.getTime().getLength(); ++i) {
                        col = Math.max(col, table[dow.getIndex()][section.getTime().getSlot() + i].size());
                        index = Math.max(index, table[dow.getIndex()][section.getTime().getSlot() + i].indexOf(section));
                    }
                    int w = 176 / col + (index + 1 < col ? -2 : 0);
                    int h = 125 * section.getTime().getLength() / 30 - 1;
                    int l = 39 + 180 * dow.getIndex() + index * 174 / col;
                    int t = 21 + 125 * section.getTime().getSlot() / 30 - 50 * firstHour;
                    g.setColor(new Color(Integer.valueOf(sColor2[color], 16)));
                    g.fillRoundRect(l, t, w, h, 6, 6);
                    g.setColor(new Color(Integer.valueOf(sColor1[color], 16)));
                    g.drawRoundRect(l, t, w, h, 6, 6);
                    g.fillRoundRect(l, t, w, 2 + fh, 6, 6);
                    g.fillRect(l, t + fh - 2, w, 4);
                    g.setColor(new Color(255, 255, 255));
                    Object text = MSG.course(course.getSubjectArea(), course.getCourseNumber()) + " " + section.getSubpartName();
                    while (g.getFontMetrics().stringWidth((String)text) > w - 10) {
                        text = ((String)text).substring(0, ((String)text).length() - 1);
                    }
                    g.drawString((String)text, l + 5, t + fh - 2);
                    ArrayList<String> texts = new ArrayList<String>();
                    if (section.getRooms() != null) {
                        for (XRoom room : section.getRooms()) {
                            texts.add(room.getName());
                        }
                    }
                    for (XInstructor instructor : section.getInstructors()) {
                        texts.add(instructor.getName());
                    }
                    if (section.getTime().getDatePatternName() != null && !section.getTime().getDatePatternName().isEmpty()) {
                        texts.add(section.getTime().getDatePatternName());
                    }
                    if (course.getNote() != null && !course.getNote().isEmpty()) {
                        texts.add(course.getNote().replace("\n", "; "));
                    }
                    if (section.getNote() != null && !section.getNote().isEmpty()) {
                        texts.add(section.getNote().replace("\n", "; "));
                    }
                    int tt = t + fh;
                    Object next = "";
                    int idx = 0;
                    while (idx < texts.size() || !((String)next).isEmpty()) {
                        if (idx < texts.size()) {
                            next = (String)next + (String)texts.get(idx++);
                            if (idx < texts.size()) {
                                next = (String)next + ", ";
                            }
                        }
                        while (g.getFontMetrics().stringWidth(((String)next).trim()) < w - 10 && idx < texts.size() && g.getFontMetrics().stringWidth((String)next + (String)texts.get(idx) + ",") < w - 10) {
                            next = (String)next + (String)texts.get(idx++);
                            if (idx >= texts.size()) continue;
                            next = (String)next + ", ";
                        }
                        text = next;
                        next = "";
                        while (g.getFontMetrics().stringWidth(((String)text).trim()) > w - 10) {
                            int sp = ((String)text).lastIndexOf(32);
                            if (sp >= 0 && g.getFontMetrics().stringWidth(((String)text).substring(sp)) < w - 10) {
                                next = ((String)text).substring(sp);
                                text = ((String)text).substring(0, sp);
                                continue;
                            }
                            next = ((String)text).substring(((String)text).length() - 1, ((String)text).length()) + (String)next;
                            text = ((String)text).substring(0, ((String)text).length() - 1);
                        }
                        if (tt + fh - 2 > t + h) continue block13;
                        g.drawString(((String)text).trim(), l + 5, tt + fh - 2);
                        tt += fh;
                    }
                }
            }
            color = (1 + color) % sColor1.length;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.flush();
        out.close();
        return out.toByteArray();
    }

    public static String toString(Collection<?> items) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return items.iterator().next().toString();
        }
        if (items.size() == 2) {
            Iterator<?> i = items.iterator();
            return GWT.itemSeparatorPair(i.next().toString(), i.next().toString());
        }
        Iterator<?> i = items.iterator();
        String list = i.next().toString();
        while (i.hasNext()) {
            String item = i.next().toString();
            if (i.hasNext()) {
                list = GWT.itemSeparatorMiddle(list, item);
                continue;
            }
            list = GWT.itemSeparatorLast(list, item);
        }
        return list;
    }

    public class CourseRequestsTable {
        List<CourseRequestLine> lines = new ArrayList<CourseRequestLine>();
        boolean hasPref = false;
        boolean hasWarn = false;
        boolean hasWait = false;
        String credit = "";
        boolean hasCritical = false;
        String criticalColumn = null;
        String criticalColumnDescription = null;

        void add(CourseRequestLine line) {
            this.lines.add(line);
        }

        public List<CourseRequestLine> getLines() {
            return this.lines;
        }

        public boolean getHasPref() {
            return this.hasPref;
        }

        public boolean getHasWarn() {
            return this.hasWarn;
        }

        public boolean getHasWait() {
            return this.hasWait;
        }

        public String getCredit() {
            return this.credit;
        }

        public boolean getHasCritical() {
            return this.hasCritical;
        }

        public String getCriticalColumn() {
            return this.criticalColumn;
        }

        public String getCriticalColumnDescription() {
            return this.criticalColumnDescription;
        }
    }

    public static class Table
    extends ArrayList<TableLine> {
        private static final long serialVersionUID = 1L;

        public boolean sameCourse(TableLine a, TableLine b) {
            if (a instanceof TableCourseLine && b instanceof TableCourseLine) {
                return ((TableCourseLine)a).getCourse().equals(((TableCourseLine)b).getCourse());
            }
            return false;
        }

        public boolean isFirst(TableLine line) {
            int index = this.indexOf(line);
            return index <= 0 || !this.sameCourse(line, (TableLine)this.get(index - 1));
        }

        public boolean isLast(TableLine line) {
            int index = this.indexOf(line);
            return index + 1 >= this.size() || !this.sameCourse(line, (TableLine)this.get(index + 1));
        }

        @Override
        public boolean add(TableLine line) {
            line.setTable(this);
            return super.add(line);
        }
    }

    public static interface TableLine {
        public XRequest getRequest();

        public String getSubject();

        public String getCourseNumber();

        public String getCourseTitle();

        public String getType();

        public String getName();

        public String getUrl();

        public XTime getTime();

        public String getRooms();

        public String getInstructors();

        public boolean isAssigned();

        public boolean isFreeTime();

        public String getArrangeHours();

        public String getDays();

        public String getStart();

        public String getEnd();

        public String getDate();

        public String getCredit();

        public String getNote();

        public String getCourseNote();

        public String getRequires();

        public void setTable(Table var1);

        public boolean isLast();

        public boolean isFirst();

        public boolean isWaitList();

        public boolean isCancelled();

        public boolean isPlainText();
    }

    public static class TableSectionDeletedLine
    extends TableSectionLine {
        public TableSectionDeletedLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url, boolean plainText) {
            super(request, course, subpart, section, requires, url, plainText);
        }

        @Override
        public String getCourseNote() {
            return null;
        }
    }

    public static class TableSectionLine
    extends TableCourseLine {
        protected XSection iSection;
        protected XSubpart iSubpart;
        protected String iRequires;

        public TableSectionLine(XCourseRequest request, XCourse course, XSubpart subpart, XSection section, String requires, URL url, boolean plainText) {
            super(request, course, url, plainText);
            this.iCourse = course;
            this.iSubpart = subpart;
            this.iSection = section;
            this.iRequires = requires;
        }

        @Override
        public String getType() {
            return this.iSection.getSubpartName();
        }

        @Override
        public String getName() {
            return this.iSection.getName(this.iCourse.getCourseId());
        }

        public XSection getSection() {
            return this.iSection;
        }

        public XSubpart getSubpart() {
            return this.iSubpart;
        }

        @Override
        public String getRequires() {
            return this.iRequires;
        }

        @Override
        public String getNote() {
            if (this.iSection.isCancelled()) {
                return MSG.classCancelled(this.getName());
            }
            return this.iSection.getNote();
        }

        @Override
        public String getCourseNote() {
            return this.iCourse.getNote();
        }

        @Override
        public String getCredit() {
            return this.iSubpart == null ? null : this.iSubpart.getCreditAbbv(this.iCourse.getCourseId());
        }

        @Override
        public XTime getTime() {
            return this.iSection.getTime();
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public String getRooms() {
            Object rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!((String)rooms).isEmpty()) {
                        rooms = (String)rooms + ", ";
                    }
                    rooms = (String)rooms + room.getName();
                }
            }
            return rooms;
        }

        @Override
        public String getInstructors() {
            Object instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!((String)instructors).isEmpty()) {
                        instructors = (String)instructors + ", ";
                    }
                    if (this.isPlainText()) {
                        instructors = (String)instructors + instructor.getName();
                        continue;
                    }
                    if (instructor.getEmail() == null) {
                        instructors = (String)instructors + "<span style='white-space: nowrap;'>" + instructor.getName() + "</span>";
                        continue;
                    }
                    instructors = (String)instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none; white-space: nowrap;\">" + instructor.getName() + "</a>";
                }
            }
            return instructors;
        }

        @Override
        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        @Override
        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        @Override
        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        @Override
        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        @Override
        public String getDate() {
            return this.getTime().getDatePatternName();
        }

        @Override
        public boolean isWaitList() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.iSection.isCancelled();
        }
    }

    public static class TableSectionModifiedLine
    extends TableSectionLine {
        protected XSubpart iOldSubpart;
        protected XSection iOldSection;
        protected String iOldRequires;

        public TableSectionModifiedLine(XCourseRequest request, XCourse course, XSubpart oldSubpart, XSubpart subpart, XSection oldSection, XSection section, String oldRequires, String requires, URL url, boolean plainText) {
            super(request, course, subpart, section, requires, url, plainText);
            this.iOldSection = oldSection;
            this.iOldSubpart = oldSubpart;
            this.iOldRequires = oldRequires;
        }

        public XSubpart getOldSubpart() {
            return this.iOldSubpart;
        }

        public XSection getOldSection() {
            return this.iOldSection;
        }

        public XTime getOldTime() {
            return this.iOldSection.getTime();
        }

        @Override
        public String getName() {
            return this.diff(this.iOldSection.getName(this.iCourse.getCourseId()), this.iSection.getName(this.iCourse.getCourseId()));
        }

        public String diff(String a, String b) {
            if (this.isPlainText()) {
                if (a == null || a.isEmpty()) {
                    return b == null || b.isEmpty() ? "" : b;
                }
                if (b == null || b.isEmpty()) {
                    return MSG.textDiff(MSG.textNotApplicable(), a);
                }
                if (a.equals(b)) {
                    return a;
                }
                return MSG.textDiff(b, a);
            }
            if (a == null || a.isEmpty()) {
                return b == null || b.isEmpty() ? "<span style='text-decoration: none;'>&nbsp;</span>" : b;
            }
            if (b == null || b.isEmpty()) {
                return "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
            }
            if (a.equals(b)) {
                return a;
            }
            return b + "<br><span style='font-style: italic; color: gray; text-decoration: line-through;'>" + a + "</span>";
        }

        @Override
        public String getRequires() {
            return this.diff(this.iOldRequires, this.iRequires);
        }

        @Override
        public String getInstructors() {
            Object oldInstructors = "";
            if (!this.iOldSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iOldSection.getInstructors()) {
                    if (!((String)oldInstructors).isEmpty()) {
                        oldInstructors = (String)oldInstructors + ", ";
                    }
                    if (this.isPlainText()) {
                        oldInstructors = (String)oldInstructors + instructor.getName();
                        continue;
                    }
                    if (instructor.getEmail() == null) {
                        oldInstructors = (String)oldInstructors + instructor.getName();
                        continue;
                    }
                    oldInstructors = (String)oldInstructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            Object instructors = "";
            if (!this.iSection.getInstructors().isEmpty()) {
                for (XInstructor instructor : this.iSection.getInstructors()) {
                    if (!((String)instructors).isEmpty()) {
                        instructors = (String)instructors + ", ";
                    }
                    if (this.isPlainText()) {
                        instructors = (String)instructors + instructor.getName();
                        continue;
                    }
                    if (instructor.getEmail() == null) {
                        instructors = (String)instructors + instructor.getName();
                        continue;
                    }
                    instructors = (String)instructors + "<a href='mailto:" + instructor.getEmail() + "' style=\"color: inherit; background-color : transparent; text-decoration: none;\">" + instructor.getName() + "</a>";
                }
            }
            return this.diff((String)oldInstructors, (String)instructors);
        }

        @Override
        public String getRooms() {
            Object oldRooms = "";
            if (this.iOldSection.getRooms() != null && !this.iOldSection.getRooms().isEmpty()) {
                for (XRoom room : this.iOldSection.getRooms()) {
                    if (!((String)oldRooms).isEmpty()) {
                        oldRooms = (String)oldRooms + ", ";
                    }
                    oldRooms = (String)oldRooms + room.getName();
                }
            }
            Object rooms = "";
            if (this.iSection.getRooms() != null && !this.iSection.getRooms().isEmpty()) {
                for (XRoom room : this.iSection.getRooms()) {
                    if (!((String)rooms).isEmpty()) {
                        rooms = (String)rooms + ", ";
                    }
                    rooms = (String)rooms + room.getName();
                }
            }
            return this.diff((String)oldRooms, (String)rooms);
        }

        @Override
        public String getNote() {
            if (this.iSection.isCancelled()) {
                return MSG.classCancelled(this.getName());
            }
            return this.diff(this.iOldSection.getNote(), this.iSection.getNote());
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getArrangeHours() {
            return this.diff((String)(this.getOldTime() == null || this.getOldTime().getDays() == 0 ? MSG.emailArrangeHours() : DayCode.toString(this.getOldTime().getDays()) + " " + StudentEmail.startTime(this.getOldTime())), MSG.emailArrangeHours());
        }

        @Override
        public String getDays() {
            return this.diff(this.getOldTime() == null ? null : DayCode.toString(this.getOldTime().getDays()), DayCode.toString(this.getTime().getDays()));
        }

        @Override
        public String getStart() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.startTime(this.getOldTime()), StudentEmail.startTime(this.getTime()));
        }

        @Override
        public String getEnd() {
            return this.diff(this.getOldTime() == null ? null : StudentEmail.endTime(this.getOldTime()), StudentEmail.endTime(this.getTime()));
        }

        @Override
        public String getDate() {
            return this.diff(this.getOldTime() == null ? null : this.getOldTime().getDatePatternName(), this.getTime().getDatePatternName());
        }
    }

    public class CourseRequestLine {
        public String priority;
        public String courseName;
        public String courseTitle;
        public String credit;
        public String prefs;
        public String note;
        public String status;
        public String icon;
        public String iconText;
        public boolean waitlist = false;
        public boolean first = false;
        public boolean firstalt = false;
        public boolean last = false;
        public boolean critical = false;
        public int rows = 1;
        public String waitListDate = null;
        public URL url;
        public int idx = 0;
        String firstChoice = null;

        public String getPriority() {
            return this.priority;
        }

        public String getCourseName() {
            return this.courseName;
        }

        public String getCourseTitle() {
            return this.courseTitle;
        }

        public String getCredit() {
            return this.credit;
        }

        public String getPrefs() {
            return this.prefs;
        }

        public String getNote() {
            return this.note;
        }

        public String getStatus() {
            return this.status;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getIconText() {
            return this.iconText;
        }

        public boolean isWaitlist() {
            return this.waitlist;
        }

        public String getWaitListDate() {
            return this.waitListDate;
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isFirstalt() {
            return this.firstalt;
        }

        public boolean isLast() {
            return this.last;
        }

        public boolean isCritical() {
            return this.critical;
        }

        public int getRows() {
            return this.rows;
        }

        public URL getUrl() {
            return this.url;
        }

        public int getIdx() {
            return this.idx;
        }

        public String getFirstChoice() {
            return this.firstChoice;
        }
    }

    public static class TableCourseLine
    implements TableLine {
        protected XCourseRequest iRequest;
        protected XCourse iCourse;
        protected Table iTable;
        protected String iUrl;
        protected boolean iWaitListEnabled;
        protected XCourse iSwapCourse;
        protected boolean iPlainText;

        public TableCourseLine(XCourseRequest request, XCourse course, URL url, boolean waitlistEnabled, XCourse swapCourse, boolean plainText) {
            this.iRequest = request;
            this.iCourse = course;
            this.iUrl = url == null ? null : url.toString();
            this.iWaitListEnabled = waitlistEnabled;
            this.iSwapCourse = swapCourse;
            this.iPlainText = plainText;
        }

        public TableCourseLine(XCourseRequest request, XCourse course, URL url, boolean plainText) {
            this(request, course, url, false, null, plainText);
        }

        @Override
        public XRequest getRequest() {
            return this.iRequest;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        @Override
        public boolean isPlainText() {
            return this.iPlainText;
        }

        @Override
        public String getSubject() {
            return this.getCourse().getSubjectArea();
        }

        @Override
        public String getCourseNumber() {
            return this.getCourse().getCourseNumber();
        }

        @Override
        public String getCourseTitle() {
            return this.getCourse().getTitle();
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public XTime getTime() {
            return null;
        }

        @Override
        public boolean isAssigned() {
            return false;
        }

        @Override
        public String getCredit() {
            return null;
        }

        @Override
        public boolean isWaitList() {
            return this.iRequest.isWaitlist() && this.iWaitListEnabled && this.iRequest.getWaitListedTimeStamp() != null;
        }

        @Override
        public String getNote() {
            if (this.iRequest.isWaitlist() && this.iWaitListEnabled && this.iRequest.getWaitListedTimeStamp() != null) {
                Integer status;
                List<XCourseRequest.XPreference> pref;
                Object note = MSG.conflictWaitListed(sTimeStampFormat.format(this.iRequest.getWaitListedTimeStamp()));
                if (this.iSwapCourse != null) {
                    note = (String)note + " " + MSG.conflictWaitListSwapWithNoCourseOffering(this.iSwapCourse.getCourseName());
                }
                if ((pref = this.iRequest.getPreferences(this.iCourse)) != null) {
                    TreeSet<String> prefs = new TreeSet<String>();
                    for (XCourseRequest.XPreference p : pref) {
                        if (!p.isRequired()) continue;
                        prefs.add(p.getLabel());
                    }
                    if (!prefs.isEmpty()) {
                        note = (String)note + " " + MSG.conflictRequiredPreferences(StudentEmail.toString(prefs));
                    }
                }
                if ((status = this.iRequest.getOverrideStatus(this.getCourse())) != null) {
                    if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                        note = (String)note + " " + MSG.overrideApproved(this.iCourse.getCourseName());
                    } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                        note = (String)note + " " + MSG.overrideRejectedWaitList(this.iCourse.getCourseName());
                    } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                        note = (String)note + " " + MSG.overrideCancelledWaitList(this.iCourse.getCourseName());
                    } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                        note = (String)note + " " + MSG.overrideNotRequested();
                    } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal()) {
                        note = (String)note + " " + MSG.overridePending(this.iCourse.getCourseName());
                    } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                        note = (String)note + " " + MSG.overrideNotNeeded(this.iCourse.getCourseName());
                    }
                }
                return note;
            }
            if (this.iRequest.isAlternative()) {
                return this.iRequest.isWaitlist() && this.iWaitListEnabled ? MSG.emailWaitListedAlternativeRequest() : MSG.emailNotEnrolledAlternativeRequest();
            }
            return this.iRequest.isWaitlist() && this.iWaitListEnabled ? MSG.emailWaitListedRequest() : MSG.emailNotEnrolledRequest();
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getRequires() {
            return null;
        }

        @Override
        public String getRooms() {
            return null;
        }

        @Override
        public String getInstructors() {
            return null;
        }

        @Override
        public boolean isFreeTime() {
            return false;
        }

        @Override
        public String getArrangeHours() {
            return null;
        }

        @Override
        public String getDays() {
            return null;
        }

        @Override
        public String getStart() {
            return null;
        }

        @Override
        public String getEnd() {
            return null;
        }

        @Override
        public String getDate() {
            return null;
        }

        @Override
        public void setTable(Table table) {
            this.iTable = table;
        }

        @Override
        public boolean isLast() {
            return this.iTable.isLast(this);
        }

        @Override
        public boolean isFirst() {
            return this.iTable.isFirst(this);
        }

        @Override
        public String getUrl() {
            return this.iUrl;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    public static class TableLineFreeTime
    implements TableLine {
        private XFreeTimeRequest iRequest;

        public TableLineFreeTime(XFreeTimeRequest request) {
            this.iRequest = request;
        }

        @Override
        public XRequest getRequest() {
            return this.iRequest;
        }

        @Override
        public boolean isPlainText() {
            return true;
        }

        @Override
        public String getSubject() {
            return MSG.freeTimeCourse();
        }

        @Override
        public String getCourseNumber() {
            return MSG.freeTimeSubject();
        }

        @Override
        public String getCourseTitle() {
            return null;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public XTime getTime() {
            return this.iRequest.getTime();
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public String getCredit() {
            return null;
        }

        @Override
        public String getNote() {
            return null;
        }

        @Override
        public String getCourseNote() {
            return null;
        }

        @Override
        public String getRequires() {
            return null;
        }

        @Override
        public String getRooms() {
            return "";
        }

        @Override
        public String getInstructors() {
            return "";
        }

        @Override
        public boolean isFreeTime() {
            return true;
        }

        @Override
        public String getArrangeHours() {
            return MSG.emailArrangeHours();
        }

        @Override
        public String getDays() {
            return DayCode.toString(this.getTime().getDays());
        }

        @Override
        public String getStart() {
            return StudentEmail.startTime(this.getTime());
        }

        @Override
        public String getEnd() {
            return StudentEmail.endTime(this.getTime());
        }

        @Override
        public String getDate() {
            return this.getTime().getDatePatternName();
        }

        @Override
        public void setTable(Table table) {
        }

        @Override
        public boolean isLast() {
            return true;
        }

        @Override
        public boolean isFirst() {
            return true;
        }

        @Override
        public String getUrl() {
            return null;
        }

        @Override
        public boolean isWaitList() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }
}

