/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.RoomPref;

@MappedSuperclass
public abstract class BaseRoomPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iRoomIndex;
    private Location iRoom;

    public BaseRoomPref() {
    }

    public BaseRoomPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="room_idx", nullable=true)
    public Integer getRoomIndex() {
        return this.iRoomIndex;
    }

    public void setRoomIndex(Integer roomIndex) {
        this.iRoomIndex = roomIndex;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="room_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Location getRoom() {
        return this.iRoom;
    }

    public void setRoom(Location room) {
        this.iRoom = room;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "RoomPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "RoomPref[\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tRoom: " + String.valueOf(this.getRoom()) + "\n\tRoomIndex: " + this.getRoomIndex() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

