/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.RefTableEntry;

@MappedSuperclass
public abstract class BaseExamType
extends RefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iType;
    private Boolean iHighlightInEvents;

    public BaseExamType() {
    }

    public BaseExamType(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="xtype", nullable=false)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="events", nullable=false)
    public Boolean isHighlightInEvents() {
        return this.iHighlightInEvents;
    }

    @Transient
    public Boolean getHighlightInEvents() {
        return this.iHighlightInEvents;
    }

    public void setHighlightInEvents(Boolean highlightInEvents) {
        this.iHighlightInEvents = highlightInEvents;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamType)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExamType)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExamType)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "ExamType[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "ExamType[\n\tHighlightInEvents: " + this.getHighlightInEvents() + "\n\tLabel: " + this.getLabel() + "\n\tReference: " + this.getReference() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

