/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;

@MappedSuperclass
public abstract class BaseAdvisor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iEmail;
    private Session iSession;
    private Roles iRole;
    private Set<Student> iStudents;

    public BaseAdvisor() {
    }

    public BaseAdvisor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=false, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="first_name", nullable=true, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="middle_name", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="last_name", nullable=true, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="acad_title", nullable=true, length=50)
    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="role_id", nullable=false)
    public Roles getRole() {
        return this.iRole;
    }

    public void setRole(Roles role) {
        this.iRole = role;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="student_advisor", joinColumns={@JoinColumn(name="advisor_id")}, inverseJoinColumns={@JoinColumn(name="student_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addToStudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Deprecated
    public void addTostudents(Student student) {
        this.addToStudents(student);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Advisor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Advisor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Advisor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Advisor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Advisor[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tRole: " + String.valueOf(this.getRole()) + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

