/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseStudentSectioningQueue;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.security.UserContext;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="sectioning_queue")
public class StudentSectioningQueue
extends BaseStudentSectioningQueue
implements Comparable<StudentSectioningQueue> {
    private static final long serialVersionUID = 8492171207847794888L;

    public static TreeSet<StudentSectioningQueue> getItems(Session hibSession, Long sessionId, Date lastTimeStamp) {
        if (sessionId != null) {
            if (lastTimeStamp == null) {
                return new TreeSet<StudentSectioningQueue>(hibSession.createQuery("select q from StudentSectioningQueue q where q.sessionId = :sessionId", StudentSectioningQueue.class).setParameter("sessionId", (Object)sessionId).list());
            }
            return new TreeSet<StudentSectioningQueue>(hibSession.createQuery("select q from StudentSectioningQueue q where q.sessionId = :sessionId and q.timeStamp > :timeStamp", StudentSectioningQueue.class).setParameter("sessionId", (Object)sessionId).setParameter("timeStamp", (Object)lastTimeStamp).list());
        }
        if (lastTimeStamp == null) {
            return new TreeSet<StudentSectioningQueue>(hibSession.createQuery("select q from StudentSectioningQueue q", StudentSectioningQueue.class).list());
        }
        return new TreeSet<StudentSectioningQueue>(hibSession.createQuery("select q from StudentSectioningQueue q where q.timeStamp > :timeStamp", StudentSectioningQueue.class).setParameter("timeStamp", (Object)lastTimeStamp).list());
    }

    public static Date getLastTimeStamp(Session hibSession, Long sessionId) {
        if (sessionId != null) {
            return (Date)hibSession.createQuery("select max(q.timeStamp) from StudentSectioningQueue q where q.sessionId = :sessionId", Date.class).setParameter("sessionId", (Object)sessionId).uniqueResult();
        }
        return (Date)hibSession.createQuery("select max(q.timeStamp) from StudentSectioningQueue q", Date.class).uniqueResult();
    }

    @Transient
    public Document getMessage() {
        try {
            return new SAXReader().read((Reader)new StringReader(this.getData()));
        }
        catch (DocumentException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    public void setMessage(Document document) {
        try {
            if (document == null) {
                this.setData(null);
            } else {
                StringWriter string = new StringWriter();
                XMLWriter writer = new XMLWriter((Writer)string, OutputFormat.createCompactFormat());
                writer.write(document);
                writer.flush();
                writer.close();
                this.setData(string.toString());
            }
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int compareTo(StudentSectioningQueue q) {
        int cmp = this.getTimeStamp().compareTo(q.getTimeStamp());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(q.getUniqueId() == null ? -1L : q.getUniqueId());
    }

    protected static void addItem(Session hibSession, UserContext user, Long sessionId, Type type, Collection<Long> ids) {
        StudentSectioningQueue q = new StudentSectioningQueue();
        q.setTimeStamp(new Date());
        q.setType(type.ordinal());
        q.setSessionId(sessionId);
        Document d = DocumentHelper.createDocument();
        Element root = d.addElement("generic");
        if (user != null) {
            Element e = root.addElement("user");
            e.addAttribute("id", user.getExternalUserId()).setText(user.getName());
        }
        if (ids != null && !ids.isEmpty()) {
            for (Long id : ids) {
                root.addElement("id").setText(id.toString());
            }
        }
        q.setMessage(d);
        hibSession.persist((Object)q);
    }

    protected static void addItem(Session hibSession, UserContext user, Long sessionId, Type type, Long ... ids) {
        StudentSectioningQueue q = new StudentSectioningQueue();
        q.setTimeStamp(new Date());
        q.setType(type.ordinal());
        q.setSessionId(sessionId);
        Document d = DocumentHelper.createDocument();
        Element root = d.addElement("generic");
        if (user != null) {
            Element e = root.addElement("user");
            e.addAttribute("id", user.getExternalUserId()).setText(user.getName());
        }
        if (ids != null && ids.length > 0) {
            for (Long id : ids) {
                root.addElement("id").setText(id.toString());
            }
        }
        q.setMessage(d);
        hibSession.persist((Object)q);
    }

    @Transient
    public List<Long> getIds() {
        if (this.getMessage() == null) {
            return null;
        }
        Element root = this.getMessage().getRootElement();
        if (!"generic".equals(root.getName())) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator i = root.elementIterator("id");
        while (i.hasNext()) {
            ids.add(Long.valueOf(((Element)i.next()).getText()));
        }
        return ids;
    }

    @Transient
    public OnlineSectioningLog.Entity getUser() {
        if (this.getMessage() == null) {
            return null;
        }
        Element root = this.getMessage().getRootElement();
        if (!"generic".equals(root.getName())) {
            return null;
        }
        Element user = root.element("user");
        if (user == null) {
            return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
        }
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(user.attributeValue("id")).setName(user.getText()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build();
    }

    public static void sessionStatusChanged(Session hibSession, UserContext user, Long sessionId, boolean reload) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, reload ? Type.SESSION_RELOAD : Type.SESSION_STATUS_CHANGE, new Long[0]);
    }

    public static void sessionSchedulingRulesChanged(Session hibSession, UserContext user, Long sessionId) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.SCHEDULING_RULES_CHANGED, new Long[0]);
    }

    public static void allStudentsChanged(Session hibSession, UserContext user, Long sessionId) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.STUDENT_ENROLLMENT_CHANGE, new Long[0]);
    }

    public static void studentChanged(Session hibSession, UserContext user, Long sessionId, Collection<Long> studentIds) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.STUDENT_ENROLLMENT_CHANGE, studentIds);
    }

    public static void classAssignmentChanged(Session hibSession, UserContext user, Long sessionId, Collection<Long> classIds) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.CLASS_ASSIGNMENT_CHANGE, classIds);
    }

    public static void classAssignmentChanged(Session hibSession, UserContext user, Long sessionId, Long ... classIds) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.CLASS_ASSIGNMENT_CHANGE, classIds);
    }

    public static void offeringChanged(Session hibSession, UserContext user, Long sessionId, Collection<Long> offeringId) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.OFFERING_CHANGE, offeringId);
    }

    public static void offeringChanged(Session hibSession, UserContext user, Long sessionId, Long ... offeringId) {
        StudentSectioningQueue.addItem(hibSession, user, sessionId, Type.OFFERING_CHANGE, offeringId);
    }

    public static enum Type {
        STUDENT_ENROLLMENT_CHANGE,
        CLASS_ASSIGNMENT_CHANGE,
        SESSION_STATUS_CHANGE,
        SESSION_RELOAD,
        OFFERING_CHANGE,
        SCHEDULING_RULES_CHANGED;

    }
}

