/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.Components;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaDialogBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class UniTimeDialogBox
extends AriaDialogBox
implements HasOpenHandlers<UniTimeDialogBox> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private FlowPanel iContainer;
    private FlowPanel iControls;
    private Anchor iClose;
    private Anchor iMaximize;
    private boolean iEscapeToHide = false;
    private Command iSubmitHandler = null;
    private String iWidth = null;
    private String iHeight = null;
    private boolean iMaximized = false;

    public UniTimeDialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.setAnimationEnabled(true);
        this.setGlassEnabled(true);
        this.iContainer = new FlowPanel();
        this.iContainer.addStyleName("dialogContainer");
        this.iMaximize = new Anchor();
        this.iMaximize.setTitle(MESSAGES.hintMaximizeDialog());
        this.iMaximize.setStyleName("maximize");
        this.iMaximize.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeDialogBox.this.onMaximizeClick(event);
            }
        });
        this.iMaximize.setVisible(false);
        this.iClose = new Anchor();
        this.iClose.setTitle(MESSAGES.hintCloseDialog());
        this.iClose.setStyleName("close");
        this.iClose.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeDialogBox.this.onCloseClick(event);
            }
        });
        this.iClose.setVisible(autoHide);
        this.iControls = new FlowPanel();
        this.iControls.setStyleName("dialogControls");
        this.iControls.add((Widget)this.iClose);
        this.iControls.add((Widget)this.iMaximize);
    }

    public void setMaximizeEnabled(boolean enabled) {
        this.iMaximize.setVisible(enabled);
    }

    public boolean isMaximizeEnabled() {
        return this.iMaximize.isVisible();
    }

    public void center() {
        super.center();
        AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()));
    }

    public void setAutoHideEnabled(boolean autoHide) {
        super.setAutoHideEnabled(autoHide);
        this.iClose.setVisible(autoHide);
    }

    public void setEscapeToHide(boolean escapeToHide) {
        this.iEscapeToHide = escapeToHide;
    }

    public boolean isEscapeToHide() {
        return this.iEscapeToHide;
    }

    public void setEnterToSubmit(Command submitCommand) {
        this.iSubmitHandler = submitCommand;
    }

    public boolean isEnterToSubmit() {
        return this.iSubmitHandler != null;
    }

    public void setWidget(Widget widget) {
        if (this.iContainer.getWidgetCount() == 0) {
            this.iContainer.add((Widget)this.iControls);
            super.setWidget((Widget)this.iContainer);
        } else {
            while (this.iContainer.getWidgetCount() > 1) {
                this.iContainer.remove(1);
            }
        }
        this.iContainer.add(widget);
    }

    protected void onCloseClick(ClickEvent event) {
        this.hide();
    }

    protected boolean isHasMenu() {
        return RootPanel.get((String)Components.menubar_static.id()) != null || RootPanel.get((String)Components.menubar_dynamic.id()) != null;
    }

    protected void maximize() {
        boolean hasMenu = this.isHasMenu();
        this.getElement().getStyle().setLeft((double)Window.getScrollLeft(), Style.Unit.PX);
        this.getElement().getStyle().setTop((double)(Window.getScrollTop() + (hasMenu ? 22 : 0)), Style.Unit.PX);
        this.iContainer.getWidget(1).setWidth("calc(100vw - 15px)");
        this.iContainer.getWidget(1).setHeight(hasMenu ? "calc(100vh - 72px)" : "calc(100vh - 50px)");
        this.iMaximize.setTitle(MESSAGES.hintDemaximizeDialog());
        ToolBox.setSessionCookie("UniTimeDialogBox.Maximize", "1");
        this.iMaximized = true;
    }

    protected void minimize() {
        if (this.iWidth != null) {
            this.iContainer.getWidget(1).getElement().getStyle().setProperty("width", this.iWidth);
        } else {
            this.iContainer.getWidget(1).getElement().getStyle().clearWidth();
        }
        if (this.iHeight != null) {
            this.iContainer.getWidget(1).getElement().getStyle().setProperty("height", this.iHeight);
        } else {
            this.iContainer.getWidget(1).getElement().getStyle().clearHeight();
        }
        this.center();
        this.iMaximize.setTitle(MESSAGES.hintMaximizeDialog());
        ToolBox.setSessionCookie("UniTimeDialogBox.Maximize", "0");
        this.iMaximized = false;
    }

    protected void onMaximizeClick(ClickEvent event) {
        if (!this.iMaximized) {
            this.maximize();
        } else {
            this.minimize();
        }
    }

    public HandlerRegistration addOpenHandler(OpenHandler<UniTimeDialogBox> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    public void show() {
        boolean fireOpen;
        boolean bl = fireOpen = !this.isShowing();
        if (this.iMaximize != null && this.iMaximize.isVisible()) {
            if (!this.iMaximized) {
                this.iHeight = this.iContainer.getWidget(1).getElement().getStyle().getProperty("height");
                this.iWidth = this.iContainer.getWidget(1).getElement().getStyle().getProperty("width");
            }
            this.iMaximized = "1".equals(ToolBox.getSessionCookie("UniTimeDialogBox.Maximize"));
            super.show();
            if (this.iMaximized) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        UniTimeDialogBox.this.maximize();
                    }
                });
            }
        } else {
            super.show();
        }
        if (fireOpen) {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
        }
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        switch (event.getTypeInt()) {
            case 128: {
                if (this.isEscapeToHide() && event.getNativeEvent().getKeyCode() == 27) {
                    AriaStatus.getInstance().setText(ARIA.dialogClosed(this.getText()));
                    this.hide();
                }
                if (!this.isEnterToSubmit() || event.getNativeEvent().getKeyCode() != 13) break;
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
                this.iSubmitHandler.execute();
            }
        }
    }
}

