/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.widgets.DayCodeSelector;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class TimePreferenceWidget
extends Composite
implements HasValue<PrefGroupEditInterface.TimeSelection> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages CMSG = (CourseMessages)GWT.create(CourseMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private PrefGroupEditInterface.TimePatternModel iModel;
    private List<PrefGroupEditInterface.PrefLevel> iPreferences;
    private AbsolutePanel iPanel;
    private PrefGroupEditInterface.PrefLevel iOption = null;
    private P iSelectedIcon = null;
    private P iSelectedTitle = null;
    protected boolean iEditable = true;
    private int iSplit = 14;
    private boolean iShowLegend = true;
    private boolean iHorizontal = true;
    private List<Cell> iAll = new ArrayList<Cell>();
    private ClickHandler iRemove;
    private ExactTable iExactTable;

    public TimePreferenceWidget(boolean editable, List<PrefGroupEditInterface.PrefLevel> preferences, boolean horizontal) {
        this.iEditable = editable;
        this.iPreferences = preferences;
        this.iHorizontal = horizontal;
        for (PrefGroupEditInterface.PrefLevel p : this.iPreferences) {
            if (!"0".equals(p.getCode())) continue;
            this.iOption = p;
        }
        this.iPanel = new AbsolutePanel();
        this.iPanel.setStyleName("unitime-RoomSharingWidget");
        this.initWidget((Widget)this.iPanel);
    }

    public void setRemove(ClickHandler remove) {
        this.iRemove = remove;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable(PrefGroupEditInterface.PrefLevel pref) {
        return this.isEditable() && this.iModel.isAllowedPref(pref.getTpCode());
    }

    public boolean isHorizontal() {
        return this.iHorizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.iHorizontal = horizontal;
    }

    public boolean isShowLegend() {
        return this.iShowLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.iShowLegend = showLegend;
    }

    public PrefGroupEditInterface.PrefLevel getPreference(int day, int slot) {
        char code = this.iModel.getPreference(day, slot);
        for (PrefGroupEditInterface.PrefLevel pref : this.iPreferences) {
            if (pref.getTpCode().charValue() != code) continue;
            return pref;
        }
        for (PrefGroupEditInterface.PrefLevel pref : this.iPreferences) {
            if (!"0".equals(pref.getCode())) continue;
            return pref;
        }
        return null;
    }

    public PrefGroupEditInterface.PrefLevel getPreference(String code) {
        for (PrefGroupEditInterface.PrefLevel pref : this.iPreferences) {
            if (!code.equals(pref.getCode())) continue;
            return pref;
        }
        return null;
    }

    public PrefGroupEditInterface.TimePatternModel getModel() {
        if (this.iModel.isExactTime()) {
            this.iModel.setPreference(this.iExactTable.getValue());
        }
        return this.iModel;
    }

    public void setModel(PrefGroupEditInterface.TimePatternModel model) {
        this.iModel = model;
        this.iPanel.clear();
        this.iAll.clear();
        if (this.iModel.getName() != null && !this.iModel.getName().isEmpty()) {
            P header = new P("header");
            P label = new P("name");
            label.setText(this.iModel.getName());
            header.add((Widget)label);
            if (this.iRemove != null) {
                ImageButton delete = new ImageButton(RESOURCES.delete());
                delete.addClickHandler(this.iRemove);
                delete.addStyleName("delete");
                header.add((Widget)delete);
            }
            if (!model.isValid()) {
                P warn = new P("warning");
                warn.setText(CMSG.warnNoMatchingDatePattern());
                header.add((Widget)warn);
            }
            this.iPanel.add((Widget)header);
        }
        if (this.iModel.isExactTime()) {
            this.iExactTable = new ExactTable();
            this.iExactTable.setValue(model.getPreference());
            this.iPanel.add((Widget)this.iExactTable);
            return;
        }
        this.iExactTable = null;
        if (this.iHorizontal) {
            P previousTable = null;
            for (int page = 0; page == 0 || this.iSplit > 0 && this.iSplit * page < this.iModel.getTimes().size(); ++page) {
                P table = new P("table");
                this.iPanel.add((Widget)table);
                P box = new P("box");
                table.add((Widget)box);
                P header = new P("row");
                box.add((Widget)header);
                P corner = new P("cell", "corner", this.isEditable() ? "clickable" : null);
                corner.setHTML(MESSAGES.roomSharingCorner());
                header.add((Widget)corner);
                int first = 0;
                int last = this.iModel.getTimes().size();
                if (this.iSplit > 0) {
                    first = this.iSplit * page;
                    last = Math.min(first + this.iSplit, this.iModel.getTimes().size());
                    if (previousTable != null) {
                        previousTable.getElement().getStyle().setDisplay(Style.Display.BLOCK);
                    }
                    previousTable = table;
                }
                ArrayList thisTime = new ArrayList();
                for (int slot = first; slot < last; ++slot) {
                    P p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                    p.setHTML(MESSAGES.roomSharingTimeHeader(this.iModel.getStartTime(slot, CONSTANTS), this.iModel.getEndTime(slot, CONSTANTS)));
                    final ArrayList t = new ArrayList();
                    thisTime.add(t);
                    header.add((Widget)p);
                    if (!this.isEditable()) continue;
                    p.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            for (Cell d : t) {
                                d.setOption(TimePreferenceWidget.this.iOption);
                            }
                        }
                    });
                }
                final ArrayList<Cell> thisPage = new ArrayList<Cell>();
                for (day = 0; day < this.iModel.getDays().size(); ++day) {
                    P line = new P("row");
                    box.add((Widget)line);
                    P d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                    d.setHTML(this.iModel.getDaysLabel(day, CONSTANTS));
                    line.add((Widget)d);
                    final ArrayList<Cell> thisDay = new ArrayList<Cell>();
                    for (int slot = first; slot < last; ++slot) {
                        Cell p = new Cell(day, slot);
                        if (this.iModel.isAssigned(day, slot)) {
                            p.addStyleName("highlight");
                        }
                        line.add((Widget)p);
                        thisDay.add(p);
                        thisPage.add(p);
                        ((List)thisTime.get(slot - first)).add(p);
                        this.iAll.add(p);
                    }
                    if (!this.isEditable()) continue;
                    d.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            for (Cell d : thisDay) {
                                d.setOption(TimePreferenceWidget.this.iOption);
                            }
                        }
                    });
                }
                if (!this.isEditable()) continue;
                corner.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisPage) {
                            d.setOption(TimePreferenceWidget.this.iOption);
                        }
                    }
                });
            }
        } else {
            P table = new P("table");
            this.iPanel.add((Widget)table);
            P box = new P("box");
            table.add((Widget)box);
            P header = new P("row");
            box.add((Widget)header);
            P corner = new P("cell", "corner", this.isEditable() ? "clickable" : null);
            corner.setHTML(MESSAGES.roomSharingCorner());
            header.add((Widget)corner);
            ArrayList thisDay = new ArrayList();
            for (int day = 0; day < this.iModel.getDays().size(); ++day) {
                P p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                p.setHTML(this.iModel.getDaysLabel(day, CONSTANTS));
                final ArrayList t = new ArrayList();
                thisDay.add(t);
                header.add((Widget)p);
                if (!this.isEditable()) continue;
                p.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : t) {
                            d.setOption(TimePreferenceWidget.this.iOption);
                        }
                    }
                });
            }
            final ArrayList<Cell> thisPage = new ArrayList<Cell>();
            for (int slot = 0; slot < this.iModel.getTimes().size(); ++slot) {
                P line = new P("row");
                box.add((Widget)line);
                P d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                d.setHTML(MESSAGES.roomSharingTimeHeader(this.iModel.getStartTime(slot, CONSTANTS), this.iModel.getEndTime(slot, CONSTANTS)));
                line.add((Widget)d);
                final ArrayList<Cell> thisSlot = new ArrayList<Cell>();
                for (day = 0; day < this.iModel.getDays().size(); ++day) {
                    Cell p = new Cell(day, slot);
                    line.add((Widget)p);
                    thisSlot.add(p);
                    thisPage.add(p);
                    ((List)thisDay.get(day)).add(p);
                    this.iAll.add(p);
                }
                if (!this.isEditable()) continue;
                d.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisSlot) {
                            d.setOption(TimePreferenceWidget.this.iOption);
                        }
                    }
                });
            }
            if (this.isEditable()) {
                corner.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisPage) {
                            d.setOption(TimePreferenceWidget.this.iOption);
                        }
                    }
                });
            }
        }
        if (!this.isShowLegend() && !this.isEditable()) {
            return;
        }
        P legend = new P("legend");
        this.iPanel.add((Widget)legend);
        P box = new P("box");
        legend.add((Widget)box);
        this.iSelectedIcon = null;
        this.iSelectedTitle = null;
        for (final PrefGroupEditInterface.PrefLevel option : this.iPreferences) {
            if (!this.iModel.isAllowedPref(option.getTpCode()) && this.iModel.getPreference().indexOf(option.getTpCode().charValue()) < 0) continue;
            P line = new P("row");
            final P icon = new P("cell", this.isEditable() && this.iModel.isAllowedPref(option.getTpCode()) ? "clickable" : null);
            if (box.getWidgetCount() == 0) {
                icon.addStyleName("first");
            }
            icon.getElement().getStyle().setBackgroundColor(option.getColor());
            line.add((Widget)icon);
            final P title = new P("title", this.isEditable(option) ? "editable-title" : null);
            title.setHTML(option.getTitle());
            line.add((Widget)title);
            if (this.isEditable(option) && option.equals(this.iOption)) {
                icon.addStyleName("selected");
                title.addStyleName("selected-title");
                this.iSelectedIcon = icon;
                this.iSelectedTitle = title;
            }
            if (this.isEditable(option)) {
                MouseDownHandler md = new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        TimePreferenceWidget.this.iOption = option;
                        if (TimePreferenceWidget.this.iSelectedIcon != null) {
                            TimePreferenceWidget.this.iSelectedIcon.removeStyleName("selected");
                        }
                        if (TimePreferenceWidget.this.iSelectedTitle != null) {
                            TimePreferenceWidget.this.iSelectedTitle.removeStyleName("selected-title");
                        }
                        icon.addStyleName("selected");
                        title.addStyleName("selected-title");
                        TimePreferenceWidget.this.iSelectedIcon = icon;
                        TimePreferenceWidget.this.iSelectedTitle = title;
                        if (TimePreferenceWidget.this.iModel.isReqConfirmation()) {
                            if ("R".equals(TimePreferenceWidget.this.iOption.getCode()) && TimePreferenceWidget.this.iModel.hasPreference()) {
                                UniTimeConfirmationDialog.alert(MESSAGES.warnPreferenceUseRequired());
                            }
                            if (TimePreferenceWidget.this.iModel.hasRequired() && !"R".equals(TimePreferenceWidget.this.iOption.getCode()) && !"0".equals(TimePreferenceWidget.this.iOption.getCode())) {
                                UniTimeConfirmationDialog.alert(MESSAGES.warnPreferenceUseNotRequired());
                            }
                        }
                    }
                };
                icon.addMouseDownHandler(md);
                title.addMouseDownHandler(md);
            }
            box.add((Widget)line);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<PrefGroupEditInterface.TimeSelection> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public PrefGroupEditInterface.TimeSelection getValue() {
        PrefGroupEditInterface.TimeSelection ret = new PrefGroupEditInterface.TimeSelection();
        ret.setItem(this.iModel.getId());
        if (this.iExactTable != null) {
            ret.setPreference(this.iExactTable.getValue());
        } else {
            ret.setPreference(this.iModel.getPreference());
        }
        return ret;
    }

    public void setValue(PrefGroupEditInterface.TimeSelection selection) {
        this.setValue(selection, false);
    }

    public void setValue(PrefGroupEditInterface.TimeSelection selection, boolean fireEvents) {
        this.iModel.setPreference(selection.getPreference());
        this.setModel(this.iModel);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    class ExactTable
    extends P
    implements TakesValue<String> {
        ChangeHandler iChangeHandler;
        HandlerRegistration iHandlerRegistration;

        public ExactTable() {
            super("preference-table");
            this.iChangeHandler = new ChangeHandler(){

                public void onChange(ChangeEvent e) {
                    if (((ExactLine)ExactTable.this.getWidget(ExactTable.this.getWidgetCount() - 1)).getValue() != null) {
                        ExactLine p = new ExactLine(null, null);
                        ExactTable.this.add((Widget)p);
                        ExactTable.this.iHandlerRegistration.removeHandler();
                        ExactTable.this.iHandlerRegistration = p.addChangeHandler(ExactTable.this.iChangeHandler);
                        ExactTable.this.fixButtons();
                    }
                }
            };
        }

        protected void fixButtons() {
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                ExactLine p = (ExactLine)this.getWidget(i);
                if (i < this.getWidgetCount() - 1) {
                    p.setButtonAdd(false);
                    continue;
                }
                p.setButtonAdd(true);
                this.iHandlerRegistration = p.addChangeHandler(this.iChangeHandler);
            }
        }

        public String getValue() {
            String ret = null;
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                ExactLine line = (ExactLine)this.getWidget(i);
                Integer[] value = line.getValue();
                if (value == null) continue;
                ret = ret == null ? value[0] + "," + value[1] : ret + ";" + value[0] + "," + value[1];
            }
            return ret;
        }

        public void setValue(String pattern) {
            this.clear();
            if (pattern != null) {
                for (String s : pattern.split(";")) {
                    if (s.indexOf(44) < 0) continue;
                    this.add((Widget)new ExactLine(Integer.valueOf(s.substring(0, s.indexOf(44))), Integer.valueOf(s.substring(1 + s.indexOf(44)))));
                }
            }
            this.add((Widget)new ExactLine(null, null));
            this.iChangeHandler = new ChangeHandler(){

                public void onChange(ChangeEvent e) {
                    ExactLine last = (ExactLine)ExactTable.this.getWidget(ExactTable.this.getWidgetCount() - 1);
                    if (last.getValue() != null) {
                        ExactLine el = new ExactLine(null, null);
                        ExactTable.this.add((Widget)el);
                        ExactTable.this.iHandlerRegistration.removeHandler();
                        ExactTable.this.iHandlerRegistration = el.addChangeHandler(ExactTable.this.iChangeHandler);
                        ExactTable.this.fixButtons();
                    }
                }
            };
            this.fixButtons();
        }

        class ExactLine
        extends P
        implements HasChangeHandlers,
        TakesValue<Integer[]> {
            DayCodeSelector iDays;
            TimeSelector iSlot;
            ImageButton iButton;
            boolean iButtonAdd;

            ExactLine(Integer days, Integer slot) {
                super("preference-line");
                this.iButtonAdd = false;
                this.iDays = new DayCodeSelector();
                if (days != null) {
                    this.iDays.setValue(days);
                }
                this.iDays.addStyleName("preference-cell");
                this.iDays.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                    public void onValueChange(ValueChangeEvent<Integer> event) {
                        ExactLine.this.fireEvent((GwtEvent)event);
                    }
                });
                this.add((Widget)this.iDays);
                this.iSlot = new TimeSelector();
                if (slot != null) {
                    this.iSlot.setValue(slot);
                }
                this.iSlot.addStyleName("preference-cell");
                this.iSlot.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                    public void onValueChange(ValueChangeEvent<Integer> event) {
                        ExactLine.this.fireEvent((GwtEvent)event);
                    }
                });
                this.add((Widget)this.iSlot);
                this.iButton = new ImageButton(RESOURCES.delete());
                this.iButton.setTitle(MESSAGES.titleDeleteRow());
                this.iButton.addStyleName("preference-cell");
                this.iButton.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                this.iButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (ExactLine.this.iButtonAdd) {
                            ExactTable.this.add((Widget)new ExactLine(null, null));
                        } else {
                            ExactTable.this.remove((Widget)ExactLine.this);
                        }
                        ExactTable.this.fixButtons();
                    }
                });
                this.add((Widget)this.iButton);
            }

            public HandlerRegistration addChangeHandler(ChangeHandler handler) {
                return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
            }

            public void setButtonAdd(boolean add) {
                this.iButtonAdd = add;
                if (add) {
                    this.iButton.setImage(RESOURCES.add());
                    this.iButton.setTitle(MESSAGES.titleAddRow());
                } else {
                    this.iButton.setImage(RESOURCES.delete());
                    this.iButton.setTitle(MESSAGES.titleDeleteRow());
                }
            }

            public void setValue(Integer[] value) {
                if (value == null) {
                    this.iDays.setValue(null);
                    this.iSlot.setValue(null);
                } else {
                    this.iDays.setValue(value[0]);
                    this.iSlot.setValue(value[1]);
                }
            }

            public Integer[] getValue() {
                if (this.iSlot.getValue() == null) {
                    return null;
                }
                return new Integer[]{this.iDays.getValue(), this.iSlot.getValue()};
            }
        }
    }

    public class Cell
    extends P {
        private int iDay;
        private int iSlot;

        Cell(int day, int slot) {
            super("cell", "item", TimePreferenceWidget.this.isEditable() ? "clickable" : null);
            this.iDay = day;
            this.iSlot = slot;
            PrefGroupEditInterface.PrefLevel option = TimePreferenceWidget.this.getPreference(day, slot);
            this.getElement().getStyle().setBackgroundColor(option.getColor());
            this.setTitle(TimePreferenceWidget.this.iModel.getDaysLabel(this.iDay, CONSTANTS) + " " + TimePreferenceWidget.this.iModel.getStartTime(this.iSlot, CONSTANTS) + " - " + TimePreferenceWidget.this.iModel.getEndTime(this.iSlot, CONSTANTS) + ": " + option.getTitle());
            if (TimePreferenceWidget.this.isEditable()) {
                this.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        Cell.this.setOption(TimePreferenceWidget.this.iOption);
                    }
                });
            }
        }

        public void setOption(PrefGroupEditInterface.PrefLevel option) {
            char code;
            PrefGroupEditInterface.PrefLevel neutral;
            TimePreferenceWidget.this.iModel.setPreference(this.iDay, this.iSlot, option.getTpCode().charValue());
            this.getElement().getStyle().setBackgroundColor(option.getColor());
            this.setTitle(TimePreferenceWidget.this.iModel.getDaysLabel(this.iDay, CONSTANTS) + " " + TimePreferenceWidget.this.iModel.getStartTime(this.iSlot, CONSTANTS) + " - " + TimePreferenceWidget.this.iModel.getEndTime(this.iSlot, CONSTANTS) + ": " + option.getTitle());
            ValueChangeEvent.fire((HasValueChangeHandlers)TimePreferenceWidget.this, (Object)TimePreferenceWidget.this.getValue());
            if ("R".equals(option.getCode()) && TimePreferenceWidget.this.iModel.hasPreference()) {
                neutral = TimePreferenceWidget.this.getPreference("0");
                for (Cell cell : TimePreferenceWidget.this.iAll) {
                    code = TimePreferenceWidget.this.iModel.getPreference(cell.getDay(), cell.getSlot());
                    if (code == 'R' || code == '2') continue;
                    cell.setOption(neutral);
                }
            }
            if (!"R".equals(option.getCode()) && !"0".equals(option.getCode()) && TimePreferenceWidget.this.iModel.hasRequired()) {
                neutral = TimePreferenceWidget.this.getPreference("0");
                for (Cell cell : TimePreferenceWidget.this.iAll) {
                    code = TimePreferenceWidget.this.iModel.getPreference(cell.getDay(), cell.getSlot());
                    if (code != 'R') continue;
                    cell.setOption(neutral);
                }
            }
        }

        public int getDay() {
            return this.iDay;
        }

        public int getSlot() {
            return this.iSlot;
        }
    }
}

