/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestDetailPage;
import org.unitime.timetable.gwt.client.instructor.TimePreferenceCell;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class TeachingRequestsTable
extends UniTimeTable<TeachingAssignmentsPage.SingleTeachingAssingment> {
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    private TeachingRequestDetailPage iDetail = null;
    private InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;

    public TeachingRequestsTable() {
        this.addStyleName("unitime-TeachingRequests");
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<TeachingAssignmentsPage.SingleTeachingAssingment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TeachingAssignmentsPage.SingleTeachingAssingment> event) {
                if (event.getData() != null && TeachingRequestsTable.this.iProperties != null) {
                    if (TeachingRequestsTable.this.iDetail == null) {
                        TeachingRequestsTable.this.iDetail = new TeachingRequestDetailPage(TeachingRequestsTable.this.iProperties){

                            @Override
                            protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                                TeachingRequestsTable.this.onAssignmentChanged(assignments);
                            }
                        };
                        TeachingRequestsTable.this.iDetail.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                            public void onClose(CloseEvent<PopupPanel> event) {
                                TeachingRequestsTable.this.clearHover();
                            }
                        });
                    }
                    TeachingRequestsTable.this.iDetail.showRequestDetail(event.getData().getRequest().getRequestId());
                }
            }
        });
    }

    protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
    }

    public void setProperties(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        this.iProperties = properties;
    }

    /*
     * WARNING - void declaration
     */
    void populate(GwtRpcResponseList<InstructorInterface.TeachingRequestInfo> results, EventInterface.FilterRpcRequest filter) {
        void var13_26;
        final Boolean assigned = filter != null && filter.hasOption("assigned") ? Boolean.valueOf("true".equalsIgnoreCase(filter.getOption("assigned"))) : null;
        this.clearTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader sortHeader = null;
        Object sortColumn = null;
        boolean asc = true;
        int sort = InstructorCookie.getInstance().getSortTeachingRequestsBy(assigned);
        for (Object column : COLUMN.values()) {
            if (!column.isVisible(assigned)) continue;
            final UniTimeTableHeader uniTimeTableHeader = this.getHeader((COLUMN)((Object)column));
            uniTimeTableHeader.addOperation(new UniTimeTableHeader.Operation(){
                final /* synthetic */ COLUMN val$column;
                final /* synthetic */ Boolean val$assigned;
                {
                    this.val$column = cOLUMN;
                    this.val$assigned = bl;
                }

                public void execute() {
                    TeachingRequestsTable.this.sort(uniTimeTableHeader, new TableComparator(this.val$column));
                    InstructorCookie.getInstance().setSortTeachingRequestsBy(this.val$assigned, uniTimeTableHeader.getOrder() != false ? 1 + this.val$column.ordinal() : -1 - this.val$column.ordinal());
                    TeachingRequestsTable.this.hideDuplicateRequests(this.val$assigned);
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return true;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(uniTimeTableHeader.getHTML().replace("<br>", " "));
                }
            });
            header.add(uniTimeTableHeader);
            if (sort == 0 || Math.abs(sort) - 1 != column.ordinal()) continue;
            sortHeader = uniTimeTableHeader;
            sortColumn = column;
            asc = sort > 0;
        }
        this.addRow(null, header);
        boolean hasInstructor = false;
        for (InstructorInterface.TeachingRequestInfo request : results) {
            ArrayList<Widget> line;
            int row;
            Widget cell;
            if (assigned == null) {
                if (request.hasInstructors()) {
                    for (InstructorInterface.InstructorInfo instructorInfo : request.getInstructors()) {
                        hasInstructor = true;
                        ArrayList<Widget> line2 = new ArrayList<Widget>();
                        for (COLUMN column : COLUMN.values()) {
                            if (!column.isVisible(assigned)) continue;
                            cell = this.getCell(column, request, instructorInfo);
                            if (cell == null) {
                                cell = new Label();
                            }
                            line2.add(cell);
                        }
                        row = this.addRow(new TeachingAssignmentsPage.SingleTeachingAssingment(instructorInfo, request), line2);
                        if (!instructorInfo.isConflict()) continue;
                        this.getRowFormatter().addStyleName(row, "enrollment-conflict");
                    }
                    continue;
                }
                line = new ArrayList();
                COLUMN[] cOLUMNArray = COLUMN.values();
                int line2 = cOLUMNArray.length;
                for (row = 0; row < line2; ++row) {
                    COLUMN column = cOLUMNArray[row];
                    if (!column.isVisible(assigned)) continue;
                    Widget cell2 = this.getCell(column, request, null);
                    if (cell2 == null) {
                        cell2 = new Label();
                    }
                    line.add(cell2);
                }
                this.addRow(new TeachingAssignmentsPage.SingleTeachingAssingment(null, request), line);
                continue;
            }
            if (assigned.booleanValue() && request.hasInstructors()) {
                for (InstructorInterface.InstructorInfo instructorInfo : request.getInstructors()) {
                    if (!instructorInfo.isMatchingFilter()) continue;
                    ArrayList<Widget> line3 = new ArrayList<Widget>();
                    for (COLUMN column : COLUMN.values()) {
                        if (!column.isVisible(assigned)) continue;
                        cell = this.getCell(column, request, instructorInfo);
                        if (cell == null) {
                            cell = new Label();
                        }
                        line3.add(cell);
                    }
                    row = this.addRow(new TeachingAssignmentsPage.SingleTeachingAssingment(instructorInfo, request), line3);
                    if (!instructorInfo.isConflict()) continue;
                    this.getRowFormatter().addStyleName(row, "enrollment-conflict");
                }
                continue;
            }
            if (assigned.booleanValue() || request.getNrAssignedInstructors() >= request.getNrInstructors()) continue;
            line = new ArrayList<Widget>();
            COLUMN[] cOLUMNArray = COLUMN.values();
            int line3 = cOLUMNArray.length;
            for (row = 0; row < line3; ++row) {
                COLUMN column = cOLUMNArray[row];
                if (!column.isVisible(assigned)) continue;
                Widget cell3 = this.getCell(column, request, null);
                if (cell3 == null) {
                    cell3 = new Label();
                }
                line.add(cell3);
            }
            this.addRow(new TeachingAssignmentsPage.SingleTeachingAssingment(null, request), line);
        }
        if (sortHeader != null) {
            this.sort(sortHeader, new TableComparator((COLUMN)((Object)sortColumn)), asc);
        }
        int col = 0;
        COLUMN[] cOLUMNArray = COLUMN.values();
        int n = cOLUMNArray.length;
        boolean bl = false;
        while (var13_26 < n) {
            final COLUMN column = cOLUMNArray[var13_26];
            if (column.isVisible(assigned)) {
                final UniTimeTableHeader h = (UniTimeTableHeader)header.get(col);
                final int colIdx = col;
                if (column.isCanHide()) {
                    ((UniTimeTableHeader)header.get(0)).getOperations().add(((UniTimeTableHeader)header.get(0)).getOperations().size() - 1, new UniTimeTableHeader.Operation(){

                        public void execute() {
                            boolean visible = !InstructorCookie.getInstance().isTeachingRequestsColumnVisible(assigned, column.ordinal());
                            InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, column.ordinal(), visible);
                            TeachingRequestsTable.this.setColumnVisible(colIdx, visible);
                            if (COLUMN.NAME == column && !visible) {
                                InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, COLUMN.EXTERNAL_ID.ordinal(), true);
                                TeachingRequestsTable.this.setColumnVisible(colIdx - 1, true);
                            } else if (COLUMN.EXTERNAL_ID == column && !visible) {
                                InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, COLUMN.NAME.ordinal(), true);
                                TeachingRequestsTable.this.setColumnVisible(colIdx + 1, true);
                            }
                        }

                        @Override
                        public boolean isApplicable() {
                            return true;
                        }

                        @Override
                        public boolean hasSeparator() {
                            return false;
                        }

                        @Override
                        public String getName() {
                            if (InstructorCookie.getInstance().isTeachingRequestsColumnVisible(assigned, column.ordinal())) {
                                return MESSAGES.opHide(h.getHTML().replace("<br>", " "));
                            }
                            return MESSAGES.opShow(h.getHTML().replace("<br>", " "));
                        }
                    });
                    h.addOperation(new UniTimeTableHeader.Operation(){

                        public void execute() {
                            boolean visible = !InstructorCookie.getInstance().isTeachingRequestsColumnVisible(assigned, column.ordinal());
                            InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, column.ordinal(), visible);
                            TeachingRequestsTable.this.setColumnVisible(colIdx, visible);
                            if (COLUMN.NAME == column && !visible) {
                                InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, COLUMN.EXTERNAL_ID.ordinal(), true);
                                TeachingRequestsTable.this.setColumnVisible(colIdx - 1, true);
                            } else if (COLUMN.EXTERNAL_ID == column && !visible) {
                                InstructorCookie.getInstance().setTeachingRequestsColumnVisible(assigned, COLUMN.NAME.ordinal(), true);
                                TeachingRequestsTable.this.setColumnVisible(colIdx + 1, true);
                            }
                        }

                        @Override
                        public boolean isApplicable() {
                            return true;
                        }

                        @Override
                        public boolean hasSeparator() {
                            return true;
                        }

                        @Override
                        public String getName() {
                            if (InstructorCookie.getInstance().isTeachingRequestsColumnVisible(assigned, column.ordinal())) {
                                return MESSAGES.opHideItem(h.getHTML().replace("<br>", " "));
                            }
                            return MESSAGES.opShowItem(h.getHTML().replace("<br>", " "));
                        }
                    });
                }
                this.setColumnVisible(col, !column.isCanHide() || InstructorCookie.getInstance().isTeachingRequestsColumnVisible(assigned, column.ordinal()));
                if (assigned == null && !hasInstructor && column.isCanHide() && column.isHasInstructor()) {
                    this.setColumnVisible(col, false);
                }
                ++col;
            }
            ++var13_26;
        }
        this.hideDuplicateRequests(assigned);
    }

    public void hideDuplicateRequests(Boolean assigned) {
        if (assigned != null && !assigned.booleanValue()) {
            return;
        }
        InstructorInterface.TeachingRequestInfo last = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            TeachingAssignmentsPage.SingleTeachingAssingment ta = (TeachingAssignmentsPage.SingleTeachingAssingment)this.getData(i);
            if (ta == null) {
                last = null;
                continue;
            }
            if (ta.getRequest().equals(last)) {
                for (COLUMN column : COLUMN.values()) {
                    this.getCellFormatter().setStyleName(i, column.ordinal(), null);
                    if (column.isHasInstructor()) continue;
                    this.getWidget(i, column.ordinal()).setVisible(false);
                }
            } else {
                for (COLUMN column : COLUMN.values()) {
                    this.getCellFormatter().setStyleName(i, column.ordinal(), "first-line");
                    if (column.isHasInstructor()) continue;
                    this.getWidget(i, column.ordinal()).setVisible(true);
                }
            }
            last = ta.getRequest();
        }
    }

    public UniTimeTableHeader getHeader(COLUMN column) {
        switch (column) {
            case COURSE: {
                return new UniTimeTableHeader(MESSAGES.colCourse());
            }
            case SECTION: {
                return new UniTimeTableHeader(MESSAGES.colSection());
            }
            case TIME: {
                return new UniTimeTableHeader(MESSAGES.colTime());
            }
            case DATE: {
                return new UniTimeTableHeader(MESSAGES.colDate());
            }
            case ROOM: {
                return new UniTimeTableHeader(MESSAGES.colRoom());
            }
            case LOAD: {
                return new UniTimeTableHeader(MESSAGES.colTeachingLoad());
            }
            case ATTRIBUTE_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colInstructorPreferences());
            }
            case EXTERNAL_ID: {
                return new UniTimeTableHeader(MESSAGES.colExternalId());
            }
            case NAME: {
                return new UniTimeTableHeader(MESSAGES.colNamePerson());
            }
            case ATTRIBUTES: {
                return new UniTimeTableHeader(MESSAGES.colAttributes());
            }
            case COURSE_PREF: {
                return new UniTimeTableHeader(MESSAGES.colCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                return new UniTimeTableHeader(MESSAGES.colDistributionPreferences());
            }
            case TIME_PREF: {
                UniTimeTableHeader timePrefHeader = new UniTimeTableHeader(MESSAGES.colTimePreferences());
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(true, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingRequestsTable.this.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationAsText();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingRequestsTable.this.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return RoomCookie.getInstance().isGridAsText();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationAsGrid();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, true);
                        TeachingRequestsTable.this.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && !RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationHorizontal();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, false);
                        TeachingRequestsTable.this.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationVertical();
                    }
                });
                if (this.iProperties != null && this.iProperties.hasModes() && !RoomCookie.getInstance().isGridAsText()) {
                    int i = 0;
                    while (i < this.iProperties.getModes().size()) {
                        final RoomInterface.RoomSharingDisplayMode mode = this.iProperties.getModes().get(i);
                        final int index = i++;
                        timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                            public void execute() {
                                RoomCookie.getInstance().setMode(RoomCookie.getInstance().areRoomsHorizontal(), mode.toHex());
                                TeachingRequestsTable.this.refreshTable();
                            }

                            @Override
                            public boolean isApplicable() {
                                return !RoomCookie.getInstance().isGridAsText() && !mode.toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            @Override
                            public boolean hasSeparator() {
                                return index == 0 || index == 1 && TeachingRequestsTable.this.iProperties.getModes().get(0).toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            @Override
                            public String getName() {
                                return mode.getName();
                            }
                        });
                    }
                }
                return timePrefHeader;
            }
            case ASSIGNED_LOAD: {
                return new UniTimeTableHeader(MESSAGES.colAssignedLoad());
            }
            case OBJECTIVES: {
                return new UniTimeTableHeader(MESSAGES.colObjectives());
            }
            case ASSIGNED_INSTRUCTORS: {
                return new UniTimeTableHeader(MESSAGES.colAssignedInstructors());
            }
        }
        return new UniTimeTableHeader(column.name());
    }

    public Widget getCell(COLUMN column, InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor) {
        switch (column) {
            case COURSE: {
                return new Label(request.getCourse().getCourseName(), false);
            }
            case SECTION: {
                P p = new P("sections");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("section");
                    i.setText(s.getSectionType() + (String)(s.getExternalId() == null ? "" : " " + s.getExternalId()));
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case TIME: {
                P p = new P("times");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("time");
                    i.setHTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case DATE: {
                P p = new P("dates");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("date");
                    i.setHTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case ROOM: {
                P p = new P("rooms");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("room");
                    i.setHTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case LOAD: {
                return new Label(sTeachingLoadFormat.format((double)request.getLoad()));
            }
            case EXTERNAL_ID: {
                InstructorInterface.PreferenceInterface pref;
                if (instructor == null || instructor.getExternalId() == null) {
                    return null;
                }
                Label extId = new Label(instructor.getExternalId());
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                    extId.setTitle(pref.getName() + " " + instructor.getExternalId());
                    extId.getElement().getStyle().setColor(pref.getColor());
                }
                return extId;
            }
            case NAME: {
                InstructorInterface.PreferenceInterface pref;
                if (instructor == null || instructor.getInstructorName() == null) {
                    return null;
                }
                Label name = new Label(instructor.getInstructorName());
                if (instructor.getTeachingPreference() != null && !"0".equals(instructor.getTeachingPreference()) && (pref = this.iProperties.getPreference(instructor.getTeachingPreference())) != null) {
                    name.setTitle(pref.getName() + " " + instructor.getInstructorName());
                    name.getElement().getStyle().setColor(pref.getColor());
                }
                return name;
            }
            case ATTRIBUTE_PREFS: {
                return new PreferenceCell(this.iProperties, request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return new PreferenceCell(this.iProperties, request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                if (instructor == null) {
                    return null;
                }
                return new PreferenceCell(this.iProperties, instructor.getCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                if (instructor == null) {
                    return null;
                }
                return new PreferenceCell(this.iProperties, instructor.getDistributionPreferences());
            }
            case TIME_PREF: {
                if (instructor == null) {
                    return null;
                }
                return new TimePreferenceCell(this.iProperties, instructor);
            }
            case ATTRIBUTES: {
                if (instructor == null) {
                    return null;
                }
                return new AttributesCell(instructor.getAttributes());
            }
            case ASSIGNED_LOAD: {
                if (instructor == null) {
                    return null;
                }
                return new Label(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad()));
            }
            case OBJECTIVES: {
                if (instructor == null) {
                    return null;
                }
                return new ObjectivesCell(this.iProperties, instructor.getValues());
            }
            case ASSIGNED_INSTRUCTORS: {
                return new Label(request.getNrAssignedInstructors() + " / " + request.getNrInstructors());
            }
        }
        return null;
    }

    public static enum COLUMN {
        COURSE(false),
        SECTION(false),
        TIME(true),
        DATE(true),
        ROOM(true),
        LOAD(true),
        ASSIGNED_INSTRUCTORS(true),
        ATTRIBUTE_PREFS(true),
        INSTRUCTOR_PREFS(true),
        EXTERNAL_ID(true, true),
        NAME(true, true),
        ASSIGNED_LOAD(true, true),
        ATTRIBUTES(true, true),
        COURSE_PREF(true, true),
        TIME_PREF(true, true),
        DISTRIBUTION_PREF(true, true),
        OBJECTIVES(true, true);

        private boolean iCanHide;
        private boolean iHasInstructor;

        private COLUMN(boolean canHide, boolean hasInstructor) {
            this.iCanHide = canHide;
            this.iHasInstructor = hasInstructor;
        }

        private COLUMN(boolean canHide) {
            this(canHide, false);
        }

        public boolean isVisible(Boolean assigned) {
            return assigned == null || assigned != false || !this.iHasInstructor;
        }

        public boolean isHasInstructor() {
            return this.iHasInstructor;
        }

        public boolean isCanHide() {
            return this.iCanHide;
        }

        public int flag() {
            return 1 << this.ordinal();
        }
    }

    public static class TableComparator
    implements Comparator<TeachingAssignmentsPage.SingleTeachingAssingment> {
        private COLUMN iColumn;

        public TableComparator(COLUMN column) {
            this.iColumn = column;
        }

        protected int compareSections(COLUMN column, InstructorInterface.SectionInfo s1, InstructorInterface.SectionInfo s2) {
            switch (column) {
                case SECTION: {
                    return this.compareOthers(s1, s2);
                }
                case TIME: {
                    return this.compareStrings(s1.getTime(), s2.getTime());
                }
                case DATE: {
                    return this.compareStrings(s1.getDate(), s2.getDate());
                }
                case ROOM: {
                    return this.compareStrings(s1.getRoom(), s2.getRoom());
                }
            }
            return 0;
        }

        protected int comparePreferences(List<InstructorInterface.PreferenceInfo> p1, List<InstructorInterface.PreferenceInfo> p2) {
            Iterator<InstructorInterface.PreferenceInfo> i1 = p1.iterator();
            Iterator<InstructorInterface.PreferenceInfo> i2 = p2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                int cmp = i1.next().compareTo(i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            if (i2.hasNext()) {
                return -1;
            }
            if (i1.hasNext()) {
                return 1;
            }
            return i1.hasNext() ? 1 : (i2.hasNext() ? -1 : 0);
        }

        private int compareByColumn(COLUMN column, TeachingAssignmentsPage.SingleTeachingAssingment a1, TeachingAssignmentsPage.SingleTeachingAssingment a2) {
            InstructorInterface.TeachingRequestInfo r1 = a1.getRequest();
            InstructorInterface.TeachingRequestInfo r2 = a2.getRequest();
            InstructorInterface.InstructorInfo i1 = a1.getInstructor();
            InstructorInterface.InstructorInfo i2 = a2.getInstructor();
            if (column.isHasInstructor() && (i1 == null || i2 == null)) {
                return this.compareBooleans(i1 == null, i2 == null);
            }
            switch (column) {
                case COURSE: {
                    return this.compareOthers(r1.getCourse(), r2.getCourse());
                }
                case SECTION: 
                case TIME: 
                case DATE: 
                case ROOM: {
                    Iterator<InstructorInterface.SectionInfo> it1 = r1.getSections().iterator();
                    Iterator<InstructorInterface.SectionInfo> it2 = r2.getSections().iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        int cmp = this.compareSections(column, it1.next(), it2.next());
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    if (it2.hasNext()) {
                        return -1;
                    }
                    if (it1.hasNext()) {
                        return 1;
                    }
                    return it1.hasNext() ? 1 : (it2.hasNext() ? -1 : 0);
                }
                case ASSIGNED_LOAD: {
                    int cmp = this.compareNumbers(Float.valueOf(i1.getAssignedLoad()), Float.valueOf(i2.getAssignedLoad()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return this.compareNumbers(Float.valueOf(i1.getMaxLoad()), Float.valueOf(i2.getMaxLoad()));
                }
                case NAME: {
                    return this.compareStrings(i1.getInstructorName(), i2.getInstructorName());
                }
                case EXTERNAL_ID: {
                    return this.compareStrings(i1.getExternalId(), i2.getExternalId());
                }
                case LOAD: {
                    return this.compareNumbers(Float.valueOf(r1.getLoad()), Float.valueOf(r2.getLoad()));
                }
                case OBJECTIVES: {
                    TreeSet<String> keys = new TreeSet<String>(i1.getValues().keySet());
                    keys.addAll(i2.getValues().keySet());
                    for (String key : keys) {
                        Double d2;
                        Double d = i1.getValues().get(key);
                        int cmp = this.compareNumbers(d, d2 = i2.getValues().get(key));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTES: {
                    TreeSet<String> attributes = new TreeSet<String>();
                    for (InstructorInterface.AttributeInterface attributeInterface : i1.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (InstructorInterface.AttributeInterface attributeInterface : i2.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (String string : attributes) {
                        int cmp = this.compareBooleans(i1.hasAttribute(string), i2.hasAttribute(string));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTE_PREFS: {
                    return this.comparePreferences(r1.getAttributePreferences(), r2.getAttributePreferences());
                }
                case COURSE_PREF: {
                    return this.comparePreferences(i1.getCoursePreferences(), i2.getCoursePreferences());
                }
                case INSTRUCTOR_PREFS: {
                    return this.comparePreferences(r1.getInstructorPreferences(), r2.getInstructorPreferences());
                }
                case DISTRIBUTION_PREF: {
                    return this.comparePreferences(i1.getDistributionPreferences(), i2.getDistributionPreferences());
                }
                case TIME_PREF: {
                    return this.comparePreferences(i1.getTimePreferences(), i2.getTimePreferences());
                }
                case ASSIGNED_INSTRUCTORS: {
                    int cmp = this.compareNumbers(r1.getNrAssignedInstructors(), r2.getNrAssignedInstructors());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return -this.compareNumbers(r1.getNrInstructors(), r2.getNrInstructors());
                }
            }
            return 0;
        }

        @Override
        public int compare(TeachingAssignmentsPage.SingleTeachingAssingment a1, TeachingAssignmentsPage.SingleTeachingAssingment a2) {
            int cmp = this.compareByColumn(this.iColumn, a1, a2);
            if (cmp != 0) {
                return cmp;
            }
            return a1.getRequest().compareTo(a2.getRequest());
        }

        protected int compareStrings(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        protected int compareNumbers(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        protected int compareBooleans(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }

        protected int compareOthers(Comparable c1, Comparable c2) {
            return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
        }
    }
}

