/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.curricula.CurriculaClassifications;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.curricula.CurriculumProjectionRulesPage;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

public class CurriculaTable
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private UniTimeTable<CurriculumInterface> iTable = null;
    private CurriculumInterface.CurriculumFilterRpcRequest iLastQuery = null;
    private AriaButton iOperations = null;
    private AsyncCallback<List<CurriculumInterface.CurriculumClassificationInterface>> iLoadClassifications;
    private List<CurriculumClickHandler> iCurriculumClickHandlers = new ArrayList<CurriculumClickHandler>();
    private Long iLastCurriculumId = null;
    private CurriculaClassifications iClassifications = null;
    private PopupPanel iClassificationsPopup = null;
    private HashSet<Long> iSelectedCurricula = new HashSet();
    private boolean iIsAdmin = false;
    private boolean iSessionHasSnapshotData = false;
    private EditClassificationHandler iEditClassificationHandler = null;

    public CurriculaTable() {
        this.iOperations = new AriaButton(MESSAGES.buttonMoreOperations());
        this.iOperations.addStyleName("unitime-NoPrint");
        this.iTable = new UniTimeTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (CurriculumColumn column : CurriculumColumn.values()) {
            UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column), this.getColumnAlignment(column));
            h.setWidth(this.getColumnWidth(column));
            this.addOperations(column, h);
            header.add(h);
        }
        this.iTable.addRow(null, header);
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<CurriculumInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<CurriculumInterface> event) {
                if (event.getData() == null) {
                    return;
                }
                CurriculaTable.this.setLastSelectedRow(event.getRow());
                CurriculumClickedEvent e = new CurriculumClickedEvent(event.getData());
                for (CurriculumClickHandler h : CurriculaTable.this.iCurriculumClickHandlers) {
                    h.onClick(e);
                }
            }
        });
        this.initWidget((Widget)this.iTable);
        this.iLoadClassifications = new AsyncCallback<List<CurriculumInterface.CurriculumClassificationInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<CurriculumInterface.CurriculumClassificationInterface> classifications) {
                if (CurriculaTable.this.iTable.getRowCount() <= 1) {
                    return;
                }
                ArrayList<Integer> rows = new ArrayList<Integer>();
                CurriculumInterface last = null;
                block0: for (CurriculumInterface.CurriculumClassificationInterface clasf : classifications) {
                    CurriculaTable.this.iSessionHasSnapshotData = clasf.isSessionHasSnapshotData();
                    if (last != null && last.getId().equals(clasf.getCurriculumId())) {
                        last.addClassification(clasf);
                        continue;
                    }
                    for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                        CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                        if (c == null || !c.getId().equals(clasf.getCurriculumId())) continue;
                        if (c.hasClassifications()) {
                            c.getClassifications().clear();
                        }
                        c.addClassification(clasf);
                        rows.add(row);
                        last = c;
                        continue block0;
                    }
                }
                Iterator<CurriculumInterface.CurriculumClassificationInterface> iterator = rows.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)((Object)iterator.next());
                    CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 5)).setText(c.getLastLikeString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 6)).setText(c.getProjectionString());
                    if (CurriculaTable.this.iTable.getWidget(row, 7) instanceof Image) {
                        CurriculaTable.this.iTable.setWidget(row, 7, (Widget)new Label(c.getExpectedString(), false));
                        CurriculaTable.this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_RIGHT);
                    } else {
                        ((Label)CurriculaTable.this.iTable.getWidget(row, 7)).setText(c.getExpectedString());
                    }
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 8)).setText(c.getEnrollmentString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 9)).setText(c.getRequestedString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 10)).setText(!c.isSessionHasSnapshotData() ? "" : c.getSnapshotExpectedString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 11)).setText(!c.isSessionHasSnapshotData() ? "" : c.getSnapshotProjectionString());
                }
                ArrayList<Long> noEnrl = new ArrayList<Long>();
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                    if (c != null && !c.hasClassifications()) {
                        noEnrl.add(c.getId());
                        if (noEnrl.size() == 1) {
                            CurriculaTable.this.iTable.setWidget(row, 7, (Widget)new Image(RESOURCES.loading_small()));
                            CurriculaTable.this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_LEFT);
                        }
                    }
                    if (noEnrl.size() >= 10) break;
                }
                if (!noEnrl.isEmpty()) {
                    CurriculaTable.this.iService.loadClassifications(noEnrl, CurriculaTable.this.iLoadClassifications);
                } else {
                    int sortBy = CurriculumCookie.getInstance().getSortBy();
                    if (sortBy != 0) {
                        int col = Math.abs(sortBy) - 1;
                        CurriculumColumn column = CurriculumColumn.values()[col];
                        Comparator<CurriculumInterface> cmp = column.getComparator();
                        if (cmp != null) {
                            boolean asc = sortBy > 0;
                            UniTimeTableHeader h = CurriculaTable.this.iTable.getHeader(col);
                            CurriculaTable.this.iTable.sort(h, cmp, asc);
                        }
                    }
                }
            }
        };
        this.iClassifications = new CurriculaClassifications();
        this.iClassificationsPopup = new PopupPanel();
        this.iClassificationsPopup.setWidget((Widget)this.iClassifications);
        this.iClassificationsPopup.setStyleName("unitime-PopupHint");
        this.iService.isAdmin(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                CurriculaTable.this.iIsAdmin = result;
            }
        });
        this.iTable.setHintProvider(new UniTimeTable.HintProvider<CurriculumInterface>(){

            @Override
            public Widget getHint(UniTimeTable.TableEvent<CurriculumInterface> event) {
                if (event.getData() == null || !event.getData().hasClassifications()) {
                    return null;
                }
                CurriculaTable.this.iClassifications.populate(event.getData().getClassifications());
                CurriculaTable.this.iClassifications.setEnabled(false);
                CurriculaTable.this.iClassifications.hideEmptyRows();
                return CurriculaTable.this.iClassifications;
            }
        });
        this.iOperations.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupPanel popup = new PopupPanel(true);
                if (!CurriculaTable.this.iTable.getHeader(0).setMenu(popup)) {
                    return;
                }
                popup.showRelativeTo((UIObject)CurriculaTable.this.iOperations);
                ((MenuBar)popup.getWidget()).focus();
            }
        });
    }

    public void setLastSelectedRow(int row) {
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            if (!"unitime-TableRowSelected".equals(this.iTable.getRowFormatter().getStyleName(r))) continue;
            this.iTable.getRowFormatter().setStyleName(r, null);
        }
        if (row >= 0) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c != null) {
                this.iLastCurriculumId = c.getId();
                this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowSelected");
            } else {
                this.iLastCurriculumId = null;
            }
        } else {
            this.iLastCurriculumId = null;
        }
    }

    protected List<CurriculumInterface> selected() {
        ArrayList<CurriculumInterface> selected = new ArrayList<CurriculumInterface>();
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.contains(c.getId())) continue;
            selected.add(c);
        }
        return selected;
    }

    protected Set<Long> markSelected() {
        HashSet<Long> markedIds = new HashSet<Long>();
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.isEmpty() && !this.iSelectedCurricula.contains(c.getId())) continue;
            markedIds.add(c.getId());
            this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowProblem");
        }
        return markedIds;
    }

    protected void unmarkSelected() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.isEmpty() && !this.iSelectedCurricula.contains(c.getId())) continue;
            this.iTable.getRowFormatter().setStyleName(row, c.getId().equals(this.iLastCurriculumId) ? "unitime-TableRowSelected" : null);
        }
    }

    protected void markAll() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable()) continue;
            this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowProblem");
        }
    }

    protected void unmarkAll() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable()) continue;
            this.iTable.getRowFormatter().setStyleName(row, c.getId().equals(this.iLastCurriculumId) ? "unitime-TableRowSelected" : null);
        }
    }

    public void setup(List<CurriculumInterface.AcademicClassificationInterface> classifications) {
        this.iClassifications.setup(classifications);
    }

    private void fillRow(CurriculumInterface c) {
        int row = this.iTable.getRowCount();
        ArrayList<Object> line = new ArrayList<Object>();
        if (c.isEditable()) {
            CheckBox ch = new CheckBox();
            final Long cid = c.getId();
            ch.setValue(Boolean.valueOf(this.iSelectedCurricula.contains(cid)));
            ch.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        CurriculaTable.this.iSelectedCurricula.add(cid);
                    } else {
                        CurriculaTable.this.iSelectedCurricula.remove(cid);
                    }
                }
            });
            line.add(ch);
        } else {
            line.add(new Label(""));
        }
        this.iSessionHasSnapshotData = c.isSessionHasSnapshotData();
        DisplayMode m = CurriculumCookie.getInstance().getCurriculaDisplayMode();
        line.add(new Label(m.isCurriculumAbbv() ? c.getAbbv() : c.getName(), false));
        line.add(new Label(m.isAreaAbbv() ? c.getAcademicArea().getAbbv() : c.getAcademicArea().getName(), false));
        line.add(new HTML(m.isMajorAbbv() ? c.getMajorCodes(", ") : c.getMajorNames("<br>"), m.isMajorAbbv()));
        line.add(new Label(m.formatDepartment(c.getDepartment()), false));
        line.add(new Label(c.getLastLike() == null ? "" : c.getLastLikeString(), false));
        line.add(new Label(c.getProjection() == null ? "" : c.getProjectionString(), false));
        line.add(new Label(c.getExpected() == null ? "" : c.getExpectedString(), false));
        line.add(new Label(c.getEnrollment() == null ? "" : c.getEnrollmentString(), false));
        line.add(new Label(c.getRequested() == null ? "" : c.getRequestedString(), false));
        line.add(new Label(!c.isSessionHasSnapshotData() ? "" : (c.getSnapshotExpected() == null ? "" : c.getSnapshotExpectedString()), false));
        line.add(new Label(!c.isSessionHasSnapshotData() ? "" : (c.getSnapshotProjection() == null ? "" : c.getSnapshotProjectionString()), false));
        this.iTable.setRow(row, c, line);
        this.iTable.getCellFormatter().addStyleName(row, 0, "unitime-NoPrint");
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 5, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 6, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 8, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 9, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 10, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 11, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    public void populate(TreeSet<CurriculumInterface> result, boolean editable) {
        this.iTable.clearTable(1);
        if (result.isEmpty()) {
            this.iTable.setEmptyMessage(MESSAGES.errorNoMatchingCurriculaFound());
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        int row = 0;
        int rowToScroll = -1;
        boolean hasEditable = false;
        HashSet<Long> newlySelected = new HashSet<Long>();
        for (CurriculumInterface curriculum : result) {
            if (ids.size() < 10 && !curriculum.hasClassifications()) {
                ids.add(curriculum.getId());
            }
            if (curriculum.isEditable() && editable) {
                hasEditable = true;
            }
            this.fillRow(curriculum);
            if (curriculum.getId().equals(this.iLastCurriculumId)) {
                this.iTable.getRowFormatter().setStyleName(1 + row, "unitime-TableRowSelected");
                rowToScroll = 1 + row;
            }
            if (curriculum.isEditable() && editable && this.iSelectedCurricula.contains(curriculum.getId())) {
                newlySelected.add(curriculum.getId());
            }
            ++row;
        }
        if (!ids.isEmpty()) {
            this.iTable.setWidget(1, 7, (Widget)new Image(RESOURCES.loading_small()));
            this.iTable.getFlexCellFormatter().setHorizontalAlignment(1, 7, HasHorizontalAlignment.ALIGN_LEFT);
        }
        this.iSelectedCurricula.clear();
        this.iSelectedCurricula.addAll(newlySelected);
        if (!hasEditable) {
            for (int r = 0; r < this.iTable.getRowCount(); ++r) {
                this.iTable.getCellFormatter().setVisible(r, 0, false);
            }
            this.iOperations.setVisible(false);
        } else {
            this.iTable.getCellFormatter().setVisible(0, 0, true);
            this.iOperations.setVisible(true);
        }
        if (rowToScroll >= 0) {
            this.iTable.getRowFormatter().getElement(rowToScroll).scrollIntoView();
        }
        if (!ids.isEmpty()) {
            this.iService.loadClassifications(ids, this.iLoadClassifications);
        }
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 7, CurriculumCookie.getInstance().isShowLast());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 6, CurriculumCookie.getInstance().isShowProjected());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 5, CurriculumCookie.getInstance().isShowExpected());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 4, CurriculumCookie.getInstance().isShowEnrolled());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 3, CurriculumCookie.getInstance().isShowRequested());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 2, this.iSessionHasSnapshotData && CurriculumCookie.getInstance().isShowSnapshotExpected());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 1, this.iSessionHasSnapshotData && CurriculumCookie.getInstance().isShowSnapshotProjected());
    }

    public void query(CurriculumInterface.CurriculumFilterRpcRequest filter, final AsyncCallback<TreeSet<CurriculumInterface>> callback) {
        this.iLastQuery = filter;
        this.iTable.clearTable(1);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingCurricula());
        this.iService.findCurricula(filter, new AsyncCallback<TreeSet<CurriculumInterface>>(){

            public void onSuccess(TreeSet<CurriculumInterface> result) {
                LoadingWidget.getInstance().hide();
                CurriculaTable.this.populate(result, true);
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                CurriculaTable.this.iTable.setEmptyMessage(MESSAGES.failedToLoadCurricula(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadCurricula(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }
        });
    }

    public void scrollIntoView() {
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            if (!"unitime-TableRowSelected".equals(this.iTable.getRowFormatter().getStyleName(r))) continue;
            this.iTable.getRowFormatter().getElement(r).scrollIntoView();
        }
    }

    private void openCurriculumProjectionRules() {
        final UniTimeDialogBox dialog = new UniTimeDialogBox(true, true);
        dialog.addStyleName("unitime-CurriculumProjectionRulesDialog");
        CurriculumProjectionRulesPage rules = new CurriculumProjectionRulesPage();
        rules.setAllowClose(true);
        rules.getElement().getStyle().setMarginRight((double)ToolBox.getScrollBarWidth(), Style.Unit.PX);
        rules.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        rules.getElement().getStyle().setPaddingRight(10.0, Style.Unit.PX);
        ScrollPanel panel = new ScrollPanel((Widget)rules);
        panel.setHeight(Math.round(0.9 * (double)Window.getClientHeight()) + "px");
        panel.setStyleName("unitime-ScrollPanel");
        dialog.setWidget((Widget)panel);
        dialog.setText(MESSAGES.dialogCurriculumProjectionRules());
        dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        rules.addProjectionRulesHandler(new CurriculumProjectionRulesPage.ProjectionRulesHandler(){

            @Override
            public void onRulesSaved(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                dialog.hide();
                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
            }

            @Override
            public void onRulesLoaded(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                dialog.center();
            }

            @Override
            public void onRulesClosed(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                dialog.hide();
            }

            @Override
            public void onException(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedToOpenCurriculumProjectionRules(caught.getMessage()), caught);
            }
        });
    }

    public void addCurriculumClickHandler(CurriculumClickHandler h) {
        this.iCurriculumClickHandlers.add(h);
    }

    public List<CurriculumInterface> getCurricula() {
        return this.iTable.getData();
    }

    public void setEditClassificationHandler(EditClassificationHandler h) {
        this.iEditClassificationHandler = h;
    }

    public Button getOperations() {
        return this.iOperations;
    }

    public CurriculumInterface next(Long id) {
        if (id == null) {
            return null;
        }
        for (int row = 0; row < this.iTable.getRowCount() - 1; ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !id.equals(c.getId())) continue;
            return this.iTable.getData(1 + row);
        }
        return null;
    }

    public CurriculumInterface previous(Long id) {
        if (id == null) {
            return null;
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !id.equals(c.getId())) continue;
            return this.iTable.getData(row - 1);
        }
        return null;
    }

    public void addOperations(final CurriculumColumn column, final UniTimeTableHeader header) {
        switch (column) {
            case SELECT: {
                header.addAdditionalStyleName("unitime-NoPrint");
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opSelectAll();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        CurriculaTable.this.iSelectedCurricula.clear();
                        for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                            CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                            if (c == null || !c.isEditable()) continue;
                            CurriculaTable.this.iSelectedCurricula.add(c.getId());
                            ((CheckBox)CurriculaTable.this.iTable.getWidget(row, 0)).setValue(Boolean.valueOf(true));
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opClearSelection();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        CurriculaTable.this.iSelectedCurricula.clear();
                        for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                            CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                            if (c == null || !c.isEditable()) continue;
                            ((CheckBox)CurriculaTable.this.iTable.getWidget(row, 0)).setValue(Boolean.valueOf(false));
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opEditRequestedEnrollments();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        if (CurriculaTable.this.iSelectedCurricula.size() <= 1 || CurriculaTable.this.iEditClassificationHandler == null) {
                            return false;
                        }
                        for (CurriculumInterface c : CurriculaTable.this.selected()) {
                            if (c.hasClassifications()) continue;
                            return false;
                        }
                        return true;
                    }

                    public void execute() {
                        CurriculaTable.this.iEditClassificationHandler.doEdit(CurriculaTable.this.selected());
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opDeleteSelectedCurricula();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return !CurriculaTable.this.iSelectedCurricula.isEmpty();
                    }

                    public void execute() {
                        Set<Long> deleteIds = CurriculaTable.this.markSelected();
                        if (!deleteIds.isEmpty()) {
                            if (Window.confirm((String)(deleteIds.size() == 1 ? MESSAGES.confirmDeleteSelectedCurriculum() : MESSAGES.confirmDeleteSelectedCurricula()))) {
                                LoadingWidget.getInstance().show(MESSAGES.waitDeletingSelectedCurricula());
                                CurriculaTable.this.iService.deleteCurricula(deleteIds, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(MESSAGES.failedToDeleteSelectedCurricula(caught.getMessage()), caught);
                                        CurriculaTable.this.unmarkSelected();
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                        CurriculaTable.this.iSelectedCurricula.clear();
                                        CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                    }
                                });
                            } else {
                                CurriculaTable.this.unmarkSelected();
                            }
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opMergeSelectedCurricula();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        if (CurriculaTable.this.iSelectedCurricula.size() <= 1) {
                            return false;
                        }
                        Long areaId = null;
                        Long deptId = null;
                        for (CurriculumInterface c : CurriculaTable.this.selected()) {
                            if (areaId == null) {
                                areaId = c.getAcademicArea().getId();
                            } else if (!areaId.equals(c.getAcademicArea().getId())) {
                                return false;
                            }
                            if (deptId == null) {
                                deptId = c.getDepartment().getId();
                                continue;
                            }
                            if (deptId.equals(c.getDepartment().getId())) continue;
                            return false;
                        }
                        return true;
                    }

                    public void execute() {
                        Set<Long> mergeIds = CurriculaTable.this.markSelected();
                        if (!mergeIds.isEmpty()) {
                            if (Window.confirm((String)(mergeIds.size() == 1 ? MESSAGES.confirmMergeSelectedCurriculum() : MESSAGES.confirmMergeSelectedCurricula()))) {
                                LoadingWidget.getInstance().show(MESSAGES.waitMergingSelectedCurricula());
                                CurriculaTable.this.iService.mergeCurricula(mergeIds, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(MESSAGES.failedToMergeSelectedCurricula(caught.getMessage()), caught);
                                        CurriculaTable.this.unmarkSelected();
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                        CurriculaTable.this.iSelectedCurricula.clear();
                                        CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                    }
                                });
                            } else {
                                CurriculaTable.this.unmarkSelected();
                            }
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opCurriculumProjectionRules();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        CurriculaTable.this.openCurriculumProjectionRules();
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opUpdateRequestedEnrollmentByProjectionRules();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        Set<Long> curIds = CurriculaTable.this.markSelected();
                        if (CurriculaTable.this.iSelectedCurricula.isEmpty()) {
                            curIds = null;
                        }
                        String string = curIds == null ? (CurriculaTable.this.iIsAdmin ? MESSAGES.confirmUpdateAllCurricula() : MESSAGES.confirmUpdateYourCurricula()) : (curIds.size() == 1 ? MESSAGES.confirmUpdateSelectedCurriculum() : MESSAGES.confirmUpdateSelectedCurricula());
                        if (Window.confirm((String)string)) {
                            LoadingWidget.getInstance().show(MESSAGES.waitUpdatingCurricula(), 300000);
                            CurriculaTable.this.iService.updateCurriculaByProjections(curIds, false, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(MESSAGES.failedToUpdateCurricula(caught.getMessage()), caught);
                                    CurriculaTable.this.unmarkSelected();
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                }
                            });
                        } else {
                            CurriculaTable.this.unmarkSelected();
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opUpdateRequestedEnrollmentAndCourseProjections();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        Set<Long> curIds = CurriculaTable.this.markSelected();
                        if (CurriculaTable.this.iSelectedCurricula.isEmpty()) {
                            curIds = null;
                        }
                        String string = curIds == null ? (CurriculaTable.this.iIsAdmin ? MESSAGES.confirmUpdateAllCurricula() : MESSAGES.confirmUpdateYourCurricula()) : (curIds.size() == 1 ? MESSAGES.confirmUpdateSelectedCurriculum() : MESSAGES.confirmUpdateSelectedCurricula());
                        if (Window.confirm((String)string)) {
                            LoadingWidget.getInstance().show(MESSAGES.waitUpdatingCurricula(), 300000);
                            CurriculaTable.this.iService.updateCurriculaByProjections(curIds, true, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(MESSAGES.failedToUpdateCurricula(caught.getMessage()), caught);
                                    CurriculaTable.this.unmarkSelected();
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                }
                            });
                        } else {
                            CurriculaTable.this.unmarkSelected();
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opPopulateCourseProjectedDemands();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iIsAdmin;
                    }

                    public void execute() {
                        if (Window.confirm((String)MESSAGES.confirmPopulateProjectedDemands())) {
                            LoadingWidget.getInstance().show(MESSAGES.waitPopulatingProjectedDemands());
                            CurriculaTable.this.iService.populateCourseProjectedDemands(false, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    UniTimeNotifications.error(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()), caught);
                                    LoadingWidget.getInstance().hide();
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    CurriculaTable.this.iSelectedCurricula.clear();
                                    CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                }
                            });
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opPopulateCourseProjectedDemandsIncludeOther();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iIsAdmin;
                    }

                    public void execute() {
                        if (Window.confirm((String)MESSAGES.confirmPopulateProjectedDemands())) {
                            LoadingWidget.getInstance().show(MESSAGES.waitPopulatingProjectedDemands());
                            CurriculaTable.this.iService.populateCourseProjectedDemands(true, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    UniTimeNotifications.error(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()), caught);
                                    LoadingWidget.getInstance().hide();
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    CurriculaTable.this.iSelectedCurricula.clear();
                                    CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                }
                            });
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculaTable.this.iTable.getRowCount() > 1 ? MESSAGES.opRecreateCurriculaFromLastLike() : MESSAGES.opCreateCurriculaFromLastLike();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iIsAdmin;
                    }

                    public void execute() {
                        CurriculaTable.this.markAll();
                        if (Window.confirm((String)MESSAGES.confirmDeleteAllCurricula())) {
                            if (Window.confirm((String)MESSAGES.confirmDeleteAllCurriculaSecondWarning())) {
                                LoadingWidget.getInstance().show(MESSAGES.waitCreatingAllCurricula(), 300000);
                                CurriculaTable.this.iService.makeupCurriculaFromLastLikeDemands(true, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(MESSAGES.failedToCreateCurricula(caught.getMessage()), caught);
                                        CurriculaTable.this.unmarkAll();
                                        LoadingWidget.getInstance().hide();
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                        CurriculaTable.this.iSelectedCurricula.clear();
                                        CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                    }
                                });
                            } else {
                                CurriculaTable.this.unmarkAll();
                            }
                        } else {
                            CurriculaTable.this.unmarkAll();
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculaTable.this.iTable.getRowCount() > 1 ? MESSAGES.opRecreateCurriculaFromCourseRequests() : MESSAGES.opCreateCurriculaFromCourseRequests();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iIsAdmin;
                    }

                    public void execute() {
                        CurriculaTable.this.markAll();
                        if (Window.confirm((String)MESSAGES.confirmDeleteAllCurricula())) {
                            if (Window.confirm((String)MESSAGES.confirmDeleteAllCurriculaSecondWarning())) {
                                LoadingWidget.getInstance().show(MESSAGES.waitCreatingAllCurricula(), 300000);
                                CurriculaTable.this.iService.makeupCurriculaFromLastLikeDemands(false, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        UniTimeNotifications.error(MESSAGES.failedToCreateCurricula(caught.getMessage()), caught);
                                        CurriculaTable.this.unmarkAll();
                                        LoadingWidget.getInstance().hide();
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                        CurriculaTable.this.iSelectedCurricula.clear();
                                        CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                                    }
                                });
                            } else {
                                CurriculaTable.this.unmarkAll();
                            }
                        } else {
                            CurriculaTable.this.unmarkAll();
                        }
                    }
                });
                break;
            }
            case CURRICULUM: {
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv();
                        CurriculumCookie.getInstance().getCurriculaDisplayMode().setCurriculumAbbv(abbv);
                        for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                            CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                            if (c == null) continue;
                            ((Label)CurriculaTable.this.iTable.getWidget(row, 1)).setText(abbv ? c.getAbbv() : c.getName());
                        }
                    }
                });
                break;
            }
            case ACAD_AREA: {
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv();
                        CurriculumCookie.getInstance().getCurriculaDisplayMode().setAreaAbbv(abbv);
                        for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                            CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                            if (c == null) continue;
                            ((Label)CurriculaTable.this.iTable.getWidget(row, 2)).setText(abbv ? c.getAcademicArea().getAbbv() : c.getAcademicArea().getName());
                        }
                    }
                });
                break;
            }
            case MAJORS: {
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv();
                        CurriculumCookie.getInstance().getCurriculaDisplayMode().setMajorAbbv(abbv);
                        for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                            CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                            if (c == null) continue;
                            ((HTML)CurriculaTable.this.iTable.getWidget(row, 3)).setHTML(abbv ? c.getMajorCodes(", ") : c.getMajorNames("<br>"));
                            ((HTML)CurriculaTable.this.iTable.getWidget(row, 3)).setWordWrap(abbv);
                        }
                    }
                });
                break;
            }
            case DEPARTMENT: {
                for (final DeptMode m : DeptMode.values()) {
                    header.addOperation(new UniTimeTableHeader.Operation(){

                        @Override
                        public String getName() {
                            return MESSAGES.opShowItem(m.getName());
                        }

                        @Override
                        public boolean hasSeparator() {
                            return false;
                        }

                        @Override
                        public boolean isApplicable() {
                            return m != CurriculumCookie.getInstance().getCurriculaDisplayMode().getDeptMode();
                        }

                        public void execute() {
                            CurriculumCookie.getInstance().getCurriculaDisplayMode().setDeptMode(m);
                            DisplayMode dm = CurriculumCookie.getInstance().getCurriculaDisplayMode();
                            for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                                CurriculumInterface c = CurriculaTable.this.iTable.getData(row);
                                if (c == null) continue;
                                ((Label)CurriculaTable.this.iTable.getWidget(row, 4)).setText(dm.formatDepartment(c.getDepartment()));
                            }
                        }
                    });
                }
                break;
            }
        }
        switch (column) {
            case SELECT: 
            case LAST_LIKE: 
            case PROJECTION: 
            case REQUESTED: 
            case ENROLLED: 
            case SNAPSHOT_REQUESTED: 
            case SNAPSHOT_PROJECTION: 
            case REGISTERED: {
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowLast() ? MESSAGES.opHide(MESSAGES.fieldLastLikeEnrollment()) : MESSAGES.opShow(MESSAGES.fieldLastLikeEnrollment());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean show = !CurriculumCookie.getInstance().isShowLast();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 7;
                        CurriculumCookie.getInstance().setShowLast(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowProjected() ? MESSAGES.opHide(MESSAGES.fieldProjectedByRule()) : MESSAGES.opShow(MESSAGES.fieldProjectedByRule());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean show = !CurriculumCookie.getInstance().isShowProjected();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 6;
                        CurriculumCookie.getInstance().setShowProjected(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowExpected() ? MESSAGES.opHide(MESSAGES.fieldRequestedEnrollment()) : MESSAGES.opShow(MESSAGES.fieldRequestedEnrollment());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean show = !CurriculumCookie.getInstance().isShowExpected();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 5;
                        CurriculumCookie.getInstance().setShowExpected(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowLast(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 7, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowEnrolled() ? MESSAGES.opHide(MESSAGES.fieldCurrentEnrollment()) : MESSAGES.opShow(MESSAGES.fieldCurrentEnrollment());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean show = !CurriculumCookie.getInstance().isShowEnrolled();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 4;
                        CurriculumCookie.getInstance().setShowEnrolled(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowRequested() ? MESSAGES.opHide(MESSAGES.fieldCourseRequests()) : MESSAGES.opShow(MESSAGES.fieldCourseRequests());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        boolean show = !CurriculumCookie.getInstance().isShowRequested();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 3;
                        CurriculumCookie.getInstance().setShowRequested(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowSnapshotExpected() ? MESSAGES.opHide(MESSAGES.fieldSnapshotRequestedEnrollment()) : MESSAGES.opShow(MESSAGES.fieldSnapshotRequestedEnrollment());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iSessionHasSnapshotData;
                    }

                    public void execute() {
                        boolean show = CurriculaTable.this.iSessionHasSnapshotData && !CurriculumCookie.getInstance().isShowSnapshotExpected();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 2;
                        CurriculumCookie.getInstance().setShowSnapshotExpected(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return CurriculumCookie.getInstance().isShowSnapshotProjected() ? MESSAGES.opHide(MESSAGES.fieldSnapshotProjectedByRule()) : MESSAGES.opShow(MESSAGES.fieldSnapshotProjectedByRule());
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return CurriculaTable.this.iSessionHasSnapshotData;
                    }

                    public void execute() {
                        boolean show = CurriculaTable.this.iSessionHasSnapshotData && !CurriculumCookie.getInstance().isShowSnapshotProjected();
                        int col = CurriculaTable.this.iTable.getCellCount(0) - 1;
                        CurriculumCookie.getInstance().setShowSnapshotProjected(show);
                        CurriculaTable.this.iTable.setColumnVisible(col, show);
                        if (CurriculumCookie.getInstance().isAllHidden()) {
                            CurriculumCookie.getInstance().setShowExpected(true);
                            CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                        }
                    }
                });
            }
        }
        switch (column) {
            case PROJECTION: {
                header.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return MESSAGES.opCurriculumProjectionRules();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    public void execute() {
                        CurriculaTable.this.openCurriculumProjectionRules();
                    }
                });
            }
        }
        if (column.getComparator() != null) {
            header.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    CurriculaTable.this.iTable.sort(header, column.getComparator());
                    CurriculumCookie.getInstance().setSortBy(header.getOrder() != false ? 1 + column.ordinal() : -1 - column.ordinal());
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    switch (column) {
                        case DEPARTMENT: 
                        case LAST_LIKE: 
                        case REQUESTED: 
                        case ENROLLED: 
                        case REGISTERED: {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(CurriculaTable.this.getFieldName(column));
                }
            });
        }
    }

    public String getColumnName(CurriculumColumn column) {
        switch (column) {
            case SELECT: {
                return "&otimes;";
            }
            case CURRICULUM: {
                return MESSAGES.colCurriculum();
            }
            case ACAD_AREA: {
                return MESSAGES.colAcademicArea();
            }
            case MAJORS: {
                return MESSAGES.colMajors();
            }
            case DEPARTMENT: {
                return MESSAGES.colDepartment();
            }
            case LAST_LIKE: {
                return MESSAGES.colLastLikeEnrollment();
            }
            case PROJECTION: {
                return MESSAGES.colProjectedByRule();
            }
            case REQUESTED: {
                return MESSAGES.colRequestedEnrollment();
            }
            case ENROLLED: {
                return MESSAGES.colCurrentEnrollment();
            }
            case REGISTERED: {
                return MESSAGES.colCourseRequests();
            }
            case SNAPSHOT_REQUESTED: {
                return MESSAGES.colSnapshotRequestedEnrollment();
            }
            case SNAPSHOT_PROJECTION: {
                return MESSAGES.colSnapshotProjectedByRule();
            }
        }
        return null;
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(CurriculumColumn column) {
        switch (column) {
            case SELECT: {
                return HasHorizontalAlignment.ALIGN_CENTER;
            }
            case LAST_LIKE: 
            case PROJECTION: 
            case REQUESTED: 
            case ENROLLED: 
            case SNAPSHOT_REQUESTED: 
            case SNAPSHOT_PROJECTION: 
            case REGISTERED: {
                return HasHorizontalAlignment.ALIGN_RIGHT;
            }
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    public String getColumnWidth(CurriculumColumn column) {
        switch (column) {
            case SELECT: {
                return "10px";
            }
            case CURRICULUM: {
                return "150px";
            }
            case ACAD_AREA: 
            case MAJORS: 
            case DEPARTMENT: {
                return "100px";
            }
            case LAST_LIKE: 
            case PROJECTION: 
            case REQUESTED: 
            case ENROLLED: 
            case SNAPSHOT_REQUESTED: 
            case SNAPSHOT_PROJECTION: 
            case REGISTERED: {
                return "90px";
            }
        }
        return null;
    }

    public String getFieldName(CurriculumColumn column) {
        switch (column) {
            case LAST_LIKE: {
                return MESSAGES.fieldLastLikeEnrollment();
            }
            case PROJECTION: {
                return MESSAGES.fieldProjectedByRule();
            }
            case REQUESTED: {
                return MESSAGES.fieldRequestedEnrollment();
            }
            case ENROLLED: {
                return MESSAGES.fieldCurrentEnrollment();
            }
            case REGISTERED: {
                return MESSAGES.fieldCourseRequests();
            }
            case SNAPSHOT_REQUESTED: {
                return MESSAGES.fieldSnapshotRequestedEnrollment();
            }
            case SNAPSHOT_PROJECTION: {
                return MESSAGES.fieldSnapshotProjectedByRule();
            }
        }
        return this.getColumnName(column);
    }

    public static interface EditClassificationHandler {
        public void doEdit(List<CurriculumInterface> var1);
    }

    public static enum CurriculumColumn implements IsSerializable
    {
        SELECT,
        CURRICULUM,
        ACAD_AREA,
        MAJORS,
        DEPARTMENT,
        LAST_LIKE,
        PROJECTION,
        REQUESTED,
        ENROLLED,
        REGISTERED,
        SNAPSHOT_REQUESTED,
        SNAPSHOT_PROJECTION;


        public Comparator<CurriculumInterface> getComparator() {
            switch (this) {
                case CURRICULUM: {
                    final boolean curAbbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv();
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            int cmp = (curAbbv ? a.getAbbv() : a.getName()).compareTo(curAbbv ? b.getAbbv() : b.getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case ACAD_AREA: {
                    final boolean areaAbbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv();
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            int cmp = (areaAbbv ? a.getAcademicArea().getAbbv() : a.getAcademicArea().getName()).compareTo(areaAbbv ? b.getAcademicArea().getAbbv() : b.getAcademicArea().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case MAJORS: {
                    final boolean mjAbbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv();
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            int cmp = (mjAbbv ? a.getMajorCodes("|") : a.getMajorNames("|")).compareTo(mjAbbv ? b.getMajorCodes("|") : b.getMajorNames("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case DEPARTMENT: {
                    final DisplayMode dm = CurriculumCookie.getInstance().getCurriculaDisplayMode();
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            int cmp = dm.formatDepartment(a.getDepartment()).compareTo(dm.formatDepartment(b.getDepartment()));
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case LAST_LIKE: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getLastLike() == null ? -1 : a.getLastLike();
                            Integer f = b.getLastLike() == null ? -1 : b.getLastLike();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case PROJECTION: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getProjection() == null ? -1 : a.getProjection();
                            Integer f = b.getProjection() == null ? -1 : b.getProjection();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case REQUESTED: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getExpected() == null ? -1 : a.getExpected();
                            Integer f = b.getExpected() == null ? -1 : b.getExpected();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case ENROLLED: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getEnrollment() == null ? -1 : a.getEnrollment();
                            Integer f = b.getEnrollment() == null ? -1 : b.getEnrollment();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case REGISTERED: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getRequested() == null ? -1 : a.getRequested();
                            Integer f = b.getRequested() == null ? -1 : b.getRequested();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case SNAPSHOT_REQUESTED: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getSnapshotExpected() == null ? -1 : a.getSnapshotExpected();
                            Integer f = b.getSnapshotExpected() == null ? -1 : b.getSnapshotExpected();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
                case SNAPSHOT_PROJECTION: {
                    return new Comparator<CurriculumInterface>(){

                        @Override
                        public int compare(CurriculumInterface a, CurriculumInterface b) {
                            Integer e = a.getSnapshotProjection() == null ? -1 : a.getSnapshotProjection();
                            Integer f = b.getSnapshotProjection() == null ? -1 : b.getSnapshotProjection();
                            int cmp = f.compareTo(e);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return a.compareTo(b);
                        }
                    };
                }
            }
            return null;
        }
    }

    public static abstract class DisplayMode {
        private boolean iCurriculumAbbv = true;
        private boolean iAreaAbbv = false;
        private boolean iMajorAbbv = false;
        private DeptMode iDeptMode = DeptMode.ABBV_NAME;

        public boolean isCurriculumAbbv() {
            return this.iCurriculumAbbv;
        }

        public void setCurriculumAbbv(boolean curriculumAbbv) {
            this.iCurriculumAbbv = curriculumAbbv;
            this.changed();
        }

        public boolean isAreaAbbv() {
            return this.iAreaAbbv;
        }

        public void setAreaAbbv(boolean areaAbbv) {
            this.iAreaAbbv = areaAbbv;
            this.changed();
        }

        public boolean isMajorAbbv() {
            return this.iMajorAbbv;
        }

        public void setMajorAbbv(boolean majorAbbv) {
            this.iMajorAbbv = majorAbbv;
            this.changed();
        }

        public DeptMode getDeptMode() {
            return this.iDeptMode;
        }

        public void setDeptMode(DeptMode deptMode) {
            this.iDeptMode = deptMode;
            this.changed();
        }

        public String formatDepartment(CurriculumInterface.DepartmentInterface dept) {
            switch (this.iDeptMode) {
                case CODE: {
                    return dept.getCode();
                }
                case ABBV: {
                    return dept.getAbbv() == null || dept.getAbbv().isEmpty() ? dept.getCode() : dept.getAbbv();
                }
                case NAME: {
                    return dept.getName();
                }
                case CODE_NAME: {
                    return dept.getCode() + " - " + dept.getName();
                }
            }
            return (dept.getAbbv() == null || dept.getAbbv().isEmpty() ? dept.getCode() : dept.getAbbv()) + " - " + dept.getName();
        }

        public String toString() {
            Object ret = "";
            if (this.iCurriculumAbbv) {
                ret = (String)ret + "c";
            }
            if (this.iAreaAbbv) {
                ret = (String)ret + "a";
            }
            if (this.iMajorAbbv) {
                ret = (String)ret + "m";
            }
            ret = (String)ret + this.iDeptMode.getCode();
            return ret;
        }

        public void fromString(String str) {
            this.iCurriculumAbbv = str.indexOf(99) >= 0;
            this.iAreaAbbv = str.indexOf(97) >= 0;
            this.iMajorAbbv = str.indexOf(109) >= 0;
            for (DeptMode m : DeptMode.values()) {
                if (str.indexOf(m.getCode()) < 0) continue;
                this.iDeptMode = m;
                break;
            }
        }

        public abstract void changed();
    }

    public static enum DeptMode {
        CODE('0', MESSAGES.fieldCode()),
        ABBV('1', MESSAGES.fieldAbbreviation()),
        NAME('2', MESSAGES.fieldName()),
        ABBV_NAME('3', MESSAGES.fieldAbbv() + " - " + MESSAGES.fieldName()),
        CODE_NAME('4', MESSAGES.fieldCode() + " - " + MESSAGES.fieldName());

        private char iCode;
        private String iName;

        private DeptMode(char code, String name) {
            this.iCode = code;
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public char getCode() {
            return this.iCode;
        }
    }

    public static interface CurriculumClickHandler {
        public void onClick(CurriculumClickedEvent var1);
    }

    public static class CurriculumClickedEvent {
        private CurriculumInterface iCurriculum;

        public CurriculumClickedEvent(CurriculumInterface curriculum) {
            this.iCurriculum = curriculum;
        }

        public CurriculumInterface getCurriculum() {
            return this.iCurriculum;
        }
    }
}

