/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=EventInterface.ResourceLookupRpcRequest.class)
public class ResourceLookupBackend
extends EventAction<EventInterface.ResourceLookupRpcRequest, GwtRpcResponseList<EventInterface.ResourceInterface>> {
    @Override
    public GwtRpcResponseList<EventInterface.ResourceInterface> execute(EventInterface.ResourceLookupRpcRequest request, EventAction.EventContext context) {
        if (request.getResourceType() == EventInterface.ResourceType.PERSON) {
            if (!request.hasName()) {
                request.setName(context.getUser().getExternalUserId());
            } else if (!request.getName().equals(context.isAuthenticated() ? context.getUser().getExternalUserId() : null)) {
                context.checkPermission(Right.EventLookupSchedule);
            }
        }
        GwtRpcResponseList<EventInterface.ResourceInterface> response = new GwtRpcResponseList<EventInterface.ResourceInterface>();
        if (request.hasLimit() && request.getLimit() == 1) {
            response.add(this.findResource(request.getSessionId(), request.getResourceType(), request.getName()));
        } else {
            response.addAll(this.findResources(request.getSessionId(), request.getResourceType(), request.getName(), request.getLimit()));
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventInterface.ResourceInterface findResource(Long sessionId, EventInterface.ResourceType type, String name) {
        try (org.hibernate.Session hibSession = EventDAO.getInstance().getSession();){
            Session academicSession = (Session)SessionDAO.getInstance().get(sessionId);
            switch (type) {
                case ROOM: {
                    if (ApplicationProperty.EventRoomTimetableAllRooms.isTrue()) {
                        List rooms = hibSession.createQuery("select distinct r from Room r where r.session.uniqueId = :sessionId and r.eventDepartment.allowEvents = true and (r.buildingAbbv || ' ' || r.roomNumber = :name or r.buildingAbbv || r.roomNumber = :name)", Room.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                        if (!rooms.isEmpty()) {
                            Room room = (Room)rooms.get(0);
                            EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                            ret.setType(EventInterface.ResourceType.ROOM);
                            ret.setId(room.getUniqueId());
                            ret.setAbbreviation(room.getLabel());
                            ret.setName(room.getLabel());
                            EventInterface.ResourceInterface resourceInterface = ret;
                            return resourceInterface;
                        }
                        List locations = hibSession.createQuery("select distinct l from NonUniversityLocation l where l.session.uniqueId = :sessionId and l.name = :name and l.eventDepartment.allowEvents = true", NonUniversityLocation.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                        if (locations.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                        NonUniversityLocation location = (NonUniversityLocation)locations.get(0);
                        EventInterface.ResourceInterface ret2 = new EventInterface.ResourceInterface();
                        ret2.setType(EventInterface.ResourceType.ROOM);
                        ret2.setId(location.getUniqueId());
                        ret2.setAbbreviation(location.getLabel());
                        ret2.setName(location.getLabel());
                        EventInterface.ResourceInterface resourceInterface = ret2;
                        return resourceInterface;
                    }
                    List rooms = hibSession.createQuery("select distinct r from Room r where r.session.uniqueId = :sessionId and (r.buildingAbbv || ' ' || r.roomNumber = :name or r.buildingAbbv || r.roomNumber = :name)", Room.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (!rooms.isEmpty()) {
                        Room room = (Room)rooms.get(0);
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.ROOM);
                        ret.setId(room.getUniqueId());
                        ret.setAbbreviation(room.getLabel());
                        ret.setName(room.getLabel());
                        EventInterface.ResourceInterface ret2 = ret;
                        return ret2;
                    }
                    List locations = hibSession.createQuery("select distinct l from NonUniversityLocation l where l.session.uniqueId = :sessionId and l.name = :name", NonUniversityLocation.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (locations.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                    NonUniversityLocation location = (NonUniversityLocation)locations.get(0);
                    EventInterface.ResourceInterface ret3 = new EventInterface.ResourceInterface();
                    ret3.setType(EventInterface.ResourceType.ROOM);
                    ret3.setId(location.getUniqueId());
                    ret3.setAbbreviation(location.getLabel());
                    ret3.setName(location.getLabel());
                    EventInterface.ResourceInterface resourceInterface = ret3;
                    return resourceInterface;
                }
                case SUBJECT: {
                    List subjects = hibSession.createQuery("select s from SubjectArea s where s.session.uniqueId = :sessionId and lower(s.subjectAreaAbbreviation) = :name", SubjectArea.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (!subjects.isEmpty()) {
                        SubjectArea subject = (SubjectArea)subjects.get(0);
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.SUBJECT);
                        ret.setId(subject.getUniqueId());
                        ret.setAbbreviation(subject.getSubjectAreaAbbreviation());
                        ret.setName(subject.getTitle());
                        EventInterface.ResourceInterface ret3 = ret;
                        return ret3;
                    }
                }
                case COURSE: {
                    List courses = hibSession.createQuery("select c from CourseOffering c inner join c.subjectArea s where s.session.uniqueId = :sessionId and lower(s.subjectAreaAbbreviation || ' ' || c.courseNbr) = :name and c.instructionalOffering.notOffered = false", CourseOffering.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (courses.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                    CourseOffering course = (CourseOffering)courses.get(0);
                    EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                    ret.setType(EventInterface.ResourceType.COURSE);
                    ret.setId(course.getUniqueId());
                    ret.setAbbreviation(course.getCourseName());
                    ret.setName(course.getTitle() == null ? course.getCourseName() : course.getTitle());
                    EventInterface.ResourceInterface resourceInterface = ret;
                    return resourceInterface;
                }
                case CURRICULUM: {
                    List curricula = hibSession.createQuery("select c from Curriculum c where c.department.session.uniqueId = :sessionId and lower(c.abbv) = :name or lower(c.name) = :name", Curriculum.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (!curricula.isEmpty()) {
                        Curriculum curriculum = (Curriculum)curricula.get(0);
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.CURRICULUM);
                        ret.setId(curriculum.getUniqueId());
                        ret.setAbbreviation(curriculum.getAbbv());
                        ret.setName(curriculum.getName());
                        EventInterface.ResourceInterface resourceInterface = ret;
                        return resourceInterface;
                    }
                    List classifications = hibSession.createQuery("select f from CurriculumClassification f inner join f.curriculum c where c.department.session.uniqueId = :sessionId and (lower(c.abbv || '/' || f.name) = :name or lower(c.name || '/' || f.name) = :name or lower(c.abbv || '/' || f.academicClassification.code) = :name or lower(c.name || '/' || f.academicClassification.code) = :name or lower(c.abbv || '/' || f.academicClassification.name) = :name or lower(c.name || '/' || f.academicClassification.name) = :name or lower(c.abbv || ' ' || f.name) = :name or lower(c.name || ' ' || f.name) = :name or lower(c.abbv || ' ' || f.academicClassification.code) = :name or lower(c.name || ' ' || f.academicClassification.code) = :name or lower(c.abbv || ' ' || f.academicClassification.name) = :name or lower(c.name || ' ' || f.academicClassification.name) = :name or lower(c.abbv || f.name) = :name or lower(c.name || f.name) = :name or lower(c.abbv || f.academicClassification.code) = :name or lower(c.name || f.academicClassification.code) = :name or lower(c.abbv || f.academicClassification.name) = :name or lower(c.name || f.academicClassification.name) = :name)", CurriculumClassification.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (classifications.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                    CurriculumClassification classification = (CurriculumClassification)classifications.get(0);
                    EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                    ret.setType(EventInterface.ResourceType.CURRICULUM);
                    ret.setId(classification.getUniqueId());
                    ret.setAbbreviation(classification.getCurriculum().getAbbv() + " " + classification.getAcademicClassification().getCode());
                    ret.setName(classification.getCurriculum().getName() + " " + classification.getAcademicClassification().getName());
                    EventInterface.ResourceInterface resourceInterface = ret;
                    return resourceInterface;
                }
                case DEPARTMENT: {
                    List departments = hibSession.createQuery("select d from Department d where d.session.uniqueId = :sessionId and (lower(d.deptCode) = :name or lower(d.abbreviation) = :name)", Department.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (departments.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                    Department department = (Department)departments.get(0);
                    EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                    ret.setType(EventInterface.ResourceType.DEPARTMENT);
                    ret.setId(department.getUniqueId());
                    ret.setAbbreviation(department.getAbbreviation() == null ? department.getDeptCode() : department.getAbbreviation());
                    ret.setName(department.getName());
                    EventInterface.ResourceInterface resourceInterface = ret;
                    return resourceInterface;
                }
                case PERSON: {
                    List students = hibSession.createQuery("select s from Student s where s.session.uniqueId = :sessionId and s.externalUniqueId = :name", Student.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (!students.isEmpty()) {
                        Student student = (Student)students.get(0);
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.PERSON);
                        ret.setId(student.getUniqueId());
                        ret.setAbbreviation(student.getName(DepartmentalInstructor.sNameFormatShort));
                        ret.setName(student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle));
                        ret.setExternalId(student.getExternalUniqueId());
                        EventInterface.ResourceInterface resourceInterface = ret;
                        return resourceInterface;
                    }
                    List instructors = hibSession.createQuery("select i from DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId = :name", DepartmentalInstructor.class).setParameter("name", (Object)name).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (!instructors.isEmpty()) {
                        DepartmentalInstructor instructor = (DepartmentalInstructor)instructors.get(0);
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.PERSON);
                        ret.setId(instructor.getUniqueId());
                        ret.setAbbreviation(instructor.getName(DepartmentalInstructor.sNameFormatShort));
                        ret.setName(instructor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle));
                        ret.setExternalId(instructor.getExternalUniqueId());
                        EventInterface.ResourceInterface resourceInterface = ret;
                        return resourceInterface;
                    }
                    List contacts = hibSession.createQuery("select c from EventContact c where c.externalUniqueId = :name", EventContact.class).setParameter("name", (Object)name).list();
                    if (!contacts.isEmpty()) {
                        EventContact contact = (EventContact)contacts.get(0);
                        EventInterface.ResourceInterface ret4 = new EventInterface.ResourceInterface();
                        ret4.setType(EventInterface.ResourceType.PERSON);
                        ret4.setId(contact.getUniqueId());
                        ret4.setAbbreviation(contact.getName());
                        ret4.setName(contact.getName());
                        ret4.setExternalId(contact.getExternalUniqueId());
                        EventInterface.ResourceInterface resourceInterface = ret4;
                        return resourceInterface;
                    }
                    EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                    ret.setType(EventInterface.ResourceType.PERSON);
                    ret.setExternalId(name);
                    ret.setName("");
                    EventInterface.ResourceInterface ret4 = ret;
                    return ret4;
                }
                case GROUP: {
                    List groups = hibSession.createQuery("select g from StudentGroup g where g.session.uniqueId = :sessionId and (lower(g.groupName) = :name or lower(g.groupAbbreviation) = :name)", StudentGroup.class).setParameter("name", (Object)name.toLowerCase()).setParameter("sessionId", (Object)academicSession.getUniqueId()).list();
                    if (groups.isEmpty()) throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ".");
                    StudentGroup group = (StudentGroup)groups.get(0);
                    EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                    ret.setType(EventInterface.ResourceType.GROUP);
                    ret.setId(group.getUniqueId());
                    ret.setAbbreviation(group.getGroupAbbreviation());
                    ret.setName(group.getGroupName());
                    EventInterface.ResourceInterface resourceInterface = ret;
                    return resourceInterface;
                }
            }
            throw new GwtRpcException("Resource type " + type.getLabel() + " not supported.");
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException("Unable to find a " + type.getLabel() + " named " + name + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventInterface.ResourceInterface> findResources(Long sessionId, EventInterface.ResourceType type, String query, int limit) {
        ArrayList<EventInterface.ResourceInterface> arrayList;
        if (query == null) {
            query = "";
        }
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        try {
            Session academicSession = (Session)SessionDAO.getInstance().get(sessionId);
            ArrayList<EventInterface.ResourceInterface> resources = new ArrayList<EventInterface.ResourceInterface>();
            switch (type) {
                case ROOM: {
                    List rooms;
                    if (ApplicationProperty.EventRoomTimetableAllRooms.isTrue()) {
                        rooms = hibSession.createQuery("select distinct r from Room r, RoomTypeOption o where r.session.uniqueId = :sessionId and r.eventDepartment.allowEvents = true and o.status != 0 and o.roomType = r.roomType and o.department = r.eventDepartment and (lower(r.roomNumber) like :name or lower(r.buildingAbbv || ' ' || r.roomNumber) like :name or lower(r.buildingAbbv || r.roomNumber) like :name) order by r.buildingAbbv, r.roomNumber", Room.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                        for (Room room : rooms) {
                            EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                            ret.setType(EventInterface.ResourceType.ROOM);
                            ret.setId(room.getUniqueId());
                            ret.setAbbreviation(room.getLabel());
                            ret.setName(room.getLabel());
                            if (room.getDisplayName() != null && !room.getDisplayName().isEmpty()) {
                                ret.setTitle(room.getLabel() + " - " + room.getDisplayName());
                            } else {
                                ret.setTitle(room.getLabel() + " - " + room.getRoomTypeLabel() + (String)(room.getCapacity() > 1 ? " (" + room.getCapacity() + " seats)" : ""));
                            }
                            resources.add(ret);
                        }
                        List locations = hibSession.createQuery("select distinct l from NonUniversityLocation l, RoomTypeOption o where l.eventDepartment.allowEvents = true and l.session.uniqueId = :sessionId and o.status != 0 and o.roomType = l.roomType and o.department = l.eventDepartment and lower(l.name) like :name order by l.name", NonUniversityLocation.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                        for (NonUniversityLocation location : locations) {
                            EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                            resourceInterface.setType(EventInterface.ResourceType.ROOM);
                            resourceInterface.setId(location.getUniqueId());
                            resourceInterface.setAbbreviation(location.getLabel());
                            resourceInterface.setName(location.getLabel());
                            if (location.getDisplayName() != null && !location.getDisplayName().isEmpty()) {
                                resourceInterface.setTitle(location.getLabel() + " - " + location.getDisplayName());
                            } else {
                                resourceInterface.setTitle(location.getLabel() + " - " + location.getRoomTypeLabel() + (String)(location.getCapacity() > 1 ? " (" + location.getCapacity() + " seats)" : ""));
                            }
                            resources.add(resourceInterface);
                        }
                        Collections.sort(resources);
                        if (limit <= 0 || resources.size() <= limit) break;
                        resources = new ArrayList(resources.subList(0, limit));
                        break;
                    }
                    rooms = hibSession.createQuery("select distinct r from Room r where r.session.uniqueId = :sessionId and (lower(r.roomNumber) like :name or lower(r.buildingAbbv || ' ' || r.roomNumber) like :name or lower(r.buildingAbbv || r.roomNumber) like :name) order by r.buildingAbbv, r.roomNumber", Room.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (Room room : rooms) {
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.ROOM);
                        ret.setId(room.getUniqueId());
                        ret.setAbbreviation(room.getLabel());
                        ret.setName(room.getLabel());
                        if (room.getDisplayName() != null && !room.getDisplayName().isEmpty()) {
                            ret.setTitle(room.getLabel() + " - " + room.getDisplayName());
                        } else {
                            ret.setTitle(room.getLabel() + " - " + room.getRoomTypeLabel() + (String)(room.getCapacity() > 1 ? " (" + room.getCapacity() + " seats)" : ""));
                        }
                        resources.add(ret);
                    }
                    List locations = hibSession.createQuery("select distinct l from NonUniversityLocation l where l.session.uniqueId = :sessionId and lower(l.name) like :name order by l.name", NonUniversityLocation.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    Iterator iterator = locations.iterator();
                    while (iterator.hasNext()) {
                        NonUniversityLocation location = (NonUniversityLocation)iterator.next();
                        EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                        resourceInterface.setType(EventInterface.ResourceType.ROOM);
                        resourceInterface.setId(location.getUniqueId());
                        resourceInterface.setAbbreviation(location.getLabel());
                        resourceInterface.setName(location.getLabel());
                        if (location.getDisplayName() != null && !location.getDisplayName().isEmpty()) {
                            resourceInterface.setTitle(location.getLabel() + " - " + location.getDisplayName());
                        } else {
                            resourceInterface.setTitle(location.getLabel() + " - " + location.getRoomTypeLabel() + (String)(location.getCapacity() > 1 ? " (" + location.getCapacity() + " seats)" : ""));
                        }
                        resources.add(resourceInterface);
                    }
                    Collections.sort(resources);
                    if (limit <= 0 || resources.size() <= limit) break;
                    resources = new ArrayList(resources.subList(0, limit));
                    break;
                }
                case SUBJECT: {
                    EventInterface.ResourceInterface ret;
                    List subjects = hibSession.createQuery("select s from SubjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation) like :name or lower(' ' || s.title) like :title) order by s.subjectAreaAbbreviation", SubjectArea.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("% " + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (SubjectArea subjectArea : subjects) {
                        ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.SUBJECT);
                        ret.setId(subjectArea.getUniqueId());
                        ret.setAbbreviation(subjectArea.getSubjectAreaAbbreviation());
                        ret.setName(subjectArea.getTitle());
                        resources.add(ret);
                    }
                    if (subjects.size() == 1) {
                        for (CourseOffering courseOffering : new TreeSet<CourseOffering>(((SubjectArea)subjects.get(0)).getCourseOfferings())) {
                            if (courseOffering.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                            ret = new EventInterface.ResourceInterface();
                            ret.setType(EventInterface.ResourceType.COURSE);
                            ret.setId(courseOffering.getUniqueId());
                            ret.setAbbreviation(courseOffering.getCourseName());
                            ret.setName(courseOffering.getTitle() == null ? courseOffering.getCourseName() : courseOffering.getTitle());
                            ret.setTitle("&nbsp;&nbsp;&nbsp;&nbsp;" + courseOffering.getCourseName() + (String)(courseOffering.getTitle() == null ? "" : " - " + courseOffering.getTitle()));
                            resources.add(ret);
                        }
                    } else {
                        if (!subjects.isEmpty()) break;
                        List courses = hibSession.createQuery("select c from CourseOffering c inner join c.subjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation || ' ' || c.courseNbr) like :name or lower(' ' || c.title) like :title) and c.instructionalOffering.notOffered = false order by s.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("% " + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                        for (CourseOffering course : courses) {
                            if (course.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                            EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                            resourceInterface.setType(EventInterface.ResourceType.COURSE);
                            resourceInterface.setId(course.getUniqueId());
                            resourceInterface.setAbbreviation(course.getCourseName());
                            resourceInterface.setName(course.getTitle() == null ? course.getCourseName() : course.getTitle());
                            resources.add(resourceInterface);
                        }
                    }
                    break;
                }
                case COURSE: {
                    List courses = hibSession.createQuery("select c from CourseOffering c inner join c.subjectArea s where s.session.uniqueId = :sessionId and (lower(s.subjectAreaAbbreviation || ' ' || c.courseNbr) like :name or lower(' ' || c.title) like :title) and c.instructionalOffering.notOffered = false order by s.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("% " + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (CourseOffering course : courses) {
                        if (course.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                        EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                        resourceInterface.setType(EventInterface.ResourceType.COURSE);
                        resourceInterface.setId(course.getUniqueId());
                        resourceInterface.setAbbreviation(course.getCourseName());
                        resourceInterface.setName(course.getTitle() == null ? course.getCourseName() : course.getTitle());
                        resources.add(resourceInterface);
                    }
                    break;
                }
                case CURRICULUM: {
                    EventInterface.ResourceInterface ret;
                    List list = hibSession.createQuery("select c from Curriculum c where c.department.session.uniqueId = :sessionId and (lower(c.abbv) like :name or lower(c.name) like :title) order by c.abbv", Curriculum.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("%" + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (Curriculum curriculum : list) {
                        ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.CURRICULUM);
                        ret.setId(curriculum.getUniqueId());
                        ret.setAbbreviation(curriculum.getAbbv());
                        ret.setName(curriculum.getName());
                        resources.add(ret);
                    }
                    if (list.size() == 1) {
                        for (CurriculumClassification curriculumClassification : new TreeSet<CurriculumClassification>(((Curriculum)list.get(0)).getClassifications())) {
                            ret = new EventInterface.ResourceInterface();
                            ret.setType(EventInterface.ResourceType.CURRICULUM);
                            ret.setId(curriculumClassification.getUniqueId());
                            ret.setAbbreviation(curriculumClassification.getCurriculum().getAbbv() + " " + curriculumClassification.getAcademicClassification().getCode());
                            ret.setName(curriculumClassification.getCurriculum().getName() + " " + curriculumClassification.getAcademicClassification().getName());
                            ret.setTitle("&nbsp;&nbsp;&nbsp;&nbsp;" + curriculumClassification.getAcademicClassification().getCode() + " " + curriculumClassification.getAcademicClassification().getName());
                            resources.add(ret);
                        }
                    } else if (list.isEmpty()) {
                        List classifications = hibSession.createQuery("select f from CurriculumClassification f inner join f.curriculum c where c.department.session.uniqueId = :sessionId and (lower(c.abbv || '/' || f.name) like :name or lower(c.name || '/' || f.name) like :title or lower(c.abbv || '/' || f.academicClassification.code) like :name or lower(c.name || '/' || f.academicClassification.code) like :title or lower(c.abbv || '/' || f.academicClassification.name) like :name or lower(c.name || '/' || f.academicClassification.name) like :title or lower(c.abbv || ' ' || f.name) like :name or lower(c.name || ' ' || f.name) like :title or lower(c.abbv || ' ' || f.academicClassification.code) like :name or lower(c.name || ' ' || f.academicClassification.code) like :title or lower(c.abbv || ' ' || f.academicClassification.name) like :name or lower(c.name || ' ' || f.academicClassification.name) like :title or lower(c.abbv || f.name) like :name or lower(c.name || f.name) like :title or lower(c.abbv || f.academicClassification.code) like :name or lower(c.name || f.academicClassification.code) like :title or lower(c.abbv || f.academicClassification.name) like :name or lower(c.name || f.academicClassification.name) like :title) order by c.abbv, f.academicClassification.code", CurriculumClassification.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("%" + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit - resources.size()).list();
                        for (CurriculumClassification classification : classifications) {
                            EventInterface.ResourceInterface ret3 = new EventInterface.ResourceInterface();
                            ret3.setType(EventInterface.ResourceType.CURRICULUM);
                            ret3.setId(classification.getUniqueId());
                            ret3.setAbbreviation(classification.getCurriculum().getAbbv() + " " + classification.getAcademicClassification().getCode());
                            ret3.setName(classification.getCurriculum().getName() + " " + classification.getAcademicClassification().getName());
                            resources.add(ret3);
                        }
                    }
                    if (limit <= 0 || resources.size() <= limit) break;
                    resources = new ArrayList(resources.subList(0, limit));
                    break;
                }
                case DEPARTMENT: {
                    List departments = hibSession.createQuery("select d from Department d where d.session.uniqueId = :sessionId and (lower(d.deptCode) like :name or lower(d.abbreviation) like :name or lower(d.name) like :title) order by d.abbreviation, d.deptCode", Department.class).setParameter("name", (Object)(query.toLowerCase() + "%")).setParameter("title", (Object)("%" + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (Department department : departments) {
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.DEPARTMENT);
                        ret.setId(department.getUniqueId());
                        ret.setAbbreviation(department.getAbbreviation() == null ? department.getDeptCode() : department.getAbbreviation());
                        ret.setName(department.getName());
                        resources.add(ret);
                    }
                    break;
                }
                case GROUP: {
                    List list = hibSession.createQuery("select g from StudentGroup g where g.session.uniqueId = :sessionId and (lower(g.groupAbbreviation) like :abbv or lower(g.groupName) like :name) order by g.groupAbbreviation, g.groupName", StudentGroup.class).setParameter("abbv", (Object)(query.toLowerCase() + "%")).setParameter("name", (Object)("%" + query.toLowerCase() + "%")).setParameter("sessionId", (Object)academicSession.getUniqueId()).setMaxResults(limit).list();
                    for (StudentGroup group : list) {
                        EventInterface.ResourceInterface ret = new EventInterface.ResourceInterface();
                        ret.setType(EventInterface.ResourceType.GROUP);
                        ret.setId(group.getUniqueId());
                        ret.setAbbreviation(group.getGroupAbbreviation());
                        ret.setName(group.getGroupName());
                        resources.add(ret);
                    }
                    break;
                }
                default: {
                    throw new GwtRpcException("Resource type " + type.getLabel() + " not supported.");
                }
            }
            if (resources.isEmpty()) {
                throw new GwtRpcException("No " + type.getLabel() + " " + query + " found.");
            }
            arrayList = resources;
        }
        catch (Throwable throwable) {
            try {
                hibSession.close();
                throw throwable;
            }
            catch (GwtRpcException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GwtRpcException("Failed to find resources: " + e.getMessage(), e);
            }
        }
        hibSession.close();
        return arrayList;
    }
}

