/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ExamPeriodEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Action(value="examPeriodEdit", results={@Result(name={"list"}, type="tiles", location="examPeriodList.tiles"), @Result(name={"add"}, type="tiles", location="examPeriodAdd.tiles"), @Result(name={"edit"}, type="tiles", location="examPeriodEdit.tiles"), @Result(name={"autosetup"}, type="tiles", location="examPeriodSetup.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="examPeriodList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Periods"), @TilesPutAttribute(name="body", value="/admin/examPeriods.jsp")}), @TilesDefinition(name="examPeriodAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Examination Period"), @TilesPutAttribute(name="body", value="/admin/examPeriods.jsp")}), @TilesDefinition(name="examPeriodEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Examination Period"), @TilesPutAttribute(name="body", value="/admin/examPeriods.jsp")}), @TilesDefinition(name="examPeriodSetup.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Setup Examination Periods"), @TilesPutAttribute(name="body", value="/admin/examPeriods.jsp")})})
public class ExamPeriodEditAction
extends UniTimeAction<ExamPeriodEditForm> {
    private static final long serialVersionUID = 3188159298911284079L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String op2 = null;
    private Long id;

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        ExamPeriod ep;
        org.hibernate.Session hibSession;
        Transaction tx;
        if (this.form == null) {
            this.form = new ExamPeriodEditForm();
        }
        this.sessionContext.checkPermission(Right.ExaminationPeriods);
        ((ExamPeriodEditForm)this.form).setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        if (this.op == null) {
            this.op = ((ExamPeriodEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null) {
            ((ExamPeriodEditForm)this.form).load(null, this.sessionContext);
            this.op = "List";
        }
        ((ExamPeriodEditForm)this.form).setOp(this.op);
        List<ExamType> types = ExamType.findAll();
        if (!this.sessionContext.hasPermission(Right.StatusIndependent) && this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.ExaminationSolver)) {
            Iterator<ExamType> i = types.iterator();
            while (i.hasNext()) {
                ExamType t = i.next();
                ExamStatus status = ExamStatus.findStatus(this.sessionContext.getUser().getCurrentAcademicSessionId(), t.getUniqueId());
                if (status == null || status.getManagers().isEmpty()) continue;
                boolean hasManager = false;
                for (TimetableManager m : status.getManagers()) {
                    if (!this.sessionContext.getUser().getCurrentAuthority().hasQualifier(m)) continue;
                    hasManager = true;
                    break;
                }
                if (hasManager) continue;
                i.remove();
            }
        }
        this.request.setAttribute("examTypes", types);
        if (MSG.actionBackToExaminationPeriods().equals(this.op)) {
            if (((ExamPeriodEditForm)this.form).getUniqueId() != null) {
                this.request.setAttribute("hash", (Object)((ExamPeriodEditForm)this.form).getUniqueId());
            }
            ((ExamPeriodEditForm)this.form).load(null, this.sessionContext);
            ((ExamPeriodEditForm)this.form).setOp("List");
        }
        if (MSG.actionAddExaminationPeriod().equals(this.op)) {
            ((ExamPeriodEditForm)this.form).load(null, this.sessionContext);
            ((ExamPeriodEditForm)this.form).setOp(MSG.actionSaveExaminationPeriod());
        }
        for (ExamType type : ExamTypeDAO.getInstance().findAll()) {
            if (!MSG.actionSetupExaminationPeriods(type.getLabel()).equals(this.op) || !((ExamPeriodEditForm)this.form).getCanAutoSetup(type.getUniqueId())) continue;
            ((ExamPeriodEditForm)this.form).setAutoSetup(true);
            ((ExamPeriodEditForm)this.form).setExamType(type.getUniqueId());
            ((ExamPeriodEditForm)this.form).setOp(MSG.actionSaveExaminationPeriod());
        }
        if (MSG.actionUpdateExaminationPeriod().equals(this.op) || MSG.actionSaveExaminationPeriod().equals(this.op)) {
            ((ExamPeriodEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                if (((ExamPeriodEditForm)this.form).getAutoSetup()) {
                    ((ExamPeriodEditForm)this.form).setDays(this.request);
                }
                ((ExamPeriodEditForm)this.form).setOp(((ExamPeriodEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveExaminationPeriod() : MSG.actionUpdateExaminationPeriod());
            } else {
                tx = null;
                try {
                    hibSession = ExamPeriodDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    if ((ep = ((ExamPeriodEditForm)this.form).saveOrUpdate(this.request, this.sessionContext, hibSession)) != null) {
                        ChangeLog.addChange(hibSession, this.sessionContext, ep, ChangeLog.Source.EXAM_PERIOD_EDIT, "Save".equals(this.op) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                ((ExamPeriodEditForm)this.form).setOp("List");
                if (((ExamPeriodEditForm)this.form).getUniqueId() != null) {
                    this.request.setAttribute("hash", (Object)((ExamPeriodEditForm)this.form).getUniqueId());
                }
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorExaminationIdNotProvided());
                return "list";
            }
            ExamPeriod ep2 = (ExamPeriod)ExamPeriodDAO.getInstance().get(Long.valueOf(this.id));
            if (ep2 == null) {
                this.addFieldError("form.uniqueId", MSG.errorExaminationIdNotProvided());
                return "list";
            }
            ((ExamPeriodEditForm)this.form).load(ep2, this.sessionContext);
        }
        if (MSG.actionDeleteExaminationPeriod().equals(this.op)) {
            tx = null;
            try {
                hibSession = ExamPeriodDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                ep = (ExamPeriod)ExamPeriodDAO.getInstance().get(((ExamPeriodEditForm)this.form).getUniqueId(), hibSession);
                ChangeLog.addChange(hibSession, this.sessionContext, ep, ChangeLog.Source.EXAM_PERIOD_EDIT, ChangeLog.Operation.DELETE, null, null);
                ((ExamPeriodEditForm)this.form).delete(this.sessionContext, hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((ExamPeriodEditForm)this.form).load(null, this.sessionContext);
            ((ExamPeriodEditForm)this.form).setOp("List");
        }
        if ("List".equals(((ExamPeriodEditForm)this.form).getOp())) {
            return "list";
        }
        if ("Reload".equals(((ExamPeriodEditForm)this.form).getOp())) {
            if (((ExamPeriodEditForm)this.form).getExamType() != null && ((ExamPeriodEditForm)this.form).getExamType() >= 0L) {
                this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)((ExamPeriodEditForm)this.form).getExamType());
                ((ExamPeriodEditForm)this.form).load(null, this.sessionContext);
            } else {
                ((ExamPeriodEditForm)this.form).reset();
                ((ExamPeriodEditForm)this.form).setEditable(true);
            }
            ((ExamPeriodEditForm)this.form).setOp(MSG.actionSaveExaminationPeriod());
        }
        return ((ExamPeriodEditForm)this.form).getAutoSetup() ? "autosetup" : (((ExamPeriodEditForm)this.form).getUniqueId() < 0L ? "add" : "edit");
    }

    public String getExamPeriods() {
        WebTable.setOrder(this.sessionContext, "examPeriods.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(8, null, "examPeriodEdit.action?ord=%%", new String[]{MSG.colType(), MSG.colDate(), MSG.colStartTime(), MSG.colEndTime(), MSG.colExamLength(), MSG.colEventStartOffset(), MSG.colEventStopOffset(), MSG.colPreference()}, new String[]{"left", "left", "left", "left", "right", "right", "right", "left"}, null);
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), (Long)null);
        if (periods.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.infoNoExaminationPeriodsDefined()}, null, null);
        }
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        Formats.Format<Date> stf = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        HashSet<ExamType> types = null;
        if (!this.sessionContext.hasPermission(Right.StatusIndependent) && this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.ExaminationSolver)) {
            types = new HashSet<ExamType>();
            block0: for (ExamType t : ExamType.findAll()) {
                ExamStatus status = ExamStatus.findStatus(this.sessionContext.getUser().getCurrentAcademicSessionId(), t.getUniqueId());
                if (status != null && !status.getManagers().isEmpty()) {
                    for (TimetableManager m : status.getManagers()) {
                        if (!this.sessionContext.getUser().getCurrentAuthority().hasQualifier(m)) continue;
                        types.add(t);
                        continue block0;
                    }
                    continue;
                }
                types.add(t);
            }
        }
        for (ExamPeriod ep : periods) {
            if (types != null && !types.contains(ep.getExamType())) continue;
            String onClick = "onClick=\"document.location='examPeriodEdit.action?op=Edit&id=" + ep.getUniqueId() + "';\"";
            webTable.addLine(onClick, new String[]{ep.getExamType().getLabel(), "<a name='" + ep.getUniqueId() + "'>" + sdf.format(ep.getStartDate()) + "</a>", stf.format(ep.getStartTime()), stf.format(ep.getEndTime()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getLength()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getEventStartOffset()), String.valueOf(Constants.SLOT_LENGTH_MIN * ep.getEventStopOffset()), PreferenceLevel.sNeutral.equals(ep.getPrefLevel().getPrefProlog()) ? "" : "<font color='" + PreferenceLevel.prolog2color(ep.getPrefLevel().getPrefProlog()) + "'>" + ep.getPrefLevel().getPrefName() + "</font>"}, new Comparable[]{ep.getExamType(), ep.getStartDate(), ep.getStartSlot(), Integer.valueOf(ep.getStartSlot() + ep.getLength()), ep.getLength(), ep.getEventStartOffset(), ep.getEventStopOffset(), ep.getPrefLevel().getPrefId()});
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "examPeriods.ord"));
    }
}

