/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

public enum Action {
    NONE,
    CREATE_ONLY,
    DROP,
    CREATE,
    CREATE_DROP,
    VALIDATE,
    UPDATE,
    TRUNCATE;

    public static final String ACTION_NONE = "none";
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_CREATE_ONLY = "create-only";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_CREATE_THEN_DROP = "create-drop";
    public static final String ACTION_VALIDATE = "validate";
    public static final String ACTION_UPDATE = "update";
    public static final String SPEC_ACTION_NONE = "none";
    public static final String SPEC_ACTION_DROP = "drop";
    public static final String SPEC_ACTION_CREATE = "create";
    public static final String SPEC_ACTION_DROP_AND_CREATE = "drop-and-create";

    public String getExternalJpaName() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case CREATE_ONLY: {
                return "create";
            }
            case DROP: {
                return "drop";
            }
            case CREATE: {
                return SPEC_ACTION_DROP_AND_CREATE;
            }
        }
        return null;
    }

    public String getExternalHbm2ddlName() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case CREATE_ONLY: {
                return ACTION_CREATE_ONLY;
            }
            case DROP: {
                return "drop";
            }
            case CREATE: {
                return "create";
            }
            case CREATE_DROP: {
                return ACTION_CREATE_THEN_DROP;
            }
            case VALIDATE: {
                return ACTION_VALIDATE;
            }
            case UPDATE: {
                return ACTION_UPDATE;
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(externalJpaName=" + this.getExternalJpaName() + ", externalHbm2ddlName=" + this.getExternalHbm2ddlName() + ")";
    }

    public static Action interpretJpaSetting(Object value) {
        if (value == null) {
            return NONE;
        }
        if (value instanceof Action) {
            return (Action)((Object)value);
        }
        String name = value.toString().trim();
        if (name.isEmpty()) {
            return NONE;
        }
        for (Action action : Action.values()) {
            String jpaName = action.getExternalJpaName();
            if (jpaName == null || !jpaName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            String hbm2ddlName = action.getExternalHbm2ddlName();
            if (hbm2ddlName == null || !hbm2ddlName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            if (!action.name().equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unrecognized JPA schema management action setting: '" + String.valueOf(value) + "'");
    }

    public static Action interpretHbm2ddlSetting(Object value) {
        if (value == null) {
            return NONE;
        }
        if (value instanceof Action) {
            return (Action)((Object)value);
        }
        String name = value.toString().trim();
        if (name.isEmpty()) {
            return NONE;
        }
        for (Action action : Action.values()) {
            String hbm2ddlName = action.getExternalHbm2ddlName();
            if (hbm2ddlName == null || !hbm2ddlName.equals(name)) continue;
            return action;
        }
        for (Action action : Action.values()) {
            String jpaName = action.getExternalJpaName();
            if (jpaName == null || !jpaName.equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unrecognized 'hibernate.hbm2ddl.auto' setting: '" + name + "'");
    }
}

