/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.ToolBox;

public class BreakFlexibleConstraint
extends FlexibleConstraint {
    private int iBreakStart;
    private int iBreakEnd;
    private int iBreakLength;

    public BreakFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Pattern pattern = null;
        Matcher matcher = null;
        String patternString = "_(Break):([0-9]+):([0-9]+):([0-9]+)_";
        pattern = Pattern.compile(patternString);
        matcher = pattern.matcher(reference);
        if (matcher.find()) {
            this.iBreakStart = Integer.parseInt(matcher.group(2));
            this.iBreakEnd = Integer.parseInt(matcher.group(3));
            this.iBreakLength = Integer.parseInt(matcher.group(4)) / Constants.SLOT_LENGTH_MIN;
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.BREAK;
        }
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        List<BitSet> weeks = this.getWeeks();
        if (value.getTimeLocation().getStartSlot() <= this.iBreakEnd && value.getTimeLocation().getStartSlot() + value.getTimeLocation().getLength() > this.iBreakStart) {
            for (int dayCode : Constants.DAY_CODES) {
                if ((value.getTimeLocation().getDayCode() & dayCode) == 0) continue;
                for (BitSet week : weeks) {
                    boolean isProblem = false;
                    do {
                        Placement conflict;
                        HashSet<Placement> adepts = new HashSet<Placement>();
                        List<FlexibleConstraint.Block> blocks = this.getBreakBlocks(assignment, dayCode, conflicts, value, null, week);
                        this.getAdeptsLunchBreak(blocks, adepts);
                        if (adepts.isEmpty()) {
                            isProblem = false;
                        }
                        if (adepts.size() >= 2) {
                            adepts.remove(value);
                        }
                        if ((conflict = ToolBox.random(adepts)) == null) continue;
                        conflicts.add(conflict);
                    } while (isProblem);
                }
            }
        }
    }

    public List<FlexibleConstraint.Block> getBreakBlocks(Assignment<Lecture, Placement> assignment, int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        ArrayList<Placement> toBeSorted = new ArrayList<Placement>(this.getRelevantPlacements(assignment, dayCode, conflicts, value, assignments, week));
        Collections.sort(toBeSorted, new FlexibleConstraint.PlacementTimeComparator());
        return this.mergeToBlocks(toBeSorted, this.iBreakLength);
    }

    private void getAdeptsLunchBreak(List<FlexibleConstraint.Block> blocks, Set<Placement> adepts) {
        ArrayList<FlexibleConstraint.Block> matchingBlocks = new ArrayList<FlexibleConstraint.Block>();
        for (FlexibleConstraint.Block block : blocks) {
            if (block.getStartSlotCurrentBlock() > this.iBreakEnd || block.getEndSlotCurrentBlock() < this.iBreakStart) continue;
            matchingBlocks.add(block);
        }
        int size = matchingBlocks.size();
        if (size == 1) {
            FlexibleConstraint.Block block;
            block = (FlexibleConstraint.Block)matchingBlocks.get(0);
            if (block.getStartSlotCurrentBlock() - this.iBreakStart >= this.iBreakLength || this.iBreakEnd - block.getEndSlotCurrentBlock() >= this.iBreakLength) {
                return;
            }
            for (Placement p : block.getPlacements()) {
                if (p.getTimeLocation().getStartSlot() > this.iBreakEnd || p.getTimeLocation().getStartSlot() + p.getTimeLocation().getLength() < this.iBreakStart) continue;
                adepts.add(p);
            }
        }
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        List<BitSet> weeks = this.getWeeks();
        int violatedDays = 0;
        for (int dayCode : Constants.DAY_CODES) {
            Iterator<BitSet> iterator = weeks.iterator();
            if (!iterator.hasNext()) continue;
            BitSet week = iterator.next();
            HashSet<Placement> adepts = new HashSet<Placement>();
            List<FlexibleConstraint.Block> blocks = this.getBreakBlocks(assignment, dayCode, null, null, assignments, week);
            this.getAdeptsLunchBreak(blocks, adepts);
            if (adepts.isEmpty()) continue;
            ++violatedDays;
        }
        return violatedDays;
    }
}

