/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.StudentSchedulingRule;

@MappedSuperclass
public abstract class BaseStudentSchedulingRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iOrd;
    private String iRuleName;
    private String iStudentFilter;
    private String iFilterInitiative;
    private String iFilterTerm;
    private Integer iFirstYear;
    private Integer iLastYear;
    private String iInstructonalMethod;
    private String iCourseName;
    private String iCourseType;
    private Boolean iDisjunctive;
    private Boolean iAppliesToFilter;
    private Boolean iAppliesToOnline;
    private Boolean iAppliesToBatch;
    private Boolean iAdminOverride;
    private Boolean iAdvisorOverride;

    public BaseStudentSchedulingRule() {
    }

    public BaseStudentSchedulingRule(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="ord", nullable=false)
    public Integer getOrd() {
        return this.iOrd;
    }

    public void setOrd(Integer ord) {
        this.iOrd = ord;
    }

    @Column(name="name", nullable=false, length=255)
    public String getRuleName() {
        return this.iRuleName;
    }

    public void setRuleName(String ruleName) {
        this.iRuleName = ruleName;
    }

    @Column(name="student_filter", nullable=true, length=2048)
    public String getStudentFilter() {
        return this.iStudentFilter;
    }

    public void setStudentFilter(String studentFilter) {
        this.iStudentFilter = studentFilter;
    }

    @Column(name="initiative", nullable=true, length=1024)
    public String getFilterInitiative() {
        return this.iFilterInitiative;
    }

    public void setFilterInitiative(String filterInitiative) {
        this.iFilterInitiative = filterInitiative;
    }

    @Column(name="term", nullable=true, length=1024)
    public String getFilterTerm() {
        return this.iFilterTerm;
    }

    public void setFilterTerm(String filterTerm) {
        this.iFilterTerm = filterTerm;
    }

    @Column(name="first_year", nullable=true, length=4)
    public Integer getFirstYear() {
        return this.iFirstYear;
    }

    public void setFirstYear(Integer firstYear) {
        this.iFirstYear = firstYear;
    }

    @Column(name="last_year", nullable=true, length=4)
    public Integer getLastYear() {
        return this.iLastYear;
    }

    public void setLastYear(Integer lastYear) {
        this.iLastYear = lastYear;
    }

    @Column(name="instr_method", nullable=true, length=2048)
    public String getInstructonalMethod() {
        return this.iInstructonalMethod;
    }

    public void setInstructonalMethod(String instructonalMethod) {
        this.iInstructonalMethod = instructonalMethod;
    }

    @Column(name="course_name", nullable=true, length=2048)
    public String getCourseName() {
        return this.iCourseName;
    }

    public void setCourseName(String courseName) {
        this.iCourseName = courseName;
    }

    @Column(name="course_type", nullable=true, length=2048)
    public String getCourseType() {
        return this.iCourseType;
    }

    public void setCourseType(String courseType) {
        this.iCourseType = courseType;
    }

    @Column(name="disjunctive", nullable=false)
    public Boolean isDisjunctive() {
        return this.iDisjunctive;
    }

    @Transient
    public Boolean getDisjunctive() {
        return this.iDisjunctive;
    }

    public void setDisjunctive(Boolean disjunctive) {
        this.iDisjunctive = disjunctive;
    }

    @Column(name="apply_filter", nullable=false)
    public Boolean isAppliesToFilter() {
        return this.iAppliesToFilter;
    }

    @Transient
    public Boolean getAppliesToFilter() {
        return this.iAppliesToFilter;
    }

    public void setAppliesToFilter(Boolean appliesToFilter) {
        this.iAppliesToFilter = appliesToFilter;
    }

    @Column(name="apply_online", nullable=false)
    public Boolean isAppliesToOnline() {
        return this.iAppliesToOnline;
    }

    @Transient
    public Boolean getAppliesToOnline() {
        return this.iAppliesToOnline;
    }

    public void setAppliesToOnline(Boolean appliesToOnline) {
        this.iAppliesToOnline = appliesToOnline;
    }

    @Column(name="apply_batch", nullable=false)
    public Boolean isAppliesToBatch() {
        return this.iAppliesToBatch;
    }

    @Transient
    public Boolean getAppliesToBatch() {
        return this.iAppliesToBatch;
    }

    public void setAppliesToBatch(Boolean appliesToBatch) {
        this.iAppliesToBatch = appliesToBatch;
    }

    @Column(name="admin_override", nullable=false)
    public Boolean isAdminOverride() {
        return this.iAdminOverride;
    }

    @Transient
    public Boolean getAdminOverride() {
        return this.iAdminOverride;
    }

    public void setAdminOverride(Boolean adminOverride) {
        this.iAdminOverride = adminOverride;
    }

    @Column(name="advisor_override", nullable=false)
    public Boolean isAdvisorOverride() {
        return this.iAdvisorOverride;
    }

    @Transient
    public Boolean getAdvisorOverride() {
        return this.iAdvisorOverride;
    }

    public void setAdvisorOverride(Boolean advisorOverride) {
        this.iAdvisorOverride = advisorOverride;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentSchedulingRule)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentSchedulingRule)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentSchedulingRule)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentSchedulingRule[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentSchedulingRule[\n\tAdminOverride: " + this.getAdminOverride() + "\n\tAdvisorOverride: " + this.getAdvisorOverride() + "\n\tAppliesToBatch: " + this.getAppliesToBatch() + "\n\tAppliesToFilter: " + this.getAppliesToFilter() + "\n\tAppliesToOnline: " + this.getAppliesToOnline() + "\n\tCourseName: " + this.getCourseName() + "\n\tCourseType: " + this.getCourseType() + "\n\tDisjunctive: " + this.getDisjunctive() + "\n\tFilterInitiative: " + this.getFilterInitiative() + "\n\tFilterTerm: " + this.getFilterTerm() + "\n\tFirstYear: " + this.getFirstYear() + "\n\tInstructonalMethod: " + this.getInstructonalMethod() + "\n\tLastYear: " + this.getLastYear() + "\n\tOrd: " + this.getOrd() + "\n\tRuleName: " + this.getRuleName() + "\n\tStudentFilter: " + this.getStudentFilter() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

