/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.JoinFormula;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseExam
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iName;
    private String iNote;
    private Integer iLength;
    private Integer iExamSize;
    private Integer iPrintOffset;
    private Integer iMaxNbrRooms;
    private Integer iSeatingType;
    private String iAssignedPreference;
    private Integer iAvgPeriod;
    private Long iUniqueIdRolledForwardFrom;
    private Session iSession;
    private ExamPeriod iAssignedPeriod;
    private ExamType iExamType;
    private DepartmentStatusType iStatusType;
    private Set<ExamOwner> iOwners;
    private Set<Location> iAssignedRooms;
    private Set<DepartmentalInstructor> iInstructors;
    private Set<ExamConflict> iConflicts;

    public BaseExam() {
    }

    public BaseExam(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="name", nullable=true, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="note", nullable=true, length=1000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="length", nullable=false, length=10)
    public Integer getLength() {
        return this.iLength;
    }

    public void setLength(Integer length) {
        this.iLength = length;
    }

    @Column(name="exam_size", nullable=true, length=10)
    public Integer getExamSize() {
        return this.iExamSize;
    }

    public void setExamSize(Integer examSize) {
        this.iExamSize = examSize;
    }

    @Column(name="print_offset", nullable=true, length=10)
    public Integer getPrintOffset() {
        return this.iPrintOffset;
    }

    public void setPrintOffset(Integer printOffset) {
        this.iPrintOffset = printOffset;
    }

    @Column(name="max_nbr_rooms", nullable=false, length=10)
    public Integer getMaxNbrRooms() {
        return this.iMaxNbrRooms;
    }

    public void setMaxNbrRooms(Integer maxNbrRooms) {
        this.iMaxNbrRooms = maxNbrRooms;
    }

    @Column(name="seating_type", nullable=false, length=10)
    public Integer getSeatingType() {
        return this.iSeatingType;
    }

    public void setSeatingType(Integer seatingType) {
        this.iSeatingType = seatingType;
    }

    @Column(name="assigned_pref", nullable=true, length=100)
    public String getAssignedPreference() {
        return this.iAssignedPreference;
    }

    public void setAssignedPreference(String assignedPreference) {
        this.iAssignedPreference = assignedPreference;
    }

    @Column(name="avg_period", nullable=true, length=10)
    public Integer getAvgPeriod() {
        return this.iAvgPeriod;
    }

    public void setAvgPeriod(Integer avgPeriod) {
        this.iAvgPeriod = avgPeriod;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Override
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="assigned_period", nullable=true)
    public ExamPeriod getAssignedPeriod() {
        return this.iAssignedPeriod;
    }

    public void setAssignedPeriod(ExamPeriod assignedPeriod) {
        this.iAssignedPeriod = assignedPeriod;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="exam_type_id", nullable=false)
    public ExamType getExamType() {
        return this.iExamType;
    }

    public void setExamType(ExamType examType) {
        this.iExamType = examType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value=" ( select s.status_id from %SCHEMA%.exam_status s where s.session_id = session_id and s.type_id = exam_type_id ) ")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public DepartmentStatusType getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(DepartmentStatusType statusType) {
        this.iStatusType = statusType;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="exam", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExamOwner> getOwners() {
        return this.iOwners;
    }

    public void setOwners(Set<ExamOwner> owners) {
        this.iOwners = owners;
    }

    public void addToOwners(ExamOwner examOwner) {
        if (this.iOwners == null) {
            this.iOwners = new HashSet<ExamOwner>();
        }
        this.iOwners.add(examOwner);
    }

    @Deprecated
    public void addToowners(ExamOwner examOwner) {
        this.addToOwners(examOwner);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="exam_room_assignment", joinColumns={@JoinColumn(name="exam_id")}, inverseJoinColumns={@JoinColumn(name="location_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Location> getAssignedRooms() {
        return this.iAssignedRooms;
    }

    public void setAssignedRooms(Set<Location> assignedRooms) {
        this.iAssignedRooms = assignedRooms;
    }

    public void addToAssignedRooms(Location location) {
        if (this.iAssignedRooms == null) {
            this.iAssignedRooms = new HashSet<Location>();
        }
        this.iAssignedRooms.add(location);
    }

    @Deprecated
    public void addToassignedRooms(Location location) {
        this.addToAssignedRooms(location);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="exams")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToInstructors(departmentalInstructor);
    }

    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="xconflict_exam", joinColumns={@JoinColumn(name="exam_id")}, inverseJoinColumns={@JoinColumn(name="conflict_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ExamConflict> getConflicts() {
        return this.iConflicts;
    }

    public void setConflicts(Set<ExamConflict> conflicts) {
        this.iConflicts = conflicts;
    }

    public void addToConflicts(ExamConflict examConflict) {
        if (this.iConflicts == null) {
            this.iConflicts = new HashSet<ExamConflict>();
        }
        this.iConflicts.add(examConflict);
    }

    @Deprecated
    public void addToconflicts(ExamConflict examConflict) {
        this.addToConflicts(examConflict);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Exam)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Exam)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Exam)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Exam[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "Exam[\n\tAssignedPeriod: " + String.valueOf(this.getAssignedPeriod()) + "\n\tAssignedPreference: " + this.getAssignedPreference() + "\n\tAvgPeriod: " + this.getAvgPeriod() + "\n\tExamSize: " + this.getExamSize() + "\n\tExamType: " + String.valueOf(this.getExamType()) + "\n\tLength: " + this.getLength() + "\n\tMaxNbrRooms: " + this.getMaxNbrRooms() + "\n\tName: " + this.getName() + "\n\tNote: " + this.getNote() + "\n\tPrintOffset: " + this.getPrintOffset() + "\n\tSeatingType: " + this.getSeatingType() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

