/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.base.BaseSolverParameterDef;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="solver_parameter_def")
public class SolverParameterDef
extends BaseSolverParameterDef
implements Comparable {
    private static final long serialVersionUID = 1L;

    public SolverParameterDef() {
    }

    public SolverParameterDef(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static ArrayList getAll() throws HibernateException {
        return (ArrayList)SolverParameterDefDAO.getInstance().findAll();
    }

    public static SolverParameterDef getSolverParameterDefById(Long id) throws HibernateException {
        return (SolverParameterDef)SolverParameterDefDAO.getInstance().get(id);
    }

    @Deprecated
    public static SolverParameterDef findByNameGroup(String name) {
        return (SolverParameterDef)SolverParameterDefDAO.getInstance().getSession().createQuery("from SolverParameterDef where name = :name", SolverParameterDef.class).setParameter("name", (Object)name).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static SolverParameterDef findByNameGroup(String name, String group) {
        return SolverParameterDef.findByNameGroup(SolverParameterDefDAO.getInstance().getSession(), name, group);
    }

    public static SolverParameterDef findByNameGroup(Session hibSession, String name, String group) {
        List list = hibSession.createQuery("from SolverParameterDef where name = :name and group.name = :group", SolverParameterDef.class).setParameter("name", (Object)name).setParameter("group", (Object)group).setCacheable(true).list();
        return list.isEmpty() ? null : (SolverParameterDef)list.get(0);
    }

    public static SolverParameterDef findByNameType(String name, SolverParameterGroup.SolverType type) {
        return SolverParameterDef.findByNameType(SolverParameterDefDAO.getInstance().getSession(), name, type);
    }

    public static SolverParameterDef findByNameType(Session hibSession, String name, SolverParameterGroup.SolverType type) {
        List list = hibSession.createQuery("from SolverParameterDef where name = :name and group.type = :type", SolverParameterDef.class).setParameter("name", (Object)name).setParameter("type", (Object)type.ordinal()).setCacheable(true).list();
        return list.isEmpty() ? null : (SolverParameterDef)list.get(0);
    }

    public static List<SolverParameterDef> findByGroup(SolverParameterGroup group) {
        return SolverParameterDefDAO.getInstance().getSession().createQuery("from SolverParameterDef where group.uniqueId = :groupId order by order", SolverParameterDef.class).setParameter("groupId", (Object)group.getUniqueId()).list();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof SolverParameterDef)) {
            return -1;
        }
        SolverParameterDef p = (SolverParameterDef)o;
        int cmp = this.getOrder().compareTo(p.getOrder());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(p.getUniqueId() == null ? -1L : p.getUniqueId());
    }

    @Override
    @Transient
    public String getDefault() {
        String ret = super.getDefault();
        return ret == null ? "" : ret;
    }

    @Transient
    public String[] getOptions() {
        if (this.getType() != null && this.getType().startsWith("enum(") && this.getType().endsWith(")")) {
            return this.getType().substring(5, this.getType().length() - 1).split(",");
        }
        return null;
    }
}

