/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.TreeSet;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.offerings.InstrOfferingConfigTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.CourseDetailsWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.InstrOfferingConfigInterface;

public class InstrOfferingConfigPage
extends Composite {
    protected static final GwtMessages GWTMSG = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final CourseMessages MESSAGES = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private TextBox iConfigName;
    private ListBox iDurationType;
    private ListBox iInstructionalMethod;
    private CheckBox iUnlimited;
    private NumberBox iLimit;
    private InstrOfferingConfigTable iTable;
    private CheckBox iVariableLimits;
    private ListBox iInstructionalType;
    private Button iAdd;
    private boolean iInstructionalTypeAllOptions = false;
    private int iLimitRow;
    private P iError;
    private InstrOfferingConfigInterface iData;

    public InstrOfferingConfigPage() {
        this.iForm.addStyleName("unitime-InstrOfferingConfig");
        LoadingWidget.getInstance().show(GWTMSG.waitLoadingData());
        String configId = Window.Location.getParameter((String)"id");
        String offeringId = Window.Location.getParameter((String)"offering");
        InstrOfferingConfigInterface request = new InstrOfferingConfigInterface(InstrOfferingConfigInterface.Operation.LOAD, offeringId == null ? null : Long.valueOf(offeringId), configId == null ? null : Long.valueOf(configId));
        request.setOp(Window.Location.getParameter((String)"op"));
        RPC.execute(request, new AsyncCallback<InstrOfferingConfigInterface>(){

            public void onSuccess(InstrOfferingConfigInterface result) {
                InstrOfferingConfigPage.this.initPage(result);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        InstrOfferingConfigPage.this.iHeader.setEnabled("back", true);
                        InstrOfferingConfigPage.this.iHeader.setEnabled("save", InstrOfferingConfigPage.this.iData.getConfigId() == null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                        InstrOfferingConfigPage.this.iHeader.setEnabled("update", InstrOfferingConfigPage.this.iData.getConfigId() != null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                        InstrOfferingConfigPage.this.iHeader.setEnabled("delete", InstrOfferingConfigPage.this.iData.isCanDelete());
                        LoadingWidget.getInstance().hide();
                    }
                });
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(GWTMSG.failedLoadData(caught.getMessage()), caught);
                InstrOfferingConfigPage.this.iHeader = new UniTimeHeaderPanel("");
                InstrOfferingConfigPage.this.iForm.addHeaderRow((Widget)InstrOfferingConfigPage.this.iHeader);
                InstrOfferingConfigPage.this.iError = new P("error-table");
                P eh = new P("error-header");
                eh.setText(GWTMSG.failedLoadData(""));
                InstrOfferingConfigPage.this.iError.add((Widget)eh);
                P em = new P("error-message");
                em.setText(caught.getMessage());
                InstrOfferingConfigPage.this.iError.add((Widget)em);
                InstrOfferingConfigPage.this.iForm.addRow((Widget)InstrOfferingConfigPage.this.iError);
                InstrOfferingConfigPage.this.iHeader.addButton("back", GWTMSG.buttonBack(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        History.back();
                    }
                });
                InstrOfferingConfigPage.this.iForm.addBottomRow((Widget)InstrOfferingConfigPage.this.iHeader.clonePanel());
                ToolBox.checkAccess(caught);
            }
        });
        this.initWidget((Widget)this.iForm);
    }

    protected void initPage(InstrOfferingConfigInterface data) {
        this.iData = data;
        this.iHeader = new UniTimeHeaderPanel(data.getCourseName());
        this.iForm.addHeaderRow((Widget)this.iHeader);
        final ClickHandler saveOrUpdateClick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstrOfferingConfigPage.this.iHeader.setEnabled("back", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("save", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("update", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("delete", false);
                LoadingWidget.getInstance().show(InstrOfferingConfigPage.this.iData.getConfigId() == null ? GWTMSG.waitCreate(GWTMSG.labelConfiguration(InstrOfferingConfigPage.this.iData.getConfigName())) : GWTMSG.waitUpdate(GWTMSG.labelConfiguration(InstrOfferingConfigPage.this.iData.getConfigName())));
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        if (InstrOfferingConfigPage.this.validate()) {
                            InstrOfferingConfigPage.this.iData.setOperation(InstrOfferingConfigInterface.Operation.SAVE);
                            RPC.execute(InstrOfferingConfigPage.this.iData, new AsyncCallback<InstrOfferingConfigInterface>(){

                                public void onSuccess(InstrOfferingConfigInterface result) {
                                    ToolBox.open("instructionalOfferingDetail.action?op=view&io=" + result.getOfferingId() + "#ioc" + result.getConfigId());
                                }

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(GWTMSG.failedSave(caught.getMessage()), caught);
                                    ToolBox.checkAccess(caught);
                                    InstrOfferingConfigPage.this.iHeader.setEnabled("save", InstrOfferingConfigPage.this.iData.getConfigId() == null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                                    InstrOfferingConfigPage.this.iHeader.setEnabled("update", InstrOfferingConfigPage.this.iData.getConfigId() != null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                                    InstrOfferingConfigPage.this.iHeader.setEnabled("delete", InstrOfferingConfigPage.this.iData.isCanDelete());
                                    InstrOfferingConfigPage.this.iHeader.setEnabled("back", true);
                                    InstrOfferingConfigPage.this.iError.clear();
                                    P eh = new P("error-header");
                                    eh.setText(GWTMSG.failedSave(""));
                                    InstrOfferingConfigPage.this.iError.add((Widget)eh);
                                    P em = new P("error-message");
                                    em.setText(caught.getMessage());
                                    InstrOfferingConfigPage.this.iError.add((Widget)em);
                                    InstrOfferingConfigPage.this.iError.setVisible(true);
                                }
                            });
                        } else {
                            LoadingWidget.getInstance().hide();
                            InstrOfferingConfigPage.this.iHeader.setEnabled("save", InstrOfferingConfigPage.this.iData.getConfigId() == null);
                            InstrOfferingConfigPage.this.iHeader.setEnabled("update", InstrOfferingConfigPage.this.iData.getConfigId() != null);
                            InstrOfferingConfigPage.this.iHeader.setEnabled("delete", InstrOfferingConfigPage.this.iData.isCanDelete());
                            InstrOfferingConfigPage.this.iHeader.setEnabled("back", true);
                        }
                    }
                });
            }
        };
        this.iHeader.addButton("save", GWTMSG.buttonSave(), saveOrUpdateClick);
        this.iHeader.addButton("update", GWTMSG.buttonUpdate(), new ClickHandler(){

            public void onClick(final ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.confirmMayDeleteSubpartsClasses(), new Command(){

                    public void execute() {
                        saveOrUpdateClick.onClick(event);
                    }
                });
            }
        });
        this.iHeader.addButton("delete", GWTMSG.buttonDelete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.confirmDeleteExistingSubpartsClasses(), new Command(){

                    public void execute() {
                        InstrOfferingConfigPage.this.iHeader.setEnabled("back", false);
                        InstrOfferingConfigPage.this.iHeader.setEnabled("save", false);
                        InstrOfferingConfigPage.this.iHeader.setEnabled("update", false);
                        InstrOfferingConfigPage.this.iHeader.setEnabled("delete", false);
                        LoadingWidget.getInstance().show(GWTMSG.waitDelete(MESSAGES.labelConfiguration(InstrOfferingConfigPage.this.iData.getConfigName())));
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                InstrOfferingConfigPage.this.iData.setOperation(InstrOfferingConfigInterface.Operation.DELETE);
                                RPC.execute(InstrOfferingConfigPage.this.iData, new AsyncCallback<InstrOfferingConfigInterface>(){

                                    public void onSuccess(InstrOfferingConfigInterface result) {
                                        ToolBox.open("instructionalOfferingDetail.action?op=view&io=" + result.getOfferingId());
                                    }

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(GWTMSG.failedDelete(MESSAGES.labelConfiguration(InstrOfferingConfigPage.this.iData.getConfigName()), caught.getMessage()), caught);
                                        ToolBox.checkAccess(caught);
                                        InstrOfferingConfigPage.this.iHeader.setEnabled("save", InstrOfferingConfigPage.this.iData.getConfigId() == null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                                        InstrOfferingConfigPage.this.iHeader.setEnabled("update", InstrOfferingConfigPage.this.iData.getConfigId() != null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                                        InstrOfferingConfigPage.this.iHeader.setEnabled("delete", InstrOfferingConfigPage.this.iData.isCanDelete());
                                        InstrOfferingConfigPage.this.iHeader.setEnabled("back", true);
                                        InstrOfferingConfigPage.this.iError.clear();
                                        P eh = new P("error-header");
                                        eh.setText(GWTMSG.failedSave(""));
                                        InstrOfferingConfigPage.this.iError.add((Widget)eh);
                                        P em = new P("error-message");
                                        em.setText(caught.getMessage());
                                        InstrOfferingConfigPage.this.iError.add((Widget)em);
                                        InstrOfferingConfigPage.this.iError.setVisible(true);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("back", GWTMSG.buttonBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstrOfferingConfigPage.this.iHeader.setEnabled("back", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("save", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("update", false);
                InstrOfferingConfigPage.this.iHeader.setEnabled("delete", false);
                ToolBox.open("instructionalOfferingDetail.action?op=view&io=" + InstrOfferingConfigPage.this.iData.getOfferingId() + (String)(InstrOfferingConfigPage.this.iData.getConfigId() == null ? "" : "#ioc" + InstrOfferingConfigPage.this.iData.getConfigId()));
            }
        });
        this.iHeader.setEnabled("save", false);
        this.iHeader.setEnabled("update", false);
        this.iHeader.setEnabled("back", false);
        this.iHeader.setEnabled("delete", false);
        this.iError = new P("error-table");
        this.iForm.addRow((Widget)this.iError);
        this.iError.setVisible(false);
        this.iConfigName = new AriaTextBox();
        this.iConfigName.setStyleName("gwt-SuggestBox");
        this.iConfigName.setMaxLength(20);
        this.iConfigName.setWidth("140px");
        this.iConfigName.setText(this.iData.getConfigName() == null ? "" : this.iData.getConfigName());
        this.iForm.addRow(MESSAGES.propertyConfigurationName(), (Widget)this.iConfigName);
        this.iConfigName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> evt) {
                InstrOfferingConfigPage.this.iData.setConfigName((String)evt.getValue());
            }
        });
        this.iUnlimited = new CheckBox();
        this.iUnlimited.setValue(this.iData.isUnlimited());
        this.iForm.addRow(MESSAGES.propertyUnlimitedEnrollment(), (Widget)this.iUnlimited);
        this.iUnlimited.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstrOfferingConfigPage.this.iData.setUnlimited((Boolean)event.getValue());
                InstrOfferingConfigPage.this.updateCounts();
            }
        });
        this.iLimit = new NumberBox();
        this.iLimit.setValue(Boolean.TRUE.equals(this.iData.isUnlimited()) ? null : this.iData.getLimit());
        this.iLimit.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                InstrOfferingConfigPage.this.iData.setLimit(InstrOfferingConfigPage.this.iLimit.toInteger());
                if (InstrOfferingConfigPage.this.iData.getLimit() == null) {
                    InstrOfferingConfigPage.this.iData.setLimit(0);
                    InstrOfferingConfigPage.this.iLimit.setValue(InstrOfferingConfigPage.this.iData.getLimit());
                }
                InstrOfferingConfigPage.this.updateCounts();
            }
        });
        this.iLimitRow = this.iForm.addRow(MESSAGES.propertyConfigurationLimit(), (Widget)this.iLimit);
        if (this.iData.isDisplayCourseLink()) {
            CourseDetailsWidget link = new CourseDetailsWidget(true);
            link.reload(this.iData.getCourseId());
            this.iForm.addRow(MESSAGES.propertyCourseCatalog(), (Widget)link);
        }
        if (this.iData.hasDurationTypes()) {
            if (this.iData.isDurationTypeEditable()) {
                this.iDurationType = new ListBox();
                for (InstrOfferingConfigInterface.Reference im : this.iData.getDurationTypes()) {
                    this.iDurationType.addItem(im.getLabel(), im.getId().toString());
                    if (!im.getId().equals(this.iData.getDurationTypeId())) continue;
                    this.iDurationType.setSelectedIndex(this.iDurationType.getItemCount() - 1);
                }
                this.iForm.addRow(MESSAGES.propertyClassDurationType(), (Widget)this.iDurationType);
                this.iDurationType.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        String id = InstrOfferingConfigPage.this.iDurationType.getValue(InstrOfferingConfigPage.this.iDurationType.getSelectedIndex());
                        if (id == null || id.isEmpty()) {
                            InstrOfferingConfigPage.this.iData.setDurationTypeId(null);
                        } else {
                            InstrOfferingConfigPage.this.iData.setDurationTypeId(Long.valueOf(id));
                        }
                        InstrOfferingConfigPage.this.updateTable();
                    }
                });
            } else {
                InstrOfferingConfigInterface.Reference dt = this.iData.getDurationType(this.iData.getDurationTypeId());
                if (dt != null) {
                    this.iForm.addRow(MESSAGES.propertyClassDurationType(), (Widget)new Label(dt.getLabel()));
                }
            }
        }
        if (this.iData.hasInstructionalMethods()) {
            if (this.iData.isInstructionalMethodEditable()) {
                this.iInstructionalMethod = new ListBox();
                for (InstrOfferingConfigInterface.Reference im : this.iData.getInstructionalMethods()) {
                    this.iInstructionalMethod.addItem(im.getLabel(), im.getId().toString());
                    if (!im.getId().equals(this.iData.getInstructionalMethodId())) continue;
                    this.iInstructionalMethod.setSelectedIndex(this.iInstructionalMethod.getItemCount() - 1);
                }
                this.iForm.addRow(MESSAGES.propertyInstructionalMethod(), (Widget)this.iInstructionalMethod);
                this.iInstructionalMethod.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        String id = InstrOfferingConfigPage.this.iInstructionalMethod.getValue(InstrOfferingConfigPage.this.iInstructionalMethod.getSelectedIndex());
                        if (id == null || id.isEmpty()) {
                            InstrOfferingConfigPage.this.iData.setInstructionalMethodId(null);
                        } else {
                            InstrOfferingConfigPage.this.iData.setInstructionalMethodId(Long.valueOf(id));
                        }
                    }
                });
            } else {
                InstrOfferingConfigInterface.Reference im = this.iData.getInstructionalMethod(this.iData.getInstructionalMethodId());
                if (im != null) {
                    this.iForm.addRow(MESSAGES.propertyInstructionalMethod(), (Widget)new Label(im.getLabel()));
                }
            }
        }
        this.iInstructionalType = new ListBox();
        this.populateInstructionalTypes();
        this.iInstructionalType.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String id = InstrOfferingConfigPage.this.iInstructionalType.getValue(InstrOfferingConfigPage.this.iInstructionalType.getSelectedIndex());
                if ("less".equals(id)) {
                    InstrOfferingConfigPage.this.iInstructionalTypeAllOptions = false;
                    InstrOfferingConfigPage.this.populateInstructionalTypes();
                } else if ("more".equals(id)) {
                    InstrOfferingConfigPage.this.iInstructionalTypeAllOptions = true;
                    InstrOfferingConfigPage.this.populateInstructionalTypes();
                }
            }
        });
        this.iAdd = new Button(MESSAGES.actionAddInstructionalTypeToConfig());
        this.iAdd.setAccessKey(MESSAGES.accessAddInstructionalTypeToConfig().charAt(0));
        this.iAdd.setTitle(MESSAGES.titleAddInstructionalTypeToConfig(MESSAGES.accessAddInstructionalTypeToConfig()));
        P it = new P("instructional-type-selection");
        it.add((Widget)this.iInstructionalType);
        it.add((Widget)this.iAdd);
        this.iForm.addRow(MESSAGES.filterInstructionalType(), (Widget)it);
        this.iAdd.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String id = InstrOfferingConfigPage.this.iInstructionalType.getValue(InstrOfferingConfigPage.this.iInstructionalType.getSelectedIndex());
                try {
                    InstrOfferingConfigPage.this.iTable.addSubpartLine(Long.valueOf(id));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        if (this.iData.isDisplayOptionForMaxLimit()) {
            this.iVariableLimits = new CheckBox(MESSAGES.labelAllowVariableLimits());
            this.iVariableLimits.setValue(Boolean.valueOf(this.iData.isDisplayMaxLimit()));
            this.iVariableLimits.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    InstrOfferingConfigPage.this.iData.setDisplayMaxLimit((Boolean)event.getValue());
                    InstrOfferingConfigPage.this.updateTable();
                }
            });
            this.iForm.addRow("", (Widget)this.iVariableLimits);
        }
        this.iTable = new InstrOfferingConfigTable(data){

            @Override
            protected void onLimitChange() {
                InstrOfferingConfigPage.this.updateCounts();
                InstrOfferingConfigPage.this.iHeader.setEnabled("back", true);
                InstrOfferingConfigPage.this.iHeader.setEnabled("save", InstrOfferingConfigPage.this.iData.getConfigId() == null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                InstrOfferingConfigPage.this.iHeader.setEnabled("update", InstrOfferingConfigPage.this.iData.getConfigId() != null && !InstrOfferingConfigPage.this.iData.getSubpartLines().isEmpty());
                InstrOfferingConfigPage.this.iHeader.setEnabled("delete", InstrOfferingConfigPage.this.iData.isCanDelete());
            }
        };
        this.iForm.addRow((Widget)this.iTable);
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.updateCounts();
    }

    protected void populateInstructionalTypes() {
        this.iInstructionalType.clear();
        this.iInstructionalType.addItem(MESSAGES.itemSelect(), "-");
        for (InstrOfferingConfigInterface.Reference it : this.iData.getInstructionalTypes()) {
            if (!this.iInstructionalTypeAllOptions && !it.isSelectable()) continue;
            this.iInstructionalType.addItem(it.getLabel(), it.getId().toString());
        }
        if (this.iInstructionalTypeAllOptions) {
            this.iInstructionalType.addItem(MESSAGES.selectLessOptions(), "less");
        } else {
            this.iInstructionalType.addItem(MESSAGES.selectMoreOptions(), "more");
        }
    }

    protected void updateCounts() {
        this.iForm.getRowFormatter().setVisible(this.iLimitRow, this.iData.isUnlimited() == false);
        if (this.iVariableLimits != null) {
            this.iVariableLimits.setVisible(this.iData.isUnlimited() == false);
            boolean hasVariable = false;
            int row = 1;
            for (InstrOfferingConfigInterface.SubpartLine line : this.iData.getSubpartLines()) {
                if (line.getMinClassLimit() != null && line.getMaxClassLimit() != null && !line.getMinClassLimit().equals(line.getMaxClassLimit())) {
                    hasVariable = true;
                }
                boolean badLimit = false;
                boolean badNbrClasses = false;
                if (!this.iData.isUnlimited().booleanValue()) {
                    if (line.getMaxClassLimit() != null && line.getNumberOfClasses() != null) {
                        parent = this.iData.getSubpartLine(line.getParentId());
                        if (parent != null && parent.getNumberOfClasses() != null && parent.getMaxClassLimit() != null) {
                            if (line.getNumberOfClasses() <= 0 || parent.getNumberOfClasses() <= 0 || line.getNumberOfClasses() % parent.getNumberOfClasses() != 0) {
                                badNbrClasses = true;
                            }
                            if (line.getMaxClassLimit() < 0 || parent.getMaxClassLimit() < 0) {
                                badLimit = true;
                            }
                            if (line.getNumberOfClasses() * line.getMaxClassLimit() < parent.getNumberOfClasses() * parent.getMaxClassLimit()) {
                                badLimit = true;
                            } else if (line.getMaxClassLimit() * (line.getNumberOfClasses() / parent.getNumberOfClasses()) < parent.getMaxClassLimit()) {
                                badLimit = true;
                            } else if (line.getMaxClassLimit() > parent.getMaxClassLimit()) {
                                badLimit = true;
                            }
                        } else if (parent == null && this.iData.getLimit() != null) {
                            if (line.getNumberOfClasses() <= 0) {
                                badNbrClasses = true;
                            }
                            if (line.getMaxClassLimit() < 0) {
                                badLimit = true;
                            }
                            if (this.iData.isCheckLimits()) {
                                if (line.getNumberOfClasses() * line.getMaxClassLimit() < this.iData.getLimit()) {
                                    badLimit = true;
                                } else if (line.getNumberOfClasses() == 1 && !line.getMaxClassLimit().equals(this.iData.getLimit())) {
                                    badLimit = true;
                                } else if (line.getNumberOfClasses() > 1 && line.getMaxClassLimit() > this.iData.getLimit()) {
                                    badLimit = true;
                                }
                            }
                        }
                    }
                } else if (line.getNumberOfClasses() != null) {
                    parent = this.iData.getSubpartLine(line.getParentId());
                    if (parent != null) {
                        if (line.getNumberOfClasses() <= 0 || parent.getNumberOfClasses() <= 0 || line.getNumberOfClasses() % parent.getNumberOfClasses() != 0) {
                            badNbrClasses = true;
                        }
                    } else if (line.getNumberOfClasses() <= 0) {
                        badNbrClasses = true;
                    }
                }
                if (badLimit) {
                    this.iTable.getRowFormatter().addStyleName(row, "bad-limit");
                } else {
                    this.iTable.getRowFormatter().removeStyleName(row, "bad-limit");
                }
                if (badNbrClasses) {
                    this.iTable.getRowFormatter().addStyleName(row, "bad-nbr-classes");
                } else {
                    this.iTable.getRowFormatter().removeStyleName(row, "bad-nbr-classes");
                }
                ++row;
            }
            this.iVariableLimits.setEnabled(!hasVariable);
        }
        this.iTable.setUnlimited(this.iData.isUnlimited());
    }

    protected void updateTable() {
        int limitIdx = this.iTable.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.LIMIT);
        for (int i = 0; i < this.iTable.getRowCount(); ++i) {
            Widget w;
            InstrOfferingConfigInterface.SubpartLine line = (InstrOfferingConfigInterface.SubpartLine)this.iTable.getData(i);
            if (line == null || limitIdx < 0 || (w = this.iTable.getWidget(i, limitIdx)) == null || !(w instanceof InstrOfferingConfigTable.ClassLimit)) continue;
            ((InstrOfferingConfigTable.ClassLimit)w).setMaxVisible(this.iData.isDisplayMaxLimit());
        }
        UniTimeTableHeader h = this.iTable.getHeader(this.iTable.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.LIMIT));
        h.setHTML(this.iTable.getColumnName(InstrOfferingConfigInterface.InstrOfferingConfigColumn.LIMIT));
        UniTimeTableHeader h2 = this.iTable.getHeader(this.iTable.getIndex(InstrOfferingConfigInterface.InstrOfferingConfigColumn.MINS_PER_WK));
        h2.setHTML(this.iTable.getColumnName(InstrOfferingConfigInterface.InstrOfferingConfigColumn.MINS_PER_WK));
    }

    private boolean validate() {
        TreeSet<String> errors = new TreeSet<String>();
        if (this.iData.getConfigName() == null || this.iData.getConfigName().isEmpty()) {
            errors.add(MESSAGES.errorRequiredField(MESSAGES.propertyConfigurationName().replace(":", "")));
        } else if (this.iData.hasConfigs()) {
            for (InstrOfferingConfigInterface.Reference reference : this.iData.getConfigs()) {
                if (!reference.getLabel().equalsIgnoreCase(this.iData.getConfigName()) || reference.getId().equals(this.iData.getConfigId())) continue;
                errors.add(MESSAGES.errorConfigurationAlreadyExists());
            }
        }
        if (!this.iData.isUnlimited().booleanValue() && this.iData.getLimit() == null) {
            errors.add(MESSAGES.errorRequiredField(MESSAGES.propertyConfigurationLimit().replace(":", "")));
        }
        String lblMax = MESSAGES.columnLimit();
        if (this.iData.isDisplayMaxLimit()) {
            lblMax = MESSAGES.columnMaxLimit();
        }
        for (InstrOfferingConfigInterface.SubpartLine line : this.iData.getSubpartLines()) {
            String error;
            InstrOfferingConfigInterface.SubpartLine parent;
            String error2;
            line.setError(null);
            if (line.getNumberOfClasses() == null || line.getNumberOfClasses() <= 0) {
                String error22 = MESSAGES.errorIntegerGt(MESSAGES.messageNumberOfClassesForIType(line.getLabel()), "0");
                errors.add(error22);
                line.addError(error22);
            } else if (this.iData.getMaxNumberOfClasses() != null && line.getNumberOfClasses() > this.iData.getMaxNumberOfClasses()) {
                error2 = MESSAGES.errorIntegerLtEq(MESSAGES.messageNumberOfClassesForIType(line.getLabel()), this.iData.getMaxNumberOfClasses().toString());
                errors.add(error2);
                line.addError(error2);
            }
            if (!(this.iData.isUnlimited().booleanValue() || line.getMinClassLimit() != null && line.getMaxClassLimit() != null && line.getMinClassLimit() >= 0 && line.getMaxClassLimit() >= 0)) {
                error2 = MESSAGES.errorIntegerGtEq(MESSAGES.messageLimitPerClassForIType(lblMax, line.getLabel()), "0");
                errors.add(error2);
                line.addError(error2);
            }
            if (!this.iData.isUnlimited().booleanValue() && line.getNumberOfRooms() == null || line.getNumberOfRooms() < 0) {
                error2 = MESSAGES.errorIntegerGtEq(MESSAGES.messageNumberOfRoomsForIType(line.getLabel()), "0");
                errors.add(error2);
                line.addError(error2);
            }
            if (line.getMinutesPerWeek() == null || line.getMinutesPerWeek() < 0) {
                error2 = MESSAGES.errorIntegerGtEq(MESSAGES.messageMinsPerWeekForIType(line.getLabel()), "0");
                errors.add(error2);
                line.addError(error2);
            } else if (!this.iData.isUnlimited().booleanValue() && line.getMinutesPerWeek() == 0 && line.getNumberOfRooms() != null && line.getNumberOfRooms() > 0) {
                error2 = MESSAGES.messageMinsPerWeekForITypeCanBeZeroWhenNbrRoomsIsZero(line.getLabel());
                errors.add(error2);
                line.addError(error2);
            }
            if (!this.iData.isUnlimited().booleanValue() && line.getRoomRatio() == null || line.getRoomRatio().floatValue() < 0.0f) {
                error2 = MESSAGES.errorIntegerGtEq(MESSAGES.messageRoomRatioForIType(line.getLabel()), "0");
                errors.add(error2);
                line.addError(error2);
            }
            if (!this.iData.isUnlimited().booleanValue() && this.iData.isCheckLimits() && this.iData.getLimit() != null && !line.hasError()) {
                if (line.getNumberOfClasses() == 1 && !line.getMaxClassLimit().equals(this.iData.getLimit())) {
                    error2 = MESSAGES.errorEqual(MESSAGES.messageLimitPerClassForIType(lblMax, line.getLabel()), MESSAGES.messageConfigurationLimit(this.iData.getLimit()));
                    errors.add(error2);
                    line.addError(error2);
                }
                if (line.getNumberOfClasses() > 1 && line.getMaxClassLimit() * line.getNumberOfClasses() < this.iData.getLimit()) {
                    error2 = MESSAGES.errorIntegerGtEq(MESSAGES.messageSumClassLimitsForIType(line.getLabel()), MESSAGES.messageConfigurationLimit(this.iData.getLimit()));
                    errors.add(error2);
                    line.addError(error2);
                }
                if (line.getNumberOfClasses() > 1 && line.getMaxClassLimit() > this.iData.getLimit()) {
                    error2 = MESSAGES.errorIntegerLtEq(MESSAGES.messageLimitPerClassOfLimitForIType(lblMax, line.getMaxClassLimit(), line.getLabel()), MESSAGES.messageConfigurationLimit(this.iData.getLimit()));
                    errors.add(error2);
                    line.addError(error2);
                }
            }
            if ((parent = this.iData.getSubpartLine(line.getParentId())) == null || line.hasError() || parent.hasError()) continue;
            if (parent.getNumberOfClasses() > 0 && line.getNumberOfClasses() % parent.getNumberOfClasses() != 0) {
                error = MESSAGES.errorConfigurationNC(parent.getLabel(), parent.getNumberOfClasses());
                errors.add(error);
                line.addError(error);
            }
            if (this.iData.isUnlimited().booleanValue()) continue;
            if (line.getMaxClassLimit() > parent.getMaxClassLimit()) {
                error = MESSAGES.errorConfigurationCL(parent.getLabel(), lblMax, parent.getMaxClassLimit());
                errors.add(error);
                line.addError(error);
            }
            if (line.getNumberOfClasses() * line.getMaxClassLimit() < parent.getNumberOfClasses() * parent.getMaxClassLimit()) {
                error = MESSAGES.errorConfigurationLS(parent.getLabel());
                errors.add(error);
                line.addError(error);
            }
            if (line.getMaxClassLimit() * (line.getNumberOfClasses() / parent.getNumberOfClasses()) >= parent.getMaxClassLimit()) continue;
            error = MESSAGES.errorConfigurationLS(parent.getLabel());
            errors.add(error);
            line.addError(error);
        }
        this.iTable.updateButtons();
        this.updateCounts();
        if (errors.isEmpty()) {
            this.iError.clear();
            this.iError.setVisible(false);
        } else {
            this.iError.clear();
            P p = new P("error-header");
            p.setText(MESSAGES.formValidationErrors());
            this.iError.add((Widget)p);
            for (String error2 : errors) {
                P em = new P("error-message");
                em.setHTML(error2);
                this.iError.add((Widget)em);
            }
            this.iError.setVisible(true);
        }
        return errors.isEmpty();
    }
}

