/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.dev.util.Pair;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReflectionHelper {
    private static final Cache<Class<?>, Constructor<?>> constructorCache = new Cache();
    private static final Cache<Pair<Class<?>, String>, Field> fieldCache = new Cache();

    private static Field findField(Class<?> klass, String name) {
        Pair key = Pair.create(klass, (Object)name);
        Field f = (Field)fieldCache.get(key);
        if (f == null) {
            try {
                f = klass.getDeclaredField(name);
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("Unable to find field " + klass.getName() + "." + name, ex);
            }
            f.setAccessible(true);
            fieldCache.put(key, f);
        }
        return f;
    }

    public static Object getField(Class<?> klass, Object obj, String name) {
        Field f = ReflectionHelper.findField(klass, name);
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unexpected failure", ex);
        }
    }

    public static Class<?> loadClass(String klass) {
        try {
            return Class.forName(klass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to find class " + klass, ex);
        }
    }

    public static <T> T newInstance(Class<T> klass) {
        Constructor<T> c = (Constructor<T>)constructorCache.get(klass);
        try {
            if (c == null) {
                c = klass.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                constructorCache.put(klass, c);
            }
            return c.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected failure", ex);
        }
    }

    public static void setField(Class<?> klass, Object obj, String name, Object value) throws Exception {
        Field f = ReflectionHelper.findField(klass, name);
        try {
            f.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unexpected failure", ex);
        }
    }

    private static class Cache<K, V extends AccessibleObject>
    extends LinkedHashMap<K, V> {
        private static final int MAX_SIZE = 1024;
        private static final int INITIAL_CAPACITY = 16;
        private static final float LOAD_FACTOR = 0.75f;

        public Cache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 1024;
        }
    }
}

