/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Campus;
import org.unitime.timetable.model.Degree;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.Program;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;

@MappedSuperclass
public abstract class BaseStudentAreaClassificationMajor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Double iWeight;
    private Student iStudent;
    private AcademicArea iAcademicArea;
    private AcademicClassification iAcademicClassification;
    private PosMajor iMajor;
    private PosMajorConcentration iConcentration;
    private Degree iDegree;
    private Program iProgram;
    private Campus iCampus;

    public BaseStudentAreaClassificationMajor() {
    }

    public BaseStudentAreaClassificationMajor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="weight", nullable=true)
    public Double getWeight() {
        return this.iWeight;
    }

    public void setWeight(Double weight) {
        this.iWeight = weight;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_area_id", nullable=false)
    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_clasf_id", nullable=false)
    public AcademicClassification getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(AcademicClassification academicClassification) {
        this.iAcademicClassification = academicClassification;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="major_id", nullable=false)
    public PosMajor getMajor() {
        return this.iMajor;
    }

    public void setMajor(PosMajor major) {
        this.iMajor = major;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="concentration_id", nullable=true)
    public PosMajorConcentration getConcentration() {
        return this.iConcentration;
    }

    public void setConcentration(PosMajorConcentration concentration) {
        this.iConcentration = concentration;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="degree_id", nullable=true)
    public Degree getDegree() {
        return this.iDegree;
    }

    public void setDegree(Degree degree) {
        this.iDegree = degree;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="program_id", nullable=true)
    public Program getProgram() {
        return this.iProgram;
    }

    public void setProgram(Program program) {
        this.iProgram = program;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="campus_id", nullable=true)
    public Campus getCampus() {
        return this.iCampus;
    }

    public void setCampus(Campus campus) {
        this.iCampus = campus;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentAreaClassificationMajor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentAreaClassificationMajor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentAreaClassificationMajor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentAreaClassificationMajor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentAreaClassificationMajor[\n\tAcademicArea: " + String.valueOf(this.getAcademicArea()) + "\n\tAcademicClassification: " + String.valueOf(this.getAcademicClassification()) + "\n\tCampus: " + String.valueOf(this.getCampus()) + "\n\tConcentration: " + String.valueOf(this.getConcentration()) + "\n\tDegree: " + String.valueOf(this.getDegree()) + "\n\tMajor: " + String.valueOf(this.getMajor()) + "\n\tProgram: " + String.valueOf(this.getProgram()) + "\n\tStudent: " + String.valueOf(this.getStudent()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWeight: " + this.getWeight() + "]";
    }
}

