/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.base.SavedHQLParameterId;

@MappedSuperclass
@IdClass(value=SavedHQLParameterId.class)
public abstract class BaseSavedHQLParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SavedHQL iSavedHQL;
    private String iName;
    private String iLabel;
    private String iType;
    private String iDefaultValue;

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="hql_id")
    public SavedHQL getSavedHQL() {
        return this.iSavedHQL;
    }

    public void setSavedHQL(SavedHQL savedHQL) {
        this.iSavedHQL = savedHQL;
    }

    @Id
    @Column(name="name", length=128)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="label", nullable=true, length=256)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    @Column(name="type", nullable=false, length=2048)
    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    @Column(name="default_value", nullable=true, length=2048)
    public String getDefaultValue() {
        return this.iDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.iDefaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SavedHQLParameter)) {
            return false;
        }
        SavedHQLParameter savedHQLParameter = (SavedHQLParameter)o;
        if (this.getSavedHQL() == null || savedHQLParameter.getSavedHQL() == null || !this.getSavedHQL().equals(savedHQLParameter.getSavedHQL())) {
            return false;
        }
        return this.getName() != null && savedHQLParameter.getName() != null && this.getName().equals(savedHQLParameter.getName());
    }

    public int hashCode() {
        if (this.getSavedHQL() == null || this.getName() == null) {
            return super.hashCode();
        }
        return this.getSavedHQL().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return "SavedHQLParameter[" + String.valueOf(this.getSavedHQL()) + ", " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SavedHQLParameter[\n\tDefaultValue: " + this.getDefaultValue() + "\n\tLabel: " + this.getLabel() + "\n\tName: " + this.getName() + "\n\tSavedHQL: " + String.valueOf(this.getSavedHQL()) + "\n\tType: " + this.getType() + "]";
    }
}

