/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.courses.OfferingsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorsTableBuilder;

@Service(value="org.unitime.timetable.export.Exporter:instructors.csv")
public class InstructorsCSV
implements Exporter {
    @Override
    public String reference() {
        return "instructors.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.exportDataCsv(this.getInstructors(helper), helper);
    }

    protected void exportDataCsv(TableInterface table, ExportHelper helper) throws IOException {
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), table.getId() + "-" + this.reference(), false);
        if (table.hasErrorMessage()) {
            printer.printLine(table.getErrorMessage());
        }
        if (table.getHeader() != null) {
            for (TableInterface.LineInterface line : table.getHeader()) {
                printer.printHeader(line.toCsvLine());
            }
        }
        if (table.getLines() != null) {
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(line.toCsvLine());
            }
        }
        printer.flush();
        printer.close();
    }

    protected TableInterface getInstructors(ExportHelper helper) {
        InstructorsTableBuilder builder = new InstructorsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        Department department = (Department)DepartmentDAO.getInstance().get(Long.valueOf(helper.getParameter("deptId")));
        helper.getSessionContext().checkPermissionAnySession((Object)department, Right.InstructorsExportPdf, new Qualifiable[0]);
        TableInterface table = builder.generateTableForDepartment(department, new OfferingsCSV.Filter(helper), helper.getSessionContext());
        table.setId(department.getDeptCode());
        String sort = helper.getParameter("sort");
        if (sort != null && !sort.isEmpty()) {
            TableInterface.LineInterface header = table.getHeader().get(0);
            for (int col = 0; col < header.getCells().size(); ++col) {
                int column;
                if (sort.equals(header.getCells().get(col).getText())) {
                    column = col;
                    Collections.sort(table.getLines(), new Comparator<TableInterface.LineInterface>(){

                        @Override
                        public int compare(TableInterface.LineInterface l1, TableInterface.LineInterface l2) {
                            TableInterface.CellInterface c1 = l1.getCells().get(column);
                            TableInterface.CellInterface c2 = l2.getCells().get(column);
                            Comparable<?> o1 = c1.getComparable();
                            Comparable<?> o2 = c2.getComparable();
                            if (o1 instanceof String) {
                                return TableInterface.NaturalOrderComparator.compare(o1.toString(), o2.toString());
                            }
                            return o1.compareTo(o2);
                        }
                    });
                    continue;
                }
                if (!sort.equals("!" + header.getCells().get(col).getText())) continue;
                column = col;
                Collections.sort(table.getLines(), new Comparator<TableInterface.LineInterface>(){

                    @Override
                    public int compare(TableInterface.LineInterface l1, TableInterface.LineInterface l2) {
                        TableInterface.CellInterface c1 = l1.getCells().get(column);
                        TableInterface.CellInterface c2 = l2.getCells().get(column);
                        Comparable<?> o1 = c1.getComparable();
                        Comparable<?> o2 = c2.getComparable();
                        if (o1 instanceof String) {
                            return -TableInterface.NaturalOrderComparator.compare(o1.toString(), o2.toString());
                        }
                        return -o1.compareTo(o2);
                    }
                });
            }
        }
        return table;
    }
}

