/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.MessageLog;
import org.unitime.timetable.model.dao.MessageLogDAO;
import org.unitime.timetable.util.LogCleaner;

public class MessageLogAppender
extends AbstractAppender {
    private String iHost = null;
    private Saver iSaver = null;
    private Level iMinLevel = null;

    public MessageLogAppender() {
        super("message-log", null, null, true, Property.EMPTY_ARRAY);
        try {
            this.iHost = InetAddress.getLocalHost().getHostName();
            if (this.iHost.indexOf(46) > 0) {
                this.iHost = this.iHost.substring(0, this.iHost.indexOf(46));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private Saver getSaver() {
        if (this.iSaver == null) {
            this.iSaver = new Saver();
            this.iSaver.start();
        }
        return this.iSaver;
    }

    public Level getMinLevel() {
        if (this.iMinLevel == null) {
            this.iMinLevel = Level.toLevel((String)ApplicationProperty.MessageLogLevel.value());
        }
        return this.iMinLevel;
    }

    public void stop() {
        if (this.iSaver != null) {
            this.iSaver.interrupt();
        }
        super.stop();
    }

    public void append(LogEvent event) {
        Throwable t;
        if (!event.getLevel().isMoreSpecificThan(this.getMinLevel())) {
            return;
        }
        if (MessageLogAppender.class.getName().equals(event.getLoggerName())) {
            return;
        }
        MessageLog m = new MessageLog();
        m.setLevel(event.getLevel().intLevel());
        String logger = event.getLoggerName();
        if (logger.indexOf(46) >= 0) {
            logger = logger.substring(logger.lastIndexOf(46) + 1);
        }
        m.setLogger(logger.length() > 255 ? logger.substring(0, 255) : logger);
        m.setMessage(event.getMessage() == null ? null : event.getMessage().toString());
        m.setTimeStamp(new Date(event.getTimeMillis()));
        if (event.getContextStack() != null && !event.getContextStack().isEmpty()) {
            m.setNdc(event.getContextStack().toString());
        } else if (this.iHost != null) {
            m.setNdc("[host:" + this.iHost + "]");
        }
        String thread = event.getThreadName();
        m.setThread(thread == null ? null : (thread.length() > 100 ? thread.substring(0, 100) : thread));
        if (t != null) {
            Object ex = "";
            for (t = event.getThrown(); t != null; t = t.getCause()) {
                String clazz = t.getClass().getName();
                if (clazz.indexOf(46) >= 0) {
                    clazz = clazz.substring(1 + clazz.lastIndexOf(46));
                }
                if (!((String)ex).isEmpty()) {
                    ex = (String)ex + "\n";
                }
                ex = (String)ex + clazz + ": " + t.getMessage();
                if (t.getStackTrace() == null || t.getStackTrace().length <= 0) continue;
                ex = (String)ex + " (at " + t.getStackTrace()[0].getFileName() + ":" + t.getStackTrace()[0].getLineNumber() + ")";
            }
            if (!((String)ex).isEmpty()) {
                m.setException((String)ex);
            }
        }
        this.getSaver().add(m);
    }

    public static class Saver
    extends Thread {
        private List<MessageLog> iMessages = new Vector<MessageLog>();
        private boolean iActive = true;
        private int iLogLimit = ApplicationProperty.MessageLogLimit.intValue();
        private int iCleanupInterval = ApplicationProperty.MessageLogCleanupInterval.intValue();
        private int iCleanupDays = ApplicationProperty.LogCleanupMessageLog.intValue();
        private long iCounter = 0L;

        public Saver() {
            super("MessageLogSaver");
            this.setDaemon(true);
        }

        @Override
        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(MessageLog m) {
            if (!this.iActive) {
                return;
            }
            List<MessageLog> list = this.iMessages;
            synchronized (list) {
                if (this.iLogLimit <= 0 || this.iMessages.size() < this.iLogLimit) {
                    this.iMessages.add(m);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    try {
                        Saver.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++this.iCounter;
                    if (this.iCounter % (long)this.iCleanupInterval == 0L) {
                        LogCleaner.cleanupMessageLog(this.iCleanupDays);
                    }
                    ArrayList<MessageLog> messagesToSave = null;
                    List<MessageLog> list = this.iMessages;
                    synchronized (list) {
                        if (!this.iMessages.isEmpty()) {
                            messagesToSave = new ArrayList<MessageLog>(this.iMessages);
                            this.iMessages.clear();
                        }
                    }
                    if (messagesToSave != null) {
                        Session hibSession = MessageLogDAO.getInstance().getSession();
                        hibSession.setCacheMode(CacheMode.IGNORE);
                        Transaction tx = hibSession.beginTransaction();
                        try {
                            for (MessageLog m : messagesToSave) {
                                hibSession.persist((Object)m);
                            }
                            hibSession.flush();
                            tx.commit();
                        }
                        catch (Exception e) {
                            tx.rollback();
                            System.err.println("Failed to persist " + messagesToSave.size() + " log entries:" + e.getMessage());
                        }
                    }
                    if (this.iActive) continue;
                }
                catch (Exception e) {
                    System.err.println("Failed to persist log entries:" + e.getMessage());
                    continue;
                }
                finally {
                    HibernateUtil.closeCurrentThreadSessions();
                    continue;
                }
                break;
            }
        }
    }
}

