/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.weights;

import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.course.weights.ClassWeightProvider;

public class NbrWeeksClassWeights
implements ClassWeightProvider {
    private double iDefaultNumberOfWeeks = 1.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NbrWeeksClassWeights(DataProperties config) {
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            Session session = (Session)SessionDAO.getInstance().get(config.getPropertyLong("General.SessionId", -1L));
            DatePattern dp = session.getDefaultDatePattern();
            if (dp != null) {
                this.iDefaultNumberOfWeeks = dp.getEffectiveNumberOfWeeks();
            }
        }
    }

    @Override
    public double getWeight(Lecture lecture, Class_ clazz) {
        DatePattern dp = clazz.effectiveDatePattern();
        return dp == null ? 1.0 : (double)dp.getEffectiveNumberOfWeeks() / this.iDefaultNumberOfWeeks;
    }
}

