/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;

public class StudentUnavailabilityConflicts
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static GwtMessages GWT_MSG = Localization.create(GwtMessages.class);

    public StudentUnavailabilityConflicts(StudentSectioningModel model) {
        super(model);
    }

    protected String rooms(SctAssignment section) {
        if (section.getNrRooms() == 0) {
            return "";
        }
        Object ret = "";
        for (RoomLocation r : section.getRooms()) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ",\n") + r.getName();
        }
        return ret;
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ",\n") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ",\n") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ",\n") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.colRoom()), new CSVFile.CSVField((Object)MSG.reportUnavailability(MSG.reportCourse())), new CSVFile.CSVField((Object)MSG.reportUnavailability(MSG.reportClass())), new CSVFile.CSVField((Object)MSG.reportUnavailability(MSG.reportMeetingTime())), new CSVFile.CSVField((Object)MSG.reportUnavailability(MSG.colRoom())), new CSVFile.CSVField((Object)MSG.reportProblem()), new CSVFile.CSVField((Object)MSG.reportTeachingAssignment()), new CSVFile.CSVField((Object)MSG.reportAllowedOverlap())});
        StudentQuality q = this.getModel().getStudentQuality();
        for (Student student : this.getModel().getStudents()) {
            for (Request request : student.getRequests()) {
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment == null || !enrollment.isCourseRequest() || !this.matches(request, enrollment)) continue;
                for (Section section : enrollment.getSections()) {
                    TimeLocation time = section.getTime();
                    if (time == null) continue;
                    for (Unavailability unavailability : student.getUnavailabilities()) {
                        TimeLocation uaTime = unavailability.getTime();
                        if (uaTime == null) continue;
                        if (uaTime.hasIntersection(time)) {
                            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                            line.add(new CSVFile.CSVField(student.getId()));
                            line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                            line.add(new CSVFile.CSVField((Object)student.getName()));
                            line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                            line.add(new CSVFile.CSVField((Object)this.group(student)));
                            line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                            line.add(new CSVFile.CSVField((Object)enrollment.getCourse().getName()));
                            line.add(new CSVFile.CSVField((Object)(section.getSubpart().getName() + " " + section.getName(enrollment.getCourse().getId()))));
                            line.add(new CSVFile.CSVField((Object)(time.getDayHeader() + " " + time.getStartTimeHeader(this.isUseAmPm()) + " - " + time.getEndTimeHeader(this.isUseAmPm()))));
                            line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)section)));
                            line.add(new CSVFile.CSVField((Object)unavailability.getCourseName()));
                            line.add(new CSVFile.CSVField((Object)unavailability.getSectionName()));
                            line.add(new CSVFile.CSVField((Object)(uaTime.getDayHeader() + " " + uaTime.getStartTimeHeader(this.isUseAmPm()) + " - " + uaTime.getEndTimeHeader(this.isUseAmPm()))));
                            line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)unavailability)));
                            line.add(new CSVFile.CSVField((Object)(unavailability.isOverlapping((SctAssignment)section) ? MSG.reportAllowedOverlapForMins(5 * time.nrSharedDays(uaTime) * time.nrSharedHours(uaTime)) : MSG.reportTimeConflict())));
                            line.add(new CSVFile.CSVField((Object)(unavailability.isTeachingAssignment() ? GWT_MSG.exportTrue() : GWT_MSG.exportFalse())));
                            line.add(new CSVFile.CSVField((Object)(section.isAllowOverlap() || unavailability.isAllowOverlap() ? GWT_MSG.exportTrue() : GWT_MSG.exportFalse())));
                            csv.addLine(line);
                            continue;
                        }
                        if (q == null || !StudentQuality.Type.UnavailabilityDistance.inConflict(q.getStudentQualityContext(), (SctAssignment)section, (SctAssignment)unavailability)) continue;
                        TimeLocation t1 = time;
                        TimeLocation t2 = uaTime;
                        int a1 = t1.getStartSlot();
                        int a2 = t2.getStartSlot();
                        int distTime = q.getStudentQualityContext().getUnavailabilityDistanceInMinutes(section.getPlacement(), unavailability);
                        int breakTime = a1 + t1.getNrSlotsPerMeeting() <= a2 ? t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength());
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(student.getId()));
                        line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                        line.add(new CSVFile.CSVField((Object)student.getName()));
                        line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                        line.add(new CSVFile.CSVField((Object)this.group(student)));
                        line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                        line.add(new CSVFile.CSVField((Object)enrollment.getCourse().getName()));
                        line.add(new CSVFile.CSVField((Object)(section.getSubpart().getName() + " " + section.getName(enrollment.getCourse().getId()))));
                        line.add(new CSVFile.CSVField((Object)(time.getDayHeader() + " " + time.getStartTimeHeader(this.isUseAmPm()) + " - " + time.getEndTimeHeader(this.isUseAmPm()))));
                        line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)section)));
                        line.add(new CSVFile.CSVField((Object)unavailability.getCourseName()));
                        line.add(new CSVFile.CSVField((Object)unavailability.getSectionName()));
                        line.add(new CSVFile.CSVField((Object)(uaTime.getDayHeader() + " " + uaTime.getStartTimeHeader(this.isUseAmPm()) + " - " + uaTime.getEndTimeHeader(this.isUseAmPm()))));
                        line.add(new CSVFile.CSVField((Object)this.rooms((SctAssignment)unavailability)));
                        line.add(new CSVFile.CSVField((Object)MSG.reportDistanceConflict(breakTime, distTime)));
                        line.add(new CSVFile.CSVField((Object)(unavailability.isTeachingAssignment() ? GWT_MSG.exportTrue() : GWT_MSG.exportFalse())));
                        line.add(new CSVFile.CSVField((Object)(section.isAllowOverlap() || unavailability.isAllowOverlap() ? GWT_MSG.exportTrue() : GWT_MSG.exportFalse())));
                        csv.addLine(line);
                    }
                }
            }
        }
        return csv;
    }
}

