/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.reports;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.reports.OnlineSectioningReport;

public class UsageReport
implements OnlineSectioningReport.Report {
    private DateFormat dfHour = new SimpleDateFormat("yy-MM-dd HH");
    private DateFormat dfDay = new SimpleDateFormat("yy-MM-dd");

    @Override
    public String getYear() {
        return System.getProperty("year", "2012");
    }

    @Override
    public String getTerm() {
        return System.getProperty("term", "Fall");
    }

    @Override
    public String getCampus() {
        return System.getProperty("campus", "PWL");
    }

    @Override
    public File getReportFolder() {
        return new File(System.getProperty("user.home", "~"));
    }

    @Override
    public String[] getOperations() {
        return new String[]{"section", "suggestions", "reload-student"};
    }

    @Override
    public String[] getExcludeUsers() {
        return System.getProperty("exclude", "TEST").split(",");
    }

    @Override
    public String getLastTimeStamp() {
        return System.getProperty("before", null);
    }

    @Override
    public void process(OnlineSectioningReport report, String student, List<OnlineSectioningLog.Action> actions) {
        HashSet<String> hours = new HashSet<String>();
        HashSet<String> days = new HashSet<String>();
        for (OnlineSectioningLog.Action action : actions) {
            Date d = new Date(action.getStartTime());
            report.inc(action.getOperation() + " [" + this.dfHour.format(d) + "]", 1.0);
            report.inc("HourDistribution", this.dfHour.format(d), action.getOperation(), 1.0);
            report.inc("DayDistribution", this.dfDay.format(d), action.getOperation(), 1.0);
            if ("reload-student".equals(action.getOperation())) continue;
            hours.add(this.dfHour.format(d));
            days.add(this.dfDay.format(d));
        }
        for (String s : days) {
            report.inc("Student [" + s + "]", 1.0);
            report.inc("DayDistribution", s, "Students", 1.0);
        }
        for (String s : hours) {
            report.inc("Student [" + s + "]", 1.0);
            report.inc("HourDistribution", s, "Students", 1.0);
        }
        long done = Math.round(report.inc("Students", 1.0));
        if (done % 100L == 0L) {
            OnlineSectioningReport.sLog.info((Object)("---- after " + done + " students"));
            for (String name : new TreeSet<String>(report.iCounters.keySet())) {
                OnlineSectioningReport.sLog.info((Object)(name + ": " + String.valueOf(report.iCounters.get(name))));
            }
        }
    }

    public static void main(String[] args) {
        try {
            new OnlineSectioningReport(new UsageReport()).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

