/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.advisors;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorInstrMthPref;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.solver.studentsct.StudentSolver;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

public class AdvisorGetCourseRequests
implements OnlineSectioningAction<CourseRequestInterface> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private boolean iCheckExistingDemands = false;
    private boolean iCheckHolds = false;

    public AdvisorGetCourseRequests forStudent(Long id) {
        this.iStudentId = id;
        return this;
    }

    public AdvisorGetCourseRequests checkDemands(boolean check) {
        this.iCheckExistingDemands = check;
        return this;
    }

    public AdvisorGetCourseRequests checkHolds(boolean check) {
        this.iCheckHolds = check;
        return this;
    }

    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (server instanceof DatabaseServer) {
            return this.executeDB(server, helper);
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
        XStudent student = server.getStudent(this.iStudentId);
        if (student != null) {
            action.getStudentBuilder().setExternalId(student.getExternalId());
            action.getStudentBuilder().setName(student.getName());
            if (student.getStatus() != null) {
                action.addOptionBuilder().setKey("status").setValue(student.getStatus());
            }
        }
        CourseRequestInterface request = new CourseRequestInterface();
        request.setStudentId(this.iStudentId);
        request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
        if (student != null && this.iCheckExistingDemands) {
            Formats.Format<Date> ts = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
            for (XRequest xr : student.getRequests()) {
                CourseRequestInterface.Request r = null;
                if (!(xr instanceof XCourseRequest)) continue;
                XCourseRequest xcr = (XCourseRequest)xr;
                r = new CourseRequestInterface.Request();
                boolean enrolled = false;
                boolean reserved = false;
                for (XCourseId course : xcr.getCourseIds()) {
                    XOffering offering;
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(course.getCourseId());
                    rc.setCourseName(course.getCourseName() + (String)(!CONST.showCourseTitle() || course.getTitle() == null || course.getTitle().isEmpty() ? "" : " - " + course.getTitle()));
                    rc.setCourseTitle(course.getTitle());
                    XCourse xcourse = server.getCourse(course.getCourseId());
                    if (xcourse != null) {
                        rc.setCredit(xcourse.getMinCredit(), xcourse.getMaxCredit());
                        rc.setParentCourseId(xcourse.getParentCourseId());
                    }
                    Date hasEnrollments = null;
                    if (xcr.getEnrollment() != null && xcr.getEnrollment().equals(course)) {
                        hasEnrollments = xcr.getEnrollment().getTimeStamp();
                    }
                    rc.setReadOnly(hasEnrollments != null);
                    rc.setCanDelete(hasEnrollments == null);
                    if (hasEnrollments != null) {
                        enrolled = true;
                        r.addAdvisorNote(MSG.noteEnrolled(course.getCourseName(), ts.format(hasEnrollments)));
                    }
                    if ((offering = server.getOffering(course.getOfferingId())) != null && offering.hasReservations()) {
                        for (XReservation reservation : offering.getReservations()) {
                            if (!(reservation instanceof XIndividualReservation) && !(reservation instanceof XGroupReservation) && !(reservation instanceof XLearningCommunityReservation) || !reservation.mustBeUsed() || !reservation.isApplicable(student, course)) continue;
                            if (reservation instanceof XGroupReservation) {
                                r.addAdvisorNote(MSG.noteHasGroupReservation(((XGroupReservation)reservation).getGroup().getTitle()));
                            } else if (reservation instanceof XLearningCommunityReservation) {
                                r.addAdvisorNote(MSG.noteHasGroupReservation(((XLearningCommunityReservation)reservation).getGroup().getTitle()));
                            } else {
                                r.addAdvisorNote(MSG.noteHasIndividualReservation());
                            }
                            reserved = true;
                            break;
                        }
                    }
                    rc.setCanWaitList(offering != null && offering.isWaitList());
                    xcr.fillPreferencesIn(rc, course);
                    r.addRequestedCourse(rc);
                }
                if (r.hasRequestedCourse() && (enrolled || reserved) && !student.hasAdvisorRequests()) {
                    if (xr.isAlternative()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                }
                r.setWaitList(xcr.isWaitlist());
                r.setCritical(xcr.getCritical());
                r.setTimeStamp(xcr.getTimeStamp());
            }
        }
        if (student.hasAdvisorRequests()) {
            AdvisorGetCourseRequests.fillCourseRequests(request, student.getAdvisorRequests(), server);
        }
        for (OnlineSectioningLog.Request log : OnlineSectioningHelper.toProto(request)) {
            action.addRecommendation(log);
        }
        request.setPin(student.getPin());
        request.setPinReleased(student.isPinReleased());
        if (this.iCheckHolds && Customization.StudentHoldsCheckProvider.hasProvider()) {
            try {
                StudentHoldsCheckProvider provider = (StudentHoldsCheckProvider)Customization.StudentHoldsCheckProvider.getProvider();
                request.setErrorMessage(provider.getStudentHoldError(server, helper, student));
                for (OnlineSectioningLog.Property p : helper.getAction().getOptionList()) {
                    if (!"PIN".equals(p.getKey())) continue;
                    request.setPin(p.getValue());
                }
            }
            catch (Exception e) {
                helper.warn(MSG.exceptionFailedEligibilityCheck(e.getMessage()), e);
            }
        }
        return request;
    }

    protected CourseRequestInterface executeDB(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
        Student student = (Student)StudentDAO.getInstance().get(this.iStudentId, helper.getHibSession());
        if (student != null) {
            action.getStudentBuilder().setExternalId(student.getExternalUniqueId());
            action.getStudentBuilder().setName(NameFormat.LAST_FIRST_MIDDLE.format(student));
            if (student.getSectioningStatus() != null) {
                action.addOptionBuilder().setKey("status").setValue(student.getSectioningStatus().getReference());
            }
        }
        CourseRequestInterface request = new CourseRequestInterface();
        request.setStudentId(this.iStudentId);
        request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
        List acrs = helper.getHibSession().createQuery("from AdvisorCourseRequest where student.uniqueId = :studentId order by priority, alternative", AdvisorCourseRequest.class).setParameter("studentId", (Object)this.iStudentId).list();
        if (student != null && this.iCheckExistingDemands) {
            Formats.Format<Date> ts = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP_SHORT);
            TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

                @Override
                public int compare(CourseDemand d1, CourseDemand d2) {
                    if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                        return 1;
                    }
                    if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                        return -1;
                    }
                    int cmp = d1.getPriority().compareTo(d2.getPriority());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return d1.getUniqueId().compareTo(d2.getUniqueId());
                }
            });
            demands.addAll(student.getCourseDemands());
            for (CourseDemand cd : demands) {
                CourseRequestInterface.Request r = null;
                if (cd.getCourseRequests().isEmpty()) continue;
                r = new CourseRequestInterface.Request();
                boolean enrolled = false;
                boolean reserved = false;
                for (CourseRequest course : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(course.getCourseOffering().getUniqueId());
                    rc.setCourseName(course.getCourseOffering().getSubjectAreaAbbv() + " " + course.getCourseOffering().getCourseNbr() + (String)(!CONST.showCourseTitle() ? "" : " - " + course.getCourseOffering().getTitle()));
                    rc.setCourseTitle(course.getCourseOffering().getTitle());
                    CourseCreditUnitConfig credit = course.getCourseOffering().getCredit();
                    if (credit != null) {
                        rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                    }
                    rc.setParentCourseId(course.getCourseOffering().getParentOffering() == null ? null : course.getCourseOffering().getParentOffering().getUniqueId());
                    Date hasEnrollments = null;
                    for (StudentClassEnrollment e : course.getClassEnrollments()) {
                        if (hasEnrollments != null && !hasEnrollments.before(e.getTimestamp())) continue;
                        hasEnrollments = e.getTimestamp();
                    }
                    rc.setReadOnly(hasEnrollments != null);
                    rc.setCanDelete(hasEnrollments == null);
                    if (hasEnrollments != null) {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                        enrolled = true;
                    } else {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                    if (hasEnrollments != null) {
                        rc.setCanChangeAlternatives(false);
                        rc.setCanChangePriority(false);
                        r.addAdvisorNote(MSG.noteEnrolled(course.getCourseOffering().getSubjectAreaAbbv() + " " + course.getCourseOffering().getCourseNbr(), ts.format(hasEnrollments)));
                    }
                    for (Reservation reservation : course.getCourseOffering().getInstructionalOffering().getReservations()) {
                        if (!(reservation instanceof IndividualReservation) && !(reservation instanceof StudentGroupReservation) && !(reservation instanceof LearningCommunityReservation) || !reservation.isMustBeUsed() || !reservation.isApplicable(student, course)) continue;
                        rc.setReadOnly(true);
                        rc.setCanDelete(false);
                        rc.setCanChangeAlternatives(false);
                        rc.setCanChangePriority(false);
                        if (reservation instanceof StudentGroupReservation) {
                            r.addAdvisorNote(MSG.noteHasGroupReservation(((StudentGroupReservation)reservation).getGroup().getGroupName()));
                        } else if (reservation instanceof LearningCommunityReservation) {
                            r.addAdvisorNote(MSG.noteHasGroupReservation(((LearningCommunityReservation)reservation).getGroup().getGroupName()));
                        } else {
                            r.addAdvisorNote(MSG.noteHasIndividualReservation());
                        }
                        reserved = true;
                        break;
                    }
                    rc.setCanWaitList(course.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                    if (course.getPreferences() != null) {
                        for (StudentSectioningPref ssp : course.getPreferences()) {
                            if (ssp instanceof StudentClassPref) {
                                StudentClassPref scp = (StudentClassPref)ssp;
                                rc.setSelectedClass(scp.getClazz().getUniqueId(), scp.getClazz().getClassPrefLabel(course.getCourseOffering()), scp.isRequired(), true);
                                continue;
                            }
                            if (!(ssp instanceof StudentInstrMthPref)) continue;
                            StudentInstrMthPref imp = (StudentInstrMthPref)ssp;
                            rc.setSelectedIntructionalMethod(imp.getInstructionalMethod().getUniqueId(), imp.getInstructionalMethod().getLabel(), imp.isRequired(), true);
                        }
                    }
                    r.addRequestedCourse(rc);
                }
                if (r.hasRequestedCourse() && (enrolled || reserved) && acrs.isEmpty()) {
                    if (cd.isAlternative().booleanValue()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                }
                r.setWaitList(cd.effectiveWaitList());
                r.setNoSub(cd.effectiveNoSub());
                if (cd.getCriticalOverride() != null) {
                    r.setCritical(cd.getCriticalOverride());
                } else {
                    r.setCritical(cd.getCritical());
                }
                r.setTimeStamp(cd.getTimestamp());
            }
        }
        AdvisorGetCourseRequests.fillCourseRequests(request, acrs);
        for (OnlineSectioningLog.Request log : OnlineSectioningHelper.toProto(request)) {
            action.addRecommendation(log);
        }
        request.setPin(student.getPin());
        request.setPinReleased(student.isPinReleased() != null && student.isPinReleased() != false);
        if (this.iCheckHolds && Customization.StudentHoldsCheckProvider.hasProvider()) {
            try {
                StudentHoldsCheckProvider provider = (StudentHoldsCheckProvider)Customization.StudentHoldsCheckProvider.getProvider();
                request.setErrorMessage(provider.getStudentHoldError(server, helper, new XStudentId(student, helper)));
                for (OnlineSectioningLog.Property p : helper.getAction().getOptionList()) {
                    if (!"PIN".equals(p.getKey())) continue;
                    request.setPin(p.getValue());
                }
            }
            catch (Exception e) {
                helper.warn(MSG.exceptionFailedEligibilityCheck(e.getMessage()), e);
            }
        }
        if (request.hasPin() && acrs.isEmpty()) {
            request.setPinReleased(true);
        }
        return request;
    }

    protected static void fillCourseRequests(CourseRequestInterface request, List<AdvisorCourseRequest> acrs) {
        int last = -1;
        CourseRequestInterface.Request r = null;
        HashSet<Integer> skip = new HashSet<Integer>();
        String note = null;
        for (AdvisorCourseRequest acr : acrs) {
            CourseRequestInterface.RequestPriority rp;
            if (acr.getAlternative() == 0 || acr.getNotes() != null) {
                note = acr.getNotes();
            }
            if (acr.getCourseOffering() == null || (rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(acr.getCourseOffering().getUniqueId(), acr.getCourseOffering().getCourseName()))) == null) continue;
            if (note != null) {
                rp.getRequest().addAdvisorNote(note);
            }
            skip.add(acr.getPriority());
        }
        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
        HashMap<String, String> nameCache = new HashMap<String, String>();
        for (AdvisorCourseRequest acr : acrs) {
            if (skip.contains(acr.getPriority())) continue;
            if (acr.getPriority() == -1) {
                request.setCreditNote(acr.getNotes());
                request.setTimeStamp(acr.getTimestamp());
                request.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                continue;
            }
            if (r == null || last != acr.getPriority()) {
                r = new CourseRequestInterface.Request();
                if (acr.isSubstitute().booleanValue()) {
                    request.getAlternatives().add(r);
                } else {
                    request.getCourses().add(r);
                }
                last = acr.getPriority();
            }
            if (acr.getCourseOffering() != null) {
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseId(acr.getCourseOffering().getUniqueId());
                rc.setCourseName(acr.getCourseOffering().getSubjectAreaAbbv() + " " + acr.getCourseOffering().getCourseNbr() + (String)(!CONST.showCourseTitle() ? "" : " - " + acr.getCourseOffering().getTitle()));
                rc.setCourseTitle(acr.getCourseOffering().getTitle());
                rc.setCanWaitList(acr.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                CourseCreditUnitConfig credit = acr.getCourseOffering().getCredit();
                if (credit != null) {
                    rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                }
                rc.setParentCourseId(acr.getCourseOffering().getParentOffering() == null ? null : acr.getCourseOffering().getParentOffering().getUniqueId());
                if (acr.getPreferences() != null) {
                    for (AdvisorSectioningPref ssp : acr.getPreferences()) {
                        if (ssp instanceof AdvisorClassPref) {
                            AdvisorClassPref scp = (AdvisorClassPref)ssp;
                            rc.setSelectedClass(scp.getClazz().getUniqueId(), scp.getClazz().getClassPrefLabel(acr.getCourseOffering()), scp.isRequired(), true);
                            continue;
                        }
                        if (!(ssp instanceof AdvisorInstrMthPref)) continue;
                        AdvisorInstrMthPref imp = (AdvisorInstrMthPref)ssp;
                        rc.setSelectedIntructionalMethod(imp.getInstructionalMethod().getUniqueId(), imp.getInstructionalMethod().getLabel(), imp.isRequired(), true);
                    }
                }
                r.addRequestedCourse(rc);
                if (acr.getAlternative() == 0) {
                    r.setCritical(acr.getCritical());
                }
                rc.setTimeStamp(acr.getTimestamp());
                rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
            } else if (acr.getFreeTime() != null) {
                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                ft.setStart(acr.getFreeTime().getStartSlot());
                ft.setLength(acr.getFreeTime().getLength());
                for (DayCode day : DayCode.toDayCodes(acr.getFreeTime().getDayCode())) {
                    ft.addDay(day.getIndex());
                }
                CourseRequestInterface.RequestedCourse rc = null;
                if (!r.hasRequestedCourse()) {
                    rc = new CourseRequestInterface.RequestedCourse();
                    r.addRequestedCourse(rc);
                    rc.setTimeStamp(acr.getTimestamp());
                    rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                } else {
                    rc = r.getRequestedCourse(0);
                    if (acr.getTimestamp() != null && (rc.getTimeStamp() == null || rc.getTimeStamp().before(acr.getTimestamp()))) {
                        rc.setTimeStamp(acr.getTimestamp());
                        rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                    }
                }
                rc.addFreeTime(ft);
            } else if (acr.getCourse() != null) {
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseName(acr.getCourse());
                r.addRequestedCourse(rc);
                rc.setTimeStamp(acr.getTimestamp());
                rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
            }
            if (acr.getCredit() != null) {
                r.setAdvisorCredit(acr.getCredit());
            }
            if (acr.getNotes() != null) {
                r.setAdvisorNote(acr.getNotes());
            }
            if (acr.getWaitlist() != null) {
                r.setWaitList(acr.getWaitlist());
            }
            if (acr.getNoSub() != null) {
                r.setNoSub(acr.getNoSub());
            }
            if (acr.getTimestamp() == null || r.getTimeStamp() != null && !r.getTimeStamp().before(acr.getTimestamp())) continue;
            r.setTimeStamp(acr.getTimestamp());
            r.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
        }
    }

    public static String getName(Map<String, String> nameCache, String externalUniqueId, Long studentId, Long sessionId, NameFormat format) {
        if (externalUniqueId == null || externalUniqueId.isEmpty()) {
            return null;
        }
        String ret = nameCache.get(externalUniqueId);
        if (ret == null) {
            Advisor a = null;
            if (sessionId != null) {
                a = Advisor.findByExternalId(externalUniqueId, sessionId);
            } else if (studentId != null) {
                a = Advisor.findByExternalIdForStudent(externalUniqueId, studentId);
            }
            if (a != null && a.getLastName() != null && a.getFirstName() != null) {
                ret = format.format(a);
            } else {
                TimetableManager m = TimetableManager.findByExternalId(externalUniqueId);
                if (m != null) {
                    ret = format.format(m);
                }
            }
            if (ret != null) {
                nameCache.put(externalUniqueId, ret);
            }
        }
        return ret;
    }

    protected static void fillCourseRequests(CourseRequestInterface request, List<XAdvisorRequest> acrs, OnlineSectioningServer server) {
        int last = -1;
        CourseRequestInterface.Request r = null;
        HashSet<Integer> skip = new HashSet<Integer>();
        String note = null;
        for (XAdvisorRequest acr : acrs) {
            CourseRequestInterface.RequestPriority rp;
            if (acr.getAlternative() == 0 || acr.getNote() != null) {
                note = acr.getNote();
            }
            if (acr.getCourseId() == null || (rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(acr.getCourseId().getCourseId(), acr.getCourseId().getCourseName()))) == null) continue;
            if (note != null) {
                rp.getRequest().addAdvisorNote(note);
            }
            skip.add(acr.getPriority());
        }
        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
        HashMap<String, String> nameCache = new HashMap<String, String>();
        for (XAdvisorRequest acr : acrs) {
            if (skip.contains(acr.getPriority())) continue;
            if (acr.getPriority() == -1) {
                request.setCreditNote(acr.getNote());
                request.setTimeStamp(acr.getTimeStamp());
                request.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                continue;
            }
            if (r == null || last != acr.getPriority()) {
                r = new CourseRequestInterface.Request();
                if (acr.isSubstitute()) {
                    request.getAlternatives().add(r);
                } else {
                    request.getCourses().add(r);
                }
                last = acr.getPriority();
            }
            if (acr.getCourseId() != null) {
                XOffering offering;
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseId(acr.getCourseId().getCourseId());
                rc.setCourseName(acr.getCourseId().getCourseName() + (String)(!CONST.showCourseTitle() || acr.getCourseId().getTitle() == null || acr.getCourseId().getTitle().isEmpty() ? "" : " - " + acr.getCourseId().getTitle()));
                rc.setCourseTitle(acr.getCourseId().getTitle());
                XCourse course = server.getCourse(acr.getCourseId().getCourseId());
                if (course != null) {
                    rc.setCredit(course.getMinCredit(), course.getMaxCredit());
                    rc.setParentCourseId(course.getParentCourseId());
                }
                rc.setCanWaitList((offering = server.getOffering(acr.getCourseId().getOfferingId())) != null && offering.isWaitList());
                if (acr.hasPreferences()) {
                    for (XCourseRequest.XPreference ssp : acr.getPreferences()) {
                        switch (ssp.getType()) {
                            case SECTION: {
                                rc.setSelectedClass(ssp.getUniqueId(), ssp.getLabel(), ssp.isRequired(), true);
                                break;
                            }
                            case INSTR_METHOD: {
                                rc.setSelectedIntructionalMethod(ssp.getUniqueId(), ssp.getLabel(), ssp.isRequired(), true);
                            }
                        }
                    }
                }
                r.addRequestedCourse(rc);
                if (acr.getAlternative() == 0) {
                    r.setCritical(acr.getCritical());
                }
                rc.setTimeStamp(acr.getTimeStamp());
                rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
            } else if (acr.getFreeTime() != null) {
                CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                ft.setStart(acr.getFreeTime().getSlot());
                ft.setLength(acr.getFreeTime().getLength());
                for (DayCode day : DayCode.toDayCodes(acr.getFreeTime().getDays())) {
                    ft.addDay(day.getIndex());
                }
                CourseRequestInterface.RequestedCourse rc = null;
                if (!r.hasRequestedCourse()) {
                    rc = new CourseRequestInterface.RequestedCourse();
                    r.addRequestedCourse(rc);
                    rc.setTimeStamp(acr.getTimeStamp());
                    rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                } else {
                    rc = r.getRequestedCourse(0);
                    if (acr.getTimeStamp() != null && (rc.getTimeStamp() == null || rc.getTimeStamp().before(acr.getTimeStamp()))) {
                        rc.setTimeStamp(acr.getTimeStamp());
                        rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
                    }
                }
                rc.addFreeTime(ft);
            } else if (acr.getCourseName() != null) {
                rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseName(acr.getCourseName());
                r.addRequestedCourse(rc);
                rc.setTimeStamp(acr.getTimeStamp());
                rc.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
            }
            if (acr.getCredit() != null) {
                r.setAdvisorCredit(acr.getCredit());
            }
            if (acr.getNote() != null) {
                r.setAdvisorNote(acr.getNote());
            }
            if (acr.getWaitList() != null) {
                r.setWaitList(acr.getWaitList());
            }
            if (acr.getNoSub() != null) {
                r.setNoSub(acr.getNoSub());
            }
            if (acr.getTimeStamp() == null || r.getTimeStamp() != null && !r.getTimeStamp().before(acr.getTimeStamp())) continue;
            r.setTimeStamp(acr.getTimeStamp());
            r.setChangedBy(AdvisorGetCourseRequests.getName(nameCache, acr.getChangedBy(), request.getStudentId(), request.getAcademicSessionId(), nameFormat));
        }
    }

    public static CourseRequestInterface getRequest(Student student, Session hibSession) {
        CourseRequestInterface request = AdvisorGetCourseRequests.getRequest(student.getUniqueId(), hibSession);
        request.setPin(student.getPin());
        request.setPinReleased(student.isPinReleased() != null && student.isPinReleased() != false);
        return request;
    }

    public static CourseRequestInterface getRequest(Long studentId, Session hibSession) {
        CourseRequestInterface request = new CourseRequestInterface();
        request.setStudentId(studentId);
        List acrs = hibSession.createQuery("from AdvisorCourseRequest where student.uniqueId = :studentId order by priority, alternative", AdvisorCourseRequest.class).setParameter("studentId", (Object)studentId).list();
        if (!acrs.isEmpty()) {
            request.setSessionId(((AdvisorCourseRequest)acrs.get(0)).getStudent().getSession().getUniqueId());
        }
        AdvisorGetCourseRequests.fillCourseRequests(request, acrs);
        return request;
    }

    public static CourseRequestInterface getRequest(XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (server instanceof StudentSolver) {
            return AdvisorGetCourseRequests.getRequest(student.getStudentId(), helper.getHibSession());
        }
        if (!student.hasAdvisorRequests()) {
            return null;
        }
        CourseRequestInterface request = new CourseRequestInterface();
        request.setStudentId(student.getStudentId());
        request.setSessionId(server.getAcademicSession().getUniqueId());
        request.setPin(student.getPin());
        request.setPinReleased(student.isPinReleased());
        AdvisorGetCourseRequests.fillCourseRequests(request, student.getAdvisorRequests(), server);
        return request;
    }

    @Override
    public String name() {
        return "advisor-requests";
    }
}

